C*****APINVB
      DOUBLE PRECISION FUNCTION APINVB( P, Alpha, Beta )
C
      DOUBLE PRECISION       P
      DOUBLE PRECISION       Alpha
      DOUBLE PRECISION       Beta
C
C        Function:  APINVB
C
C        Purpose:  CALCULATES INVERSE Beta DISTRIBUTION
C
C        Calling Sequence:
C
C             B := APINVB( P, Alpha, Beta )
C
C                  P      --- PROBABILITY FOR WHICH PERCENTAGE
C                             POINT IS TO BE FOUND (DOUBLE PRECISION,INP
C                  Alpha  --- FIRST PARAMETER OF Beta DISTRIBUTION
C                             (DOUBLE PRECISION,INPUT)
C                  Beta   --- SECOND PARAMETER OF Beta DISTRIBUTION
C                             (DOUBLE PRECISION,INPUT)
C
C                  B      --- RESULTING PERCENTAGE POINT OF Beta DIST.
C
C        Calls:  CDBeta  (CUMULATIVE Beta DISTRIBUTION)
C
C        Called By:  MANY
C
C        Remarks:
C
C             BECAUSE OF THE RELATIONSHIP BETWEEN THE Beta
C             DISTRIBUTION AND THE F DISTRIBUTION, THIS
C             ROUTINE CAN BE USED TO FIND THE INVERSE OF
C             THE F DISTRIBUTION.
C
C             THE PERCENTAGE POINT IS RETURNED AS -1.0
C             IF ANY ERROR OCCURS.
C
C             THIS ROUTINE USES NEWTONS METHOD
C             TO FIND THE PERCENTAGE POINT.
C
C             THE ALGORITHM IS BASED UPON AS110
C             FROM APPLIED STATISTICS.
C
      INTEGER    ITER,   MAXITR
C
      DOUBLE PRECISION       EPSZ
C
      DOUBLE PRECISION       XIM1,   XI,     XIP1,   FIM1,   FI,     W
      DOUBLE PRECISION       CMPLBT, ADJ,    SQ,     R,      S,      T
      DOUBLE PRECISION       H,      PP,     AA,     BB,     A1,     B1
      DOUBLE PRECISION       G
C
      DOUBLE PRECISION       ALGama
      DOUBLE PRECISION       CDBeta
C
      DOUBLE PRECISION APINVN
      DOUBLE PRECISION PSING
C
      DATA       EPSZ  / 1.0D-26 /
C
      DATA       MAXITR/ 50 /
C
C        (1)  CHECK VALIDITY OF PARAMETERS.
C
      IF( Alpha <= 0.0 ) GOTO 9005
      IF( Beta  <= 0.0 ) GOTO 9005
C
      IF( ( P > 1.0 ) OR ( P < 0.0 ) ) GOTO 9005
C
C        (2)  FLIP PARAMETERS SO THAT
C             'P' FOR EVALUATION IS <:= .5
C
      IF( P > 0.5 ) GOTO 10
C
         AA     := Alpha
         BB     := Beta
         PP     := P
         GOTO 20
C
  10     AA     := Beta
         BB     := Alpha
         PP     := 1.0 - P
C
C        (3)  GENERATE INITIAL APPROXIMATION.
C             SEVERAL DIFFERENT ONES USED, DEPENDING UPON
C             VALUES OF (P,Alpha,Beta).
C
  20  CMPLBT := ALGama( AA ) + ALGama( BB ) -
     1         ALGama( AA + BB )
C
      PSING  := 1.0 - PP
      FI     := APINVN( PSING )
C
      IF( ( AA > 1.0 ) AND ( BB > 1.0 ) ) GOTO 40
C
         R      := BB + BB
         T      := 1.0 / ( 9.0 * BB )
         T      := R * ( 1.0 - T + FI * SQRT( T ) ) ** 3
C
         IF( T > 0.0 ) GOTO 30
C
            XI     := 1.0 - EXP( ( LOG( ( 1.0 - PP ) * BB )
     1                            + CMPLBT ) / BB )
            GOTO 50
C
  30     T      := ( 4.0 * AA + R - 2.0 ) / T
C
         IF( T <= 1.0 ) XI := EXP( (LOG( PP * AA ) + CMPLBT) / PP)
         IF( T > 1.0 ) XI := 1.0 - 2.0 / ( T + 1.0 )
         GOTO 50
C
  40     R      := ( FI * FI - 3.0 ) / 6.0
         S      := 1.0 / ( AA + AA - 1.0 )
         T      := 1.0 / ( BB + BB - 1.0 )
         H      := 2.0 / ( S + T )
         W      := FI * SQRT( H + R ) / H - ( T - S ) *
     1            ( R + 5.0 / 6.0 - 2.0 / ( 3.0 * H ) )
         XI     := AA / ( AA + BB * EXP( W + W ) )
C
C        (4)  BEGIN NEWTON-RAPHSON LOOP.
C
  50  A1     := 1.0 - AA
      B1     := 1.0 - BB
      FIM1   := 0.0
      SQ     := 1.0
      XIM1   := 1.0
C
      DO 100 ITER := 1 , MAXITR
C
         FI     := CDBeta( XI, AA, BB )
         IF( FI < 0.0 ) GOTO 9005
C
         FI     := ( FI - PP ) * EXP( CMPLBT + A1 * LOG( XI ) +
     1                               B1 * LOG( 1.0 - XI ) )
C
         IF( ( FI * FIM1 ) <= 0.0 ) XIM1 := SQ
C
         G      := 1.0
C
  60     ADJ    := G * FI
         SQ     := ADJ * ADJ
C
         IF( SQ < XIM1 ) GOTO 70
C
            G      := G / 3.0
            GOTO 60
C
  70        XIP1     := XI - ADJ
            IF( ( XIP1 .GE. 0.0 ) AND
     1          ( XIP1 <= 1.0 ) ) GOTO 80
C
               G      := G / 3.0
               GOTO 60
C
  80     IF( XIM1    <= EPSZ ) GOTO 9000
         IF( FI * FI <= EPSZ ) GOTO 9000
C
         IF( ( XIP1 = 0.0 ) OR
     1       ( XIP1 = 1.0 ) ) GOTO 70
C
         IF( XIP1 = XI ) GOTO 9000
C
            XI     := XIP1
            FIM1   := FI
C
  100 CONTINUE
C
 9000 APINVB := XI
      IF( P > 0.5 ) APINVB := 1.0 - APINVB
C
      RETURN
C
 9005 XI     := -1.0
      GOTO 9000
C
      END
