/* SERIO.C - Programmed by Maarten Hofman */
/* 211093: Started programming */
/* 251093: Continued programming */
/* 011193: jtextattr() jungetch() */

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

#include "includes/serio.h"
#include "includes/serial.h"

static unsigned char buffer[BUFFER_SIZE][2],portactive,password[9];
static int comaddress,pending,count[2][2],oldattr;
static void interrupt (*oldfunc)();

static int loop_increment(int what) {
  if(++what==BUFFER_SIZE) what=0;
  return(what);
}

static void write_byte(void) {
int tmp;

  if((tmp=count[WRITE_PART][START_PART])==count[WRITE_PART][END_PART]) {
	pending=0;
	return;
  }
  outp(comaddress+THR,buffer[tmp][WRITE_PART]);
  count[WRITE_PART][START_PART]=loop_increment(tmp);
  pending=1;
}

static void read_byte(void) {
int tmp;

  buffer[tmp=count[READ_PART][END_PART]][READ_PART]=inp(comaddress+RBR);
  count[READ_PART][END_PART]=loop_increment(tmp);
}

static void interrupt far com_isr(void) {
  if(portactive) {
	switch(inp(comaddress+IRQ)&7) {
	  case 2:
		write_byte();
		break;
	  case 4:
		read_byte();
	  default:
		break;
	}
  }
  outp(0x20,0x20);
}

static void open_com(int cport) {
int ptemp,intlev;

  oldfunc=getvect(intlev=0xc-cport);
  disable();
  setvect(intlev,com_isr);
  if(!cport) {
	comaddress=0x3f8;
  }
  else {
	comaddress=0x2f8;
  }
  ptemp=inp(comaddress+LCR)&0x7f;
  outp(comaddress+LCR,ptemp);
  ptemp=inp(LSR+comaddress);
  ptemp=inp(RBR+comaddress);
  if(!cport) {
	ptemp=inp(0x21)&0xef;
	outp(0x21,ptemp);
  }
  else {
	ptemp=inp(0x21)&0xf7;
	outp(0x21,ptemp);
  }
  outp(IER+comaddress,3);
  ptemp=inp(MCR+comaddress)|0xb;
  outp(MCR+comaddress,ptemp);
  enable();
  portactive=cport+1;
  pending=0;
}

static void close_com(void) {
int ptemp;

  if(portactive) {
	disable();
	ptemp=inp(0x21)|0x18;
	outp(0x21,ptemp);
	ptemp=inp(LCR+comaddress)&0x7f;
	outp(LCR+comaddress,ptemp);
	outp(IER+comaddress,0);
	outp(MCR+comaddress,0);
	setvect(0xd-portactive,oldfunc);
	enable();
	portactive=0;
  }
}

static int get_byte(void) {
int tmp,data;

  if((tmp=count[READ_PART][START_PART])==count[READ_PART][END_PART]) {
	return(NO_BYTE_AVAILABLE);
  }
  data=buffer[tmp][READ_PART];
  count[READ_PART][START_PART]=loop_increment(tmp);
  return(data);
}

int jungetch(int ch) {
int tmp,temp;

  if((temp=count[READ_PART][START_PART])==(tmp=count[READ_PART][END_PART])) {
	buffer[tmp][READ_PART]=ch;
	count[READ_PART][END_PART]=loop_increment(tmp);
	return(ch);
  }
  if(!temp) temp=BUFFER_SIZE;
  count[READ_PART][START_PART]=temp-1;
  buffer[temp][READ_PART]=ch;
  return(ch);
}

void jputs(char *what) {
int i;
int tmp;

  tmp=count[WRITE_PART][END_PART];
  for(i=0;i<=strlen(what);i++) {
	buffer[tmp][WRITE_PART]=what[i];
	tmp=loop_increment(tmp);
  }
  count[WRITE_PART][END_PART]=tmp;
  if(!pending) write_byte();
}

void init_serio(int port) {
int i,j;

  open_com(port);
  for(i=0;i<2;i++) for(j=0;j<2;j++) count[i][j]=0;
  oldattr=0;
}

void exit_serio(void) {
  close_com();
}

int jkbhit(void) {
  if(count[READ_PART][START_PART]==count[READ_PART][END_PART]) return(0);
  return(1);
}

int jgetch(void) {
int tmp;

  while((tmp=get_byte())==NO_BYTE_AVAILABLE);
  return(tmp);
}

void jputch(int what) {
unsigned char it[2];

  it[1]=0;
  it[0]=what;
  jputs(it);
}

int jgetche(void) {
int tmp;

  tmp=jgetch();
  jputch(tmp);
  return(tmp);
}

void jgotoxy(int x,int y) {
char buffer[20];

  sprintf(buffer,"\033[%u;%uH",y,x);
  jputs(buffer);
}

void jclrscr(void) {
  jputs("\033[2J");
  jgotoxy(1,1);
}

void jclreol(void) {
  jputs("\033[K");
}

void jhighvideo(void) {
  jputs("\033[1m");
}

void jnormvideo(void) {
  jputs("\033[0m");
}

void jlowvideo(void) {
  jnormvideo();
}


void jtextattr(int attr) {
  oldattr=attr;
  jnormvideo();
  if(attr&0x80) jputs("\033[5m");
  if(attr&0x08) jhighvideo();
  if(((attr&0x70)/16)>(attr&0x07)) jputs("\033[7m");
  if(attr&1) jputs("\033[4m");
}

void jtextcolor(int color) {
int tmp;

  tmp=oldattr&0x70;
  tmp|=(color&0x8f);
  jtextattr(tmp);
}

void jtextbackground(int color) {
int tmp;

  tmp=oldattr&0x8f;
  tmp+=((color&0x07)*16);
  jtextattr(tmp);
}

char *jgets(char *what) {
int tmp;

  what[1]=2;
  while(what[1]-1<what[0]) {
	if((tmp=jgetche())=='\r') break;
	if(tmp==8) {
	  if(what[1]>2) what[1]--;
	}
	else {
	  what[what[1]++]=tmp;
	}
  }
  tmp=jgetche();
  what[what[1]]=0;
  what[1]-=2;
  return(&what[2]);
}

char *jgetpass(char *prompt) {
int tmp,sign;

  tmp=0;
  jputs(prompt);
  while(tmp<8) {
	if((sign=jgetch())=='\r') break;
	if(sign==8) {
	  if(tmp>0) tmp--;
	}
	else {
	  password[tmp++]=sign;
	}
  }
  tmp=jgetche();
  password[tmp]=0;
  return(password);
}
