/*
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University
 * in the City of New York.  Permission is granted to any individual or
 * institution to use, copy, or redistribute this software so long as it
 * is not sold for profit, provided this copyright notice is retained.
 *
 */

#ifndef lint
static char *rcsid = "$Header: bboard.c,v 1.62 88/12/06 15:25:03 Bill Exp $";
#endif

/*
 * bboard.c - routines for reading bulletin boards.
 *            A tad of a quick hack. Note that the
 *            bulletin board read date is kept in
 *            an invisible file on the mail-directory.
 *
 *                                    Bill Yeager Dec 6, 1988
 *
 * Cloned from routines in file.c
 */

#include "mm.h"
#include "parse.h"
#include "cmds.h"
#include "rd.h"
#include "bboard.h"

extern msgvec *cf;			/* current mail file */

msgvec *getfile ();

string bboard_file;				  /* for the file name */
string bboard_directory;			  /* the path */

extern string mail_directory;
char *parse_bboard_file ();
char *parse_bbd_file ();
FILE *set_bboard_last_read();
FILE *bboard_opendatefile();
static FILE *rdate_stream = nil;
						  
time_t bbd_last_read;

int
cmd_bboard (n)
int n;
{
    msgvec *nf, *f;
    char *fname, *parse_input_file();
    extern int gotargs;			/* are we processing command line? */
    int i;
    FILE *rstream;
    char bboard_rof[MAXPATHLEN];		  /* the read only date file */

    gotargs = FALSE;			/* don't exit after get in cmd line */
    noise ("bulletin board");
    bboard_file[0] = '\0';
    strcpy(bboard_directory,BBOARD_DIRECTORY);
    fname = parse_bboard_file ("bulletin board", bboard_file, true);
    confirm ();				/* XXX leak */
    
    if (cf)   /* save it before reading new file in case it's the same file */
	if (!update (&cf,UPD_SAVEMOD) && (cf->flags & MF_WRITERR)) {
	    fprintf (stderr,
		     "?Cannot save old file -- %s command aborted.\n",
		     n == CMD_EXAMINE ? "EXAMINE" : "GET");
	    free (fname);
	    return (false);
	}
    nf = getfile(fname, CMD_EXAMINE);		  /* We are examining */
    if (nf == nil) {				  /* Oops.. get failed */
        free (fname);				  /* drop the memory */
	return false;
      }
    if (cf) {				/* get rid of old current file */
	f = cf;			        /* remember this another minute... */
	cf = nil;			/* ...but don't update it anymore */
	(*msg_ops[f->type].close)(f->filep);	  /* close old file */
	msgvec_free (f);		/* free all the bits and pieces */
    }
    cf = nf;					  /* make new file current */
    cf->flags |= MF_BBOARD;			  /* flag as bboard */
    bbd_set_rdate_name(fname,bboard_rof);	  /* set read date file name */
    free (fname);				  /* drop the memory */
    rstream = set_bboard_last_read(bboard_rof);
    bboard_display_new();			  /* show new headers */
    rdate_stream = rstream;			  /* for time stamp save */
    return true;
}
bbd_set_rdate_name(fname,rname)
     char *fname;
     char *rname;
{
  char *tptr;       

  if (mail_directory[0] == '.') {		  /* home directory */
    strcpy(rname,HOME);
    strcat(rname,"/");
  }
  else {					  /* use mail directory */
    strcpy(rname,mail_directory);  
    tptr = rindex(rname,'.');
    if (tptr) *tptr = '\0';			  /* Do not want "." */
    tptr = rindex(rname,'/');			  /* check for a "/" */
    if (tptr) {					  /* check for tail "/" */
      int len= strlen(rname);

      if (rname[len-1] != '/') strcat(rname,"/"); /* append "/" */
    }
  }
  strcat(rname,BBOARD_ROFSUFFIX);
  tptr = rindex(fname,'/');			  /* path supplied? */
  if (!tptr) tptr = fname;			  /* no path, use name */
  else
    ++tptr;					  /* skip "/"  */
  strcat(rname,tptr);
}

/*
 * parse the name of a file.  returns the absolute pathname.
 * Note: caller must free storage.
 */


char *
parse_bboard_file (help, def, allowdir)
char *help, *def;
{
    static fdb filefdb = 
      { _CMFIL, FIL_SDH|FIL_OLD|FIL_RD|FIL_NOPTH|FIL_NOEXT };

    if (allowdir && directory_folders)
	filefdb._cmffl &= ~FIL_NODIR;
    else
	filefdb._cmffl |= FIL_NODIR;
    return (parse_bbd_file (help, def, filefdb));
}


/*
 * (WAS parse_in_out_file):
 * do the work for parse_input_file or parse_output_file
 */
char *
parse_bbd_file (help, def, filefdb)
char *help, *def;
fdb filefdb;
{
    char wd[MAXPATHLEN];
    char *getwd();
    char *fname;
    char *cp;
    filblk fb;
    static char *dirs[] = { nil };
    static char *ex[]= { ".txt", NULL };

    dirs[0] = bboard_directory;
    fb.pathv = dirs;
    fb.exceptionspec = ".*";
    fb.def_extension = ex;
    filefdb._cmdat = (pdat) &fb;
    filefdb._cmhlp = help;
    filefdb._cmdef = def;

    parse (&filefdb, &pv, &used);
    if (*pv._pvfil[0] == '/') {		/* absolute path specified */
      fname = (char *) malloc (strlen(pv._pvfil[0])+1);
      strcpy (fname, pv._pvfil[0]);
      return (fname);
    }
    if (getwd (wd) == NULL) { 		/* got some kind of error */
      fprintf (stderr, "%s\n", wd);	/* print the error message */
      fname = (char *) malloc (strlen(pv._pvfil[0])+1);
      strcpy (fname, pv._pvfil[0]);
      return (fname);
    }
    cp = pv._pvfil[0];
    if (cp[0] == '.' && cp[1] == '/')
      cp += 2;
    fname = (char *) malloc (strlen(cp)+strlen(wd)+2);
    sprintf (fname, "%s/%s", wd, cp);
    return (fname);
}

FILE *set_bboard_last_read(rname)
     char *rname;
{
  FILE *rstream;

  rstream = bboard_opendatefile(rname);
  if (!rstream) {
    bbd_last_read = 0;
    return(0);
  }
  /*
   * read in the last read date and set it.
   */
  if (1 != fread(&bbd_last_read,sizeof(time_t),1,rstream)) {
    cmerr("Read error");
    bbd_last_read = 0;
  }
  rewind(rstream);  
  return(rstream);
}
FILE *bboard_opendatefile(rname)
     char *rname;
{
  FILE *rstream;
  char *omode;
  int create;

  /*
   * If the file doesn't exist then open "w+" else "r+"
   * Since it belongs to the user, we assume r/w access to
   * the file's path and the file itself.
   */
  if (access(rname,F_OK) < 0) {
    omode = "w+";				  /* does not exist */
    create = 1;
  }
  else						  /* read/write */
    {
      omode = "r+";
      create = 0;
    }
  rstream = fopen(rname,omode);
  if (!rstream) return(0);			  /* something wrong */
  if (create) {
    bbd_last_read = 0;
    if (1 != fwrite(&bbd_last_read,sizeof(time_t),1,rstream))
      cmerr("Write error: open date file");
    rewind(rstream);
    fsync(rstream);
  }
  return(rstream);
}
/*  
 * bboard_display_new:
 * (clone of do_flagged)
 * display new messages of bboard file
 */
bboard_display_new()
{
    int i,count,first_new;
    extern int display_length;
    extern FILE *header_pipe;
    FILE *more_pipe_open();
    time_t last_rdate= bbd_last_read;

    /* first find out how many */
    cf->current = 0;
    if (last_rdate == 0) {			  /* See them all */
      count = cf->count;
      first_new = 1;
    } else
      first_new = 0;
      for (count = 0, i = 1; i <= cf->count; i++) {
	if (cf->msgs[i].date > last_rdate) {
	  if (first_new == 0) first_new = i;
	  ++count;
	} else {				  /* Then mark as seen */
	  cf->msgs[i].flags |= M_SEEN;		  /* For Nakul. 20dec88 */
	  /*
	   * we make it the last seen 
           *     o If the user reads a message it will become that
           *       message number.
           *     o else, when we update the time-stamp we want it to
           *       be the last_seen which is current;
           */
	  cf->current = i;			  
	}
      }
    fprintf(stdout,"%d New message%s\n",count,
	    ((char *)(count == 1) ? "" : "s"));
    if (count == 0) 				  /* Nothing to report */
        return;
    if (count >= display_length)
	header_pipe = more_pipe_open(cmcsb._cmoj);
    else
	header_pipe = cmcsb._cmoj;
    if (header_pipe == nil)
	header_pipe == stdout;
    header_print(0);
    for (i = first_new; i <= cf->count; i++) {
            cf->msgs[i].flags |= M_RECENT;	  /* Want NEW */
	    header_print(i);			  /* uses header_pipe */
    }
    header_print(-1);
    if (header_pipe == cmcsb._cmoj){
	if (cmcsb._cmoj)
	    fflush(cmcsb._cmoj);	/* didn't open the pipe */
    }
    else if (header_pipe != stdout)
	more_pipe_close(header_pipe);
    header_pipe = NULL;
  }
/*
 *  Called from update() in file.c
 */
bbd_update_lastread(m)
     msgvec *m;
{
  int user_last_read= m->current;
  time_t time_stamp;

  if (m == nil || rdate_stream == nil) return;	  /* nothing to do */
  if (user_last_read > 0 && user_last_read <= m->last_read){/* sanity checks */
    if (user_last_read == m->last_read)
      time_stamp = m->mtime;			  /* seen them all */
    else					  /* saw this one last */
       time_stamp = m->msgs[user_last_read].date;
    /*
     *  See if the user just "re-read" a message. If so, then
     *  we leave the last read date as it was.
     */
    if (time_stamp < bbd_last_read)		  /* Nothing to do */
       return;
  } else
    if (user_last_read == 0)			  /* never read */
       time_stamp = 0;
    else
       time_stamp = time(0);			  /* mark all msgs as read */

  bbd_update_read_date(rdate_stream,time_stamp);  /* do it */
  fsync(rdate_stream);				  /* Insure update */
  fclose(rdate_stream);
  rdate_stream = nil;				  /* Mark file as closed */
}
bbd_update_read_date(rstream,ts)
  FILE *rstream;
  time_t ts;
{
  rewind(rstream);
  if (1 != fwrite(&ts,sizeof(time_t),1,rstream))
    cmerr("Write error: update read date");
}

/*
 * cmd_find:
 *         find will examine the user_bulletin_boards external
 *         for a sequential list of bulletin boards to check for
 *         new messages.
 *
 *         It has as subcommands "FIRST" and "NEXT".
 */
extern keylist user_bulletin_boards;
static keywrd bbd_find_keys[] = {
  { "first", 0,      (keyval) FIND_FIRST },	  /* 0 */
  { "next", KEY_IGN|KEY_INV, (keyval) FIND_NEXT }	  /* 1 */
};
static char opt_first[]= {"first"};
static char opt_next[]= {"next"};

/*
 *  current_bbd indexes the user_bulletin_boards list
 */
static current_bbd = 0;
static bbd_nread = 0;

cmd_find(n)
     int n;
{
  static keytab findtab = { (sizeof(bbd_find_keys)/sizeof(keywrd)), 
			      bbd_find_keys };
  static fdb findfdb = { _CMKEY, NULL, NULL, (pdat)&findtab, 
			   "with ", "first", NULL };
  char *bbptr;
  char bbdfile[MAXPATHLEN];
  char rdatefile[MAXPATHLEN];
  msgvec *nf, *f;
  FILE *rstream;

  if (user_bulletin_boards == nil) {
    fprintf(stdout,"? user-bulletin-boards list required\n");
    return true;
  }

  if (n == CMD_FIND) {                /* FIND command */
    noise("Recent bboard messages");
    parse(&findfdb, &pv, &used);
    confirm();
  } else {	                      /* IGNORE command */
    char *nptr;
  
    if (cf == nil) {
      fprintf(stdout,"\n Please use commmand FIND before IGNORE\n");
      return true;
    }
    if (!(cf->flags & MF_BBOARD)) {
      noise("Current bulletin board");
      confirm();
      fprintf(stdout,"\n  Sorry, %s, is not a bulletin board.\n",
		cf->filename);
      return true;
    }
    nptr = rindex(cf->filename,'/');		  /* cleanup a little */
    if (!nptr) 
      nptr = cf->filename;			  /* use full name */
    else
      ++nptr;					  /* skip "/" */
    noise(nptr);				  /* Ignoree ... */
    confirm();
    /*
     * OK. The current mail file is a bulletin board. 
     * So, we set things to cause its time-stamp to be the last
     * message in the file when update() below coerces its
     * time-stamp to be written, and invoke a "find first/next":
     *
     * Note: If the user has done something
     *       silly between the last find and this command, eg: expunge,
     *       then the time-stamp will not be written since the previous
     *       "sillyness" would've caused it to be written.
     */
    if (bbd_nread == 0)
      pv._pvkey = FIND_FIRST;			  /* do a find FIRST */
    else
      pv._pvkey = FIND_NEXT;			  /* find FIRST has been done*/
    cf->current = cf->count;			  /* last message in file */
  }
  /*
   *  Find first. Then if successful, make "next" visible
   *  for 2nd and successive passes
   */
  if (pv._pvkey == FIND_FIRST) {
    bbd_nread = 0;
    current_bbd = 0;
    bbd_find_keys[FIND_NEXT]._kwflg &= ~(KEY_IGN|KEY_INV); /* see next now */
    findfdb._cmdef = opt_next;			  /* next on <return> */
  }
  else
    {/*
      * Try next bulletin board
      */
      current_bbd += 1;
    }
  /*
   *  Update cf (current file) since it may be the one requested next,
   *  and this will coerce the time stamp to be updated if necessary.
   */
  if (cf)   /* save it before reading new file in case it's the same file */
    if (!update (&cf,UPD_SAVEMOD) && (cf->flags & MF_WRITERR)) {
      fprintf (stderr,
	       "?Cannot save old file -- \"%s\" command aborted.\n",
	       n == CMD_FIND ? "FIND" : "IGNORE");
      return (false);
    }
  /*
   * Search for a bulletin board to enter.
   */
  current_bbd = bbd_next(bbdfile,rdatefile,&rstream,current_bbd);
  bbptr = user_bulletin_boards[current_bbd];  /* ptr to current name */
  if (!bbptr) {
    if (bbd_nread > 0)				  /* then read some bbd */
       fprintf(stdout,"Finished scanning bboard list.\n");
    else					  /* did not read any bbd */
       fprintf(stdout,"No new messages.\n");
    /*
     *  Now get the user's default mail file back if necessary.
     */
    if (cf && strcmp(mail_file, cf->filename) != 0) {/* current not default */
      int type;
      switch (mail_probe(mail_file, &type))	  /* can we read this? */
	{
            case PR_NAME:
            case PR_NOEX:
            case PR_PERM:
            case PR_EMPTY:
            case PR_NOTOK:
                break;
	    default:
		printf("Reading %s\n",mail_file);	  /* tell em 's up */
		nf = getfile(mail_file,CMD_GET);
		if (nf != nil) {
		  f = cf;			  /* remember this */
		  cf = nil;			  /* ...but don't update */
		  (*msg_ops[f->type].close)(f->filep);	  /* close old file */
		  msgvec_free (f);		/* free all the bits-pieces */
		  cf = nf;			  /* make new file current */
		  do_flagged();			  /* show the F'd msgs */
		} else
		  cf = nil;			  /* no default mail file */
	} /* switch */
    }
    bbd_nread = current_bbd = 0;		  /* reset to FIRST again */
    bbd_find_keys[FIND_NEXT]._kwflg |= KEY_IGN|KEY_INV;	/* HIDE next now */
    findfdb._cmdef = opt_first;			  /* first on <return> */
    rdate_stream = nil;				  /* No current file open */
    return(true);				  /* all done */
  }
  nf = getfile(bbdfile, CMD_EXAMINE);		  /* Read in the messages */
  if (nf == nil) return false;			  /*.. get failed */
  if (cf) {				/* get rid of old current file */
    f = cf;			        /* remember this another minute... */
    cf = nil;			/* ...but don't update it anymore */
    (*msg_ops[f->type].close)(f->filep);	  /* close old file */
    msgvec_free (f);		/* free all the bits and pieces */
  }
  cf = nf;					  /* make new file current */
  cf->flags |= MF_BBOARD;			  /* flag as bboard */
  fprintf(stdout,"(Reading %s) ",bbptr);
  bbd_nread += 1;				  /* count them */
  bboard_display_new();				  /* show new headers */
  rdate_stream = rstream;			  /* save for time stamping */
  return true;
}
/*
 *  Scan user_bulletin_boards for next bboard
 *  with new messages.
 */

bbd_next(bbdfile,rdatefile,rstream,ubbindex)
     char *bbdfile;
     char *rdatefile;
     FILE **rstream;
     int ubbindex;
{
  int i;
  struct stat sbuf;
  char *nptr;

  strcpy(bbdfile,BBOARD_DIRECTORY);
  strcat(bbdfile,"/");
  nptr = rindex(bbdfile,'/');			  /* For name concats */
  nptr += 1;
  i = ubbindex;
  while (1) {
    char *bbptr= user_bulletin_boards[i];

    if (bbptr == nil) return(i);		  /* list exausted */
    strcpy(nptr,bbptr);
    if (strcmp(default_mail_type.current,"mtxt") == 0) /* type check */
      strcat(bbdfile,".txt");
    /*
     *  get last modify date of bulletin board
     */
    if (stat(bbdfile,&sbuf) < 0) {		  /* skip it */
      ++i;
      continue;
    }
    bbd_set_rdate_name(bbdfile,rdatefile);	  /* set read date file name */
    *rstream = set_bboard_last_read(rdatefile);
    if (sbuf.st_mtime > bbd_last_read) break;
    fclose(*rstream);
    i += 1;					  /* try next one */
  }
  return(i);
}
