/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.examples.lib.timerbean;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.examples.lib.timerbean.TimerListener;

public class Timer
implements Serializable {
    public static final String PROP_ONCE_ONLY = "onceOnly";
    public static final String PROP_DELAY = "delay";
    public static final long DEFAULT_DELAY = 1000L;
    public static final boolean DEFAULT_ONLY_ONCE = false;
    static final long serialVersionUID = -7954930904657028678L;
    private transient TimerThread timerThread;
    private transient Vector listeners;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private boolean running;
    private boolean onceOnly = false;
    private long delay = 1000L;

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.timerThread = new TimerThread();
        this.running = true;
        this.timerThread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.timerThread.stop();
        this.timerThread = null;
        this.running = false;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long value) {
        if (this.delay == value) {
            return;
        }
        long oldValue = this.delay;
        this.delay = value;
        this.propertySupport.firePropertyChange(PROP_DELAY, new Long(oldValue), new Long(this.delay));
    }

    public boolean getOnceOnly() {
        return this.onceOnly;
    }

    public void setOnceOnly(boolean value) {
        if (this.onceOnly == value) {
            return;
        }
        this.onceOnly = value;
        this.propertySupport.firePropertyChange(PROP_ONCE_ONLY, !this.onceOnly ? Boolean.TRUE : Boolean.FALSE, this.onceOnly ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public void addTimerListener(TimerListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeTimerListener(TimerListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimerEvent() {
        Vector l;
        if (this.listeners == null) {
            return;
        }
        Timer timer = this;
        synchronized (timer) {
            l = (Vector)this.listeners.clone();
        }
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            TimerListener tl = (TimerListener)e.nextElement();
            tl.onTime(new ActionEvent(this, 1001, "onTime"));
        }
    }

    class TimerThread
    extends Thread {
        TimerThread() {
        }

        public void run() {
            do {
                try {
                    TimerThread.sleep(Timer.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Timer.this.fireTimerEvent();
            } while (!Timer.this.onceOnly);
            Timer.this.running = false;
        }
    }
}

