<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

    
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>
 
<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_USER_PREFS,request); %>

<%@ include file="../global/topInclude.jsp" %>
<%@ include file="includes/prefsInclude.jsp" %>
<%!

%>

<%
ArrayList allUsers=null;
String[] otherUsernames=null;
String otherUsernamesJsArray=null;
   
boolean doNotifications=false;
User user=null;

String username=null;
String fullname=null;
boolean dropUserCookie=false;

// notifications-related values:
String emailAddress=null;
int secretQuestion=0;
String secretAnswer="";

boolean secretQuestionNeeded=true;

boolean sendMissedDeadlineReminder=false;
boolean sendICalendarFileWithNotification=false;
long preDeadlineReminderBeforeMillis=-1;
int defaultNotificationPref=-1;

try
{

	doNotifications=controller.getCurrentInstallationConfig().isDoNotifications();
	user=controller.getSessionInfo().getUser();
	username=user.getUsername();
	fullname=user.getFullname();
	dropUserCookie=user.isDropUserCookie();

	allUsers=Manager.selectAllUsers();
	if (allUsers!=null)
	{
		otherUsernames=new String[allUsers.size()-1];
		int currIndex=0;
		for (int i=0; i<allUsers.size(); i++)
		{
			User u=(User)allUsers.get(i);
			if (!(u.getUsername().trim().equals(username)))
			{
				otherUsernames[currIndex]=u.getUsername();
				currIndex++;
			}
		}
		StringBuffer jsArrayBuffer=new StringBuffer("[");
		for (int i=0; i<otherUsernames.length; i++)
		{
			if (i>0)
			{
				jsArrayBuffer.append(",");
			}
			jsArrayBuffer.append("\""+otherUsernames[i]+"\"");
		}
		jsArrayBuffer.append("]");
		otherUsernamesJsArray=jsArrayBuffer.toString();
	}
  
	// notifications-related values:
	emailAddress=PageUtils.nonNull(user.getEmailAddress());
	
	secretQuestion=user.getSecretQuestion();
	secretAnswer=PageUtils.nonNull(user.getSecretAnswer());
	secretQuestionNeeded=(secretAnswer.trim().length()==0);

	sendMissedDeadlineReminder=user.isSendMissedDeadlineReminder();
	sendICalendarFileWithNotification=user.isSendICalendarFileWithNotification();
	preDeadlineReminderBeforeMillis=user.getPreDeadlineReminderBeforeMillis(); // -1 indicates no pre-deadline reminder
	defaultNotificationPref=user.getDefaultNotificationPref();
	
}
catch (Exception e)
{}

otherUsernamesJsArray=(otherUsernamesJsArray!=null?otherUsernamesJsArray:"[]");
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

var otherUsernames=<%=otherUsernamesJsArray%>
var doNotifications=<%=doNotifications?"true":"false"%>

var secretQuestionNeeded=<%=""+secretQuestionNeeded%>

function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["username"].value).length==0)
	{
		errorAlert("You have not supplied a username; all users must have a username. Please fix and try again.",els["username"])
		return false
	}
	if (trim(els["fullname"].value).length==0)
	{
		errorAlert("You have not supplied a full name; this field is required. Please fix and try again.",els["fullname"])
		return false
	}
	var password=trim(els["password"].value)
	var retypepassword=trim(els["retypepassword"].value)
	if (""+password!=""+retypepassword)
	{
		errorAlert("The password and the retyped password do not match.  Please fix and try again. (Note that you should leave these two fields blank unless you wish to change your password.)",els["retypepassword"])
		return false
	}
	
	if (secretQuestionNeeded)
	{
		if (trim(els["secretAnswer"].value).length==0)
		{
			errorAlert("You have not supplied an answer to your secret question. Please supply one and try again.",els["secretAnswer"])
			return false
		}	
	}
	
	if (doNotifications && trim(els["emailAddress"].value).length==0)
	{
		errorAlert("You have not supplied an e-mail address; this field is required. Please fix and try again.",els["emailAddress"])
		return false
	}

 	
 	// If we've gotten this far, then we know that all fields that should have something in
 	// them do; now make sure all field values are valid:
 	
	if (!isValidUsername(trim(els["username"].value)))
	{
		errorAlert("The username \""+trim(els["username"].value)+"\" is not valid; usernames may contain only letters, numbers, underscores, dashes, and periods, and must be between "+USERNAME_MIN_LENGTH+" and "+USERNAME_MAX_LENGTH+" characters long. Please fix and try again.",els["username"])
		return false
	}
	if (doNotifications && !isValidEmail(trim(els["emailAddress"].value)))
	{
		errorAlert("An e-mail address is not required, but the one you have entered is not valid.  Please fix and try again.  \"myname@mycompany.com\" is an example of a valid e-mail address.",els["emailAddress"])
		return false
	}

	if (trim(els["password"].value).length>0 && !isValidPassword(trim(els["password"].value)))
	{
		errorAlert("The password \""+trim(els["password"].value)+"\" is not valid; passwords may contain only letters, numbers, underscores, dashes, and periods, and must be between "+PASSWORD_MIN_LENGTH+" and "+PASSWORD_MAX_LENGTH+" characters long. Please fix and try again. (Note that you should leave these two fields blank unless you wish to change your password.)",els["password"])
		return false
	}

	for (var i=0; i<otherUsernames.length; i++)
	{
		if (trim(otherUsernames[i])==trim(els["username"].value))
		{
			errorAlert("The username \""+trim(els["username"].value)+"\" is already taken by another user. Please fix and try again.",els["username"])
			return false
		}
	}

	hidePageAndShowPleaseWait()
	return true
}

</script> 

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth>
<form action=processPrefs.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>

<font class=bodyFont>
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>Please make changes to your account</span>  below, then press the "change" button.<%=HtmlUtils.doubleLB(request)%><BR>
</span>
<BR>
<%
if (false)
{
	%>
	<i>General</i><%=HtmlUtils.doubleLB(request)%>
	<%
}
%>


<span class=boldishFont>Username<%=HelpManager.helpLink("username",request)%></span><BR>
<input type=text class=inputText name=username id=username value="<%=username%>" size=16><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Full name<%=HelpManager.helpLink("fullName",request)%></span><BR>
<input type=text class=inputText name=fullname id=fullname value="<%=fullname%>" size=50><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>New password</span><%=HelpManager.helpLink("password",request)%> (leave blank unless you want to change your password)<BR>
<input type=password class=inputText name=password id=password value="" size=16><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Retype new password</span> (leave blank unless you want to change your password)<BR>
<input type=password class=inputText name=retypepassword id=retypepassword value="" size=16><%=HtmlUtils.doubleLB(request)%>

<%
if (secretQuestionNeeded)
{
	%>
	<span class=boldishFont>Secret question</span> (for if you forget your password)<BR>
	<select class=selectText style="width:310px;" name=secretQuestion id=secretQuestion>
	<%

	for (int i=0; i<WorkRollConstants.SECRET_QUESTION_LABELS.length; i++)
	{
		%>
		<option value="<%=WorkRollConstants.SECRET_QUESTION_VALUES[i]%>"><%=WorkRollConstants.SECRET_QUESTION_LABELS[i]%></option>
		<%
	}
	%>
	</select><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Answer to secret question</span> (Note: If you lose your password, you will need to remember <I>exactly</I> what you typed here to get it back; you will also not be able to change this field once you submit this page.)<BR>
	<input type=text class=inputText name=secretAnswer id=secretAnswer value="" size=16><%=HtmlUtils.doubleLB(request)%>
	
	<%
}
%>



<span class=boldishFont>Remember me on this computer<%=HelpManager.helpLink("rememberMeOnThisComputer",request)%>:</span> <%=HtmlUtils.getYesNoRadios(dropUserCookie,"dropUserCookie")%><%=HtmlUtils.doubleLB(request)%>




<%
if (doNotifications)
{
	%>

	<%=HtmlUtils.doubleLB(request)%>
	<i>Notifications and reminders<%=HelpManager.helpLink("notificationsAndReminders",request)%></i><%=HtmlUtils.doubleLB(request)%>
	
	<span class=standardTextBlockWidth>Your system is configured for e-mail notifications and reminders.  A <i>notification</i> is an e-mail sent to you either to tell you that someone has assigned an issue to you, or to tell you that someone has changed something about an issue already assigned to you.  It is up to the person assigning the issue to decide whether or not to send you a notification.  Notifications may optionally (it's up to you) contain an attached iCalendar file.  A <i>reminder</i> is an e-mail automatically sent to you to remind you that you have a deadline approaching, or that you have missed a deadline.  It is up to you whether or not you receive these reminders.</span><%=HtmlUtils.doubleLB(request)%><BR>
	
	<span class=boldishFont>E-mail address</span><BR>
	<input type=text class=inputText name=emailAddress id=emailAddress value="<%=emailAddress%>" size=50><%=HtmlUtils.doubleLB(request)%>
	
	<span class=boldishFont>By default, send notifications of new/changed issues to users...</span><BR>
	<select class=selectText style="width:210px;" name=defaultNotificationPref id=defaultNotificationPref>
	<%
	for (int i=0; i<DEFAULT_NOTIF_LABELS.length; i++)
	{
		%>
		<option value="<%=DEFAULT_NOTIF_VALUES[i]%>" <%=(DEFAULT_NOTIF_VALUES[i]==defaultNotificationPref)?" selected":""%>><%=DEFAULT_NOTIF_LABELS[i]%></option>
		<%
	}
	%>
	</select><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Send me pre-deadline reminders</span><BR>
	<select class=selectText style="width:210px;" name=preDeadlineReminderBeforeMillis id=preDeadlineReminderBeforeMillis>
	<%
	for (int i=0; i<REMINDER_MILLIS_LABELS.length; i++)
	{
		%>
		<option value="<%=REMINDER_MILLIS_VALUES[i]%>" <%=(REMINDER_MILLIS_VALUES[i]==preDeadlineReminderBeforeMillis)?" selected":""%>><%=REMINDER_MILLIS_LABELS[i]%></option>
		<%
	}
	%>
	</select><%=HtmlUtils.doubleLB(request)%>
	
	<span class=boldishFont>Send me a reminder e-mail if I miss a deadline</span> <%=HtmlUtils.getYesNoRadios(sendMissedDeadlineReminder,"sendMissedDeadlineReminder")%><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Attach an iCalendar file to notification e-mails<%=HelpManager.helpLink("icalendar",request)%></span> <%=HtmlUtils.getYesNoRadios(sendICalendarFileWithNotification,"sendICalendarFileWithNotification")%><%=HtmlUtils.doubleLB(request)%>


	<%
}
%>

 
<BR>
<input  class=formButton type=submit value=change><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form></span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

