<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% //PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>
<%@ page import="java.text.*" %>

<%@ page import="javax.mail.*" %>
<%@ page import="javax.mail.internet.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
 
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
int idToReturnToDialog=-1;
boolean success;

boolean sendNotification=controller.getParamAsBoolean("sendNotification",false);

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();

Calendar dueDateCalendar=Calendar.getInstance();

boolean resetReminderSentFlags=controller.getParamAsBoolean("resetReminderSentFlags");

int issueId=controller.getParamAsInt("issueId");
idToReturnToDialog=issueId;
String descriptionText=controller.getParam("descriptionText");
int assignedByUserId=controller.getParamAsInt("assignedByUserId");
int assignedToUserId=controller.getParamAsInt("assignedToUserId");
int status=controller.getParamAsInt("status");
int priority=controller.getParamAsInt("priority");
String url=controller.getParam("url").trim();
if (url.toLowerCase().equals("http://"))
{
	url="";
}
int projectId=controller.getParamAsInt("projectId");
int instanceId=controller.getParamAsInt("instanceId");

dueDateCalendar.set(Calendar.YEAR,controller.getParamAsInt("dueDateYear"));
dueDateCalendar.set(Calendar.MONTH,controller.getParamAsInt("dueDateMonth"));
dueDateCalendar.set(Calendar.DATE,controller.getParamAsInt("dueDateDate"));

dueDateCalendar.set(Calendar.HOUR,0);
dueDateCalendar.set(Calendar.AM_PM,Calendar.AM);
dueDateCalendar.set(Calendar.MINUTE,0);
dueDateCalendar.set(Calendar.SECOND,0);
dueDateCalendar.set(Calendar.MILLISECOND,0);
dueDateCalendar.add(Calendar.MILLISECOND,controller.getParamAsInt("dueDateHour"));

Date dueDate=dueDateCalendar.getTime();

boolean issueIsNonClosed=controller.getParamAsBoolean("issueIsNonClosed");

AbstractIssue issue=null;
String mode=request.getParameter("mode");


try
{
	

	if (mode.equals("add"))
	{
		issue=new NonClosedIssue();
	}
	else
	{
		if (issueIsNonClosed)
		{
			issue=Manager.selectNonClosedIssueById(issueId);
		}
		else
		{
			issue=Manager.selectClosedIssueById(issueId);
		}
	}
	issue.setLastModifiedDate(new Date());
	
	// reset these:
	issue.setApproachingDeadlineReminderSent(false);
	issue.setMissedDeadlineReminderSent(false);

	issue.setDescriptionText(descriptionText);
	issue.setAssignedByUserId(assignedByUserId);
	issue.setAssignedToUserId(assignedToUserId);
	issue.setPriority(priority);
	// if not new issue, we'll leave the openDate field as-is, and deal with the status
	// when we update:
	if (mode.equals("add"))
	{
		issue.setOpenDate(new Date());
		issue.setStatus(status);
	}
	issue.setDueDate(dueDate);
	issue.setUrl(url);
	issue.setProjectId(projectId);
	issue.setInstanceId(instanceId);
	if (resetReminderSentFlags)
	{
		issue.setApproachingDeadlineReminderSent(false);
		issue.setMissedDeadlineReminderSent(false);
	}
	if (mode.equals("add"))
	{
		idToReturnToDialog=Manager.insertNonClosedIssue((NonClosedIssue)issue);
	}
	else
	{
		if (issueIsNonClosed)
		{
		
			// issue WASN'T closed; it may have just been closed:
			if (status==AbstractIssue.STATUS_CLOSED)
			{
				// update the issue to the non-closed-issue table, without setting
				// its status to CLOSED because moveIssueToClosedIssues does this,
				// then move it (yes, this is clunky):
				Manager.updateNonClosedIssue((NonClosedIssue)issue);
				Manager.moveIssueToClosedIssues(issueId);
			}
			else
			{
				// else the issue was non-closed, and is still, so just update, after
				// setting the correct status:
				issue.setStatus(status);
				Manager.updateNonClosedIssue((NonClosedIssue)issue);
			}
		}
		else
		{
			// issue WAS closed; it may have just had its status changed to a non-closed
			// status:
			if (status==AbstractIssue.STATUS_CLOSED)
			{
				// was closed and still is, so  just update, after setting the correct 
				// status:
				issue.setStatus(status);
				Manager.updateClosedIssue((ClosedIssue)issue);
			}
			else
			{
				// else it was closed but has been re-opened, so we do something similar
				// to the clunky thing above, although slightly different/backwards-ish:
				Manager.updateClosedIssue((ClosedIssue)issue);
				Manager.moveIssueToNonClosedIssues(issueId,status);
			}
			
		}
	}
	success=true;
}
catch (Throwable t)
{
	success=false;
	Printer.pe("storing issue", t);
}

String mailExceptionText="";
String eol=WorkRollConstants.LINE_SEPARATOR;

User assignedToUser=Manager.selectUserById(assignedToUserId);
User assignedByUser=Manager.selectUserById(assignedByUserId);

if (success && sendNotification && assignedToUser.isActive())
{
	try
	{
		Project project=null;
		if (projectId>0)
		{
			project=Manager.selectProjectById(projectId);
		}
		Instance instance=null;
		if (instanceId>0)
		{
			instance=Manager.selectInstanceById(instanceId);
		}

		String subjectPrefix="";
		if (mode.equals("add"))
		{
			if (installationConfig.getMailSubjectPrefixInitialNotification()!=null && installationConfig.getMailSubjectPrefixInitialNotification().trim().length()>0)
			{
				subjectPrefix+=installationConfig.getMailSubjectPrefixInitialNotification().trim()+" ";
			}
		}
		else
		{
			if (installationConfig.getMailSubjectPrefixChangeNotification()!=null && installationConfig.getMailSubjectPrefixChangeNotification().trim().length()>0)
			{
				subjectPrefix+=installationConfig.getMailSubjectPrefixChangeNotification().trim()+" ";
			}
		}
		String subject=subjectPrefix+(mode.equals("add")?"New WorkRoll issue has been assigned to you":"WorkRoll issue assigned to you has been changed");
		StringBuffer message=new StringBuffer(2000);
		message.append((mode.equals("add")?"A new WorkRoll issue has been assigned to you":"A WorkRoll issue assigned to you has been changed")+" by "+assignedByUser.getFullname()+" ("+assignedByUser.getEmailAddress()+"). ");
		message.append("Details are as follows:"+eol+eol);
		message.append("Issue ID: "+idToReturnToDialog+eol);
		message.append("Project: "+(project!=null?project.getName():"All Projects")+eol);
		message.append("Instance: "+(instance!=null?instance.getName():"All Instances")+eol);
		message.append("Assigned by: "+assignedByUser.getFullname()+eol);
		message.append("Assigned to: "+assignedToUser.getFullname()+eol);
		message.append("Status: "+GeneralUtils.getStatusLabelFromCode(status)+eol);
		message.append("Priority: "+GeneralUtils.getPriorityLabelFromCode(priority)+eol);
		
		DateFormat dateFormat=DateFormat.getDateInstance(DateFormat.LONG);
		String timeText="Anytime";
		if (dueDateCalendar.get(Calendar.HOUR)==9 && dueDateCalendar.get(Calendar.MINUTE)==30 && dueDateCalendar.get(Calendar.AM_PM)==Calendar.AM)
		{
			timeText="Start of work";
		}
		else if (dueDateCalendar.get(Calendar.HOUR)==5 && dueDateCalendar.get(Calendar.MINUTE)==30 && dueDateCalendar.get(Calendar.AM_PM)==Calendar.PM)
		{
			timeText="End of work";
		}
		else if (dueDateCalendar.get(Calendar.MINUTE)==0 && dueDateCalendar.get(Calendar.SECOND)==0 && dueDateCalendar.get(Calendar.MILLISECOND)==0)
		{
			timeText=DateFormat.getTimeInstance(DateFormat.SHORT).format(dueDateCalendar.getTime());
		}
		message.append("Due: "+dateFormat.format(dueDateCalendar.getTime())+" ("+timeText+")"+eol+eol);
		message.append("Description: "+descriptionText+eol+eol);
		message.append("URL: "+(url.trim().length()>0?url:"[none]")+eol+eol);
		String appRootUrl=controller.getApplicationRootURL();
		if (appRootUrl!=null)
		{
			message.append("You may view this and all other active issues at "+appRootUrl+"/issues/list.jsp"+eol+eol);
		}
		message.append(WorkRollConstants.DEFAULT_EMAIL_SIG);
		
		String iCalendarText=null;
		File[] attachmentFiles=null;
		String[] attachmentMimeTypes=null;
		if (assignedToUser.isSendICalendarFileWithNotification())
		{
			NonClosedIssue issueForICal=issue.getNonClosedCopy();
			issueForICal.setId(issue.getId());
			iCalendarText=GeneralUtils.getICalendarTextForIssue(issueForICal, message.toString(), installationConfig);
		}
		if (iCalendarText!=null)
		{
			try
			{
				attachmentFiles=new File[1];
				attachmentMimeTypes=new String[1];
				File file=File.createTempFile("ical",null);
				file.deleteOnExit();
				FileWriter writer=new FileWriter(file);
				writer.write(iCalendarText.toCharArray());
				writer.close();
				attachmentFiles[0]=file;
				attachmentMimeTypes[0]="text/x-vCalendar";
			}
			catch (Exception e)
			{
				Printer.pe("creating attachment files",e);
			}
		}
		// this method call sends the message without waiting for the MailerThread to execute; this means that an Exception thrown by it will never actually be caught by the catch clause below; but even a successful send takes a second or so, and that's too long to wait for the dialog to close.
		InternetAddress[] to={new InternetAddress(assignedToUser.getEmailAddress())};
		String fromAddress=(installationConfig.getSmtpUsername()!=null && installationConfig.getSmtpUsername().length()>0?installationConfig.getSmtpUsername():"postmaster")+"@"+installationConfig.getSmtpHost();
		Mailer.send(to, null, null, new InternetAddress(fromAddress), subject, message.toString(), "text/plain", attachmentFiles, attachmentMimeTypes, installationConfig, false);
	}
	catch (Exception e)
	{
		Printer.pe("sending mail",e);
		mailExceptionText=URLEncoder.encode(""+e);
		try
		{
			mailExceptionText+=": "+URLEncoder.encode(e.getMessage());
		}
		catch (Exception e1) {}
	}
}


if (success)
{
	%>
	<html><head></head>
	<body onload="parent.frames[0].storeIssueSuccess(true,<%=idToReturnToDialog%>,'<%=mailExceptionText%>')">
	</body>
	</html>
	<%
}
else
{
	%>
	<html><head></head>
	<body onload="parent.frames[0].storeIssueSuccess(false,<%=idToReturnToDialog%>,'<%=mailExceptionText%>')">
	</body>
	</html>
	<%
}
%>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>
