<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

    
<% PageUtils.jspStart(request); %>



<% 
// Added this after finding an apparent bug in Tomcat: the page was cutting itself off after
// exactly 8K of output; this is the default buffer, so I increase the buffer here (this should
// absolutely not be necessary, but it does seem to fix the problem):
%>
<% // @ // REMOVING because later version of Tomcat choked on it: oh, Tomcat...  page buffer="200" %>



<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>
 
<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES,request); %>
<% PageUtils.setSubsection(WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE,request); %>

<%@ include file="../global/topInclude.jsp" %>
<%! 
       
%>

<%
boolean isActiveIssues=controller.getParamAsBoolean("a");
boolean isAscendingSort=controller.getParamAsBoolean("asc");
boolean isShadeAltRows=controller.getParamAsBoolean("shading");
boolean isPortrait=controller.getParamAsBoolean("portrait");
String sortName=controller.getParam("sn","openDateSort");
int textSize=controller.getParamAsInt("textSize");
String headerText=controller.getParam("headerText");



HashMap sortNamesToColumnNamesMap=new HashMap();
sortNamesToColumnNamesMap.put("idSort","ID");
sortNamesToColumnNamesMap.put("assignedByUserFullnameSort","By");
sortNamesToColumnNamesMap.put("assignedToUserFullnameSort","To");
sortNamesToColumnNamesMap.put("statusSort","Status");
sortNamesToColumnNamesMap.put("prioritySort","Priority");
sortNamesToColumnNamesMap.put("projectNameSort","Project");
sortNamesToColumnNamesMap.put("instanceNameSort","Instance");
sortNamesToColumnNamesMap.put("openDateSort","Opened");
sortNamesToColumnNamesMap.put("dueDateSort","Due");
sortNamesToColumnNamesMap.put("descriptionSort","Description");


IssueFilter filter=controller.getSessionInfo().getCurrentFilter();

// No matter how user has filtered for status (possibly having set the filter on a different list), we want to show closed issues here:
if (isActiveIssues)
{
	if (filter!=null && filter.getStatuses()==IssueFilter.CLOSED_ONLY)
	{
		filter=(IssueFilter)filter.clone();
		filter.setStatuses(IssueFilter.OPEN_AND_RESOLVED);
	}
}
else // closed (inactive) issues list:
{
	if (filter!=null && filter.getStatuses()!=IssueFilter.CLOSED_ONLY)
	{
		filter=(IssueFilter)filter.clone();
		filter.setStatuses(IssueFilter.CLOSED_ONLY);
	}
}

// Following arrays for use by staticList.jsp:
String[] headerNames={"ID","By","To","Status","Priority","Project","Instance","Opened","Due","Description",""};
ArrayList issuesForPreview=null;

int[] COL_WIDTHS_PORTRAIT={37,55,55,50,61,70,70,50,50,142,-1}; 
int[] COL_WIDTHS_LANDSCAPE={52,60,60,72,89,75,75,70,70,225,-1}; 


int[] colWidths=(isPortrait?COL_WIDTHS_PORTRAIT:COL_WIDTHS_LANDSCAPE);

if (controller.getClient().isNav())
{
	adjustWidthsForNav(colWidths);
}

// Include expects these vars (constant defined in include itself):
int listType=LIST_TYPE_PRINTABLE;

String staticListSortName=controller.getParam("sn","openDateSort");
boolean staticListSortAscending=controller.getParamAsBoolean("asc",true);
boolean staticListDoFilterIfFound=true;



%>


<%@ include file="includes/staticListTop.jsp" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<SCRIPT src=../global/HashMap.js></script>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/cookieJs.jsp" %>

<%@ include file="js/issuesHeadInclude.jsp" %>



<SCRIPT src=js/ListManager.js></script>

<script language="JavaScript">

<%@ include file="js/msToLabelsMap.jsp" %>

var numIssues="<%=issues.size()%>"

var sortName="<%=controller.getParam("sn","openDateSort")%>"
var sortAscending=<%=controller.getParamAsBoolean("asc",true)%>

window.focus();

if (okToShowDialog("printalert"))
{
	generalAlert("To print this list, choose \"Print\" from the \"File\" menu."+dontShowHTML("printalert",false))
}

function init()
{
}

</script> 


  

<style type="text/css">

.dataCellWidthConstraint {overflow:hidden;}

.dataCellLeft {border-left:1px solid #000000; border-bottom:1px solid #000000; padding:2px; padding-top:1px; padding-bottom:1px; overflow:hidden; font-size:<%=textSize%>px; font-family:arial,helvetica; }
.dataCell {border-left:1px solid #000000; border-bottom:1px solid #000000; padding:2px; padding-top:1px; padding-bottom:1px; overflow:hidden; font-size:<%=textSize%>px; font-family:arial,helvetica; }
.filterDetailFont {font-family:arial,helvetica; font-size:<%=textSize%>px; color:#000000; }
.filteredFieldFont {color:#000000; }

#filterInfoHeader {z-index:99; border:1px solid #000000; 
background-color:#ffffff; padding:2px; font-size:<%=(textSize+1)%>px; width:640px; font-family:arial,helvetica; color:#000000; }

#filterInfoText {z-index:99; border:1px solid #000000; background-color:#ffffff; padding:2px; font-size:<%=textSize%>px; border-top:0px solid #000000; 
font-family:arial,helvetica; width:640px; }

#filterInfo {}
.ruleRow {display:none;}  

.evenDataRow {background-color:#ffffff; color:#000000; cursor:auto; } 
.oddDataRow {background-color:#<%=(isShadeAltRows?"cccccc":"ffffff")%>; color:#000000; cursor:auto; } 
.headerRow {background-color:#ffffff;}
.boldishColumnHeaderFont {color:#000000; font-family:arial,helvetica; font-size:<%=(textSize+1)%>px; }

.headerFont {font-family:arial,helvetica; font-size:<%=(textSize+4)%>px; color:#000000; }
.printableBodyFont {font-family:arial,helvetica; font-size:<%=(textSize+1)%>px; color:#000000;}
#mainDiv { position:relative; top:10px; left:10px; }
.mainDivClass {}


#headerDiv {}
#popupHeaderDiv {}
#popupMainDiv {}

#noIssuesIndicator {position:relative; top:10px; left:95px; width:460px; text-align:center; border:1px solid #000000; background-color:#ffffff; padding:4px; font-family:arial,helvetica; font-size:11px; color:#000000; }

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>


 


<div id=mainDiv style="width:500px;" class=mainDivClass>

 
<span style="width:640px;">
<font class=headerFont><B>WorkRoll <%=WorkRollConstants.APP_VERSION%>:</B> <%=headerText%><BR><BR>
</font>

<font class=printableBodyFont>
<B>Date/Time Printed:</B> <%=new java.util.Date()%><BR>
<B>Active or Closed:</B> <%=isActiveIssues?"Active (only \"open\" or \"resolved\" issues appear on this list)":"Closed (\"open\" and \"resolved\" issues do not appear on this list)"%><BR>
<B>Sort:</B> The list is sorted on the "<%=sortNamesToColumnNamesMap.get(sortName)%>" column in <%=(isAscendingSort?"ascending":"descending")%> order<BR>
<B>Filter:</B> <%=(filter==null?"The list is not filtered; all "+issues.size()+" issues are shown":"The list is filtered (see below)")%><BR>
</font>

<BR>
<%
boolean isActiveListFooter=false;
String filterTableWidth="632";

%>
<%@ include file="includes/filterInfo.jsp" %>
<%=HtmlUtils.spacer(4, 1, request)%><BR>
<%
%>

<%@ include file="includes/staticList.jsp" %>




</div>




<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

