

<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
       

<% PageUtils.jspStart(request); %>
    
<%@ page import="java.util.*" %>   
      
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>

<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>
 
<%@ include file="../global/topInclude.jsp" %>
<%!

static final String[] STATUS_LABELS={"Open","Resolved","Any"};
	
static final String[] PRIORITY_LABELS={"Any","Low or above","Normal or above","High or above","Emergency",};

static final int OBJECT_TYPE_PROJECT=0;
static final int OBJECT_TYPE_INSTANCE=1;
static final int OBJECT_TYPE_BY_USER=2;
static final int OBJECT_TYPE_TO_USER=3;


static final boolean optionsAreSelected(boolean[] projOrInstanceSelectedStates)
{
	for (int i=0; i<projOrInstanceSelectedStates.length; i++)
	{
		if (projOrInstanceSelectedStates[i])
		{
			return true;
		}
	}
	return false;
}

static final boolean optionsAreSelected(IssueFilter filter, int objectType) // objectType=OBJECT_TYPE_BY_USER or OBJECT_TYPE_TO_USER
{
	int[] suppressedIds={};
	if (objectType==OBJECT_TYPE_BY_USER)
	{
		suppressedIds=filter.getSuppressAssignedByUserIds();
	}
	else if (objectType==OBJECT_TYPE_TO_USER)
	{
		suppressedIds=filter.getSuppressAssignedToUserIds();
	}
	if (suppressedIds==null)
	{
		suppressedIds=new int[0];
	}
	return (suppressedIds.length>0);
}

static int getDateField(Date date, int field, boolean dateIsAny)
{
	if (dateIsAny)
	{
		return -1;
	}
	Calendar cal=Calendar.getInstance();
	cal.setTime(date);
	return cal.get(field);
}


static final String truncateWithEllipses(String s, int maxLength)
{
	if (s==null)
	{
		return "";
	}
	if (s.length()<=maxLength)
	{
		return new String(s);
	}
	return s.substring(0,maxLength)+"...";
}

static final boolean isSpecificDate(Date date)
{
	long dateMs=date.getTime();
	return
	(
		dateMs!=IssueFilter.NO_MINIMUM_DATE.getTime() &&
		dateMs!=IssueFilter.NO_MAXIMUM_DATE.getTime()
	);
}


static final boolean isSuppressed(int id, IssueFilter filter, int objectType) // objectType=one of the OBJECT_TYPE_* constants defined above
{
	int[] suppressedIds=null;
	if (objectType==OBJECT_TYPE_PROJECT)
	{
		suppressedIds=filter.getSuppressProjectIds();
	}
	else if (objectType==OBJECT_TYPE_INSTANCE)
	{
		suppressedIds=filter.getSuppressInstanceIds();
	}
	else if (objectType==OBJECT_TYPE_BY_USER)
	{
		suppressedIds=filter.getSuppressAssignedByUserIds();
	}
	else if (objectType==OBJECT_TYPE_TO_USER)
	{
		suppressedIds=filter.getSuppressAssignedToUserIds();
	}
	if (suppressedIds==null)
	{
		suppressedIds=new int[0];
	}
	for (int i=0; i<suppressedIds.length; i++)
	{
		if (suppressedIds[i]==id)
		{
			return true;
		}
	}
	return false;
}

%>        

<%


IssueFilter filter=controller.getSessionInfo().getCurrentFilter();

// temp:
/*
filter=new IssueFilter();
filter.setShowOnlyAssignedBySelf(false);
filter.setShowOnlyAssignedToSelf(false);

int[] suppressIds={1,3};
filter.setSuppressProjectIds(suppressIds);
filter.setSuppressInstanceIds(suppressIds);
filter.setSuppressAssignedByUserIds(suppressIds);
suppressIds=new int[1];
suppressIds[0]=2;
filter.setSuppressAssignedToUserIds(suppressIds);

filter.setLowestPriority(30);
filter.setStatuses(2);

//filter.setEarliestOpenDate(IssueFilter.NO_MINIMUM_DATE);
//filter.setLatestOpenDate(IssueFilter.NO_MAXIMUM_DATE);
filter.setEarliestDueDate(IssueFilter.NO_MINIMUM_DATE);
//filter.setLatestDueDate(IssueFilter.NO_MAXIMUM_DATE);

filter.setEarliestOpenDate(new Date(new Date().getTime()-(1000l*60l*60l*24l*5l)));
filter.setLatestOpenDate(new Date(new Date().getTime()+(1000l*60l*60l*24l*43)));
//filter.setEarliestDueDate(new Date(new Date().getTime()-(1000l*60l*60l*24l*233)));
filter.setLatestDueDate(new Date(new Date().getTime()+(1000l*60l*60l*24l*783)));

*/

boolean isListWasUnfiltered=(filter==null);



if (isListWasUnfiltered)
{
	filter=new IssueFilter();
}


// shouldn't happen, but:
int[] emptyArray={};
if (filter.isShowOnlyAssignedBySelf())
{
	filter.setSuppressAssignedByUserIds(emptyArray);
}
if (filter.isShowOnlyAssignedToSelf())
{
	filter.setSuppressAssignedToUserIds(emptyArray);
}


Date earliestOpenDate=filter.getEarliestOpenDate();
Date earliestDueDate=filter.getEarliestDueDate();
Date latestOpenDate=filter.getLatestOpenDate();
Date latestDueDate=filter.getLatestDueDate();

boolean earliestOpenDateIsAny=!isSpecificDate(earliestOpenDate);
int earliestOpenDateYear=getDateField(earliestOpenDate,Calendar.YEAR,earliestOpenDateIsAny);
int earliestOpenDateMonth=getDateField(earliestOpenDate,Calendar.MONTH,earliestOpenDateIsAny);
int earliestOpenDateDate=getDateField(earliestOpenDate,Calendar.DATE,earliestOpenDateIsAny);

boolean earliestDueDateIsAny=!isSpecificDate(earliestDueDate);
int earliestDueDateYear=getDateField(earliestDueDate,Calendar.YEAR,earliestDueDateIsAny);
int earliestDueDateMonth=getDateField(earliestDueDate,Calendar.MONTH,earliestDueDateIsAny);
int earliestDueDateDate=getDateField(earliestDueDate,Calendar.DATE,earliestDueDateIsAny);

boolean latestOpenDateIsAny=!isSpecificDate(latestOpenDate);
int latestOpenDateYear=getDateField(latestOpenDate,Calendar.YEAR,latestOpenDateIsAny);
int latestOpenDateMonth=getDateField(latestOpenDate,Calendar.MONTH,latestOpenDateIsAny);
int latestOpenDateDate=getDateField(latestOpenDate,Calendar.DATE,latestOpenDateIsAny);

boolean latestDueDateIsAny=!isSpecificDate(latestDueDate);
int latestDueDateYear=getDateField(latestDueDate,Calendar.YEAR,latestDueDateIsAny);
int latestDueDateMonth=getDateField(latestDueDate,Calendar.MONTH,latestDueDateIsAny);
int latestDueDateDate=getDateField(latestDueDate,Calendar.DATE,latestDueDateIsAny);


Calendar now=Calendar.getInstance();
int nowYear=now.get(Calendar.YEAR);
int nowMonth=now.get(Calendar.MONTH);
int nowDate=now.get(Calendar.DATE);

User thisUser=controller.getSessionInfo().getUser();

// default these as if we're creating a new filter:



int menuFirstYear=nowYear-10;
int menuLastYear=nowYear+20;



%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>


<% // Re following js include: "Calendar" replicates java.util.Calendar to some extent; it is not a set of scripts specific to this popup calendar module: %>
<SCRIPT src=../global/Calendar.js></script>

<SCRIPT src=../global/HashMap.js></script>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/popupHeadInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>
<%@ include file="../global/cookieJs.jsp" %>






<script language="JavaScript">

top.focus()

top.setModalReturnValue(false)

var formSubmitted=false;

var isListWasUnfiltered=<%=""+isListWasUnfiltered%>

var earliestOpenDateMs=<%=earliestOpenDate.getTime()%>
var earliestDueDateMs=<%=earliestDueDate.getTime()%>
var latestOpenDateMs=<%=latestOpenDate.getTime()%>
var latestDueDateMs=<%=latestDueDate.getTime()%>


var commentsEmailAddress="<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>"

var now=new Date(<%=now.getTime().getTime()%>)

function deselectMenu(menuName)
{
	var menuOptions=document.forms["mainForm"].elements[menuName].options
	for (var i=0; i<menuOptions.length; i++)
	{
		menuOptions[i].selected=false
	}
	
}

function setDateMenus(dateTypePrefix,isAny)
{
	var els=document.forms["mainForm"].elements
	var dateMenu=els[dateTypePrefix+"Date"]
	var monthMenu=els[dateTypePrefix+"Month"]
	var yearMenu=els[dateTypePrefix+"Year"]
	if (isAny)
	{
		dateMenu.selectedIndex=0;
		monthMenu.selectedIndex=0;
		yearMenu.selectedIndex=0;
	}
	else
	{
		selectMenuOption(dateMenu,window.now.getDate())
		selectMenuOption(monthMenu,window.now.getMonth())
		selectMenuOption(yearMenu,window.now.getFullYear())
	}
}

function checkRadioById(id)
{
	document.forms["mainForm"].elements[id].checked=true
}



function launchCalendar(formObj,fieldPrefix)
{
	var els=formObj.elements
	
	var date=els[fieldPrefix+"Date"].options[els[fieldPrefix+"Date"].selectedIndex].value
	var month=els[fieldPrefix+"Month"].options[els[fieldPrefix+"Month"].selectedIndex].value
	var year=els[fieldPrefix+"Year"].options[els[fieldPrefix+"Year"].selectedIndex].value

	if (date=="") {date=new Date(window.now).getDate()}
	else {date=parseInt(date)}
	
	if (month=="") {month=new Date(window.now).getMonth()}
	else {month=parseInt(month)}
	
	if (year=="") {year=new Date(window.now).getFullYear()}
	else {year=parseInt(year)}
	
	// have to make sure date of month is valid for month:
	var dateTestCal=new Calendar()
	dateTestCal.set(dateTestCal.DATE,1)
	dateTestCal.set(dateTestCal.MONTH,month)
	dateTestCal.set(dateTestCal.YEAR,year)
	dateTestCal.set(dateTestCal.HOUR,0)
	date=Math.min(date,dateTestCal.getDaysInMonth())
	
	var url="issues/calendar.jsp?date="+date+"&month="+month+"&year="+year+"&hour=0&showTime=false"
	
	callbackValuesHolder.els=els
	callbackValuesHolder.fieldPrefix=fieldPrefix
	openDialogWithCallback(url, "calendarWin", 274, 258, false, true,"launchCalendarCALLBACK")
} 
function launchCalendarCALLBACK(newDateArray)
{
	// if user didn't choose a date, then newDateArray will equal []; otherwise it will be
	// a four-el array of nums: year, month, date, hour (using array instead of object or
	// custom object b/c have had trouble in the past with objects returned by modal
	// dialogs; also passing values as vars, not array, to setNewDate(), for same reason):
	if (newDateArray!=null && newDateArray.length==4)
	{
		setNewDate(callbackValuesHolder.els,newDateArray[0],newDateArray[1],newDateArray[2],newDateArray[3],callbackValuesHolder.fieldPrefix)
	}
	
}

function setNewDate(els,year,month,date,hour,fieldPrefix)
{
	setSelect(els[fieldPrefix+"Year"],""+year)
	setSelect(els[fieldPrefix+"Month"],""+month)
	setSelect(els[fieldPrefix+"Date"],""+date)
}

function setSelect(selectObj,s)
{
	for (var i=0; i<selectObj.options.length; i++)
	{
		var thisOption=selectObj.options[i]
		if (thisOption.value==s)
		{
			thisOption.selected=true
		}
		else
		{
			thisOption.selected=false
		}
	}
}

function isValidRadioMenuCombination(radioObj,multiMenuObj)
{
	if (!radioObj.checked)
	{
		return true
	}
	var selectedOptionFound=false
	for (var i=0; i<multiMenuObj.options.length; i++)
	{
		if (multiMenuObj.options[i].selected)
		{
			selectedOptionFound=true
			break
		}
	}
	return selectedOptionFound
}

function isValidRadioDateCombination(fieldPrefix)
{
	
	var thisDateRadioObj=document.getElementById(fieldPrefix+"AllFalse")
	if (!thisDateRadioObj.checked)
	{
		return true
	}
	var els=document.forms["mainForm"].elements
	var date=els[fieldPrefix+"Date"].options[els[fieldPrefix+"Date"].selectedIndex].value
	var month=els[fieldPrefix+"Month"].options[els[fieldPrefix+"Month"].selectedIndex].value
	var year=els[fieldPrefix+"Year"].options[els[fieldPrefix+"Year"].selectedIndex].value
	if (date=="" || month=="" || year=="")
	{
		return false
	}
	var testCal=new Calendar(new Date(year,month,1,0,0,0,0).getTime())
	if (date>testCal.getDaysInMonth())
	{
		return false
	}
	return true

}


function fromToDatesValid(dateType)
{
	if (document.getElementById("earliest"+dateType+"DateAllFalse").checked && document.getElementById("latest"+dateType+"DateAllFalse").checked)
	{
		var els=document.forms["mainForm"].elements
		
		var date=els["earliest"+dateType+"DateDate"].options[els["earliest"+dateType+"DateDate"].selectedIndex].value
		var month=els["earliest"+dateType+"DateMonth"].options[els["earliest"+dateType+"DateMonth"].selectedIndex].value
		var year=els["earliest"+dateType+"DateYear"].options[els["earliest"+dateType+"DateYear"].selectedIndex].value
		var earliest=new Date(year,month,date,0,0,0,0)
		
		date=els["latest"+dateType+"DateDate"].options[els["latest"+dateType+"DateDate"].selectedIndex].value
		month=els["latest"+dateType+"DateMonth"].options[els["latest"+dateType+"DateMonth"].selectedIndex].value
		year=els["latest"+dateType+"DateYear"].options[els["latest"+dateType+"DateYear"].selectedIndex].value
		var latest=new Date(year,month,date,0,0,0,0)
		if (earliest.getTime()>latest.getTime())
		{
			return false
		}
		return true
	}
	else
	{
		return true
	}
}
	
	
function isValidForm(formObj)
{
	// don't allow submit more than once:
	if (window.formSubmitted)
	{
		return false;
	}
	var els=formObj.elements
	
	if (!isValidRadioMenuCombination(document.getElementById("projectTypeSuppress"),els["projectIds"]))
	{
		errorAlert("Under \"Project,\" you have chosen \"Show all but selected,\" but you have not selected any projects. Please fix and try again.",els["projectIds"])
		return false
	}
	if (!isValidRadioMenuCombination(document.getElementById("instanceTypeSuppress"),els["instanceIds"]))
	{
		errorAlert("Under \"Instance,\" you have chosen \"All but selected,\" but you have not selected any instances. Please fix and try again.",els["instanceIds"])
		return false
	}
	if (!isValidRadioMenuCombination(document.getElementById("assignedByTypeSuppress"),els["assignedByUsers"]))
	{
		errorAlert("Under \"Assigned by,\" you have chosen \"Show all but selected,\" but you have not selected any users. Please fix and try again.",els["assignedByUsers"])
		return false
	}
	if (!isValidRadioMenuCombination(document.getElementById("assignedToTypeSuppress"),els["assignedToUsers"]))
	{
		errorAlert("Under \"Assigned to,\" you have chosen \"Show all but selected,\" but you have not selected any users. Please fix and try again.",els["assignedToUsers"])
		return false
	}

	if (!isValidRadioDateCombination("earliestOpenDate"))
	{
		errorAlert("Under \"Open date,\" for the \"from\" date, you have chosen \"This date,\" but the date you have selected is not valid. Please fix and try again.",els["earliestOpenDateMonth"])
		return false
	}
	if (!isValidRadioDateCombination("latestOpenDate"))
	{
		errorAlert("Under \"Open date,\" for the \"to\" date, you have chosen \"This date,\" but the date you have selected is not valid. Please fix and try again.",els["latestOpenDateMonth"])
		return false
	}
	if (!isValidRadioDateCombination("earliestDueDate"))
	{
		errorAlert("Under \"Due date,\" for the \"from\" date, you have chosen \"This date,\" but the date you have selected is not valid. Please fix and try again.",els["earliestDueDateMonth"])
		return false
	}
	if (!isValidRadioDateCombination("latestDueDate"))
	{
		errorAlert("Under \"Due date,\" for the \"to\" date, you have chosen \"This date,\" but the date you have selected is not valid. Please fix and try again.",els["latestDueDateMonth"])
		return false
	}
	
	if (!fromToDatesValid("Open"))
	{
		errorAlert("Under \"Open date,\" the \"from\" date is later than the \"to\" date. Please fix and try again.",els["earliestOpenDateMonth"])
		return false
	}
	if (!fromToDatesValid("Due"))
	{
		errorAlert("Under \"Due date,\" the \"from\" date is later than the \"to\" date. Please fix and try again.",els["earliestDueDateMonth"])
		return false
	}
	
	window.formSubmitted=true
	hidePageAndShowPleaseWait()
	return true
}


  
 
function storeFilterSuccess(isSuccess)
{
	if (isSuccess)
	{
		if (okToShowDialog("filternotice"))
		{
			generalAlert((isListWasUnfiltered?"The list will now be redisplayed based on the filter you have just created.":"The list will now be redisplayed based on your filter changes.")+dontShowHTML("filternotice",false))
		}
		top.setModalReturnValue(true)
	}
	else
	{
		errorAlert("There was a problem; the list will not be filtered.  You may wish to tell your administrator, or send e-mail to "+window.commentsEmailAddress+".")
		top.setModalReturnValue(false)
	}
	top.doModalClose()
} 


function init()
{
	if (document.getElementById("submitButton").focus)
	{
		document.getElementById("submitButton").focus()
	}
}
</script> 

<style type="text/css">
.inputClass {padding:2px; height:20px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; width:294px; } 
.textareaClass {padding:4px; height:120px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; } 
.selectClass {padding:2px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; }
.xradioClass {height:20px; }
</style>

 
  
 
</head>

<%@ include file="../global/bodyOpen.jsp" %>  

<div id=popupMainDiv style="width:500px; ">
<form action=processFilterInput.jsp target=hiddensubmitter method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>

<font class=bodyFont>

<span class=firstSentenceFont><%
if (isListWasUnfiltered)
{
	%>
	Apply a filter<%=HelpManager.helpLink("filter","F2F2E1",request)%> by 
	<%
}
else
{
	%>
	Modify the current filter<%=HelpManager.helpLink("filter","F2F2E1",request)%> by
	<%
}

%></span> 


<%
if (isListWasUnfiltered)
{
	%>
	completing all relevant fields below
	<%
}
else
{
	%>
	making changes to the fields below
	<%
}

%> and pressing the "apply" button. The filter will display only issues matching the criteria you choose:
<BR><BR>



<%
ArrayList users=Manager.selectAllUsers();
if (users==null)
{
	users=new ArrayList();
}
%>


<table border=0 cellspacing=0 cellpadding=0>
<tr>
<td>
	<span class=boldishFont>Status<%=HelpManager.helpLink("status","F2F2E1",request)%></span><span class=bodyFont> (applies to<br></span>
</td>
<td><%=HtmlUtils.spacer(2, 15, request)%><br></td>
<td>
	<span class=boldishFont>Project<%=HelpManager.helpLink("project","F2F2E1",request)%></span><BR>
</td>
<td><%=HtmlUtils.spacer(2, 5, request)%><br></td>
<td>
	<span class=boldishFont>Instance<%=HelpManager.helpLink("instance","F2F2E1",request)%></span><BR>
</td>
<td><%=HtmlUtils.spacer(2, 5, request)%><br></td>
<td>
	<span class=boldishFont>Assigned by<%=HelpManager.helpLink("assignedByUser","F2F2E1",request)%></span><BR>
</td>
<td><%=HtmlUtils.spacer(2, 5, request)%><br></td>
<td>
	<span class=boldishFont>Assigned to<%=HelpManager.helpLink("assignedToUser","F2F2E1",request)%></span><BR>
</td>

</tr>
<tr valign=top>
<td>
<span class=bodyFont>active-issues list only)<BR></span>
<%=HtmlUtils.spacer(3, 5, request)%><BR>
	<select name=status id=status class=selectText style="width:110px; ">
	<%
	int[] codes={IssueFilter.OPEN_ONLY,IssueFilter.RESOLVED_ONLY,IssueFilter.OPEN_AND_RESOLVED,};
	String[] labels=STATUS_LABELS;
	for (int i=0; i<codes.length; i++)
	{
		%>
		<option value="<%=codes[i]%>" <%=filter.getStatuses()==codes[i]?" selected":""%>><%=labels[i]%></option>
		<%
	}
	%>
	</select><%=HtmlUtils.doubleLB(request)%><BR>
	<span class=boldishFont>Priority<%=HelpManager.helpLink("priority","F2F2E1",request)%><BR></span>
	<select name=priority id=priority class=selectText style="width:110px; ">
	<%
	codes=AbstractIssue.PRIORITY_CODES;
	labels=PRIORITY_LABELS;
	for (int i=0; i<codes.length; i++)
	{
		%>
		<option value="<%=codes[i]%>" <%=filter.getLowestPriority()==codes[i]?" selected":""%>><%=labels[i]%></option>
		<%
	}
	%>
	
	</select><%=HtmlUtils.doubleLB(request)%>
</td>
<td><br></td>

<td>
	<%
	ArrayList projects=Manager.selectAllProjects();
	if (projects==null)
	{
		projects=new ArrayList();
	}
	String[] projOrInstanceLabels=new String[projects.size()];
	boolean[] projOrInstanceSelectedStates=new boolean[projects.size()];
	int[] projOrInstanceIds=new int[projects.size()];
	for (int i=0; i<projects.size(); i++)
	{
		Project project=(Project)projects.get(i);
		projOrInstanceLabels[i]=project.getName();
		projOrInstanceIds[i]=project.getId();
		projOrInstanceSelectedStates[i]=isSuppressed(project.getId(),filter,OBJECT_TYPE_PROJECT);
	}
	String projectOrInstance="project";
	%>
	<%@ include file="filterInputProjOrInstanceInclude.jsp" %>
	
</td>
<td><br></td>
<td>
	<%
	ArrayList instances=Manager.selectAllInstances();
	if (instances==null)
	{
		instances=new ArrayList();
	}
	projOrInstanceLabels=new String[instances.size()];
	projOrInstanceSelectedStates=new boolean[instances.size()];
	projOrInstanceIds=new int[instances.size()];
	for (int i=0; i<instances.size(); i++)
	{
		Instance instance=(Instance)instances.get(i);
		projOrInstanceLabels[i]=instance.getName();
		projOrInstanceIds[i]=instance.getId();
		projOrInstanceSelectedStates[i]=isSuppressed(instance.getId(),filter,OBJECT_TYPE_INSTANCE);
	}
	projectOrInstance="instance";
	%>

	<%@ include file="filterInputProjOrInstanceInclude.jsp" %>
	
</td>
<td><br></td>
<td>
	<% 
	String userTypePrefix="By";
	String truncatedSelfName=truncateWithEllipses(controller.getSessionInfo().getUser().getFullname(),9);
	boolean isSelfOnly=filter.isShowOnlyAssignedBySelf();
	%>
	<%@ include file="filterInputUserInclude.jsp" %>
</td>
<td><br></td>
<td>
	<% 
	userTypePrefix="To";
	isSelfOnly=filter.isShowOnlyAssignedToSelf();
	%>
	<%@ include file="filterInputUserInclude.jsp" %>
	
</td>

</tr>
</table>


 

<%=HtmlUtils.spacer(8, 2, request)%><BR>



<%
// Define each of these before each inclusion of filterInputDateInclude.jsp:
String dateTypePrefix;
int selectedDate;
int selectedMonth;
int selectedYear;
boolean dateIsAny;
%>

<table border=0 cellspacing=0 cellpadding=0>
<tr>
<td>

	<table border=0 cellspacing=0 cellpadding=0>
	<tr>
	<td>
		<span class=boldishFont>Open date<%=HelpManager.helpLink("openedDate","F2F2E1",request)%></span><span class=bodyFont><i> from...</i></span><BR>
	</td>
	<td>&nbsp;&nbsp;<br></td>
	<td>
		<span class=bodyFont><i>...to:</i></span><BR>
	</td>
	</tr>
	<tr>
	<td>
		<% 
		dateTypePrefix="earliestOpenDate";
		selectedDate=earliestOpenDateDate; 
		selectedMonth=earliestOpenDateMonth; 
		selectedYear=earliestOpenDateYear;
		dateIsAny=earliestOpenDateIsAny;
		
		%>
		<%@ include file="filterInputDateInclude.jsp" %>
	</td>
	<td><br></td>
	<td>
		<% 
		dateTypePrefix="latestOpenDate";
		selectedDate=latestOpenDateDate; 
		selectedMonth=latestOpenDateMonth; 
		selectedYear=latestOpenDateYear; 
		dateIsAny=latestOpenDateIsAny;

		%>
		<%@ include file="filterInputDateInclude.jsp" %>
	</td>
	</tr>
	</table>
</td>
<td>&nbsp;&nbsp;&nbsp;&nbsp;<BR></td>
<td>



	<table border=0 cellspacing=0 cellpadding=0>
	<tr>
	<td>
		<span class=boldishFont>Due date<%=HelpManager.helpLink("dueDate","F2F2E1",request)%></span><span class=bodyFont><i> from...</i></span><BR>
	</td>
	<td>&nbsp;&nbsp;<br></td>
	<td>
		<span class=bodyFont><i>...to:</i></span><BR>
	</td>
	</tr>
	<tr>
	<td>
		<% 
		dateTypePrefix="earliestDueDate";
		selectedDate=earliestDueDateDate; 
		selectedMonth=earliestDueDateMonth; 
		selectedYear=earliestDueDateYear; 
		dateIsAny=earliestDueDateIsAny;

		%>
		<%@ include file="filterInputDateInclude.jsp" %>
	</td>
	<td><br></td>
	<td>
		<% 
		dateTypePrefix="latestDueDate";
		selectedDate=latestDueDateDate; 
		selectedMonth=latestDueDateMonth; 
		selectedYear=latestDueDateYear; 
		dateIsAny=latestDueDateIsAny;

		%>
		<%@ include file="filterInputDateInclude.jsp" %>
	</td>
	</tr>
	</table>
</td>
</tr>
</table>



<%=HtmlUtils.spacer(9, 2, request)%><BR>



 
<BR>

<input id="submitButton" class=formButton type=submit value="apply"> <input  class=formButton type=button value=cancel onclick="top.doModalClose()"><BR>

<BR>
</font>

</form>	

</div>

<%@ include file="../global/popupBodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>


