<%@ page import="com.workroll.app.help.HelpManager" %>

<%=HelpManager.itemTitle("Errors")%>


You are likely to encounter certain types of errors while using WorkRoll, and less likely to encounter others, as follows:

<ul>
<li><I>User errors.</I>  For example, leaving an input field blank which must not be blank; entering a malformed e-mail address, etc.  Users are alerted to these types of errors via a dialog box and allowed to fix them before the form is summitted.
<LI><I>Authentication errors.</I> For example, mis-typing a username or password while logging in.  Users are alerted to these errors after the screen in question has been submitted; the solution to authentication errors can involve simply re-typing the username or password, speaking to an <%=HelpManager.itemLink("administrator","administrator")%> who may have accidentally disabled a user and who can also reset forgotten passwords (note, however, that for security, administrators cannot view or retrieve existing passwords), or supplying the answer to a "secret question" entered previously
<li><I>Browser incompatibility errors.</I>  WorkRoll supports a <%=HelpManager.itemLink("large number of web browsers","clientPlatform")%>, but not all web browsers.  Users who attempt to access WorkRoll with an incompatible browser receive an error screen telling them what browsers are compatible with WorkRoll.  An e-mail address for hate mail regarding this issue is also supplied.  (Users will also receive this error screen if they have either cookies or JavaScript disabled; the solution in such a case is simply for the user to re-enable the disabled technology.)
<li><I>SMTP-related errors.</I>  WorkRoll uses the highly abstracted JavaMail API to communicate with your SMTP (outgoing-mail) server, assuming you have e-mail notifications and reminders enabled.  (WorkRoll only sends mail -- it doesn't receive it -- so it does not use JavaMail to communicate with your POP, IMAP, or other incoming-mail server.)  Sending mail via SMTP and JavaMail is generally a simple task.  However there are many, many SMTP-server platforms available, and a near-infinite number of ways to configure them, especially with regard to authentication.  WorkRoll provides for end-to-end testing of WorkRoll-JavaMail-SMTP communication, so you will likely be aware of any SMTP-related problems before your mail-setup is finished, and WorkRoll attempts to give you helpful advice on what the problem might be (often the problem is a typo).  Once configured, though, both notifications and reminders are sent in background threads, so errors encountered in SMTP-server communication may not be immediately apparent (they are, however, logged so that administrators can review them).  Generally such errors will be user-specific: a mis-entered e-mail address, a local e-mail address that doesn't exist, etc.  But errors are almost assured to occur with some configurations.  WorkRoll makes it as convenient as possible for users to report such errors to WorkRoll.com, and such reporting is always appreciated.  Note: SMTP-related errors will never interfere with the otherwise normal operation of a WorkRoll installation.
<li><I>Server-environment problems.</I>  WorkRoll does what it can to ensure that it is working within a properly configured Java environment, but like any Java application, it will be tripped up by the lack of access to standard J2SE packages (JavaMail however, while common, is not standard, so WorkRoll checks for its existence before allowing an administrator to attempt to configure e-mail notifications and reminders).  Such errors will appear as application errors (see next item).  Filesystem I/O errors are also possible, such as if the directory containing the WorkRoll database unexpectedly becomes read-protected or otherwise unavailable.  Such errors will also appear as application errors (see next item).
<li><I>Application errors.</I>  If WorkRoll itself malfunctions, you will be alerted to this fact via a prominent (red) dialog box with as much information about the situation that caused the problem as is available (server- and client-platofrm information, a stack trace, etc.).  As with SMTP problems, users (and especailly administrators) are encouraged to report such errors to WorkRoll.com; a "mailto" link accompanies application-error reports for this purpose.
</ul>

<BR><BR>






