
<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %><%@ page import="com.workroll.app.WorkRollConstants" %><%@ page import="com.workroll.app.help.*" %><%@ page import="com.workroll.app.control.*" %><%@ page import="com.workroll.app.util.PageUtils" %><%@ page import="com.workroll.app.util.HtmlUtils" %><%@ page import="com.workroll.app.util.Printer" %><%!


String[] MONTHS_ABBREV={"Jan.","Feb.","Mar.","Apr.","May","Jun.","Jul.","Aug.","Sep.","Oct.","Nov.","Dec.",};
String[] MONTHS_VERBOSE={"January","February","March","April","May","June","July","August","September","October","November","December",};
int[] MONTH_LENGTHS={31,28,31,30,31,30,31,31,30,31,30,31};

int[] LEAP_YEARS={2000, 2004, 2008, 2012, 2016, 2020, 2024, 2028, 2032, 2036, 2040, 2044, 2048, 2052};

String[] WEEKDAYS_ABBREV={"Sun.","Mon.","Tue.","Wed.","Thu.","Fri.","Sat.",};
String[] WEEKDAYS_VERBOSE={"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday",};

String[] sortNames={"idSort","assignedByUserFullnameSort","assignedToUserFullnameSort","statusSort","prioritySort","projectNameSort","instanceNameSort","openDateSort","dueDateSort","descriptionSort",""};

%><%

PageUtils.doCompileOnlyCheck(request);

Throwable pageException=null;

try
{
	// Rest of the JSP is try/catched; if an exception is thrown, bottomInclude.jsp gives pageException a reference to it and some JavaScript that launches an error dialog containing the stack trace and other info is included:

	// for a reason that I don't understand, under Tomcat (and I've seen this also with WebLogic), when
	// pages are POSTed, sometimes the request happens twice, first as a POST and then as a GET.  Therefore,
	// a JSP can specify itself (via PageUtils.setRequiredRequestMethod()) as a "POST page" only, in which
	// case if the page gets the secondary GET request, it can ignore it:
	String requiredRequestMethod=PageUtils.nonNull(PageUtils.getRequiredRequestMethod(request)).trim().toUpperCase();
	String requestMethod=PageUtils.nonNull(request.getMethod()).trim().toUpperCase();

	boolean invalidRequestMethod=false;
	if (requiredRequestMethod.length()>0 && !(requiredRequestMethod.equals(requestMethod)))
	{
		Printer.p("Invalid request method: required="+requiredRequestMethod+"; found="+requiredRequestMethod+".");
		invalidRequestMethod=true;
		Printer.p("sss");
	}


	if (!invalidRequestMethod && !PageUtils.isCompileOnly(request))
	{
		Controller controller=new Controller();
		Printer.p("in topInclude...");
		boolean executePage=controller.doGlobalControl(pageContext);

		// doGlobalControl() returns false if it redirects to another page; we only 
		// execute this page if it returns true (this mostly is here to prevent nullpointers
		// and similar exceptions that occur after the redirect):
		if (executePage)
		{

		%>