<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<%@ page import="java.util.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
<%@ page import="com.workroll.app.entity.*" %>
<%!

// three parallel arrays:
static final String[] SECTION_NAMES=
{
	WorkRollConstants.SECTION_ISSUES,
	WorkRollConstants.SECTION_USER_PREFS,
	//WorkRollConstants.SECTION_PRINT,
	//WorkRollConstants.SECTION_HELP,
	//WorkRollConstants.SECTION_FEEDBACK,
	//WorkRollConstants.SECTION_ABOUT,
	WorkRollConstants.SECTION_LOGIN,
	//WorkRollConstants.SECTION_EXPORT,
	WorkRollConstants.SECTION_ADMIN,
};
static final String[] LINK_URLS=
{
	"issues/index.jsp",
	"userprefs/prefs.jsp",
	"login/login.jsp",
	//"export/export.jsp",
	"admin/menu.jsp",
};
static final String[] LINK_NAMES=
{
	"ISSUES",
	"OPTIONS",
	//"PRINT",
	//"HELP",
	//"FEEDBACK",
	//"ABOUT",
	"LOGIN",
	//"EXPORT",
	"ADMIN",
};

%>

<%


InstallationConfig iConfig=null;
try
{
	iConfig=controller.getCurrentInstallationConfig();
}
catch (Exception e)
{
	// do nothing; this will happen only during the install process:
}

boolean isInstallScreen=(controller.getSection().equals(WorkRollConstants.SECTION_INSTALL));

String rootPath=PageUtils.getPathToAppRoot(request);

String userStatusText;
User currentUser=controller.getSessionInfo().getUser();
String loginStatus=PageUtils.nonNull(controller.getSessionInfo().getLoginStatus()).trim().toLowerCase();
if (loginStatus.equals("user") && currentUser!=null)
{
	userStatusText="logged in as <font color=#323213>"+currentUser.getUsername()+"</font>";
}
else if (loginStatus.equals("superuser") && currentUser!=null)
{
	userStatusText="logged in as <font color=#323213>"+currentUser.getUsername()+" (administrator)</font>";
}
else 
{
	userStatusText="not logged in";
}

int daysLeft=0;
if (iConfig!=null)
{
	daysLeft=iConfig.daysRemainingInTrial();
}

String installationStatusText;
int regType=0;
if (iConfig!=null)
{
	regType=iConfig.getRegistrationType();

}


String registeredToText="";

if (iConfig!=null && iConfig.getCompanyName()!=null && iConfig.getCompanyName().trim().length()>0)
{
	registeredToText=" to <font color=000000>"+iConfig.getCompanyName()+"</font>";
}



if (isInstallScreen)
{
	installationStatusText="installation in progress";
}
else if (regType==iConfig.UNREGISTERED_TIER && daysLeft>=0)
{
	installationStatusText="<font color=#cc0000>"+daysLeft+" days left</font> in trial period (<a href=\""+controller.getPurchaseLink()+"\" target=_blank><font color=#cc0000>register</font></a>)";
}
else if (regType==iConfig.UNREGISTERED_TIER && daysLeft<0)
{
	installationStatusText="<font color=#cc0000>trial period expired (<a href=\""+controller.getPurchaseLink()+"\" target=_blank><font color=#cc0000>register</font></a>)</font>";
}
else
{
	String numPermittedUsers=""+InstallationConfig.MAX_USERS_FOR_TIER[regType];
	if (numPermittedUsers.equals("-1"))
	{
		numPermittedUsers="unlimited";
	}
	installationStatusText="Registered"+registeredToText+" ("+numPermittedUsers+"-user license)";
}



%>

<body onload=init() bgcolor="#FFFFFF" text="#000000" link="#ff6600" vlink="#ff6600" alink="#000000" marginheight=0 marginwidth=0 topmargin=0 leftmargin=0>


<div id=genericPleaseWaitDiv style="width:430px; ">
<span class=standardTextBlockWidth>
<font class=bodyFont>
<span class=firstSentenceFont style="color:#cc0000;">Please wait a moment...</span><BR></font>
</span>
</div>


<%


if (showHeaderElements)
{
	if (!isPopup)
	{
		%>
		<MAP NAME="helpFeedbackAboutSupportMap">
		<AREA SHAPE=RECT COORDS="1,0,25,11" HREF="javascript:launchHelp()" target=_top>
		<AREA SHAPE=RECT COORDS="32,0,82,11" HREF="javascript:launchFeedback(false)" target=_top>
		<AREA SHAPE=RECT COORDS="88,0,120,11" HREF="javascript:launchAbout()" target=_top>
		<AREA SHAPE=RECT COORDS="150,0,191,11" HREF="javascript:launchFeedback(true)" target=_top>
		</MAP>

		<div id=headerDiv>

		<table border=0 cellspacing=0 cellpadding=0 width=865>

		<tr valign=bottom nowrap height=36>
		<td nowrap width=4><%=HtmlUtils.spacer(2,2,request)%><br></td>
		<td nowrap width=134><img src=<%=PageUtils.getPathToAppRoot(request)%>images/logo_main.gif height=28 width=121><br>
		<%=HtmlUtils.spacer(1,2,request)%><br></td>
		<td nowrap width=264>


		<%
		if (!isInstallScreen)
		{
			for (int i=0; i<SECTION_NAMES.length; i++)
			{
				String url=LINK_URLS[i];
				if (url.indexOf(":")==-1)
				{
					url=rootPath+url;
				}
				String linkType="on";
				if (!(currentSectionName.equals(SECTION_NAMES[i])))
				{
					linkType="off";
				}

				%><a href=<%=url%> target=_top><img src=<%=PageUtils.getPathToAppRoot(request)%>images/link_<%=SECTION_NAMES[i]%>_<%=linkType%>.gif border=0></a><%=HtmlUtils.spacer(2,13,request)%><%
			}
		}
		%><BR>
		</td>
		<td nowrap width=463 valign=bottom align=right><%
		if (!isInstallScreen)
		{
			%><img src=<%=PageUtils.getPathToAppRoot(request)%>images/links_helpFeedbackAboutSupport.gif usemap=#helpFeedbackAboutSupportMap height=12 width=191 border=0><%
		}
		
		%><br></td>
		</tr>

		<tr nowrap height=17 valign=bottom>
		<td><%=HtmlUtils.spacer(2,2,request)%><BR></td>
		<td colspan=2><font class=statusFont>User status: <%=userStatusText%><BR></font></td>
		<td align=right><font class=statusFont>Installation status: <%=installationStatusText%><BR></font></td>
		</tr>


		<tr nowrap height=25 valign=bottom>
		<td><%=HtmlUtils.spacer(2,2,request)%><BR></td>
		<td colspan=2><img src=<%=PageUtils.getPathToAppRoot(request)%>images/header_<%=currentSectionName%>.gif height=16 width=157><BR></td>
		<td align=right><%
		if (currentSectionName.equals(WorkRollConstants.SECTION_ISSUES))
		{
			String[] subsectionNames=
			{
				WorkRollConstants.SUBSECTION_ISSUES_ACTIVE,
				WorkRollConstants.SUBSECTION_ISSUES_CLOSED,
				WorkRollConstants.SUBSECTION_ISSUES_IMPORT,
				WorkRollConstants.SUBSECTION_ISSUES_EXPORT,
				WorkRollConstants.SUBSECTION_ISSUES_PRINTABLE,
			};
			String[] subsectionLinks=
			{
				"list.jsp",
				"closed.jsp",
				"javascript:importIssues()",
				"javascript:exportIssues("+(request.getRequestURI().indexOf("closed.jsp")==-1?"true":"false")+")",
				"javascript:printableConfirm()",
			};
			for (int i=0; i<subsectionNames.length; i++)
			{
				// only show "print" if we're on the active- or closed-issues page:
				if (i<subsectionNames.length-1 || currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_ACTIVE)|| currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_CLOSED) || currentSubsectionName.equals(WorkRollConstants.SUBSECTION_ISSUES_ACTIVE_BASIC))
				{
					%><a <%=subsectionLinks[i].indexOf("javascript:")>-1?"":" target=\"_top\" "%> 
					href="<%=subsectionLinks[i]%>"><img vspace=4 style="<%=i>0?"margin-left:"+(i==2?36:7)+"px; ":""%>" 
					src=images/subnav_<%=subsectionNames[i]%>_<%=(currentSubsectionName.indexOf(subsectionNames[i])>-1?"on":"off")%>.gif border=0></a><%
				}
			}
		}
		%></td>
		</tr>


		</table>


		</div> 
		<%
	}
	else
	{
		// page is popup:
		%> 
		<div id=popupHeaderDiv>

		<table border=0 cellspacing=0 cellpadding=0 width=300>

		<tr valign=bottom nowrap height=24> 
		<td nowrap width=4><%=HtmlUtils.spacer(2,2,request)%><br></td>
		<td nowrap width=296><img src=<%=PageUtils.getPathToAppRoot(request)%>images/logo_popup.gif height=19 width=80><br>
		<%=HtmlUtils.spacer(1,2,request)%><br></td>
		</tr>



		<tr nowrap height=23  valign=bottom>
		<td><%=HtmlUtils.spacer(2,2,request)%><BR></td>
		<td><img src=<%=PageUtils.getPathToAppRoot(request)%>images/header_<%=currentSectionName%>_popup.gif height=12 width=75><BR></td>
		</tr>


		</table>


		</div>
		<%
	}
}
%>
 