<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>
   
<%@ include file="../global/topInclude.jsp" %>

<%! 

%>

<%
Properties sysProps=null;
try
{
	sysProps=controller.getSystemProperties();
}
catch (Exception e)
{
	sysProps=new Properties();
}


String operatingSystem=sysProps.getProperty("os.name","")+" "+sysProps.getProperty("os.version","")+" ("+sysProps.getProperty("os.arch","")+")";


String javaVersion="";
try
{
	javaVersion+=sysProps.getProperty("java.vm.version","");
	javaVersion+=", "+sysProps.getProperty("java.vm.vendor","");
}
catch (Throwable t) {}

String appServer="";
try
{
	appServer+=application.getServerInfo();
	appServer+="; Servlet API "+application.getMajorVersion()+"."+application.getMinorVersion();
}
catch (Throwable t)
{}



String currProdKey=null;
try
{
	currProdKey=new String(controller.getCurrentInstallationConfig().getProductKey());
}
catch (Exception e){}
if (currProdKey==null || currProdKey.trim().length()==0)
{
	currProdKey="[unregistered]";
}

ArrayList users=Manager.selectAllUsers();
ArrayList projects=Manager.selectAllProjects();
ArrayList instances=Manager.selectAllInstances();
ArrayList closedIssues=Manager.selectAllClosedIssues();
ArrayList activeIssues=Manager.selectAllNonClosedIssues();

if (users==null) users=new ArrayList();
if (projects==null) projects=new ArrayList();
if (instances==null) instances=new ArrayList();
if (closedIssues==null) closedIssues=new ArrayList();
if (activeIssues==null) activeIssues=new ArrayList();

int numUsers=users.size();
int numActiveIssues=activeIssues.size();
int numClosedIssues=closedIssues.size();
int numIssues=numActiveIssues+numClosedIssues;
int numInstances=instances.size();
int numProjects=projects.size();

int numActiveUsers=0;
for (int i=0; i<users.size(); i++)
{
	User user=(User)users.get(i);
	if (user.isActive())
	{
		numActiveUsers++;
	}
}

String primaryAdmin="<a href=\"mailto:"+controller.getCurrentInstallationConfig().getAdminEmail()+"\">"+controller.getCurrentInstallationConfig().getAdminName()+"</a>";

%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth style="width:600px;">

<font class=bodyFont>

<span class=firstSentenceFont>The following is a summary</span> of your WorkRoll installation's status and data.<%=HtmlUtils.doubleLB(request)%>
<font color=#000000>


</font>


<blockquote>
<B>Total users:</B> <%=numUsers%><%=HtmlUtils.doubleLB(request)%>

<B>Active users:</B> <%=numActiveUsers%><%=HtmlUtils.doubleLB(request)%>

<B>Total issues:</B> <%=numIssues%><%=HtmlUtils.doubleLB(request)%>

<B>Active issues:</B> <%=numActiveIssues%><%=HtmlUtils.doubleLB(request)%>

<B>Closed issues:</B> <%=numClosedIssues%><%=HtmlUtils.doubleLB(request)%>

<B>Total projects:</B> <%=numProjects%><%=HtmlUtils.doubleLB(request)%>

<B>Total instances:</B> <%=numInstances%><%=HtmlUtils.doubleLB(request)%>

<B>Primary administrator:</B> <%=primaryAdmin%><%=HtmlUtils.doubleLB(request)%>

<B>Current product key:</B> <%=currProdKey%><%=HtmlUtils.doubleLB(request)%>

<B>Current installation status:</B> <%=installationStatusText%><%=HtmlUtils.doubleLB(request)%>

<B>WorkRoll server OS:</B> <%=operatingSystem%><%=HtmlUtils.doubleLB(request)%>

<B>WorkRoll server JVM:</B> <%=javaVersion%><%=HtmlUtils.doubleLB(request)%>

<B>WorkRoll server application server:</B> <%=appServer%><%=HtmlUtils.doubleLB(request)%>

<B>Database path:</B> <%=com.workroll.app.filesystem.FileSystem.getDbPath(application,false)%><%=HtmlUtils.doubleLB(request)%>

<B>Installation date/time:</B> <%=new Date(controller.getCurrentInstallationConfig().getInstallTimeInMillis())%><%=HtmlUtils.doubleLB(request)%>


</blockquote>
<input  class=formButton type=button value=back onclick="location.href='menu.jsp'">

<br></font>
</span>

</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

