<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>


<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String mode=controller.getParam("mode"); // "add" or "edit"
boolean success=controller.getParamAsBoolean("success",true);


ArrayList allUsers=Manager.selectAllUsers();
if (allUsers==null)
{
	allUsers=new ArrayList();
}
String[] usernames=new String[allUsers.size()];
String[] fullnames=new String[allUsers.size()];
String[] emailAddresses=new String[allUsers.size()];
String[] passwords=new String[allUsers.size()];
boolean[] actives=new boolean[allUsers.size()];
boolean[] superUsers=new boolean[allUsers.size()];
int[] ids=new int[allUsers.size()];

for (int i=0; i<allUsers.size(); i++)
{
	User user=(User)allUsers.get(i);
	usernames[i]=user.getUsername();
	fullnames[i]=user.getFullname();
	emailAddresses[i]=user.getEmailAddress();
	passwords[i]=user.getPassword();
	actives[i]=user.isActive();
	superUsers[i]=user.isSuperUser();
	ids[i]=user.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth>
<form>
<font class=bodyFont>


<%
if (success)
{
	if (mode.equals("edit"))
	{
		%>
		<span class=firstSentenceFont>Your changes have been made.</span> The current set of users appears below.  You may now:

		<ul>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="users.jsp">make more user changes</a>
		<li><a href="addUsers.jsp">add users</a>
		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
	if (mode.equals("add"))
	{
		%>
		<span class=firstSentenceFont>Your additions have been made.</span> The current set of users appears below.  You may now:

		<ul>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addUsers.jsp">add more users</a>
		<li><a href="users.jsp">make user changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. The current list of instances is below.  You may now:

		<ul>
		<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addUsers.jsp">add more users</a>
		<li><a href="users.jsp">make user changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>

	<%
}
%>

<table border=0 cellspacing=0 cellpadding=0> 
<%@ include file="usersTableHeaderRow.jsp" %>
 
<% 

for (int i=0; i<usernames.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=22>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<%=usernames[i]%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=fullnames[i]%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=HtmlUtils.getMailtoLink(emailAddresses[i])%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=HtmlUtils.getPasswordAsterisks(passwords[i])%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=actives[i]?"yes":"no"%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=superUsers[i]?"yes":"no"%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(8, request)%>
	<%
}

%>

</table><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form></span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

