<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

  
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

static final Date NOW=new Date();

static HashMap getSummaryItemsMap(Project project, ArrayList activeIssues, ArrayList closedIssues)
{
	HashMap ret=new HashMap();
	int activeToTotal=0;
	int activeToOpen=0;
	int activeToOpenVeryLow=0;
	int activeToOpenLow=0;
	int activeToOpenNormal=0;
	int activeToOpenHigh=0;
	int activeToOpenEmergency=0;
	int activeToOverdue=0;
	int activeToOverdueVeryLow=0;
	int activeToOverdueLow=0;
	int activeToOverdueNormal=0;
	int activeToOverdueHigh=0;
	int activeToOverdueEmergency=0;
	int activeToResolved=0;
	int activeByTotal=0;
	int closedByTotal=0;
	int closedToTotal=0;
	
	for (int i=0; i<activeIssues.size(); i++)
	{
		AbstractIssue issue=(AbstractIssue)activeIssues.get(i);
		if (project==null || issue.getProjectId()==project.getId())
		{
			activeToTotal++;
			int status=issue.getStatus();
			int priority=issue.getPriority();
			if (status==AbstractIssue.STATUS_RESOLVED)
			{
				activeToResolved++;
			}
			else
			{
				activeToOpen++;
				if (NOW.getTime()<issue.getDueDate().getTime())
				{
					activeToOverdue++;
					switch (issue.getPriority())
					{
						case AbstractIssue.PRIORITY_VERY_LOW: activeToOverdueVeryLow++; break;
						case AbstractIssue.PRIORITY_LOW: activeToOverdueLow++; break;
						case AbstractIssue.PRIORITY_NORMAL: activeToOverdueNormal++; break;
						case AbstractIssue.PRIORITY_HIGH: activeToOverdueHigh++; break;
						case AbstractIssue.PRIORITY_EMERGENCY: activeToOverdueEmergency++; break;
					}
				}
				else
				{
					switch (issue.getPriority())
					{
						case AbstractIssue.PRIORITY_VERY_LOW: activeToOpenVeryLow++; break;
						case AbstractIssue.PRIORITY_LOW: activeToOpenLow++; break;
						case AbstractIssue.PRIORITY_NORMAL: activeToOpenNormal++; break;
						case AbstractIssue.PRIORITY_HIGH: activeToOpenHigh++; break;
						case AbstractIssue.PRIORITY_EMERGENCY: activeToOpenEmergency++; break;
					}
				}
			}
		}
		if (project==null || issue.getProjectId()==project.getId())
		{
			activeByTotal++;
		}
	}
	for (int i=0; i<closedIssues.size(); i++)
	{
		AbstractIssue issue=(AbstractIssue)closedIssues.get(i);
		if (project==null || issue.getProjectId()==project.getId())
		{
			closedToTotal++;
		}
		if (project==null || issue.getProjectId()==project.getId())
		{
			closedByTotal++;
		}
	}
	
	ret.put("activeToTotal",""+activeToTotal);
	ret.put("activeToOpen",""+activeToOpen);
	ret.put("activeToOpenVeryLow",""+activeToOpenVeryLow);
	ret.put("activeToOpenLow",""+activeToOpenLow);
	ret.put("activeToOpenNormal",""+activeToOpenNormal);
	ret.put("activeToOpenHigh",""+activeToOpenHigh);
	ret.put("activeToOpenEmergency",""+activeToOpenEmergency);
	ret.put("activeToOverdue",""+activeToOverdue);
	ret.put("activeToOverdueVeryLow",""+activeToOverdueVeryLow);
	ret.put("activeToOverdueLow",""+activeToOverdueLow);
	ret.put("activeToOverdueNormal",""+activeToOverdueNormal);
	ret.put("activeToOverdueHigh",""+activeToOverdueHigh);
	ret.put("activeToOverdueEmergency",""+activeToOverdueEmergency);
	ret.put("activeToResolved",""+activeToResolved);
	ret.put("activeByTotal",""+activeByTotal);
	ret.put("closedToTotal",""+closedToTotal);
	ret.put("closedByTotal",""+closedByTotal);
	return ret;
}
%>

<%

ArrayList allProjects=Manager.selectAllProjects();
if (allProjects==null)
{
	allProjects=new ArrayList();
}

ArrayList activeIssues=Manager.selectAllNonClosedIssues();
ArrayList closedIssues=Manager.selectAllClosedIssues();
if (activeIssues==null)
{
	activeIssues=new ArrayList(1);
}
if (closedIssues==null)
{
	closedIssues=new ArrayList(1);
}

String[] names=new String[allProjects.size()];
int[] ids=new int[allProjects.size()];
String[] summaries=new String[allProjects.size()];

StringBuffer summary=null;

for (int i=0; i<allProjects.size(); i++)
{
	Project project=(Project)allProjects.get(i);
	names[i]=project.getName();
	ids[i]=project.getId();
	
	summary=new StringBuffer();
	HashMap summaryItems=getSummaryItemsMap(project,activeIssues,closedIssues);
	summary.append("<b>Active (non-closed) issues associated with this project:</b>");
	summary.append("<blockquote><i>Total: </i><span style=\"\">"+(String)(summaryItems.get("activeToTotal"))+"</span><BR>");
	summary.append("<i>Open: </i><span style=\"\">"+(String)(summaryItems.get("activeToOpen"))+"</span><BR>");
	
	summary.append("<i>Open (by priority): </i><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Very low: <span style=\"\">"+(String)(summaryItems.get("activeToOpenVeryLow"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Low: <span style=\"\">"+(String)(summaryItems.get("activeToOpenLow"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Normal: <span style=\"\">"+(String)(summaryItems.get("activeToOpenNormal"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;High: <span style=\"\">"+(String)(summaryItems.get("activeToOpenHigh"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Emergency: <span style=\"\">"+(String)(summaryItems.get("activeToOpenEmergency"))+"</span><BR><BR>");
	
	summary.append("<i>Open and overdue: </i><span style=\"\">"+(String)(summaryItems.get("activeToOverdue"))+"</span><BR>");
	summary.append("<i>Open and overdue (by priority): </i><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Very low: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueVeryLow"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Low: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueLow"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Normal: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueNormal"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;High: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueHigh"))+"</span><BR>");
	summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Emergency: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueEmergency"))+"</span><BR><BR>");
	summary.append("<i>Resolved: </i><span style=\"\">"+(String)(summaryItems.get("activeToResolved"))+"</span></blockquote>");
	summary.append("<b>Closed issues associated with this project:</b> "+(String)(summaryItems.get("closedByTotal"))+"<BR><BR>");
	
	summary.append("<b>Active (non-closed) issues associated with this project:</b> "+(String)(summaryItems.get("activeByTotal"))+"<BR>");
	summary.append("<b>Closed issues associated with this project:</b> "+(String)(summaryItems.get("closedToTotal"))+"<BR>");
	
	summaries[i]=summary.toString();
}
summary=new StringBuffer();
HashMap summaryItems=getSummaryItemsMap(null, activeIssues, closedIssues);
summary.append("<b>Active (non-closed) issues associated with <I>any project</I>:</b>");
summary.append("<blockquote><i>Total: </i><span style=\"\">"+(String)(summaryItems.get("activeToTotal"))+"</span><BR>");
summary.append("<i>Open: </i><span style=\"\">"+(String)(summaryItems.get("activeToOpen"))+"</span><BR>");

summary.append("<i>Open (by priority): </i><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Very low: <span style=\"\">"+(String)(summaryItems.get("activeToOpenVeryLow"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Low: <span style=\"\">"+(String)(summaryItems.get("activeToOpenLow"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Normal: <span style=\"\">"+(String)(summaryItems.get("activeToOpenNormal"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;High: <span style=\"\">"+(String)(summaryItems.get("activeToOpenHigh"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Emergency: <span style=\"\">"+(String)(summaryItems.get("activeToOpenEmergency"))+"</span><BR><BR>");

summary.append("<i>Open and overdue: </i><span style=\"\">"+(String)(summaryItems.get("activeToOverdue"))+"</span><BR>");
summary.append("<i>Open and overdue (by priority): </i><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Very low: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueVeryLow"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Low: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueLow"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Normal: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueNormal"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;High: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueHigh"))+"</span><BR>");
summary.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Emergency: <span style=\"\">"+(String)(summaryItems.get("activeToOverdueEmergency"))+"</span><BR><BR>");
summary.append("<i>Resolved: </i><span style=\"\">"+(String)(summaryItems.get("activeToResolved"))+"</span></blockquote>");
summary.append("<b>Closed issues associated with <I>any project</I>:</b> "+(String)(summaryItems.get("closedByTotal"))+"<BR><BR>");

String summaryAll=summary.toString();



%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

var numProjects=<%=allProjects.size()%>
var doNotifications=<%=(controller.getCurrentInstallationConfig().isDoNotifications()?"true":"false")%>

<% pageContext.include("js/js.jsp"); %>

</script>

<style type="text/css">
.ruleRowBeforeSummaryEven {background-color:#C4C493; } 
.ruleRowBeforeSummaryOdd {background-color:#D9D9A9; } 
.summaryFont {font-size:11px; font-family:arial,helvetica; color:#666666;}
</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
  
<form action=# onsubmit="return false" name=mainForm id=mainForm>
<font class=bodyFont>
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>A summary of each project's status<%=HelpManager.helpLink("projectSummaries",request)%></span> appears below. A summary of the status of all projects also appears at the <a href="#bottomPg">bottom of the page</a>.
</span>
<%=HtmlUtils.doubleLB(request)%><BR>

<table border=0 cellspacing=0 cellpadding=0>

<%=HtmlUtils.getHorizRuleTr(5, request)%>

<% 

for (int i=0; i<names.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=20>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left colspan=3><font class=columnDataFont>&nbsp;<B><%=names[i]%></B><BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr> 
	<tr>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td colspan=3 class=<%=((((double)i/2)==(double)((int)(i/2)))?"ruleRowBeforeSummaryEven":"ruleRowBeforeSummaryOdd")%>><img src="../images/spacer.gif" height=1 width=1><BR></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<tr bgcolor="F2F2E1">
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td colspan=3 style="padding:3px;"><font class=summaryFont><%=summaries[i]%><BR></font>
	</td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	
	<%=HtmlUtils.getHorizRuleTr(5, 1, "ruleRow", request)%>
	<%
}

%>
<tr><td><BR></td></tr>
<tr>
<%=HtmlUtils.getSingleRuleCell(request)%>
<td colspan=3 class=ruleRow><img src="../images/spacer.gif" height=1 width=1><a name=bottomPg></a><BR></td>
<%=HtmlUtils.getSingleRuleCell(request)%>
</tr>
<tr bgcolor="F2F2E1">
<%=HtmlUtils.getSingleRuleCell(request)%>
<td colspan=3 style="padding:3px;"><font class=summaryFont><%=summaryAll%><BR></font>
</td>
<%=HtmlUtils.getSingleRuleCell(request)%>
</tr>

<%=HtmlUtils.getHorizRuleTr(4, 1, "ruleRow", request)%>

</table><BR><BR>

<input  class=formButton type=button value=back onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

