<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
  
<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String successParam;
try
{
	int numProjects=controller.getParamAsInt("numProjects");
	for (int i=0; i<numProjects; i++)
	{
		if (controller.getParam("name"+i).trim().length()>0)
		{
			// then this is an Project to add (not a blank row):
			Project project=new Project();
			project.setName(controller.getParam("name"+i));
			// it's possible (not likely given JS validation) that a user
			// goes to the add-Projects page, enters new Projects, submits the form,
			// then uses the back button, makes changes, and submits
			// again.  This would result in duplicate Project names being inserted,
			// so check first for existence of Project, then update instead of insert
			// if needed:
			Project testProject=Manager.selectProjectByName(controller.getParam("name"+i));
			Printer.p("testProject="+testProject+"");
			if (testProject==null)
			{
				Printer.p("inserting");
				Manager.insertProject(project);
			}
			else
			{
				// else (see above) Project already exists:
				Printer.p("updating");
				Manager.updateProject(project);
			}
		}
	}
	successParam="true";
}
catch (Exception e)
{
	Printer.pe("storing new Project(s)",e);
	successParam="false";
}

controller.redirect("showProjectChanges.jsp?mode=add&success="+successParam);
%>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

