<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
  
<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String successParam;
try
{
	int numInstances=controller.getParamAsInt("numInstances");
	for (int i=0; i<numInstances; i++)
	{
		if (controller.getParam("name"+i).trim().length()>0)
		{
			// then this is an instance to add (not a blank row):
			Instance instance=new Instance();
			instance.setName(controller.getParam("name"+i));
			instance.setRootUrl(controller.getParam("rootUrl"+i));
			// it's possible (not likely given JS validationj) that a user
			// goes to the add-instances page, enters new instances, submits the form,
			// then uses the back button, makes changes, and submits
			// again.  This would result in duplicate instance names being inserted,
			// so check first for existence of instance, then update instead of insert
			// if needed:
			Instance testInstance=Manager.selectInstanceByName(controller.getParam("name"+i));
			Printer.p("testInstance="+testInstance+"");
			if (testInstance==null)
			{
				Printer.p("inserting");
				Manager.insertInstance(instance);
			}
			else
			{
				// else (see above) instance already exists:
				Printer.p("updating");
				Manager.updateInstance(instance);
			}
		}
	}
	successParam="true";
}
catch (Exception e)
{
	Printer.pe("storing new Instance(s)",e);
	successParam="false";
}

controller.redirect("showInstanceChanges.jsp?mode=add&success="+successParam);
%>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>





<% PageUtils.jspEnd(request); %>

