<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%


InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
String mailSubjectPrefixInitialNotification=PageUtils.nonNull(installationConfig.getMailSubjectPrefixInitialNotification());
String mailSubjectPrefixChangeNotification=PageUtils.nonNull(installationConfig.getMailSubjectPrefixChangeNotification());
String mailSubjectPrefixReminderMissed=PageUtils.nonNull(installationConfig.getMailSubjectPrefixReminderMissed());
String mailSubjectPrefixReminderApproaching=PageUtils.nonNull(installationConfig.getMailSubjectPrefixReminderApproaching());
String smtpHost=PageUtils.nonNull(installationConfig.getSmtpHost());
String smtpLocalhost=PageUtils.nonNull(installationConfig.getSmtpLocalhost());
String smtpUsername=PageUtils.nonNull(installationConfig.getSmtpUsername());
String smtpPassword=PageUtils.nonNull(installationConfig.getSmtpPassword());
int smtpPort=installationConfig.getSmtpPort();
boolean doNotifications=installationConfig.isDoNotifications();

String testEmail=controller.getParam("testEmail","");

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>

<script language="JavaScript">

var doNotifications=<%=doNotifications%>


function isValidForm(formObj)
{
	// don't allow submit more than once:
	if (window.formSubmitted)
	{
		return false;
	}
	var els=formObj.elements
	
	if (radioGroupValue(formObj,"doNotifications")=="true")
	{
		// REQUIRED FIELDS:
		if (trim(els["smtpHost"].value).length==0)
		{
			errorAlert("You have not entered an SMTP mail-server hostname. Please enter one and try again.",els["smtpHost"])
			return false
		}
		if (trim(els["smtpPort"].value).length==0)
		{
			errorAlert("You have not entered an SMTP port number.  This number is almost always 25. Please enter one and try again.",els["smtpPort"])
			return false
		}
		
		
		// FIELD CONFLICTS/INVALID VALUES:
		
		
		
		var smtpUsername=els["smtpUsername"].value
		var smtpPassword=els["smtpPassword"].value
		var smtpPasswordRetype=els["smtpPasswordRetype"].value
		
		if (smtpUsername.length>0 && smtpPassword.length==0)
		{
			errorAlert("You have entered an SMTP username but not an SMTP password.  Neither of these fields is required, but if you enter one, then you must enter the other.  Please fix and try again.",els["smtpPassword"])
			return false
		}
		if (smtpUsername.length==0 && smtpPassword.length>0)
		{
			errorAlert("You have entered an SMTP password but not an SMTP username.  Neither of these fields is required, but if you enter one, then you must enter the other.  Please fix and try again.",els["smtpUsername"])
			return false
		}
		if (smtpPassword!=smtpPasswordRetype)
		{
			errorAlert("The SMTP password and the retyped SMTP password you have entered do not match. Please fix and try again.",els["smtpPasswordRetype"])
			return false
		}
		if (!isInteger(trim(els["smtpPort"].value)))
		{
			errorAlert("The SMTP port you've entered is not a positive, whole number. Please fix and try again.",els["smtpPort"])
			return false
		}

		
	}
	

	window.formSubmitted=true
	hidePageAndShowPleaseWait()
	return true
}


function testSettings()
{ 
	var els=document.forms["mainForm"].elements
	// REQUIRED FIELDS:
	if (trim(els["smtpHost"].value).length==0)
	{
		errorAlert("You have not entered an SMTP mail-server hostname. Please enter one and try again.",els["smtpHost"])
		return false
	}
	if (trim(els["smtpPort"].value).length==0)
	{
		errorAlert("You have not entered an SMTP port number.  This number is almost always 25. Please enter one and try again.",els["smtpPort"])
		return false
	}
	if (trim(els["testEmail"].value).length==0)
	{
		errorAlert("You have not entered a e-mail address to use for testing the settings you've just entered.  Please enter one and try again.",els["testEmail"])
		return false
	}


	// FIELD CONFLICTS/INVALID VALUES:



	var smtpUsername=els["smtpUsername"].value
	var smtpPassword=els["smtpPassword"].value
	var smtpPasswordRetype=els["smtpPasswordRetype"].value

	if (smtpUsername.length>0 && smtpPassword.length==0)
	{
		errorAlert("You have entered an SMTP username but not an SMTP password.  Neither of these fields is required, but if you enter one, then you must enter the other.  Please fix and try again.",els["smtpPassword"])
		return false
	}
	if (smtpUsername.length==0 && smtpPassword.length>0)
	{
		errorAlert("You have entered an SMTP password but not an SMTP username.  Neither of these fields is required, but if you enter one, then you must enter the other.  Please fix and try again.",els["smtpUsername"])
		return false
	}
	if (smtpPassword!=smtpPasswordRetype)
	{
		errorAlert("The SMTP password and the retyped SMTP password you have entered do not match. Please fix and try again.",els["smtpPasswordRetype"])
		return false
	}


	if (!isValidEmail(trim(els["testEmail"].value)))
	{
		errorAlert("The test e-mail address you've entered (\""+trim(els["testEmail"].value)+"\") is not valid. An example of a valid e-mail address is \"janedoe@somecompany.com\". Please fix and try again.",els["testEmail"])
		return false
	}
	if (!isInteger(trim(els["smtpPort"].value)))
	{
		errorAlert("The SMTP port you've entered is not a positive, whole number. Please fix and try again.",els["smtpPort"])
		return false
	}
	
	
	var queryStr=""
		+"smtpHost="+escape(trim(els["smtpHost"].value))+"&"
		+"smtpPort="+trim(els["smtpPort"].value)+"&"
		+"smtpLocalhost="+escape(trim(els["smtpLocalhost"].value))+"&"
		+"smtpUsername="+escape(trim(els["smtpUsername"].value))+"&"
		+"smtpPassword="+escape(trim(els["smtpPassword"].value))+"&"
		+"testEmail="+escape(trim(els["testEmail"].value))
	
	var props="toolbar=0, location=0, directories=0, status=1, menubar=0, scrollbars=0, resizable=0, "
	return openDialog("admin/testNotifications.jsp?"+queryStr, "closeWin", 385, 495, false, true)

}

function notificationsChecked(id)
{
	if (id=="doNotificationsTrue")
	{
		document.getElementById("mailProps").style.display="block"
	}
	else
	{
		document.getElementById("mailProps").style.display="none"
	}
}


function setDefaultFormValue(elName,valueStr)
{
	document.forms["mainForm"].elements[elName].value=valueStr
}

function init()
{
	if (window.doNotifications && document.getElementById("mailProps"))
	{
		document.getElementById("mailProps").style.display="block"
	}
}

</script>

<style type="text/css">
#mailProps {display:none; padding:9px; position:relative; left:35px; width:455px; border:1px solid #7F7F5E; background-color:#E2E2B1;}
.defaultButton {background-color:#A2A27A; border:1px solid #444434; width:65px; height:18px; font-family:arial,helvetica; font-size:11px; color:#444434;">}

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>



<div id=mainDiv>

<%

HashMap testResults=JavaMailChecker.isJavaMailInstalled();
Boolean installedValue=(Boolean)testResults.get("installed");
boolean isInstalled=installedValue.booleanValue()==true;

if (isInstalled)
{
	%>
	<span class=standardTextBlockWidth>
	<form action=processEmailConfig.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>

	<font class=bodyFont>

	<span class=firstSentenceFont>If enabled, e-mail notifications and reminders<%=HelpManager.helpLink("notificationsAndReminders",request)%> alert users</span> to newly assigned or changed issues (notifications) and to impending or missed deadlines (reminders), via any outgoing e-mail server on which you have an account.  Please make any necessary changes to the settings below, then press the "change" button at the bottom of the page.  If you've changed your mind and don't want to make any changes right now, click the "cancel" button below.<%=HtmlUtils.doubleLB(request)%><BR>
	
	<I>Note: enabling e-mail notifications and reminders also enables the <a href="#" onclick="launchFeedback(false); return false;">feedback</a> and <a href="#" onclick="launchFeedback(true); return false;">support</a> modules to use your SMTP server for sending feedback and support messages to WorkRoll.com.  If notifications and reminders are not enabled, then these modules will use users' e-mail clients to send such messages to WorkRoll.com.<%=HtmlUtils.doubleLB(request)%><BR></I>



	<span class=boldishFont>Enable e-mail notifications/reminders: </span><%=HtmlUtils.getYesNoRadios(doNotifications,"doNotifications","Yes","No","onClick=\"notificationsChecked(this.id)\"")%>
	<BR><BR>
	<div id=mailProps>
	<I>Please note: if you make changes to the settings in this box, you will want to test the changed settings by pressing the "test" button; doing so will allow you make sure that your new settings are valid (by sending you a test message) before you commit to them by pressing the "change" button at the bottom of the page.</I><%=HtmlUtils.doubleLB(request)%><BR>

	<span class=boldishFont>SMTP mail-server hostname<%=HelpManager.helpLink("smtpHostname","E2E2B1",request)%></span> (for example, <i>mail.mydomain.com</i>)<BR>
	<input class=inputText type=text size=20 name=smtpHost id=smtpHost value="<%=smtpHost%>"><%=HtmlUtils.doubleLB(request)%>


	<I>Most SMTP servers are configured to require authentication; if yours is, enter your username, password, and re-typed password below; otherwise, leave these three fields blank:</I><%=HtmlUtils.doubleLB(request)%>

	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class=boldishFont>SMTP username<%=HelpManager.helpLink("smtpUsername","E2E2B1",request)%> (if you use Microsoft Exchange, please read <%=HelpManager.helpLink("exchangeMail","this")%>)</span><BR>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class=inputText type=text size=10 name=smtpUsername id=smtpUsername value="<%=smtpUsername%>"><%=HtmlUtils.doubleLB(request)%>

	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class=boldishFont>SMTP password<%=HelpManager.helpLink("smtpPassword","E2E2B1",request)%></span><BR>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class=inputText type=password size=10 name=smtpPassword id=smtpPassword value="<%=smtpPassword%>"><%=HtmlUtils.doubleLB(request)%>

	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class=boldishFont>Re-type SMTP password</span><BR>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class=inputText type=password size=10 name=smtpPasswordRetype id=smtpPasswordRetype value="<%=smtpPassword%>"><%=HtmlUtils.doubleLB(request)%><BR>


	<span class=boldishFont>SMTP port number<%=HelpManager.helpLink("smtpPort","E2E2B1",request)%></span> (almost always <%=WorkRollConstants.DEFAULT_SMTP_PORT%>)<BR>
	<input class=inputText type=text size=4 name=smtpPort id=smtpPort value="<%=smtpPort%>"><%=HtmlUtils.doubleLB(request)%>


	<span class=boldishFont>Subject prefix for new-issue notifications<%=HelpManager.helpLink("subjectPrefix","E2E2B1",request)%></span><BR>
	<input class=inputText type=text size=45 name=mailSubjectPrefixInitialNotification id=mailSubjectPrefixInitialNotification value="<%=mailSubjectPrefixInitialNotification%>"> <input type=button onclick="setDefaultFormValue('mailSubjectPrefixInitialNotification','<%=WorkRollConstants.DEFAULT_INITIAL_NOTIFICATION_PREFIX%>')" value="use default" class=defaultButton><%=HtmlUtils.doubleLB(request)%>


	<span class=boldishFont>Subject prefix for changed-issue notifications<%=HelpManager.helpLink("subjectPrefix","E2E2B1",request)%></span><BR>
	<input class=inputText type=text size=45 name=mailSubjectPrefixChangeNotification id=mailSubjectPrefixChangeNotification value="<%=mailSubjectPrefixChangeNotification%>"> <input type=button onclick="setDefaultFormValue('mailSubjectPrefixChangeNotification','<%=WorkRollConstants.DEFAULT_CHANGE_NOTIFICATION_PREFIX%>')" value="use default" class=defaultButton><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Subject prefix for approaching-deadline reminders<%=HelpManager.helpLink("subjectPrefix","E2E2B1",request)%></span><BR>
	<input class=inputText type=text size=45 name=mailSubjectPrefixReminderApproaching id=mailSubjectPrefixReminderApproaching value="<%=mailSubjectPrefixReminderApproaching%>"> <input type=button onclick="setDefaultFormValue('mailSubjectPrefixReminderApproaching','<%=WorkRollConstants.DEFAULT_REMINDER_APPROACHING_PREFIX%>')" value="use default" class=defaultButton><%=HtmlUtils.doubleLB(request)%>

	<span class=boldishFont>Subject prefix for missed-deadline reminders<%=HelpManager.helpLink("subjectPrefix","E2E2B1",request)%></span><BR>
	<input class=inputText type=text size=45 name=mailSubjectPrefixReminderMissed id=mailSubjectPrefixReminderMissed value="<%=mailSubjectPrefixReminderMissed%>"> <input type=button onclick="setDefaultFormValue('mailSubjectPrefixReminderMissed','<%=WorkRollConstants.DEFAULT_REMINDER_MISSED_PREFIX%>')" value="use default" class=defaultButton><%=HtmlUtils.doubleLB(request)%><BR>
	
	<span class=boldishFont>Localhost name (for HELO commands)<%=HelpManager.helpLink("smtpLocalhost","E2E2B1",request)%></span> (under normal circumstances -- such as when your DNS and Java environment are configured properly -- please leave this field blank; if you click the "test" button and the test fails, WorkRoll may suggest that you supply a value for this field)<BR>
	<input class=inputText type=text size=20 name=smtpLocalhost id=smtpLocalhost value="<%=smtpLocalhost%>"><%=HtmlUtils.doubleLB(request)%><BR>

	<span class=boldishFont>E-mail address for testing above settings</span> (This is the e-mail address to which WorkRoll will send a test message when you click the "test" button below.  It is suggested, but not required, that the address you enter below should <I>not</I> be an address on your local mail server.  The reason for this is that test messages successfully sent to local addresses might fail if sent to non-local addresses, but the opposite is rarely true. If you don't have access to an e-mail account not located on your local mail server, creating a Hotmail, Yahoo, or other free, web-based account works nicely.)<BR>
	<input class=inputText type=text size=50 name=testEmail id=testEmail value="<%=testEmail%>"><%=HtmlUtils.doubleLB(request)%>

	<input class=formButton type=button value="test" onclick="testSettings()"><BR>
	<BR>
	</div>

	<BR>
	<input  class=formButton type=submit value=change> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

	<%=HtmlUtils.doubleLB(request)%><BR>


	<br></font>

	</form></span>

	<%
}
else
{
	%>
	<span class=standardTextBlockWidth>
	<form action=# onsubmit="return false" name=mainForm id=mainForm>

	<font class=bodyFont>

	<span class=firstSentenceFont>You do not have JavaMail installed.</span>  Specifically, WorkRoll could not find the following packages (either because you do not have the appropriate .jar or .class files, or because they are not in your application server's classpath):
	
	<ul>
	
	<%
	if (!(testResults.get("javax.mail.Session_installed").equals(new Boolean(true))))
	{
		%>
		<li>javax.mail
		<%
	}
	if (!(testResults.get("javax.mail.internet.MimeMessage_installed").equals(new Boolean(true))))
	{
		%>
		<li>javax.mail.internet
		<%
	}
	if (!(testResults.get("javax.activation.DataSource_installed").equals(new Boolean(true))))
	{
		%>
		<li>javax.activation (this package is not part of JavaMail but is required by it)
		<%
	}
	%>
	
	</ul>
	
	JavaMail 1.1.3 or higher is required for WorkRoll e-mail notifications and reminders, and you must also have access to an SMTP (outgoing) mail server.  JavaMail is easy to install, and is available free from Sun Microsystems <a href="http://java.sun.com/products/javamail/" target=_blank>here</a>.  Follow their instructions for installation; you will probably need to restart your application server before it "recognizes" JavaMail.  Note: JavaMail is not required for WorkRoll to work properly, but without it, WorkRoll cannot perform notifications and reminders.<BR><BR>
	
	<I>About notifications and reminders:</I> WorkRoll can integrate with your mail server to do the following:
	
	<ul>
	
	<li><B>Notifications:</B> When a user assigns an issue to another user, or revises an already-assigned issue, he or she can choose to have WorkRoll notify the user to whom the issue is assigned.  It is up to the assigning user whether or not a notification will be sent.<BR><BR>
	<li><B>Reminders:</B> Users can optionally choose to be notified when an issue's deadline is approaching (the length of time before the deadline that the message is sent is configurable per user in the "Account" section), and when an active issue's deadline is passed.<BR><BR>
	
	</ul>


	</div>

	<BR>
	<input class=formButton type=button value=back onclick="location.href='menu.jsp'"><BR>

	<%=HtmlUtils.doubleLB(request)%><BR>


	<br></font>

	</form></span>


	<%
}
%>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

