/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.ImageCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.JPEGEncodeParam;
import com.others.JPEGImageDecoder;
import com.others.JPEGImageEncoder;
import com.others.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    public String getFormatName() {
        return "jpeg";
    }

    public Class getEncodeParamClass() {
        return Class.forName("com.others.JPEGEncodeParam");
    }

    public Class getDecodeParamClass() {
        return Class.forName("java.lang.Object");
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        JPEGEncodeParam jPEGEncodeParam = null;
        if (imageEncodeParam != null) {
            jPEGEncodeParam = (JPEGEncodeParam)imageEncodeParam;
        }
        return new JPEGImageEncoder(outputStream, jPEGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder(inputStream, null);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(file), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder((InputStream)seekableStream, null);
    }

    public int getNumHeaderBytes() {
        return 3;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
    }
}

