/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.BMPEncodeParam;
import com.others.BMPImageDecoder;
import com.others.BMPImageEncoder;
import com.others.ImageCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    public String getFormatName() {
        return "bmp";
    }

    public Class getEncodeParamClass() {
        return Class.forName("com.others.BMPEncodeParam");
    }

    public Class getDecodeParamClass() {
        return Class.forName("java.lang.Object");
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 1 || n == 2 || n == 3 || n == 4 || n == 5) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (!(imageEncodeParam instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
            int n2 = bMPEncodeParam.getVersion();
            if (n2 == 0 || n2 == 2) {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        BMPEncodeParam bMPEncodeParam = null;
        if (imageEncodeParam != null) {
            bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
        }
        return new BMPImageEncoder(outputStream, bMPEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(inputStream, null);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new BMPImageDecoder(new FileInputStream(file), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder((InputStream)seekableStream, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 66 && byArray[1] == 77;
    }
}

