// View.cpp : implementation of the CSocktestView class
//

#include "stdafx.h"
#include "socktest.h"

#include "Doc.h"
#include "View.h"
//#include "cwinsock.h"    // in mainfrm.h
#include "mainfrm.h"
#include "conndlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSocktestView

IMPLEMENT_DYNCREATE(CSocktestView, CEditView)

BEGIN_MESSAGE_MAP(CSocktestView, CEditView)
	//{{AFX_MSG_MAP(CSocktestView)
	ON_COMMAND(ID_CONNECT, OnConnect)
	ON_COMMAND(ID_CLOSECONN, OnCloseconn)
	ON_COMMAND(ID_CLEARVIEW, OnClearview)
	ON_COMMAND(ID_OPEN_SCRIPT, OnOpenScript)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_WINSOCK_EVENT,OnWinsockEvent)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSocktestView construction/destruction
CSocktestView::CSocktestView()
{
}

CSocktestView::~CSocktestView()
{
}

BOOL CSocktestView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);

	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping

	cs.style |=	ES_READONLY; // make read only - it is a log window
	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CSocktestView drawing

void CSocktestView::OnDraw(CDC* pDC)
{
	CSocktestDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CSocktestView diagnostics

#ifdef _DEBUG
void CSocktestView::AssertValid() const
{
	CEditView::AssertValid();
}

void CSocktestView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CSocktestDoc* CSocktestView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSocktestDoc)));
	return (CSocktestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSocktestView message handlers

/////////////////////////////////////////////////////////////////////////////
void CSocktestView::Log(const char * szBuffer)
{
	int nChars=GetWindowTextLength();    // get the index of the last line

 	// point end of document
	GetEditCtrl().SetSel( nChars,nChars );
	GetEditCtrl().ReplaceSel((LPCSTR)szBuffer);     // display text

	// defeat the final "save document" dialog on app exit
	GetDocument()->SetModifiedFlag(FALSE); 
}
   
/////////////////////////////////////////////////////////////////////////////
LONG CSocktestView::OnWinsockEvent (WPARAM wParam, LPARAM lParam)
{
	CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
	ASSERT( pFWnd != NULL);
	ASSERT( pFWnd->m_pWinsock != NULL);

	switch ( WSAGETSELECTEVENT(lParam) ) 	  // which message arrived?
	{
		case FD_CLOSE:
			Log("SockTest Status>Connection closed by server\r\n");
			// kill the winsock object
			pFWnd->KillSockObj();
			break;

		case FD_READ:
			char szBuffer[50000+1], *str;
			memset(szBuffer,0,50000+1);
			pFWnd->m_pWinsock->Recv(szBuffer,50000,0);
			str=strtok(szBuffer,"\n");

			while( str && *str)
			{
			   Log((const char *)str);
			   Log("\r\n");
			   str=strtok((char *)NULL,"\n");
			}
			break;  
		case FD_OOB:
			AfxMessageBox("OOB");
			break;  
		case FD_ACCEPT:
			AfxMessageBox("ACCEPT");
			break;  

	} // end of switch

	return 0L;
}

/////////////////////////////////////////////////////////////////////////////
void CSocktestView::OnConnect() 
{
	CConnectDlg dlg;
	dlg.m_sHost = AfxGetApp()->GetProfileString("Connect", "Host", "");
	dlg.m_sPort = AfxGetApp()->GetProfileString("Connect", "Port", "");
	 
	// instantiate the winsock class if not active already.
	// we do this here instead of the view's constructor
	// because when the view's constructor is called, it's m_hwnd is NULL

	// run dialog
	if( dlg.DoModal() == IDOK)	  
	{
		// housecleaning?
		if( dlg.m_bClearWindow )
		{
			GetEditCtrl().SetWindowText("");
		}

		// make the winsock object
		CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
		ASSERT( pFWnd != NULL);
		pFWnd->MakeSockObj();
		ASSERT( pFWnd->m_pWinsock != NULL);

		CString sHost = dlg.m_sHost;
		CString sPort = dlg.m_sPort;
		sHost.TrimRight();
		sPort.TrimRight();
		sHost.TrimLeft();
		sPort.TrimLeft();

		// make the connection
		BeginWaitCursor(); // show hourglass 
		int s = pFWnd->m_pWinsock->ConnectToServer((const char *)sHost, (const char *)sPort);
		EndWaitCursor();

		if( SOCKET_ERROR != s && INVALID_SOCKET != s )
		{
			pFWnd->m_pWinsock->AsyncSelect(FD_READ|FD_CLOSE|FD_OOB|FD_ACCEPT);
			// write to screen and .ini
			CString sOut;
			sOut.Format("SockTest Status>Connection made OK (code %d) to %s on port %s\r\n", 
										s, sHost, sPort);
			Log(sOut);
			// save settings in ini file
			AfxGetApp()->WriteProfileString("Connect", "Host", sHost);
			AfxGetApp()->WriteProfileString("Connect", "Port", sPort);
		}
		else
		{
			CString sOut, sMoreout;
			sOut.Format("Connection error code %d", s);
			sMoreout = "";
			switch ( s ) 	  // which error?
			{
				case SOCKET_ERROR:
					sMoreout = " (SOCKET_ERROR or INVALID_SOCKET)";
					break;
			} // end of switch
			sOut += sMoreout;
			AfxMessageBox(sOut);

			// kill the winsock object
			pFWnd->KillSockObj();
		}
	} // end of if on domodal
	// defeat the final "save document" dialog on app exit
	GetDocument()->SetModifiedFlag(FALSE); 
}

/////////////////////////////////////////////////////////////////////////////
void CSocktestView::OnCloseconn() 
{
	CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
	ASSERT( pFWnd != NULL);
	ASSERT( pFWnd->m_pWinsock != NULL);

	// break the connection
	int ret = pFWnd->m_pWinsock->CloseSocket();	

	// kill the winsock object
	pFWnd->KillSockObj();
}

/////////////////////////////////////////////////////////////////////////////
void CSocktestView::OnClearview() 
{
	// clear the user input edit box
	GetEditCtrl().SetWindowText("");
}

/////////////////////////////////////////////////////////////////////////////
void CSocktestView::OnOpenScript() 
{
	CString sBuf = "";
	char ch = 0;

	// get a pointer to the mainframe
	CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
	ASSERT( pFWnd != NULL);

	// filter
	static char BASED_CODE szFilter[80];
	CString sExt = "txt";
	strcpy(szFilter, "Text Files (*.txt)|*.txt| All Files (*.*)|*.*||" );
	
	CFileDialog fileDialog( TRUE, // so Open
						(LPCTSTR)sExt, // extension
						NULL, // starter name
						OFN_EXPLORER |		// controls
						OFN_LONGNAMES,// |			
						szFilter, 
						NULL );

	if( fileDialog.DoModal() == IDOK)
	{
		// only do if object valid (i.e. there is still a connection to send to)
		if(pFWnd->m_pWinsock != NULL )
		{
			// open the user's script file - use "rb" so the 0x0d chars come thru
			FILE * fpIn = fopen( fileDialog.GetPathName(), "rb");
			ASSERT( fpIn != NULL);

			//pull in the file one character at a time
			while( fread( &ch, sizeof( char ), 1, fpIn ) )
			{
				//is this char a CR? if so then send the CString on the wire
				if( ch == 0x0d ) 
				{
					// put the script's line onto the wire if not a null line
					//   and not comment lines - they start with semicolon
					if( sBuf.GetLength() != 0 && sBuf.GetAt(0) != ';')
					{
						int ret = pFWnd->m_pWinsock->Send((const char *)sBuf, sBuf.GetLength(), 0);
						ASSERT( ret == sBuf.GetLength());
					}

					// close out the lines on the wire	- works for null lines too!
					//   but not comment lines - they start with semicolon
					if( !sBuf.GetLength() || sBuf.GetLength() != 0 && sBuf.GetAt(0) != ';' )
					{
						pFWnd->m_pWinsock->Send("\r\n",2,0);

						// show the line in the upper window
						CString sPreface = "SockTest Script>";
						sPreface += sBuf;
						Log((const char *)sPreface);
						Log("\r\n");
					}

					// reset the CString
					sBuf = "";
				}
				else
				{
					// build up the CString one char at a time
					// but not CRLF (the else already precludes
					//      the 0x0d so this test is redundant
					if( ch != 0x0d && ch != 0x0a)
					{
						sBuf += ch;
					}
				} // end of if / else on ch=CR
			}  // end of while
			fclose(fpIn);
		}  // end of if on winsock pointer
	}  // end of if on dialog IDOK	
}
