//	CWINSOCK.H
//  Declares the CWinsock class.
//
//  You are free to use and distribute this and all the other 
//  files included in this sample without fee for educational
//  purposes.  This notice must be included with all distributions
//
//  Released July 1996.
//
//  Copyright (c) 1996, by Donald C. Asonye
//  Email address as of now:  donald@uh.edu
//

#include <afxwin.h>		
#include <windows.h>
//#include "winsock.h"     // change to <winsock.h> your compiler has it
#include <winsock.h>

#define WM_WINSOCK_EVENT WM_APP+4	 // for winsock messages


///////////////////////////////////////////////////////////////
// CWinsock class
//////////////////
//
// many of the function were changed to really match the names
// used by mfc socket library :)
// and a lot of the winsock functions are not here.  i did not
// need them so i did not include them in this one.  i will 
// probably include them next time. :((	 
// i did not even use all the functions that are defined here.
//
class CWinsock : public CWnd   // base class is cwnd (has hwnd)
{
private:
	SOCKET m_hSocket;	       // the socket handle

public:
	CWinsock(CWnd *pParent);   // pParent will be sent any message
	  						   // that we receive from winsock
	~CWinsock();
	
	SOCKET ConnectToServer( const char *name, const char *port);
	
	int CloseSocket (); 
	int CloseSocket(SOCKET& sock);
	int Connect (const struct sockaddr FAR *name, int namelen,SOCKET s);
	int Connect (const struct sockaddr FAR *name, int namelen);

	// host/network byte order conversion stuff
	u_long Htonl (u_long hostlong);
	u_short Htons (u_short hostshort);
	u_long Inet_Addr (const char FAR * cp);
	char FAR * Inet_Ntoa (struct in_addr in);
	int Listen (int backlog = 5);
	u_long Ntohl (u_long netlong);
	u_short Ntohs (u_short netshort);
	
	int Select (int nfds, fd_set FAR *readfds, fd_set FAR *writefds,
	                       fd_set FAR *exceptfds, const struct timeval FAR *timeout);
	int AsyncSelect(long lEvent=FD_READ | FD_WRITE | 
		                 FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE);
	int Send (const char FAR * buf, int len, int flags);
	int SendTo (const char FAR * buf, int len, int flags,
	                       const struct sockaddr FAR *to, int tolen);

	int Recv (char FAR * buf, int len, int flags);
	int RecvFrom (char FAR * buf, int len, int flags,
	                         struct sockaddr FAR *from, int FAR * fromlen);
	
	int SetSockOpt (int level, int optname,
	                           const char FAR * optval, int optlen);
	int Shutdown (int how);
	
	SOCKET Socket (int af, int type, int protocol);	
	SOCKET Accept (struct sockaddr FAR *addr, int FAR *addrlen);
	int Bind (const struct sockaddr FAR *addr, int namelen);

	struct hostent FAR * GetHostByName(const char FAR * name);
	int GetHostName (char FAR * name, int namelen);
	                               
	void Attach(SOCKET s);
	SOCKET Detach();
	SOCKET GetSocket() const { return m_hSocket;}
	// statics for class
	static unsigned int m_nInstances; // must be initialized to 0 in a code segment
	static WSAData WsaData;
	
	// message map functions
	LONG OnWinsockEvent (WPARAM wParam, LPARAM lParam);
	
	//{{AFX_MSG(CWinsock)
	
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG	
	DECLARE_MESSAGE_MAP();
};

