VERSION 5.00
Object = "{B702FD21-94CC-11D3-B680-000000000000}#1.0#0"; "CuteControls.ocx"
Begin VB.MDIForm frmWordpad 
   BackColor       =   &H8000000C&
   Caption         =   "WordPad"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "MDIForm1"
   StartUpPosition =   3  'Windows Default
   Begin CuteControlsLibCtl.CuteBar CuteBar1 
      Left            =   1680
      Top             =   1800
      BarCollection   =   "Wordpad.frx":0000
      _cx             =   847
      _cy             =   847
      SaveState       =   0   'False
      RegistryCompanyKey=   ""
      RegistryApplKey =   "CUTECO~1"
   End
End
Attribute VB_Name = "frmWordpad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Portions of the code are copyright 1995, Microsoft Corporation
' Portions of the code are copyright 1999, Data Dynamics Corporation

Option Explicit

' Private Vars
Private mbChanged As Boolean ' has the document been changed?
Private cdlg As New GCommonDialog   ' Common dialogs class

' Help constants and function declares
Private Const HELP_CONTEXT = &H1        ' 1
Private Const HELP_QUIT = &H2           ' 2
Private Const HELP_INDEX = &H3          ' 3
Private Const HELP_CONTENTS = &H3       ' 3
Private Const HELP_HELPONHELP = &H4     ' 4
Private Const HELP_SETINDEX = &H5       ' 5
Private Const HELP_SETCONTENTS = &H5    ' 5
Private Const HELP_CONTEXTPOPUP = &H8   ' 8
Private Const HELP_FORCEFILE = &H9      ' 9
Private Const HELP_KEY = &H101          ' 257
Private Const HELP_COMMAND = &H102      ' 258
Private Const HELP_PARTIALKEY = &H105   ' 261

Private Declare Function WinHelp Lib "user32" Alias "WinHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As Long) As Long
   
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Private Enum eTextMode
    TM_PLAINTEXT = 1
    TM_RICHTEXT = 2                ' /* default behavior */
    TM_SINGLELEVELUNDO = 4
    TM_MULTILEVELUNDO = 8          ' /* default behavior */
    TM_SINGLECODEPAGE = 16
    TM_MULTICODEPAGE = 32          ' /* default behavior */
End Enum

Private Const WM_USER = &H400
Private Const WM_PASTE = &H302
Private Const WM_COPY = &H301
Private Const WM_CUT = &H300

Private Const EM_LINEINDEX = &HBB&
Private Const EM_CANUNDO = &HC6
Private Const EM_UNDO = &HC7
Private Const EM_LINEFROMCHAR = &HC9&
Private Const EM_CANPASTE = (WM_USER + 50)
Private Const EM_HIDESELECTION = (WM_USER + 63)
Private Const EM_REQUESTRESIZE = (WM_USER + 65)
Private Const EM_SETUNDOLIMIT = (WM_USER + 82)
Private Const EM_REDO = (WM_USER + 84)
Private Const EM_CANREDO = (WM_USER + 85)
Private Const EM_GETUNDONAME = (WM_USER + 86)
Private Const EM_GETREDONAME = (WM_USER + 87)
Private Const EM_STOPGROUPTYPING = (WM_USER + 88)
Private Const EM_SETTEXTMODE = (WM_USER + 89)
Private Const EM_GETTEXTMODE = (WM_USER + 90)
Private Const EM_AUTOURLDETECT = (WM_USER + 91)

Private m_bFontsLoaded As Boolean

Private Sub RecalcLayout()
Dim wHeight As Integer
Dim wTop As Integer
Dim wWidth As Integer
Dim wLeft As Integer

wHeight = CuteBar1.ScaleHeight
wTop = CuteBar1.ScaleTop
wWidth = CuteBar1.ScaleWidth
wLeft = CuteBar1.ScaleLeft

wHeight = Abs(wHeight - StatusBar1.Height)

rtf.Top = wTop
rtf.Left = wLeft
rtf.Width = wWidth
rtf.Height = wHeight

StatusBar1.Top = wTop + wHeight
StatusBar1.Left = wLeft
StatusBar1.Width = wWidth

End Sub

Private Sub CuteBar1_ClientAreaChanged()
    ' Sizes changed so recaclulate controls layout
    RecalcLayout
End Sub

Private Sub CuteBar1_ComboDrop(ByVal Item As CuteControlsLibCtl.IItem)
    If Item.ID = id_FontName Or Item.ID = id_FontSize Then
        If Not m_bFontsLoaded Then
            LoadFonts
            m_bFontsLoaded = True
        End If
    End If
End Sub

Private Sub CuteBar1_ComboSelChange(ByVal Item As CuteControlsLibCtl.IItem)
    Dim text As String
    text = Item.ComboBox.ListText(Item.ComboBox.ListIndex)
    
    Select Case Item.ID
    Case id_FontName
        If Trim$(text) <> "" Then
            rtf.SelFontName = text
        End If
    Case id_FontSize
        If Trim$(text) <> "" Then
            rtf.SelFontSize = Val(text)
        End If
    End Select
    
UpdateToolbar
End Sub

Private Sub CuteBar1_ItemClick(ByVal Item As CuteControlsLibCtl.IItem)
    
    Select Case Item.ID
    ' File
    Case id_New: FileNew
    Case id_Open: FileOpen
    Case id_Save: FileSave Me.Caption
    Case id_Print: FilePrint
    
    ' Edit
    Case id_Undo: EditUndo
    Case id_Redo: EditRedo
    Case id_Cut: EditCut
    Case id_Copy: EditCopy
    Case id_Paste: EditPaste
    Case id_Find: EditFind ""
    Case id_FindNext: EditFindNext
        
    ' Insert
    Case id_Date: InsertDate
    Case id_Time: InsertTime
    Case id_Picture: InsertPicture
    
    ' Format
    Case id_FontName: FormatFont
    Case id_FontSize: FormatFont
    'Case id_FoParagraph: FormatParagraph
    Case id_Bold: FormatBold
    Case id_Italic: FormatItalic
    Case id_Underline: FormatUnderline
    Case id_Left: FormatAlign 0
    Case id_Center: FormatAlign 1
    Case id_Right: FormatAlign 2
    Case id_Bullets: FormatBullets
    
    ' Help
    Case id_Contents: HelpContents
'    Case id_HWhatsThis: HelpWhatsThis
    
    End Select
    
'         hr = WinHelp(Me.hWnd, App.HelpFile, HELP_CONTEXTPOPUP, tool.HelpContextID)
UpdateToolbar

End Sub

Private Sub CuteBar1_ItemGotFocus(ByVal Item As CuteControlsLibCtl.IItem)
    If Item.ID = id_FindText Then
        Item.Edit.text = ""
    End If

End Sub

Private Sub eFindd_Click()
EditFind ""
End Sub

Private Sub eFindNext_Click()
EditFindNext
End Sub

Private Sub ePaste_Click()
EditPaste
End Sub

Private Sub eReplace_Click()
Editreplace ""
End Sub

Private Sub eSelectAll_Click()
EditSelectAll
End Sub

Private Sub fExit_Click()
FileExit
End Sub

Private Sub fNew_Click()
FileNew
End Sub

Private Sub fOpen_Click()
FileOpen
End Sub

Private Sub fPageSetup_Click()
FilePageSetup
End Sub

Private Sub fPrint_Click()
FilePrint
End Sub

Private Sub fSave_Click()
FileSave Me.Caption
End Sub

Private Sub fSaveAs_Click()
FileSaveAs
End Sub

Private Sub eClear_Click()
EditClear
End Sub

Private Sub eCopy_Click()
EditCopy
End Sub

Private Sub eCut_Click()
EditCut
End Sub

Private Sub eUndo_Click()
EditUndo
End Sub
Private Sub eRedo_Click()
EditRedo
End Sub

Private Sub MDIForm_Load()
'    CuteBar1.RegistryApplKey = "WordPad\CuteBar\"
'    CuteBar1.RegistryCompanyKey = "CuteExamples"
    
   ' Dim variables.
   Dim i As Integer
   Dim pnlX As Panel
   
   For i = 1 To 5   ' Add 5 panels.
      Set pnlX = StatusBar1.Panels.Add()
   Next i

   ' Set the style of each panel.
   With StatusBar1.Panels
      .Item(1).Style = sbrText    ' Status
      
      With .Item(2)
        .Style = sbrText   ' Row
        .Bevel = sbrNoBevel
        .Alignment = sbrRight
'        .AutoSize = sbrContents
      End With
      
      With .Item(3)
        .Style = sbrText   ' Colomn
        .Bevel = sbrNoBevel
        .Alignment = sbrRight
 '       .AutoSize = sbrContents
      End With
          
      With .Item(4)
        .Style = sbrCaps    ' Caps lock
        .Alignment = sbrRight
        .AutoSize = sbrContents
      End With
      
      With .Item(5)
        .Style = sbrNum   ' Number lock
      .Alignment = sbrRight
        .AutoSize = sbrContents
      End With
      
      With .Item(6)
      .Style = sbrIns    ' Insert key
      .Alignment = sbrRight
         .AutoSize = sbrContents
     End With
   End With
   
    SendMessage rtf.hwnd, EM_SETUNDOLIMIT, 10&, 0&
    LoadFonts
    m_bFontsLoaded = True
    LoadDocument
    App.HelpFile = App.Path & "\" & App.EXEName & ".HLP"
    UpdateToolbar
End Sub


Private Sub MDIForm_QueryUnload(Cancel As Integer, UnloadMode As Integer)
        
    ' If Needs saving show messagebox
End Sub

Private Sub FileNew()
    rtf.text = ""
    rtf.DataChanged = False
    Me.Caption = "(Untitled)"
End Sub

Private Sub FileOpen()
Dim sFIle As String
    On Error GoTo ehFileOpen 'set error trap
    If cdlg.VBGetOpenFileName(sFIle, "RichEdit Document", True, False, False, False, "RichText Files (*.rtf)|*.rtf", , App.Path, "Open Document...", "RTF", Me.hwnd) Then
        If UCase(Right(sFIle, 4)) <> ".RTF" Then
            ' possibly not RTF file, prompt
            If MsgBox("Do you want to open the file anyway?", _
                vbYesNo + vbQuestion, "This May Not Be A Rich Text File") _
                = vbNo Then
                Exit Sub
            End If
        End If
        rtf.Visible = False
        Me.Caption = sFIle 'set caption
        ' open file
        rtf.LoadFile sFIle
        ' let the OS catch up
        DoEvents
        rtf.DataChanged = False
        rtf.Visible = True
    End If
    
ehFileOpen:
    Exit Sub
End Sub

Private Function FileSave(Optional sSaveAsName As String) As Boolean
    On Error GoTo ehFileSave 'set error trap
    
    If IsMissing(sSaveAsName) Or sSaveAsName = "" Then
        'if no save name specified
        If InStr(Me.Caption, "(untitled)") > 0 Then
            'if no previous name existed
            sSaveAsName = "rtfdoc.rtf"
            If Not cdlg.VBGetSaveFileName(sSaveAsName, _
                "RichEdit Document", True, "Rich Text File(*.rtf)|*.rtf", , _
                App.Path, "Save As...", "RTF", Me.hwnd) Then
                FileSave = False
                Exit Function
            End If
        Else
            ' set SaveAsName to the name that
            ' the file was already given
            sSaveAsName = Me.Caption
        End If
    End If
    
    ' save file
    rtf.SaveFile CStr(sSaveAsName)
    
    ' change the caption to reflect name
    Me.Caption = CStr(sSaveAsName)
    
    ' set return value to true
    FileSave = True
    rtf.DataChanged = False
    Exit Function
ehFileSave:
    ' set return value to false
    FileSave = False
    Exit Function
End Function

Private Sub FileSaveAs()
Dim sSaveAsName As String

    On Error GoTo ehFileSaveAs 'set error trap
    
    sSaveAsName = "rtfdoc.rtf"
    If Not cdlg.VBGetSaveFileName(sSaveAsName, _
        "RichEdit Document", True, "Rich Text File(*.rtf)|*.rtf", , _
        App.Path, "Save As...", "RTF", Me.hwnd) Then
        Exit Sub
    End If
    
    ' save file
    rtf.SaveFile CStr(sSaveAsName)
    
    ' change the caption to reflect name
    Me.Caption = CStr(sSaveAsName)
    
    ' set return value to true
    rtf.DataChanged = False
    
ehFileSaveAs:
    Exit Sub
End Sub

Private Sub FilePrint()
Dim flags As Long
Dim hdc As Long

    On Error GoTo ehFilePrint ' set error trap
    With cdlg
        ' show printer dialog
        If .VBPrintDlg(hdc, IIf(rtf.SelLength = 0, eprAll, eprSelection)) = True Then
            ' print selection was selected
            If rtf.SelLength <> 0 Then
                rtf.SelPrint hdc
            Else
                ' print all was selected
                rtf.SelLength = 0
                rtf.SelPrint hdc
            End If
        End If
    End With
ehFilePrint: 'cancel pressed
    Exit Sub
End Sub

Private Sub FilePageSetup()
    frmPageSetup.Show vbModal
End Sub

Private Sub FileExit()
    Unload Me
End Sub

Private Sub EditRedo()
Dim hr As Long
    hr = SendMessage(rtf.hwnd, EM_GETREDONAME, 0&, 0&)
    Debug.Print hr, Choose(hr + 1, "Unknown", "Typing", "Delete", "Drag Drop", "Cut", "Paste")
    SendMessage rtf.hwnd, EM_REDO, 0, 0
End Sub

Private Sub EditUndo()
Dim hr As Long
    hr = SendMessage(rtf.hwnd, EM_GETUNDONAME, 0&, 0&)
    Debug.Print hr, Choose(hr + 1, "Unknown", "Typing", "Delete", "Drag Drop", "Cut", "Paste")
    SendMessage rtf.hwnd, EM_UNDO, 0, 0
End Sub

Private Sub EditCut()
    SendMessage rtf.hwnd, WM_CUT, 0, 0
    rtf.SetFocus
End Sub

Private Sub EditCopy()
    SendMessage rtf.hwnd, WM_COPY, 0, 0
    rtf.SetFocus
End Sub

Private Sub EditPaste()
    SendMessage rtf.hwnd, WM_PASTE, 0, 0
    rtf.SetFocus
End Sub

Private Sub EditClear()
    rtf.SelText = ""
    rtf.SetFocus
End Sub

Private Sub EditSelectAll()
    rtf.SelStart = 0
    rtf.SelLength = Len(rtf.text)
    rtf.SetFocus
End Sub

Private Sub EditFind(strSearch As String)
    frmFindForm.txtFind = strSearch 'set find text
    frmFindForm.Show vbModal, Me
End Sub

Private Sub EditFindNext()
Dim sFind As String
    sFind = CuteBar1.Bars(nm_barStandard).Items(nm_FindText).Edit.text
    If sFind <> "" Then
        If rtf.SelLength <> 0 Then rtf.SelStart = rtf.SelStart + rtf.SelLength
        rtf.Find sFind, rtf.SelStart, Len(rtf.text)
    Else
        frmFindForm.cboSearch.ListIndex = 2
        If frmFindForm.txtFind <> "" Then
            frmFindForm.cmdFindNext.Value = True
        End If
        frmFindForm.Show vbModal, Me
    End If
End Sub

Private Sub Editreplace(strSearch As String)
    ' Load frmFindForm 'load form
    With frmFindForm
        .txtFind = strSearch 'set find text
        .txtReplace.Enabled = True 'enable replace
        .lblReplace.Enabled = True 'enable replace
        .Show vbModal, Me
    End With
End Sub

Private Sub ViewStandard()
    CuteBar1.Bars(nm_barStandard).Visible = Not CuteBar1.Bars(nm_barStandard).Visible
    frmWordpad.vStandard.Checked = CuteBar1.Bars(nm_barStandard).Visible
End Sub

Private Sub ViewFormat()
    CuteBar1.Bars(nm_barFormat).Visible = Not CuteBar1.Bars(nm_barFormat).Visible
    frmWordpad.vFormat.Checked = CuteBar1.Bars(nm_barFormat).Visible
End Sub

Private Sub ViewStatusBar()
    StatusBar1.Visible = Not StatusBar1.Visible
    frmWordpad.vStatusBar.Checked = StatusBar1.Visible
End Sub

Private Sub ViewOptions()

End Sub

Private Sub InsertDate()
    rtf.SelText = Format(Now, "Long Date")
    rtf.SetFocus
End Sub

Private Sub InsertTime()
    rtf.SelText = Format$(Now, "Hh:Nn:Ss")
    rtf.SetFocus
End Sub

Private Sub FormatParagraph()
    frmParagraph.Show vbModal
    rtf.SetFocus
End Sub

Private Sub FormatBold()
    With rtf
        If (IsNull(.SelBold) = True) Or (.SelBold = False) Then
            ' selection is bold or mixed, so set bold
            .SelBold = True
        ElseIf .SelBold = True Then
            'selection is bold, so toggle it
            .SelBold = False
        End If
        .SetFocus
    End With
End Sub

Private Sub FormatItalic()
    With rtf
        If (IsNull(.SelItalic) = True) Or (.SelItalic = False) Then
            ' selection is italic or mixed, so set italic
            .SelItalic = True
        ElseIf .SelItalic = True Then
            'selection is italic, so toggle it
            .SelItalic = False
        End If
        .SetFocus
    End With
End Sub

Private Sub FormatUnderline()
    With rtf
        If (IsNull(.SelUnderline) = True) Or (.SelUnderline = False) Then
            ' selection is Underline or mixed, so set italic
            .SelUnderline = True
        ElseIf .SelUnderline = True Then
            'selection is Underline, so toggle it
            .SelUnderline = False
        End If
        .SetFocus
    End With
End Sub

Private Sub FormatAlign(intIndex As Integer)
    Select Case intIndex
        Case 0 'left
            'set alignment
            rtf.SelAlignment = rtfLeft
        Case 1 'center
            'set alignment
            rtf.SelAlignment = rtfCenter
        Case 2 'right
            'set images
            'set alignment
            rtf.SelAlignment = rtfRight
    End Select
    rtf.SetFocus
End Sub

Private Sub FormatBullets()
    With rtf
        If (IsNull(.SelBullet) = True) Or (.SelBullet = False) Then
            ' selection is mixed or not bulleted
            ' so set it.
            .SelBullet = True
        ElseIf .SelBullet = True Then
            ' selection is bold, toggle it
            .SelBullet = False
            .SelHangingIndent = False
        End If
        rtf.SetFocus
    End With
End Sub

Private Sub HelpContents()
Dim hr As Long
    hr = WinHelp(Me.hwnd, App.HelpFile, HELP_CONTENTS, 0&)
End Sub

Private Sub HelpAbout()
    frmAbout.Show vbModal
End Sub

Private Sub hAbout_Click()
HelpAbout
End Sub

Private Sub hContents_Click()
HelpContents
End Sub

Private Sub iDate_Click()
InsertDate
End Sub

Private Sub iPicture_Click()
InsertPicture
End Sub

Private Sub iTime_Click()
InsertTime
End Sub

Private Sub mBold_Click()
FormatBold
End Sub

Private Sub mBullets_Click()
FormatBullets
End Sub

Private Sub mCenter_Click()
 FormatAlign 1
End Sub

Private Sub mFont_Click()
FormatFont
End Sub

Private Sub mItalic_Click()
FormatItalic
End Sub

Private Sub mLeft_Click()
FormatAlign 0
End Sub

Private Sub mRight_Click()
FormatAlign 2
End Sub

Private Sub mUnderline_Click()
FormatUnderline
End Sub

Private Sub rtf_Change()
    mbChanged = True
End Sub
Private Sub UpdateFonts()
Dim i As Integer

    With CuteBar1.Bars(nm_barFormat).Items(nm_FontName).ComboBox
        For i = 0 To Screen.FontCount - 1
            If .ListText(i) = rtf.SelFontName Then
                .ListIndex = i
            End If
        Next
    End With
    
    With CuteBar1.Bars(nm_barFormat).Items(nm_FontSize).ComboBox
        For i = 0 To Screen.FontCount - 1
            If Val(.ListText(i)) = rtf.SelFontSize Then
                .ListIndex = i
            End If
        Next
    End With
End Sub

Private Sub LoadFonts()
Dim i, j As Integer
        
    With CuteBar1.Bars(nm_barFormat).Items(nm_FontName)
        For i = 0 To Screen.FontCount - 1
            .ComboBox.AddString Screen.Fonts(i)
        Next
    End With
              
    With CuteBar1.Bars(nm_barFormat).Items(nm_FontSize).ComboBox
        .AddString " 8"
        .AddString " 9"
        .AddString "10"
        .AddString "11"
        .AddString "12"
        .AddString "14"
        .AddString "16"
        .AddString "18"
        .AddString "20"
        .AddString "22"
        .AddString "24"
        .AddString "26"
        .AddString "28"
        .AddString "36"
        .AddString "48"
        .AddString "72"
'        .text = IIf(IsNull(rtf.SelFontSize), "", rtf.SelFontSize)
    End With
    UpdateFonts
End Sub

Private Sub UpdateToolbar()
    With CuteBar1.Bars(nm_barStandard)
  
        .Items(nm_Cut).Enabled = (rtf.SelLength <> 0)
        .Items(nm_Copy).Enabled = (rtf.SelLength <> 0)
        .Items(nm_Paste).Enabled = (SendMessage(rtf.hwnd, EM_CANPASTE, 0, 0) = 1)
        .Items(nm_Undo).Enabled = (SendMessage(rtf.hwnd, EM_CANUNDO, 0, 0) = 1)
        .Items(nm_Redo).Enabled = (SendMessage(rtf.hwnd, EM_CANREDO, 0, 0) = 1)
           
    End With
    
    With CuteBar1.Bars(nm_barFormat)
    
        .Items(nm_Bold).State = IIf(IsNull(rtf.SelBold) Or rtf.SelBold, ccItemPressed, ccItemUnpressed)
        .Items(nm_Italic).State = IIf(IsNull(rtf.SelItalic) Or rtf.SelItalic, ccItemPressed, ccItemUnpressed)
        .Items(nm_Underline).State = IIf(IsNull(rtf.SelUnderline) Or rtf.SelUnderline, ccItemPressed, ccItemUnpressed)
        
        .Items(nm_Left).State = IIf(rtf.SelAlignment = 0, ccItemPressed, ccItemUnpressed)
        .Items(nm_Center).State = IIf(rtf.SelAlignment = 2, ccItemPressed, ccItemUnpressed)
        .Items(nm_Right).State = IIf(rtf.SelAlignment = 1, ccItemPressed, ccItemUnpressed)

        .Items(nm_Bullets).State = IIf(IsNull(rtf.SelBullet), ccItemUnpressed, IIf(rtf.SelBullet, ccItemPressed, ccItemUnpressed))
'        .Items(nm_FontName).ComboBox.text = IIf(IsNull(rtf.SelFontName), "", rtf.SelFontName)
'        .Items(nm_FontSize).ComboBox.text = IIf(IsNull(rtf.SelFontSize), "", rtf.SelFontSize)
    End With
    
        UpdateFonts
        frmWordpad.vStandard.Checked = CuteBar1.Bars(nm_barStandard).Visible
        frmWordpad.vFormat.Checked = CuteBar1.Bars(nm_barFormat).Visible
        frmWordpad.vStatusBar.Checked = StatusBar1.Visible
        
End Sub

Private Sub LoadDocument()
Dim hr As Long
On Error Resume Next

    rtf.Filename = App.Path & "\unknown.rtf"
    rtf.DataChanged = False
    Me.Caption = rtf.Filename
    
    hr = SendMessage(rtf.hwnd, EM_HIDESELECTION, 0&, 1&)
    hr = SendMessage(rtf.hwnd, EM_AUTOURLDETECT, 0&, 0&)
    UpdatePosition
End Sub

Private Sub rtf_MouseUp(Button As Integer, shift As Integer, x As Single, y As Single)
    If Button = vbRightButton Then
'        abDDfrmWordPad.Bands("mnuContext").PopupMenu
    End If
End Sub

Private Sub rtf_SelChange()
    UpdateToolbar
    UpdatePosition
End Sub

Private Sub InsertPicture()
' thanks to "Joachim Thiele" www.N-H-P.de
On Error Resume Next
Dim sFIle As String

    If cdlg.VBGetOpenFileName(sFIle, "Picture File", True, False, False, True, "Picture Files(*.BMP;*.GIF;*.JPG)|*.BMP;*.GIF;*.JPG", , App.Path, "Insert Picture", , Me.hwnd) Then
        Clipboard.Clear
        DoEvents
        Clipboard.SetData LoadPicture(sFIle)
        If Clipboard.GetFormat(vbCFBitmap) = True Then ' Bitmap
            rtf.SetFocus
            EditPaste
        Else
            MsgBox "No Picture selected!"
        End If
    End If
    
End Sub

Private Sub FormatFont()
Dim cdlg As New GCommonDialog

Dim fnt As New StdFont
Dim clr As Long

    On Error Resume Next
    fnt.Name = rtf.SelFontName
    fnt.Strikethrough = rtf.SelStrikeThru
    fnt.Bold = rtf.SelBold
    fnt.Italic = rtf.SelItalic
    fnt.Underline = rtf.SelUnderline
    fnt.Size = rtf.SelFontSize
    clr = rtf.SelColor
    If cdlg.VBChooseFont(fnt, , Me.hwnd, clr, 5, 72, CF_ScreenFonts Or CF_EFFECTS) Then
        rtf.SelFontName = fnt.Name
        rtf.SelBold = fnt.Bold
        rtf.SelColor = clr
        rtf.SelItalic = fnt.Italic
        rtf.SelUnderline = fnt.Underline
        rtf.SelFontSize = fnt.Size
        rtf.SelStrikeThru = fnt.Strikethrough
    End If
    
    Set fnt = Nothing
End Sub

Private Sub UpdatePosition()
Dim lCol As Long, lLine As Long, lLineIndex As Long
Dim lSelStart As Long, lSelEnd As Long

  lLine = SendMessage(rtf.hwnd, EM_LINEFROMCHAR, -1, 0&)
  
  lSelStart = rtf.SelStart
  lSelEnd = rtf.SelStart + rtf.SelLength

  If lSelStart < lSelEnd Then lSelStart = lSelEnd
   
  lLineIndex = SendMessage(rtf.hwnd, EM_LINEINDEX, -1, 0&)
  lCol = lSelStart - lLineIndex
  
    With StatusBar1.Panels
      .Item(2).text = "Row: " & Str(lLine + 1)    ' Row
      .Item(3).text = "Col: " & Str(lCol + 1)    ' Colomn
   End With
End Sub


Private Sub vFormat_Click()
ViewFormat
End Sub

Private Sub vOptions_Click()
ViewOptions
End Sub

Private Sub vStandard_Click()
ViewStandard
End Sub

Private Sub vStatusBar_Click()
ViewStatusBar
End Sub


