////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// PropLabelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "PropLabelDlg.h"
#include "BarPropPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);
int _EditPicture(HWND Parent, HBITMAP hBmp, int cx, int cy, HBITMAP& hNewBmp);

/////////////////////////////////////////////////////////////////////////////
// CPropLabelDlg dialog


CPropLabelDlg::CPropLabelDlg(CWnd* pParent)
	: CDialog(CPropLabelDlg::IDD, pParent)
{
    m_pItemProp = NULL;
    m_bLoaded = FALSE;
	//{{AFX_DATA_INIT(CPropLabelDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    Create(IDD_LABELPROP_DLG, pParent);
}

CPropLabelDlg::~CPropLabelDlg()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    DestroyWindow();
}

BEGIN_MESSAGE_MAP(CPropLabelDlg, CDialog)
	//{{AFX_MSG_MAP(CPropLabelDlg)
	ON_BN_CLICKED(IDC_BTN_PICTURE, OnBtnPicture)
	ON_BN_CLICKED(IDC_CHECK_VISIBLE, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ED_TEXT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_HEIGHT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChange)
	ON_EN_CHANGE(IDC_EDIT_LEFT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChange)
	ON_EN_CHANGE(IDC_EDIT_TOP, OnChange)
	ON_EN_CHANGE(IDC_EDIT_WIDTH, OnChange)
	ON_CBN_SELCHANGE(IDC_COMBO_ALIGN, OnChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropLabelDlg message handlers

BOOL CPropLabelDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_COMBO_ALIGN));
    int i  = 0;
    ComboBox.InsertString(i++,_T("ccALeft"));
    ComboBox.InsertString(i++,_T("ccACenter"));
    ComboBox.InsertString(i++,_T("ccARight"));
    ComboBox.Detach();
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropLabelDlg::OnBtnPicture() 
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPic, cx, cy,hBmp) == IDCANCEL)    
        return;

    m_pItemProp->hPic = hBmp;
    OnChange();
    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->Pic.hPic)
        PicPreView.SetBitmap(m_pItemProp->hPic);
    PicPreView.Detach();
}

void CPropLabelDlg::OnChange() 
{
   if (m_pItemProp && m_bLoaded)
   {
        m_pItemProp->bDirty = TRUE;		
	    Update(m_pItemProp);
        // Notify Propery page to turn on "Apply" button
       ::PostMessage(::GetParent(m_hWnd),WM_MODIFIED, NULL, NULL); 
   }
}

BOOL CPropLabelDlg::ReadProp(IItem* pItem, LABEL_PROPERTIES* pLProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IItem> spItem = pItem;

    ASSERT(spItem);

    CComBSTR Name;
    if(FAILED(spItem->get_Name(&Name)))
        return FALSE;
    pLProp->Name = Name;

    long ID = -1;
    if(FAILED(spItem->get_ID(&ID)))
        return FALSE;
    pLProp->Id = ID;

    VARIANT_BOOL bVisible; 
    if(FAILED(spItem->get_Visible(&bVisible)))
        return FALSE;
    pLProp->Visible = bVisible ? TRUE: FALSE;

    //  Width
    long width = 0;
    if(FAILED(spItem->get_ControlWidth(&width)))
        return FALSE;
    pLProp->width = width;

    long top = 0;
    if(FAILED(spItem->get_ControlTop(&top)))
        return FALSE;
    pLProp->top = top;

    long left = 0;
    if(FAILED(spItem->get_ControlLeft(&left)))
        return FALSE;
    pLProp->left = left;

    long height = 0;
    if(FAILED(spItem->get_ControlHeight(&height)))
        return FALSE;
    pLProp->height = height;

    // Set Prop Align
   enAlignment nSelect =(enAlignment)ccALeft;
   if(FAILED(spItem->get_Alignment(&nSelect)))
        return FALSE;
    pLProp->Alignment =(int)nSelect; 
    
    // Set Picture
    CComPtr<IPictureDisp> pPic;
    HBITMAP hBmp = NULL;
    if (SUCCEEDED(spItem->get_Image(&pPic)))
    {
       CComQIPtr<IPicture,&IID_IPicture> spPic(pPic);
        HBITMAP hBmp = NULL;
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pLProp->hPic = hBmp;

    m_bLoaded = TRUE;
    return TRUE;
}

BOOL CPropLabelDlg::SetProp(IItem* pItem, LABEL_PROPERTIES* pLProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IItem> spItem = pItem;

     CComBSTR Name = pLProp->Name.AllocSysString();
    if(FAILED(spItem->put_Name(Name)))
        return FALSE;

    long ID = pLProp->Id;
    if(FAILED(spItem->put_ID(ID)))
        return FALSE;

    VARIANT_BOOL bVisible = pLProp->Visible ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spItem->put_Visible(bVisible)))
        return FALSE;

    enItemType type = (enItemType) pLProp->Type;
    if(FAILED(spItem->put_Type(type)))
        return FALSE;

    long width = pLProp->width;
    if(FAILED(spItem->put_ControlWidth(width)))
        return FALSE;

    long top = pLProp->top;
    if(FAILED(spItem->put_ControlTop(top)))
        return FALSE;

    long left = pLProp->left;
    if(FAILED(spItem->put_ControlLeft(left)))
        return FALSE;

    long height = pLProp->height;
    if(FAILED(spItem->put_ControlHeight(height)))
        return FALSE;

    enAlignment nSelect = (enAlignment)pLProp->Alignment;
    if(FAILED(spItem->put_Alignment(nSelect)))
        return FALSE;

    // Set Picture
    CPictureHolder* pPicHolder = new CPictureHolder;
    pPicHolder->CreateFromBitmap(pLProp->hPic);  
    if (FAILED(spItem->put_Image(pPicHolder->GetPictureDispatch())))
        return FALSE;

    return TRUE;
}

BOOL CPropLabelDlg::Update(LABEL_PROPERTIES *pProp)
{
   if (!pProp || !pProp->bDirty) return FALSE;

   int ID = GetDlgItemInt(IDC_EDIT_ID);
   pProp->Id = ID;

   TCHAR buffer[256];
   GetDlgItemText(IDC_EDIT_NAME,buffer,sizeof(buffer));
   pProp->Name = buffer; // CSting copy

   BOOL bChk = IsDlgButtonChecked(IDC_CHECK_VISIBLE ) == BST_CHECKED;
   pProp->Visible = bChk;

   bChk = IsDlgButtonChecked(IDC_CHECK_ENABLED) == BST_CHECKED;
   pProp->Enabled = bChk;

    CString str;
    GetDlgItemText(IDC_EDIT_ED_TEXT,str.GetBuffer(1024),1024);
    pProp->Text = str;

    CString psw_ch;
    GetDlgItemText(IDC_EDIT_ED_PSWD,psw_ch.GetBuffer(2),2);
    pProp->PassChar = psw_ch;

    bChk = IsDlgButtonChecked(IDC_CHECK_EDIT_BORDER) == BST_CHECKED;
    pProp->Boder = bChk;

    bChk = IsDlgButtonChecked(IDC_CHECK_EDIT_RO) == BST_CHECKED;
    pProp->ReadOnly = bChk;

    //======= Common with Combo & Label
     int height = GetDlgItemInt(IDC_EDIT_HEIGHT);
     pProp->height = height;

     int width = GetDlgItemInt(IDC_EDIT_WIDTH);
     pProp->width = width;

     int top = GetDlgItemInt(IDC_EDIT_TOP);
     pProp->top = top;

     int left = GetDlgItemInt(IDC_EDIT_LEFT);
     pProp->left = left;
     //===============================================

    // Aligment
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_COMBO_ALIGN));
    enAlignment nSelect =(enAlignment)ccALeft;
    nSelect = (enAlignment)ComboBox.GetCurSel();
    ComboBox.Detach();
    pProp->Alignment = nSelect;

    return TRUE;
}

BOOL CPropLabelDlg::ShowData(LABEL_PROPERTIES *pLProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    m_pItemProp = pLProp;
    m_bLoaded = FALSE;  // Prop page SetDirty update protection

    SetDlgItemText(IDC_EDIT_NAME, pLProp->Name);

    // Set ID
    SetDlgItemInt(IDC_EDIT_ID, pLProp->Id);

    // Set Visible
    CheckDlgButton(IDC_CHECK_VISIBLE,           // Set the check box
                  pLProp->Visible ? BST_CHECKED : BST_UNCHECKED);
    // Set Enabled
    CheckDlgButton(IDC_CHECK_ENABLED,           
                  pLProp->Enabled ? BST_CHECKED : BST_UNCHECKED);

    SetDlgItemInt(IDC_EDIT_WIDTH,pLProp->width,FALSE);

    SetDlgItemInt(IDC_EDIT_TOP,pLProp->top,FALSE);

    SetDlgItemInt(IDC_EDIT_LEFT,pLProp->left,FALSE);

    SetDlgItemInt(IDC_EDIT_HEIGHT,pLProp->height,FALSE);

    // Set Prop Align
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd,IDC_COMBO_ALIGN));    
    ComboBox.SetCurSel(pLProp->Alignment);
    ComboBox.Detach();

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
    if (pLProp->hPic)
        PicPreView.SetBitmap(pLProp->hPic);
    PicPreView.Detach();

    m_bLoaded = TRUE;
    return TRUE;
}
