////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Item.h : Declaration of the CIItem

#ifndef __ITEM_H_
#define __ITEM_H_

#include "resource.h"       // main symbols
#include "CuteControls.h"
#include "Edit.h"
#include "Combo.h"

#include "BarButton.h"
#define Picture IPictureDisp 
/////////////////////////////////////////////////////////////////////////////
// CIItem
class ATL_NO_VTABLE CIItem : public CBCBarButton,
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CIItem, &CLSID_Item>,
	public ISupportErrorInfo,
   	public IPersistStreamInitImpl<CIItem>,
    public IPersistStorageImpl<CIItem>,
	public IProvideClassInfo2Impl<&CLSID_Item, &IID_IItem, &LIBID_CuteControlsLib>,
	public IDispatchImpl<IItem, &IID_IItem, &LIBID_CuteControlsLib>
{
public:
	CIItem();
	~CIItem();

DECLARE_REGISTRY_RESOURCEID(IDR_ITEM)

DECLARE_NOT_AGGREGATABLE(CIItem)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CIItem)
	COM_INTERFACE_ENTRY(IItem)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersistStream, IPersistStreamInit)
END_COM_MAP()

BEGIN_PROP_MAP(CIItem)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
//	 PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);
    HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
    HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);

// IItem
public:
	HRESULT CreateEditObj();
	HRESULT CreateComboObj();
	STDMETHOD(get_ImageDisabled)(/*[out, retval]*/ Picture* *pVal);
	STDMETHOD(put_ImageDisabled)(/*[in]*/ Picture* newVal);
	STDMETHOD(get_ImageHot)(/*[out, retval]*/ Picture* *pVal);
	STDMETHOD(put_ImageHot)(/*[in]*/ Picture* newVal);
	STDMETHOD(get_ControlLeft)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ControlLeft)(/*[in]*/ long newVal);
	STDMETHOD(get_ControlTop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ControlTop)(/*[in]*/ long newVal);
	STDMETHOD(get_ControlHeight)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ControlHeight)(/*[in]*/ long newVal);
	STDMETHOD(get_Alignment)(/*[out, retval]*/ enAlignment *pVal);
	STDMETHOD(put_Alignment)(/*[in]*/ enAlignment newVal);
	STDMETHOD(SetFocus)();
	STDMETHOD(get_ComboBox)(/*[out, retval]*/ ICombo **pVal);
	STDMETHOD(get_Edit)(/*[out, retval]*/ IEdit **pVal);
	STDMETHOD(get_ControlWidth)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ControlWidth)(/*[in]*/ long newVal);
	STDMETHOD(get_State)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_State)(/*[in]*/ long newVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ enItemStyle *pVal);
	STDMETHOD(put_Style)(/*[in]*/ enItemStyle newVal);
	STDMETHOD(get_Image)(/*[out, retval]*/ Picture* *pVal);
	STDMETHOD(put_Image)(/*[in]*/ Picture* newVal);
	STDMETHOD(putref_Image)(/*[in]*/ Picture* newVal);
	STDMETHOD(get_Visible)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_Visible)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(get_Enabled)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_Enabled)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(get_AccelKey)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_AccelKey)(/*[in]*/ long newVal);
	STDMETHOD(get_ToolTip)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ToolTip)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Description)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Description)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Name)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Name)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_ID)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_ID)(/*[in]*/ long newVal);
	STDMETHOD(get_Type)(/*[out, retval]*/ enItemType *pVal);
	STDMETHOD(put_Type)(/*[in]*/ enItemType newVal);

	virtual void FinalRelease();
	virtual HRESULT FinalConstruct();

//--- Comtained Objects 
    CComPtr<IUnknown> m_spCombo;
    CComObject<CICombo>* m_pComboObj;

    CComPtr<IUnknown> m_spEdit;
    CComObject<CICEdit>* m_pEditObj;

    unsigned  m_bRequiresSave:1;
protected:
};

#endif //__ITEM_H_
