#if !defined(AFX_IMAGEEDITDLG_H__07E27535_C6D9_11D1_A647_00A0C93A70EC__INCLUDED_)
#define AFX_IMAGEEDITDLG_H__07E27535_C6D9_11D1_A647_00A0C93A70EC__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// ImageEditDlg.h : header file
//

#include "ColorSelector.h"
#include "ImagePaintArea.h"
#include "PaletteCommandFrameWnd.h"

/////////////////////////////////////////////////////////////////////////////
// CHCImageEditDlg dialog

class CHCImageEditDlg : public CDialog
{
// Construction
public:
	CHCImageEditDlg(CBitmap* pBitmap, SIZE sizeImage, CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CHCImageEditDlg)
	enum { IDD = IDD_IMAGE_EDITOR };
	CStatic	m_wndPaletteBarLocation;
	CStatic	m_wndPreview;
	CHCImagePaintArea	m_wndLargeDrawArea;
	CHColorSelector	m_wndColor;
	//}}AFX_DATA

// Operations:
public:
	void Open();
	BOOL OnPickColor (COLORREF color);

	void SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE mode)
	{
		m_wndLargeDrawArea.SetMode (mode);
	}

	CHCImagePaintArea::IMAGE_EDIT_MODE GetMode () const
	{
		return m_wndLargeDrawArea.GetMode ();
	}

	void Clear ();
	void Copy ();
	void Paste ();

protected:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHCImageEditDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL InsertImage(CBitmap* pCBmp);

	// Generated message map functions
	//{{AFX_MSG(CHCImageEditDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg void OnColors();
	afx_msg void OnClear();
	//}}AFX_MSG
	afx_msg LRESULT OnKickIdle(WPARAM, LPARAM);
	DECLARE_MESSAGE_MAP()

// Attributes:
	CBitmap*					m_pBitmap;
	CSize						m_sizeImage;

	CRect						m_rectPreviewFrame;
	CRect						m_rectPreviewImage;

	CToolBar					m_wndPaletteBar;        //CToolBar
	CHCPaletteCommandFrameWnd*	m_pWndPaletteBarDummyFrame;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMAGEEDITDLG_H__07E27535_C6D9_11D1_A647_00A0C93A70EC__INCLUDED_)
