// CHCImageEditDlg.cpp : implementation file
//

#include "stdafx.h"
#include <afxpriv.h>
#include "resource.h"
#include "ImageEditDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHCImageEditDlg dialog
#pragma warning (disable : 4355)

CHCImageEditDlg::CHCImageEditDlg(CBitmap* pBitmap, SIZE sizeImage, CWnd* pParent /*=NULL*/)
	: CDialog(CHCImageEditDlg::IDD, pParent),
	m_pBitmap (pBitmap),
	m_sizeImage (sizeImage),
	m_pWndPaletteBarDummyFrame (NULL),
	m_wndLargeDrawArea (this)
{
	ASSERT (m_pBitmap != NULL);

	//{{AFX_DATA_INIT(CHCImageEditDlg)
	//}}AFX_DATA_INIT
}

#pragma warning (default : 4355)

void CHCImageEditDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHCImageEditDlg)
	DDX_Control(pDX, IDC_PALETTE, m_wndPaletteBarLocation);
	DDX_Control(pDX, IDC_PREVIEW_AREA, m_wndPreview);
	DDX_Control(pDX, IDC_DRAW_AREA, m_wndLargeDrawArea);
	DDX_Control(pDX, IDC_COLORS, m_wndColor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHCImageEditDlg, CDialog)
	//{{AFX_MSG_MAP(CHCImageEditDlg)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_COLORS, OnColors)
	ON_BN_CLICKED(IDABORT, OnClear)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_KICKIDLE, OnKickIdle)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHCImageEditDlg message handlers

BOOL CHCImageEditDlg::OnInitDialog() 
{
	const int iBorderWidth = 10;
	const int iBorderHeight = 5;
	const int iPreviewBorderSize = 4;

	CDialog::OnInitDialog();

	m_wndLargeDrawArea.SetBitmap (m_pBitmap);

	//------------------------
	// Create the palette bar:
	//------------------------	
	{
		CRect rectPaletteBar;
		m_wndPaletteBarLocation.GetClientRect (&rectPaletteBar);
		m_wndPaletteBarLocation.MapWindowPoints (this, &rectPaletteBar);
		rectPaletteBar.DeflateRect (2, 2);

		m_wndPaletteBar.Create (this);
		m_wndPaletteBar.LoadToolBar(IDR_PALETTE);

		m_wndPaletteBar.SetBarStyle (
			m_wndPaletteBar.GetBarStyle () & 
				~(CBRS_GRIPPER | CBRS_BORDER_TOP | CBRS_BORDER_BOTTOM | CBRS_BORDER_LEFT | CBRS_BORDER_RIGHT));

		m_wndPaletteBar.SetBorders (iBorderWidth, iBorderHeight, 
									iBorderWidth, iBorderHeight);
		m_wndPaletteBar.MoveWindow (rectPaletteBar);

		m_wndPaletteBar.SetWindowPos (&wndTop, -1, -1, -1, -1,
			SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

		m_pWndPaletteBarDummyFrame = new CHCPaletteCommandFrameWnd;
		m_pWndPaletteBarDummyFrame->Create (0, 
			CFrameWnd::rectDefault, this);

		m_wndPaletteBar.SetOwner (m_pWndPaletteBarDummyFrame);
	}	
	//---------------------
	// Define preview area:
	//---------------------
	m_wndPreview.GetClientRect (&m_rectPreviewImage);
	m_wndPreview.MapWindowPoints (this, &m_rectPreviewImage);

	m_rectPreviewImage.left = (m_rectPreviewImage.left + m_rectPreviewImage.right - m_sizeImage.cx) / 2;
	m_rectPreviewImage.right = m_rectPreviewImage.left + m_sizeImage.cx;

	m_rectPreviewImage.top = (m_rectPreviewImage.top + m_rectPreviewImage.bottom - m_sizeImage.cy) / 2;
	m_rectPreviewImage.bottom = m_rectPreviewImage.top + m_sizeImage.cy;

	m_rectPreviewFrame = m_rectPreviewImage;
	m_rectPreviewFrame.InflateRect (iPreviewBorderSize, iPreviewBorderSize);

	m_wndLargeDrawArea.m_rectParentPreviewArea = m_rectPreviewImage;

    // Set Picture size caption
    char Caption[256];
    sprintf(Caption,"Picture Size:%d X %d", m_sizeImage.cx, m_sizeImage.cy);
    SetDlgItemText(IDC_EDIT_CAPTION,Caption);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//********************************************************************************
void CHCImageEditDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	dc.Draw3dRect (&m_rectPreviewFrame,
					::GetSysColor (COLOR_3DHILIGHT),
					::GetSysColor (COLOR_3DSHADOW));

	CBitmap* pbmOld = NULL;
	CDC dcMem;
		
	dcMem.CreateCompatibleDC (&dc);
	pbmOld = dcMem.SelectObject (m_pBitmap);

	dc.BitBlt (m_rectPreviewImage.left, m_rectPreviewImage.top,
				m_sizeImage.cx, m_sizeImage.cy, &dcMem,
				0, 0, SRCCOPY);

	dcMem.SelectObject(pbmOld);
	dcMem.DeleteDC();
}
//********************************************************************************
void CHCImageEditDlg::Clear() 
{
	CWindowDC	dc (this);
	CDC 		memDC;	

	memDC.CreateCompatibleDC (&dc);
	
	CBitmap* pOldBitmap = memDC.SelectObject (m_pBitmap);

	CRect rect (0, 0, m_sizeImage.cx, m_sizeImage.cy);
	memDC.FillSolidRect (&rect, ::GetSysColor (COLOR_3DFACE));

	memDC.SelectObject (pOldBitmap);

	InvalidateRect (m_rectPreviewImage);
	m_wndLargeDrawArea.Invalidate ();
}
//********************************************************************************
void CHCImageEditDlg::OnColors() 
{
	m_wndLargeDrawArea.SetColor (m_wndColor.GetColor ());
}
//********************************************************************************
void CHCImageEditDlg::Copy() 
{
	if (m_pBitmap == NULL)
	{
		return;
	}

	try
	{
		CWindowDC dc (this);

		//----------------------
		// Create a bitmap copy:
		//----------------------
		CDC memDCDest;
		memDCDest.CreateCompatibleDC (NULL);
		
		CDC memDCSrc;
		memDCSrc.CreateCompatibleDC (NULL);
		
		CBitmap bitmapCopy;
		if (!bitmapCopy.CreateCompatibleBitmap (&dc, m_sizeImage.cx, m_sizeImage.cy))
		{
			AfxMessageBox (IDP_CANT_COPY_BITMAP);
			return;
		}

		CBitmap* pOldBitmapDest = memDCDest.SelectObject (&bitmapCopy);
		CBitmap* pOldBitmapSrc = memDCSrc.SelectObject (m_pBitmap);

		memDCDest.BitBlt (0, 0, m_sizeImage.cx, m_sizeImage.cy,
						&memDCSrc, 0, 0, SRCCOPY);

		memDCDest.SelectObject (pOldBitmapDest);
		memDCSrc.SelectObject (pOldBitmapSrc);

		if (!OpenClipboard ())
		{
			AfxMessageBox (IDP_CANT_COPY_BITMAP);
			return;
		}

		if (!::EmptyClipboard ())
		{
			AfxMessageBox (IDP_CANT_COPY_BITMAP);
			::CloseClipboard ();
			return;
		}


		HANDLE hclipData = ::SetClipboardData (CF_BITMAP, bitmapCopy.Detach ());
		if (hclipData == NULL)
		{
			AfxMessageBox (IDP_CANT_COPY_BITMAP);
			TRACE (_T("CHCImageEditDlg::Copy() error. Error code = %x\n"), GetLastError ());
		}

		::CloseClipboard ();
	}
	catch (...)
	{
		AfxMessageBox (IDP_INTERLAL_ERROR);
	}
}
//********************************************************************************
void CHCImageEditDlg::Paste() 
{

	COleDataObject data;
	if (!data.AttachClipboard ())
	{
		AfxMessageBox (IDP_CANT_PASTE_BITMAP);
		return;
	}

	if (!data.IsDataAvailable (CF_BITMAP))
	{
		AfxMessageBox (IDP_CANT_PASTE_BITMAP);
		return;
	}

	tagSTGMEDIUM dataMedium;
	if (!data.GetData (CF_BITMAP, &dataMedium))
	{
		AfxMessageBox (IDP_CANT_PASTE_BITMAP);
		return;
	}

	CBitmap* pBmpClip = CBitmap::FromHandle (dataMedium.hBitmap);
	if (pBmpClip == NULL)
	{
		AfxMessageBox (IDP_CANT_PASTE_BITMAP);
		return;
	}

    if (InsertImage(pBmpClip))
    {
	    InvalidateRect (m_rectPreviewImage);
	    m_wndLargeDrawArea.Invalidate ();
    }
}
//****************************************************************************************
LRESULT CHCImageEditDlg::OnKickIdle(WPARAM, LPARAM)
{
	CControlBar* pBar = &m_wndPaletteBar;
	pBar->OnUpdateCmdUI (m_pWndPaletteBarDummyFrame, TRUE);

    return 0;
}
//****************************************************************************************
BOOL CHCImageEditDlg::OnPickColor (COLORREF color)
{
	if (!m_wndColor.SelectColor (color))
	{
		return FALSE;
	}

	//-----------------------------------------
	// Move to the pen mode (not so good :-(!):
	//-----------------------------------------
	m_wndLargeDrawArea.SetMode (CHCImagePaintArea::IMAGE_EDIT_MODE_PEN);
	return TRUE;
}

void CHCImageEditDlg::OnClear ()
{
	//-----------------------------------------
	// return IDABORT
	//-----------------------------------------
    EndDialog( IDABORT);
}

void CHCImageEditDlg::Open()
{
    static char BASED_CODE szFilter[] = "Bitmap Files (*.bmp)|*.bmp|All Files (*.*)|*.*||";
    CFileDialog FileDlg(TRUE, NULL, 
                        NULL,
                        OFN_HIDEREADONLY,
                        szFilter,
                        this );
    int ret = FileDlg.DoModal();
    if ( ret != IDOK)
        return;

    HBITMAP hBmp = (HBITMAP) ::LoadImage (
		NULL,   //AfxGetInstanceHandle (),
		FileDlg.m_ofn.lpstrFile ,
		IMAGE_BITMAP,
		0, 0,
		LR_LOADFROMFILE | LR_CREATEDIBSECTION | LR_LOADMAP3DCOLORS);

    if (hBmp)
    {
        CBitmap* pCBmp = CBitmap::FromHandle (hBmp);
        if(InsertImage(pCBmp))
        {
       	    InvalidateRect (m_rectPreviewImage);
    	    m_wndLargeDrawArea.Invalidate ();
        }
    }
    else
    {
        AfxMessageBox (IDP_INVALID_BITMAP);
    }
}
extern HANDLE DDBToDIB (HBITMAP bitmap, DWORD dwCompression);

BOOL CHCImageEditDlg::InsertImage(CBitmap* pCBmp)
{
    ASSERT(pCBmp);

    BOOL bStretch = FALSE;
	BITMAP bmp;
	pCBmp->GetBitmap (&bmp);

	if (bmp.bmWidth != m_sizeImage.cx ||
		bmp.bmHeight != m_sizeImage.cy)
	{
		CString strMessage;
		strMessage.Format (IDS_WRONG_IMAGE_SIZE,
						m_sizeImage.cx, m_sizeImage.cy);
        CString Caption;
        Caption.Format(_T("Insert Image %dx%d "),
                        bmp.bmWidth, bmp.bmHeight);
		UINT ret = MessageBox (strMessage, Caption,
                MB_ICONEXCLAMATION | MB_ICONQUESTION | MB_YESNOCANCEL);
      if (ret == IDCANCEL)  
		    return FALSE;
      else if (ret == IDYES)
	    bStretch = TRUE;
    }

	CDC memDCDst;
	CDC memDCSrc;

	memDCSrc.CreateCompatibleDC (NULL);
	memDCDst.CreateCompatibleDC (NULL);
	
	CBitmap* pSrcOldBitmap = memDCSrc.SelectObject (pCBmp);
	if (pSrcOldBitmap == NULL)
	{
		AfxMessageBox (IDP_CANT_INSERT_BITMAP);
		return FALSE;
	}

	CBitmap* pDstOldBitmap = memDCDst.SelectObject (m_pBitmap);
	if (pDstOldBitmap == NULL)
	{
		AfxMessageBox (IDP_CANT_INSERT_BITMAP);
		
		memDCSrc.SelectObject (pSrcOldBitmap);
		return FALSE;
    }
    if (bStretch == FALSE)
	    memDCDst.BitBlt (0, 0, m_sizeImage.cx, m_sizeImage.cy,
					&memDCSrc, 0, 0, SRCCOPY);
    else
	    memDCDst.StretchBlt(0, 0, m_sizeImage.cx, m_sizeImage.cy,
					&memDCSrc, 0, 0,bmp.bmWidth, bmp.bmHeight, SRCCOPY);

	memDCDst.SelectObject (pDstOldBitmap);
	memDCSrc.SelectObject (pSrcOldBitmap);

    HANDLE handle = DDBToDIB ((HBITMAP)pCBmp->Detach(), NULL);

    if (handle)
        pCBmp->Attach((HBITMAP) handle);

    return TRUE;
}

