////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// CuteControls.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//      To build a separate proxy/stub DLL, 
//      run nmake -f CuteControlsps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "CuteControls.h"

#include "CuteControls_i.c"
#include "CuteBar.h"
#include "BarPropPage.h"
#include "Bar.h"
#include "BarCollection.h"
#include "ItemCollection.h"
#include "Item.h"
#include "Combo.h"
#include "Edit.h"
#include "ReturnLong.h"
#include "ImageEditDlg.h"


CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_CuteBar, CICuteBar)
OBJECT_ENTRY(CLSID_BarPropPage, CBarPropPage)
OBJECT_ENTRY_NON_CREATEABLE(CIBar)
OBJECT_ENTRY_NON_CREATEABLE(CIBarCollection)
OBJECT_ENTRY_NON_CREATEABLE(CIItemCollection)
OBJECT_ENTRY_NON_CREATEABLE(CIItem)
OBJECT_ENTRY_NON_CREATEABLE(CReturnLong)
OBJECT_ENTRY(CLSID_Combo, CICombo)
OBJECT_ENTRY(CLSID_Edit, CICEdit)
END_OBJECT_MAP()

class CCuteControlsApp : public CWinApp
{
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCuteControlsApp)
	public:
    virtual BOOL InitInstance();
    virtual int ExitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CCuteControlsApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

BEGIN_MESSAGE_MAP(CCuteControlsApp, CWinApp)
	//{{AFX_MSG_MAP(CCuteControlsApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CCuteControlsApp theApp;

BOOL CCuteControlsApp::InitInstance()
{
    _Module.Init(ObjectMap, m_hInstance, &LIBID_CuteControlsLib);
    int ret = CWinApp::InitInstance();
    	
	ASSERT(m_pszAppName != NULL);
    // set up correct registry Appl Key
	BOOL bEnable = AfxEnableMemoryTracking(FALSE);
	free((void*)m_pszProfileName);
	m_pszProfileName = _tcsdup(m_pszAppName);
	AfxEnableMemoryTracking(bEnable);

    //Update Help file path for htmlhelp use
   	LPTSTR lpszExt = _tcsrchr(m_pszHelpFilePath, '.');
    lstrcpy(lpszExt, _T(".chm"));

    return ret;
}

int CCuteControlsApp::ExitInstance()
{
    _Module.Term();
    return CWinApp::ExitInstance();
}
////////////////////////////////////////////////////////////////////////////
// Global Vesion Info
const float g_Version = 1.10f;
     float g_VersionRead = 1.10f;  // to be used for persistence version schema.
const int  g_Build = 010311;

////////////////////////////////////////////////////////////////////////////
// Global Helper Fuctions
CICuteBar* g_pControl = NULL;

CICuteBar* _GetMainControl()
{
    ASSERT(g_pControl);
    return g_pControl;
}

void  _SetMainControl(CICuteBar* pCtrl)
{
    ASSERT(pCtrl);
    g_pControl = pCtrl;
}

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc)
{
    ASSERT(hBmpSrc);
	//-------------------------------------------------------
	// Create memory source DC and select an original bitmap:
	//-------------------------------------------------------
	CDC memDCSrc;
	memDCSrc.CreateCompatibleDC (NULL);

	HBITMAP hOldBitmapSrc = NULL;

	int iBitmapWidth;
	int iBitmapHeight;

	BITMAP bmp;
	if (::GetObject (hBmpSrc, sizeof (BITMAP), &bmp) == 0)
	{
		return NULL;
	}

	iBitmapWidth = bmp.bmWidth;
	iBitmapHeight = bmp.bmHeight;

	hOldBitmapSrc = (HBITMAP) memDCSrc.SelectObject (hBmpSrc);
	if (hOldBitmapSrc == NULL)
	{
		return NULL;
	}

	//----------------------------------------------------------
	// Create a new bitmap compatible with the source memory DC
	// (original bitmap SHOULD BE ALREADY SELECTED!):
	//----------------------------------------------------------
	HBITMAP hNewBitmap = (HBITMAP) ::CreateCompatibleBitmap (memDCSrc,
									iBitmapWidth,
									iBitmapHeight);
	if (hNewBitmap == NULL)
	{
		memDCSrc.SelectObject (hOldBitmapSrc);
		return NULL;
	}

	//------------------------------------------------------
	// Create memory destination DC and select a new bitmap:
	//------------------------------------------------------
	CDC memDCDst;
	memDCDst.CreateCompatibleDC (&memDCSrc);
	
	HBITMAP hOldBitmapDst = (HBITMAP) memDCDst.SelectObject (hNewBitmap);
	if (hOldBitmapDst == NULL)
	{
		memDCSrc.SelectObject (hOldBitmapSrc);
		::DeleteObject (hNewBitmap);
		return NULL;
	}

	//-----------------------------
	// Copy original bitmap to new:
	//-----------------------------
	memDCDst.BitBlt (0, 0, iBitmapWidth, iBitmapHeight,
				&memDCSrc, 0, 0, SRCCOPY);
		
	memDCDst.SelectObject (hOldBitmapDst);
	memDCSrc.SelectObject (hOldBitmapSrc);

	return hNewBitmap;
}

int _EditPicture(HWND Parent, HBITMAP hBmp, int cx, int cy, HBITMAP& hNewBmp)
{
	CSize sizeImage(cx,cy);
    CBitmap* pBitmapRet = NULL;
    int nRet = -1;
    hNewBmp = NULL;

	try
	{
       CBitmap* pBitmap = NULL;
        if (hBmp)
            hNewBmp = _CopyBitmap(hBmp);

        if (hNewBmp)
             pBitmap = CBitmap::FromHandle(hNewBmp);
        else
        {                		            
		    CDC memDC;	
            pBitmap = new CBitmap;
            HDC hDCScreen = GetDC(NULL);
		    CDC	dc;
            dc.Attach(hDCScreen);

            memDC.CreateCompatibleDC(&dc);
		    
		    if (!pBitmap->CreateCompatibleBitmap(&dc, sizeImage.cx, sizeImage.cy))
		    {
			    AfxMessageBox (IDP_CANNT_CREATE_IMAGE, MB_OK|MB_ICONSTOP);
			    return FALSE;
		    }
		    CBitmap* pOldBitmap = memDC.SelectObject(pBitmap);

		    CRect rect (0, 0, sizeImage.cx, sizeImage.cy);
		    memDC.FillSolidRect(&rect, ::GetSysColor (COLOR_3DFACE));

		    memDC.SelectObject(pOldBitmap);
            dc.Detach();
           	ReleaseDC(NULL, hDCScreen);
        }
           
       CHCImageEditDlg ImgDlg(pBitmap, sizeImage,CWnd::FromHandle(Parent));

        nRet = ImgDlg.DoModal();
        switch ( nRet )
        { 
        case -1: 
		    AfxMessageBox (IDP_INTERLAL_ERROR, MB_OK|MB_ICONSTOP);
            break;
        case IDOK:
            {
                pBitmapRet = pBitmap;
                hNewBmp = (HBITMAP)pBitmapRet->Detach();
            }
        break;
        case IDABORT:  
        case IDCANCEL:
            {
              ::DeleteObject (hNewBmp);
               hNewBmp = NULL;
            }
            break;
        default:      
            break;
        }
    }
	catch (...)
	{
		AfxMessageBox (IDP_INTERLAL_ERROR, MB_OK|MB_ICONSTOP);
        return NULL;
	}

    return nRet;
}

short  _ShiftState()
{
	BOOL bShift = (GetKeyState(VK_SHIFT) < 0);
	BOOL bCtrl  = (GetKeyState(VK_CONTROL) < 0);
	BOOL bAlt   = (GetKeyState(VK_MENU) < 0);

	return (short)(bShift + (bCtrl << 1) + (bAlt << 2));
}

void _PixelToTwips(POINT& ptPix, POINT* ptTwips)
{
    ASSERT(ptTwips);

	int nPixelsPerInchX;    // Pixels per logical inch along width
	int nPixelsPerInchY;    // Pixels per logical inch along height

	HDC hDCScreen = GetDC(NULL);
	ATLASSERT(hDCScreen != NULL);
	nPixelsPerInchX = GetDeviceCaps(hDCScreen, LOGPIXELSX);
	nPixelsPerInchY = GetDeviceCaps(hDCScreen, LOGPIXELSY);
	ReleaseDC(NULL, hDCScreen);

	ptTwips->x = ptPix.x*1440/nPixelsPerInchX;
	ptTwips->y = ptPix.y*1440/nPixelsPerInchY;
}
/////////////////////////////////////////////////////////////////////////////
// CToolBar creation etc

#ifdef AFX_CORE3_SEG
#pragma code_seg(AFX_CORE3_SEG)
#endif

/*
	DIBs use RGBQUAD format:
		0xbb 0xgg 0xrr 0x00

	Reasonably efficient code to convert a COLORREF into an
	RGBQUAD is byte-order-dependent, so we need different
	code depending on the byte order we're targeting.
*/
#define RGB_TO_RGBQUAD(r,g,b)   (RGB(b,g,r))
#define CLR_TO_RGBQUAD(clr)     (RGB(GetBValue(clr), GetGValue(clr), GetRValue(clr)))

struct _afxCOLORMAP
{
	// use DWORD instead of RGBQUAD so we can compare two RGBQUADs easily
	DWORD rgbqFrom;
	int iSysColorTo;
};

const _afxCOLORMAP _SysColorMap[] =
{
	// mapping from color in DIB to system color
	{ RGB_TO_RGBQUAD(0x00, 0x00, 0x00),  COLOR_BTNTEXT },       // black
	{ RGB_TO_RGBQUAD(0x80, 0x80, 0x80),  COLOR_BTNSHADOW },     // dark gray
	{ RGB_TO_RGBQUAD(0xC0, 0xC0, 0xC0),  COLOR_BTNFACE },       // bright gray
	{ RGB_TO_RGBQUAD(0xFF, 0xFF, 0xFF),  COLOR_BTNHIGHLIGHT }   // white
};

HBITMAP DDBTo256 (HBITMAP bitmap)
{
    BITMAP   bm; BITMAPINFOHEADER bi;
    LPBITMAPINFOHEADER  lpbi;
    DWORD   dwLen;
    HANDLE   hDIB;
    HANDLE   handle;
    HDC    hDC;

    // Get bitmap information
    ::GetObject(bitmap, sizeof(bm),(LPSTR)&bm);

    // Initialize the bitmapinfoheader
    bi.biSize  = sizeof(BITMAPINFOHEADER);
    bi.biWidth  = bm.bmWidth;
    bi.biHeight   = bm.bmHeight;
    bi.biPlanes   = 1;
    bi.biBitCount  = (WORD) (bm.bmPlanes * bm.bmBitsPixel);
    bi.biCompression = BI_RGB;   //dwCompression;
    bi.biSizeImage  = 0;
    bi.biXPelsPerMeter = 0;
    bi.biYPelsPerMeter = 0;
    bi.biClrUsed  = 0;
    bi.biClrImportant = 0;

    // Compute the size of the  infoheader and the color table
    int nColors = (1 << (bm.bmPlanes * bm.bmBitsPixel));
    if( nColors > 256 )
    {
      nColors = 256;
      bi.biBitCount  = 8;
    }
//    bi.biClrUsed  = nColors;
    bi.biSizeImage = ((((bi.biWidth * bi.biBitCount) + 31) & ~31) / 8)
      * bi.biHeight;
    dwLen  = bi.biSize + nColors * sizeof(RGBQUAD);

 // Allocate enough memory to hold bitmapinfoheader and color table
    hDIB = GlobalAlloc(GMEM_FIXED,dwLen);
    if (hDIB == NULL)
      return NULL; 

    lpbi = (LPBITMAPINFOHEADER)hDIB;
 // We need a device context to get the DIB from
    HDC hDCScreen = GetDC(NULL); // Screeen DC
    HBITMAP bmp = ::CreateCompatibleBitmap(hDCScreen, bi.biWidth, bi.biHeight);
    hDC = ::CreateCompatibleDC (hDCScreen);
    if (hDC == NULL)
        return NULL;
    *lpbi = bi;
    // Call GetDIBits with a NULL lpBits param, so the device driver
    // will calculate the biSizeImage field
    GetDIBits(hDC, bitmap, 0L, (DWORD)bi.biHeight,
            (LPBYTE)NULL, (LPBITMAPINFO)lpbi,
            (DWORD)DIB_RGB_COLORS);
    bi = *lpbi;
    if (!hDIB)
    {
        ::GlobalFree(hDIB);
        ::ReleaseDC(NULL,hDCScreen);
        return NULL;
    }
    dwLen = bi.biSizeImage;
    handle = GlobalAlloc( GMEM_FIXED, dwLen);
    if (handle == NULL)
    {
        GlobalFree(hDIB);  // Reselect the original palette
        ::ReleaseDC(NULL,hDCScreen);
        return NULL;
    }
    GetDIBits(hDC, bitmap, 0L, bi.biHeight,
        (LPBYTE)handle,    // address for bitmap bits
        //    + (bi.biSize + nColors * sizeof(RGBQUAD)),
        (LPBITMAPINFO)lpbi,  // address of bitmapinfo
                (DWORD)DIB_RGB_COLORS);
//-------
	// color table is in RGBQUAD DIB format
    BOOL bMono = FALSE;
	DWORD* pColorTable =
		(DWORD*)(((LPBYTE)lpbi) + (UINT)lpbi->biSize);

	for (int iColor = 0; iColor < nColors; iColor++)
	{
		// look for matching RGBQUAD color in original
		for (int i = 0; i < _countof(_SysColorMap); i++)
		{
			if (pColorTable[iColor] == _SysColorMap[i].rgbqFrom)
			{
				if (bMono)
				{
					// all colors except text become white
					if (_SysColorMap[i].iSysColorTo != COLOR_BTNTEXT)
						pColorTable[iColor] = RGB_TO_RGBQUAD(255, 255, 255);
				}
				else
					pColorTable[iColor] =
						CLR_TO_RGBQUAD(::GetSysColor(_SysColorMap[i].iSysColorTo));
				break;
			}
		}
	}
//--------
    if (bmp && handle)
        SetDIBits(hDC, bmp, 0, (UINT)bi.biHeight, handle, (LPBITMAPINFO)lpbi,
                    DIB_RGB_COLORS);

	::DeleteDC(hDC);
    ::ReleaseDC(NULL,hDCScreen);
    ::GlobalFree(hDIB);
    ::GlobalFree(handle);

    return bmp;
}

HBITMAP _SysColorBitmap(HBITMAP hBmp, BOOL bMono)
{
    ASSERT(hBmp);
    // Get bitmap information
    BITMAP   bm;
    ::GetObject(hBmp, sizeof(bm),(LPSTR)&bm);

    // Compute the size of the  infoheader and the color table
    int nColors = (1 << (bm.bmPlanes * bm.bmBitsPixel));
    WORD biBitCount = (WORD) (bm.bmPlanes * bm.bmBitsPixel);   
    if( nColors > 16 )
    {
      nColors = 16;
      biBitCount  = 4;
    }
    UINT dwLen  = sizeof(BITMAPINFOHEADER) + nColors * sizeof(RGBQUAD);

    LPBITMAPINFOHEADER lpBitmap = (LPBITMAPINFOHEADER)::malloc(dwLen);
	if (lpBitmap == NULL)
		return NULL;

    // Call GetDIBits with a NULL lpBits param, so the device driver
    // will calculate the biSizeImage field
    // Initialize the bitmapinfoheader
    lpBitmap->biSize  = sizeof(BITMAPINFOHEADER);
    lpBitmap->biWidth  = bm.bmWidth;
    lpBitmap->biHeight   = bm.bmHeight;
    lpBitmap->biPlanes   = 1;
    lpBitmap->biBitCount  = biBitCount;
    lpBitmap->biCompression = BI_RGB;   //dwCompression;
    lpBitmap->biSizeImage  = 0;
    lpBitmap->biSizeImage = ((((lpBitmap->biWidth * lpBitmap->biBitCount) + 31) & ~31) / 8)
      * lpBitmap->biHeight;
    lpBitmap->biXPelsPerMeter = 0;
    lpBitmap->biYPelsPerMeter = 0;
    lpBitmap->biClrUsed  = 1;
    lpBitmap->biClrImportant = 0;
	
    HDC hDCScreen = ::GetDC(NULL);
    GetDIBits(hDCScreen, hBmp, 0L, (DWORD)bm.bmHeight,
            (LPBYTE)NULL, (LPBITMAPINFO)lpBitmap,
            (DWORD)DIB_RGB_COLORS);


	// make copy of BITMAPINFOHEADER so we can modify the color table
	const int nColorTableSize = 16;
	UINT nSize = lpBitmap->biSize + nColorTableSize * sizeof(RGBQUAD)+ lpBitmap->biSizeImage;
	LPBITMAPINFOHEADER lpBitmapInfo = (LPBITMAPINFOHEADER)::malloc(nSize);
	if (lpBitmapInfo == NULL)
    {
        ::free(lpBitmap);
		return NULL;
    }
	memcpy(lpBitmapInfo, lpBitmap, nSize);

	// color table is in RGBQUAD DIB format
	DWORD* pColorTable =
		(DWORD*)(((LPBYTE)lpBitmapInfo) + (UINT)lpBitmapInfo->biSize);

	for (int iColor = 0; iColor < nColorTableSize; iColor++)
	{
		// look for matching RGBQUAD color in original
		for (int i = 0; i < _countof(_SysColorMap); i++)
		{
			if (pColorTable[iColor] == _SysColorMap[i].rgbqFrom)
			{
				if (bMono)
				{
					// all colors except text become white
					if (_SysColorMap[i].iSysColorTo != COLOR_BTNTEXT)
						pColorTable[iColor] = RGB_TO_RGBQUAD(255, 255, 255);
				}
				else
					pColorTable[iColor] =
						CLR_TO_RGBQUAD(::GetSysColor(_SysColorMap[i].iSysColorTo));
				break;
			}
		}
	}

	int nWidth = (int)lpBitmapInfo->biWidth;
	int nHeight = (int)lpBitmapInfo->biHeight;
	HBITMAP hbm = ::CreateCompatibleBitmap(hDCScreen, nWidth, nHeight);

	if (hbm != NULL)
	{
		HDC hDCGlyphs = ::CreateCompatibleDC(hDCScreen);
		HBITMAP hbmOld = (HBITMAP)::SelectObject(hDCGlyphs, hbm);

		LPBYTE lpBits;
		lpBits = (LPBYTE)(lpBitmap + 1);
		lpBits += (1 << (lpBitmapInfo->biBitCount)) * sizeof(RGBQUAD);

		StretchDIBits(hDCGlyphs, 0, 0, nWidth, nHeight, 0, 0, nWidth, nHeight,
			lpBits, (LPBITMAPINFO)lpBitmapInfo, DIB_RGB_COLORS, SRCCOPY);
		SelectObject(hDCGlyphs, hbmOld);
		::DeleteDC(hDCGlyphs);
	}
	::ReleaseDC(NULL, hDCScreen);

	// free copy of bitmap info struct and resource itself
	::free(lpBitmapInfo);
    ::free(lpBitmap);

	return hbm;
}

void _HFileString(HFILETYPE Type, CString Name, UINT ID, CString& OutStr)
{
    CString str_id;
    CString str_Name;

    str_id.Format(_T("\n Public Const id_%s = %i\n"), Name,ID);
    str_Name.Format(_T(" Public Const name_%s = \"%s\"\n"), Name, Name);

    OutStr += str_id + str_Name;
}
/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState());
    return (AfxDllCanUnloadNow()==S_OK && _Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
    // registers object, typelib and all interfaces in typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
    return _Module.UnregisterServer(TRUE);
}


