////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Combo.h : Declaration of the CICombo

#ifndef __COMBO_H_
#define __COMBO_H_

#include "resource.h"       // main symbols
class CCoreCombo;
class CICuteBar;
class CIItem;
#include "ComboHook.h"

extern short  _ShiftState();

/////////////////////////////////////////////////////////////////////////////
// CICombo
class ATL_NO_VTABLE CICombo :  public CComboBox,
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CICombo, &CLSID_Combo>,
	public IDispatchImpl<ICombo, &IID_ICombo, &LIBID_CuteControlsLib>
{
public:
	CICombo();
	~CICombo();

DECLARE_REGISTRY_RESOURCEID(IDR_COMBO)
DECLARE_NOT_AGGREGATABLE(CICombo)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CICombo)
	COM_INTERFACE_ENTRY(ICombo)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// ICombo
public:
	STDMETHOD(get_ListIndex)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ListIndex)(/*[in]*/ short newVal);
	STDMETHOD(get_Text)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Text)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_ItemData)(/*[in]*/ VARIANT Index, /*[out, retval]*/ long *pVal);
	STDMETHOD(put_ItemData)(/*[in]*/ VARIANT Index, /*[in]*/ long newVal);
	STDMETHOD(get_ListCount)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ListText)(/*[in]*/ long Index, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ListText)(/*[in]*/ long Index, /*[in]*/ BSTR newVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ enComboStyle *pVal);
	STDMETHOD(put_Style)(/*[in]*/ enComboStyle newVal);
	STDMETHOD(get_Sorted)(/*[out, retval]*/ VARIANT_BOOL  *pVal);
	STDMETHOD(put_Sorted)(/*[in]*/ VARIANT_BOOL  newVal);
#ifdef COMBO_PROP_READONLY
	STDMETHOD(get_ReadOnly)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_ReadOnly)(/*[in]*/ VARIANT_BOOL newVal);
#endif
	STDMETHOD(RemoveString)(/*[in]*/ long Index);
	STDMETHOD(Clear)();
	STDMETHOD(AddString)(/*[in]*/ BSTR String, /*[in, optional]*/ VARIANT* Index);

    CICuteBar * m_pMainControl;

public:
	CWnd* GetControl();
    BOOL Create(DWORD dwStyle,const RECT &rect, CWnd *pParentWnd, UINT nID);
    void SetFocus();
    void Update();
    virtual void Serialize(CArchive &ar);
    void SetMainControl(CICuteBar *pControl){ m_pMainControl = pControl;}
    void SetHolder(CIItem* pHolder);



// Attributes
public:
	void OnComboKeyPress( UINT& nChar);
	void OnComboKeyDown( UINT nChar);
	void OnComboKeyUp( UINT nChar);

protected:
    CStringArray   m_Strings; // Combo strings array for Serialization
    CMap<int,int,long,long>  m_DataMap;
 	enComboStyle m_Style;
    BOOL    m_bSorted;
    BOOL    m_bReadOnly;
    CString m_WndText;

    CIItem* m_pHolder;
    CComboHook m_Hook;

protected:
	BOOL GetComboText(CString& str, int nIndex);

	// Generated message map functions
protected:
	//{{AFX_MSG(CICombo)
	afx_msg void OnSetfocus();
	afx_msg void OnKillfocus();
	afx_msg void OnSelchange();
	afx_msg void OnDropdown();
	afx_msg void OnEditchange();
	afx_msg void OnCloseup();
	afx_msg void OnParentNotify(UINT message, LPARAM lParam);
	afx_msg void OnDestroy();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif //__COMBO_H_
