////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Combo.cpp : Implementation of CICombo
#include "stdafx.h"
#include "CuteControls.h"
#include "Combo.h"
#include "Item.h"
#include "CuteBar.h"
#include "ReturnLong.h"

/////////////////////////////////////////////////////////////////////////////
// CICombo
BEGIN_MESSAGE_MAP(CICombo, CComboBox)
	//{{AFX_MSG_MAP(CICombo)
	ON_CONTROL_REFLECT(CBN_SETFOCUS, OnSetfocus)
	ON_CONTROL_REFLECT(CBN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
	ON_CONTROL_REFLECT(CBN_DROPDOWN, OnDropdown)
	ON_CONTROL_REFLECT(CBN_EDITCHANGE, OnEditchange)
	ON_CONTROL_REFLECT(CBN_CLOSEUP, OnCloseup)
	ON_WM_PARENTNOTIFY()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CICombo::CICombo()
{
    m_bSorted = FALSE;
    m_Style = ccComboStandard;
    m_bReadOnly = FALSE;
    m_pMainControl = NULL;

}

CICombo::~CICombo()
{
}

void CICombo::SetHolder(CIItem* pHolder)
{
    ASSERT(pHolder);
    m_pHolder = pHolder;
}

BOOL CICombo::Create(DWORD dwStyle,const RECT &rect, CWnd *pParentWnd, UINT nID)
{
    if (m_Style ==  ccComboStandard)
    {
        dwStyle |= CBS_DROPDOWN;
        m_bReadOnly = FALSE;
    }
    else
    {
        dwStyle |= CBS_DROPDOWNLIST;
        m_bReadOnly = TRUE;
    }
    if (m_bSorted)
     dwStyle |= CBS_SORT;

	const int nDropHeight = 100;
    CRect rc;
    rc= rect;
//	rc.top = CY_CONTROL_SPACE;
	rc.bottom = rc.bottom + nDropHeight;
//    rc.left  = 0;
//    rc.right -= 2*CX_CONTROL_SPACE;

     BOOL bRet = CComboBox::Create( WS_CHILD|CBS_AUTOHSCROLL|WS_TABSTOP|WS_VSCROLL|
                                    dwStyle,
                                    rc, pParentWnd, nID );
    if(bRet)
    {
       // Load combobox strings
        for (int i=0;i < m_Strings.GetSize();i++)
            CComboBox::AddString((LPCSTR)m_Strings[i]);
        // Load Item data
        POSITION pos = m_DataMap.GetStartPosition();
        int    nKey;   long data;
        while (pos != NULL)
        {
            m_DataMap.GetNextAssoc( pos, nKey, data );
            SetItemData(nKey, data);
        }
        SetWindowText(m_WndText);
    }
    return bRet;
}

void CICombo::Serialize(CArchive &ar)
{
   	m_Strings.Serialize(ar);
    m_DataMap.Serialize(ar);

    if (ar.IsStoring())
	{
       ar << m_Style;
       ar << m_bSorted;
       ar << m_bReadOnly;
    }
    else
    {
       int temp;
       ar >> temp;
       m_Style = (enComboStyle)temp;
       ar >> m_bSorted;
       ar >> m_bReadOnly;
    }
}

void CICombo::SetFocus()
{
    CComboBox::SetFocus();
}

void CICombo::Update()
{
#ifdef UNSOLVED
    if ( m_bDirty == FALSE)
        return;
    // To add runtime property sincronization
    return;
    // Check Control Width
    CRect rc;
    if (::IsWindow(m_hWnd))
    {
        GetWindowRect(&rc);
        CWnd* pParent = GetParent();
        pParent->ScreenToClient(&rc);
        if(m_bVisible && rc.Width() != m_ControlWidth)
        SetWindowPos(NULL,rc.right,rc.top, m_ControlWidth,rc.Height(),
                        SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE );
    }
#endif
}

BOOL CICombo::GetComboText(CString &str, int nIndex)
{
    BOOL bRet = FALSE;
    if (m_hWnd)
    {
        bRet = TRUE;
        int n = GetLBTextLen( nIndex );
        if (n != -1)
        {
            GetLBText( nIndex, str.GetBuffer(n) );
            str.ReleaseBuffer(); 
        }
    }
    return bRet;
}

//===============================================================
STDMETHODIMP CICombo::AddString(BSTR String, VARIANT *Index)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR bstr;
    bstr.AppendBSTR(String);
    CString str(bstr);
    int nIndex = -1;
    if (Index->vt == VT_I2 || Index->vt == VT_I4 )
        nIndex = Index->iVal;

   if (nIndex == -1 || m_Strings.GetSize() <= nIndex)
    {
        m_Strings.Add(str);
        if (m_hWnd)
             CComboBox::AddString(str);
    }else
    { 
        m_Strings.InsertAt(nIndex,str);
        if (m_hWnd)
            InsertString(nIndex,str);
        /*SetCurSel (iIndex);
		  SetItemData (iIndex, dwData);
		  SetEditSel (-1, 0);*/

    }
	return S_OK;
}

STDMETHODIMP CICombo::Clear()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_Strings.RemoveAll();
    if (m_hWnd)
        ResetContent();

	return S_OK;
}

STDMETHODIMP CICombo::RemoveString(long Index)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    int nIndex = Index;
    ASSERT(m_Strings.GetSize() >= nIndex);

    if (m_hWnd)
    { 
       for (int i=0;i < m_Strings.GetSize();i++)
       {
        CString str;
        GetComboText(str,i);
        if ( str == m_Strings[i])
            m_Strings.RemoveAt(i);
       }
       DeleteString(nIndex);     
    }
    else
    m_Strings.RemoveAt(nIndex);

    return S_OK;
}

#ifdef COMBO_PROP_READONLY
STDMETHODIMP CICombo::get_ReadOnly(VARIANT_BOOL *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = m_bReadOnly ? VARIANT_TRUE: VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CICombo::put_ReadOnly(VARIANT_BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_bReadOnly = newVal ? TRUE : FALSE;
	return S_OK;
}
#endif

STDMETHODIMP CICombo::get_Sorted(VARIANT_BOOL *pVal)
{

    *pVal = m_bSorted ? VARIANT_TRUE: VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CICombo::put_Sorted(VARIANT_BOOL newVal)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BOOL bSorted =newVal ? TRUE : FALSE;

    if (m_bSorted == FALSE && bSorted != FALSE)
    {
       if (m_hWnd)
            ModifyStyle( 0, CBS_SORT );
    }
    else if (m_bSorted != FALSE && bSorted == FALSE)
    {
       if (m_hWnd)
            ModifyStyle( CBS_SORT, 0 );
    }

    m_bSorted = bSorted;

	return S_OK;
}

STDMETHODIMP CICombo::get_Style(enComboStyle *pVal)
{
    *pVal =  m_Style;
	return S_OK;
}

STDMETHODIMP CICombo::put_Style(enComboStyle newVal)
{
    m_Style = newVal;

	return S_OK;
}

STDMETHODIMP CICombo::get_ListText(long Index, BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    int nIndex = Index;
    if (m_Strings.GetSize() <= nIndex)
        return S_FALSE;

    if (m_hWnd)
    {
        CString str;
        GetComboText(str, nIndex);
        *pVal = str.AllocSysString();
    }
    else
        *pVal = (m_Strings.GetAt(nIndex)).AllocSysString();

	return S_OK;
}

STDMETHODIMP CICombo::put_ListText(long Index, BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

   int nIndex = Index;
   if (m_Strings.GetSize() >= nIndex)
   {
    CString str(newVal);
    m_Strings.SetAt(nIndex,str);
    if (m_hWnd)
        InsertString(nIndex, str);
   }

    return S_OK;
}

STDMETHODIMP CICombo::get_ListCount(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = m_Strings.GetSize();

	return S_OK;
}

STDMETHODIMP CICombo::get_ItemData(VARIANT Index, long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (Index.vt != VT_I4)
        return E_FAIL;

    int nIndex = Index.intVal;
    if (nIndex == 0)
        return E_FAIL;
    nIndex--;

    *pVal = GetItemData(nIndex);

	return S_OK;
}

STDMETHODIMP CICombo::put_ItemData(VARIANT Index, long newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (Index.vt != VT_I4)
        return E_FAIL;
    int nIndex = Index.intVal;
    if (nIndex == 0)
        return E_FAIL;
    nIndex--;

    SetItemData(nIndex, newVal);
    m_DataMap.SetAt(nIndex,newVal);

	return S_OK;
}

STDMETHODIMP CICombo::get_Text(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_hWnd)
        GetWindowText(m_WndText);

    *pVal = m_WndText.AllocSysString();
	return S_OK;
}

STDMETHODIMP CICombo::put_Text(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR cbstr;
    cbstr.AppendBSTR(newVal);
    m_WndText = cbstr;
    if (m_hWnd)
        SetWindowText((LPCSTR) m_WndText); 

	return S_OK;
}

STDMETHODIMP CICombo::get_ListIndex(short *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    short Sel = -1;
    if (m_hWnd)
       Sel = GetCurSel();

    *pVal = Sel;

	return S_OK;
}

STDMETHODIMP CICombo::put_ListIndex(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_hWnd)
        SetCurSel(newVal);

	return S_OK;
}


CWnd* CICombo::GetControl()
{
    return this;
}
/////////////////////////////////////////////////////////////////////////////
// CICombo message handlers

void CICombo::OnSetfocus() 
{
    ASSERT(m_pHolder);
    ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
        m_pHolder->m_pMainControl->Fire_ItemGotFocus(pItem);
}

void CICombo::OnKillfocus() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemLostFocus(pItem);	
}

void CICombo::OnSelchange() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ComboSelChange(pItem);	
}

void CICombo::OnDropdown() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
    {
        m_pHolder->m_pMainControl->Fire_ComboDrop(pItem);
    }
}

void CICombo::OnCloseup() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ComboClose(pItem);			
}

void CICombo::OnEditchange() 
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_TextChanged(pItem);				
}

void CICombo::OnParentNotify(UINT message, LPARAM lParam) 
{
	CComboBox::OnParentNotify(message, lParam);	

    if ( LOWORD(message) == WM_CREATE)
    {
        //find Edit-window by classname compare next
        HWND hWnd = (HWND)lParam;
        static const TCHAR szEdit[] = _T("edit");

        TCHAR szCompare[sizeof(szEdit)/sizeof(szEdit[0])+1];
        ::GetClassName(hWnd, szCompare,
                       sizeof(szCompare)/sizeof(szCompare[0]) );
        BOOL bMatch = lstrcmpi(szCompare, szEdit) == 0;
        if (bMatch)
          m_Hook.Install(this,hWnd);
    }
    else if ( LOWORD(message) == WM_DESTROY && m_Hook.IsHooked())
    {
        m_Hook.Install(this,(HWND)NULL); // unhook
    }

}
void CICombo::OnComboKeyDown( UINT nChar)
{
    ASSERT(m_pHolder);
    ASSERT(m_pHolder->m_pMainControl);
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyDown(pItem, nChar, _ShiftState());	
}

void CICombo::OnComboKeyUp( UINT nChar)
{
    ASSERT(m_pHolder);
	ASSERT(m_pHolder->m_pMainControl);
    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
	    m_pHolder->m_pMainControl->Fire_ItemKeyUp(pItem, nChar, _ShiftState());	
}

void CICombo::OnComboKeyPress( UINT& nChar)
{
    ASSERT(m_pHolder);

    CComObject<CReturnLong>* pObj;
    CComPtr<IReturnLong> pIRetlong;
    CComPtr<IReturnLong> pVal;

    CComObject<CReturnLong>::CreateInstance(&pObj);
    pObj->QueryInterface(&pIRetlong);
    pIRetlong.p->QueryInterface(IID_IDispatch,(void**)&pVal);

    pObj->m_lValue =(long)nChar;
	ASSERT(m_pHolder->m_pMainControl);

    CComPtr<IItem> pItem;
    HRESULT hr = m_pHolder->InternalQueryInterface(m_pHolder, m_pHolder->_GetEntries(),IID_IDispatch,(void**)&pItem);
    if (SUCCEEDED(hr))
    	m_pHolder->m_pMainControl->Fire_ItemKeyPress(pItem, pVal);

    nChar = (UINT)pObj->m_lValue;
}

void CICombo::OnDestroy() 
{
    ASSERT(m_pHolder);
//    GetWindowText(m_pHolder->m_WndText);
    CComboBox::OnDestroy();	
}
