////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// BarCollection.cpp : Implementation of CIBarCollection
#include "stdafx.h"
#include "BarCollection.h"
#include "Bar.h"

template <>
HRESULT VCUE::GenericCopy<BarColl::CollectionExposedType, BarColl::ContObj>::copy(destination_type* pTo, const source_type* pFrom)
{
    HRESULT hr = E_INVALIDARG;
    if (pFrom == NULL && *pFrom == NULL)
		return hr;
#ifdef SDS
	hr = E_FAIL;
    CComPtr<IUnknown> pIU;
    hr = (*pFrom)->QueryInterface(IID_IUnknown,(void**)&pIU);
    if (FAILED(hr)) 
		return hr;    
#endif
   return(*pFrom)->QueryInterface(IID_IDispatch,(void**)pTo);

};

/////////////////////////////////////////////////////////////////////////////
// CIBarCollection

CIBarCollection::CIBarCollection()
{
    m_pMainControl = NULL;
}

CIBarCollection::~CIBarCollection()
{
    RemoveAll();
}

HRESULT CIBarCollection::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
//    HRESULT hr = IPersistStreamInitImpl<CIBarCollection>::
//                            IPersistStreamInit_Load( pStm, pMap);
    HRESULT hr = S_OK;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        if (!RestoreObjects(pStm))
            hr = E_FAIL;
    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    return hr;
}

HRESULT CIBarCollection::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap)
{
//    HRESULT hr = IPersistStreamInitImpl<CIBarCollection>::
//                            IPersistStreamInit_Save( pStm, fClearDirty, pMap);
    HRESULT hr = S_OK;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        if (!SaveObjects(pStm,fClearDirty))
            hr = E_FAIL;
    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }
   return hr;
}
STDMETHODIMP CIBarCollection::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IBarCollection
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CIBarCollection::Add(long ID, VARIANT *Name, VARIANT *Type, IBar **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BarColl::ContObj  pObj;
    CComPtr<IUnknown> pIBar;

    HRESULT hr = CreateObject(&pObj,&pIBar);
    if (FAILED(hr))
        return hr;

    pObj->AddRef();  //Keeps Object alive once added
    pObj->put_ID(ID);
    if(Name && Name->vt == VT_BSTR)
        pObj->put_Name(Name->bstrVal);

    m_coll.push_back(pObj);
    
    pObj->SetMainControl(m_pMainControl);
    ClearState();

    hr = pIBar->QueryInterface(IID_IDispatch,(void**)pVal);
    return hr; 
}

STDMETHODIMP CIBarCollection::Remove(VARIANT *Index)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
        
    if (Index->vt == VT_EMPTY ) 
        return E_POINTER;

    HRESULT hr = E_FAIL;
    CComVariant var;
    var = *Index;
    if(var.vt == VT_BSTR)
    {
        // find item by Name
        CComBSTR bstr;
        bstr.AppendBSTR(var.bstrVal);
        CString Str = bstr;
        int i = 0;  
        BOOL bFound = FALSE;
        BarColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end())
	    {
            BarColl::ContObj pObj = *iter;
            if ( pObj->m_strName == Str)
            {
                bFound = TRUE;
                break;
            }
		    iter++; i++;
	    }

        if ( bFound == FALSE)   //  not found
            return hr;

        var.vt = VT_I4;
        var.intVal = i+1;
    }

    if (var.intVal == 0)
        return E_POINTER;

    if(var.vt == VT_I4 || var.vt == VT_I2)
    {
        long nIndex = var.iVal;
        if (var.vt == VT_I4)
            nIndex = var.intVal;

	    nIndex--;
    
        BarColl::ContainerType::iterator iter = m_coll.begin();
	    while (iter != m_coll.end() && nIndex > 0)
	    {
		    iter++;
		    nIndex--;
	    }
	    if (iter != m_coll.end())
        {
            m_coll.erase(iter);
            ClearState();
            hr = S_OK;
        }
    }

	return hr;
}

STDMETHODIMP CIBarCollection::Clear()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ClearState();
    RemoveAll();

	return S_OK;
}

BOOL CIBarCollection::RestoreObjects(LPSTREAM pStm)
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    BOOL bRet = TRUE;
	int size = 0;
    pStm->Read(&size, sizeof(size),NULL);
    
    for ( int i =0 ; i < size ; i++)
	{
        BarColl::ContObj  pObj;
        CComPtr<IUnknown> pIBar;

// Use COM class factory for object creation
        HRESULT hr = CreateObject(&pObj,&pIBar);
        if (FAILED(hr))
            return hr;
        pObj->AddRef(); // Prevent from deleting object after leaving function

		pObj->SetMainControl(m_pMainControl);

        m_coll.push_back(pObj);

        CComPtr<IPersistStream> spPersistStm;
        if(FAILED( pIBar->QueryInterface(&spPersistStm)))
        {
            bRet = FALSE;
            break;
        }

        if(FAILED(spPersistStm->Load(pStm)))
        {
            bRet = FALSE;
            break;
        }
	}
    return bRet;
}

HRESULT CIBarCollection::CreateObject(BarColl::ContObj* ppObj,IUnknown** ppIBar)
{        
    *ppIBar = NULL;

    HRESULT hr = CComObject<CIBar>::CreateInstance(ppObj);
    if (FAILED(hr))
        return hr;

    return (*ppObj)->QueryInterface(ppIBar);
}

BOOL CIBarCollection::SaveObjects(LPSTREAM pStm,BOOL fClearDirty)
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    BOOL bRet = TRUE;
    BarColl::ContainerType::iterator iter = m_coll.begin();
    // Save number of objects 
	int size = m_coll.size();
    pStm->Write(&size, sizeof(size),NULL);

    while (iter != m_coll.end())
	{
        BarColl::ContObj pObj = *iter;
        CComPtr<IPersistStream> spPersistStm;       
        if(FAILED(pObj->QueryInterface(&spPersistStm)))
        {
            bRet = FALSE;
            break;
        }

        if(FAILED(spPersistStm->Save(pStm, fClearDirty)))
        {
            bRet = FALSE;
            break;
        }
        iter++;
	}
    return bRet;
}

void CIBarCollection::RemoveAll()
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        BarColl::ContObj pObj = *iter;
        pObj->Release();
		iter++;
	}
    m_coll.clear();
}

void CIBarCollection::ClearState()
{
 	AFX_MANAGE_STATE(AfxGetStaticModuleState())
     if (AfxGetApp()->m_pszRegistryKey)
     {
        CDockState DockState;
        DockState.Clear();
        DockState.SaveState(AfxGetApp()->m_pszRegistryKey);
     }
}

void CIBarCollection::SetMainControl(CICuteBar *pControl)
{
    m_pMainControl = pControl;
}

STDMETHODIMP CIBarCollection::get_Item(VARIANT *Index, IBar **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (Index->vt == VT_EMPTY ) 
        return E_POINTER;

    HRESULT hr = E_FAIL;

    CComVariant var;
    var = *Index;
    CString Str;

    CComBSTR bstr;
    if(var.vt == VT_BSTR)
    {
        // find item by Name
        bstr.AppendBSTR(var.bstrVal);
        Str = bstr;
        BarColl::ContainerType::iterator iter = m_coll.begin();
		while (iter != m_coll.end())
		{
            if(var.vt == VT_BSTR)
            {
                BarColl::ContObj pObj = *iter;
                if (pObj->m_strName ==  Str)
                     break;                   
            }
			iter++;
		}
		if (iter != m_coll.end())
			hr = BarColl::CollectionCopyType::copy(pVal, &*iter);

      return hr;
    }

    if (var.intVal == 0)
        return E_FAIL;

    if( var.vt == VT_I4 || var.vt == VT_I2)
    {
        long index = var.iVal;
        if (var.vt == VT_I4)
            index = var.intVal;

		//Index is 1-based
		if (pVal == NULL)
			return E_POINTER;
		index--;
        BarColl::ContainerType::iterator iter = m_coll.begin();
		while (iter != m_coll.end() && index > 0)
		{
			iter++;
			index--;
		}
		if (iter != m_coll.end())
			hr = BarColl::CollectionCopyType::copy(pVal, &*iter);
    }
	return hr;
}

BOOL CIBarCollection::ConstructBars()
{
    BOOL bRet = FALSE;
    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        pBar->ConstructToolBar();
		iter++;
        bRet = TRUE;
	}
    return bRet;
}

int CIBarCollection::GetControlInfo(LPCONTROLINFO pCI)
{
    int nAccSize = 0;

    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        nAccSize += pBar->m_AcellKeys.GetCount();
		iter++;
	}

    if (nAccSize == 0) return nAccSize; // nothing to do 

 // Second loop alloc memory and fill up accel table
    HGLOBAL hMem = 	GlobalAlloc(GMEM_MOVEABLE,nAccSize*sizeof(ACCEL));
    ASSERT(hMem);
    ACCEL* pAccel =(ACCEL*) GlobalLock(hMem);
    ASSERT(pAccel);

   	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        UINT  wKey;
        UINT ID = 0;
        POSITION posA = pBar->m_AcellKeys.GetStartPosition();
        while (posA != NULL)
        {
            pBar->m_AcellKeys.GetNextAssoc( posA, wKey, ID );
            pAccel->fVirt = LOWORD(wKey);
            pAccel->key = HIWORD(wKey);
            pAccel->cmd = ID; 
            pAccel++;
        }
		iter++;
	}

    GlobalUnlock(hMem);

    pCI->cb = sizeof(CONTROLINFO);
    pCI->cAccel = nAccSize;
    pCI->hAccel = (HACCEL)hMem;
    pCI->dwFlags = CTRLINFO_EATS_ESCAPE;

    return nAccSize;
}

BOOL CIBarCollection::PreTranslateMessage(LPMSG pMsg)
{
    BOOL bRet = FALSE;
    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
 	    if (pBar->PreTranslateMessage(pMsg))
        {
		    bRet = TRUE;
            break;
        }
		iter++;
	}

    return bRet;
}

void CIBarCollection::UpdateImages(UINT id)
{
    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        pBar->UpdateImage(id);
		iter++;
	}
}

void CIBarCollection::GenHFile(HFILETYPE Type, CString &Buffer)
{
    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        pBar->GenHeader(Type,Buffer);
		iter++;
	}
}

void CIBarCollection::UpdateBars()
{
    BarColl::ContainerType::iterator iter = m_coll.begin();
	while (iter != m_coll.end())
	{
        CIBar* pBar = *iter;
        pBar->UpdateBar();
		iter++;
	}

}
