/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.util.image;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.util.image.ImageLoader;
import se.bysoft.sureshot.util.image.ImageLoaderException;

public class ImageLoaderImpl
implements ImageLoader {
    public Image load(String string) throws ImageLoaderException {
        MediaTracker mediaTracker = new MediaTracker(new JPanel());
        URL uRL = this.getClass().getResource(string);
        Image image = uRL == null ? Toolkit.getDefaultToolkit().getImage(string) : Toolkit.getDefaultToolkit().getImage(uRL);
        Assertion.assertion(image != null);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            Assertion.assertion(false);
        }
        if (mediaTracker.isErrorAny()) {
            String string2 = "Could not load the image. Image name: " + string + "\n" + "Using url:" + uRL + "\n";
            throw new ImageLoaderException(string2);
        }
        return image;
    }

    public Image[] load(String[] stringArray) throws ImageLoaderException {
        Image[] imageArray = new Image[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            imageArray[n] = this.load(stringArray[n]);
            ++n;
        }
        return imageArray;
    }
}

