/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSTypes.h
*********************************************************************/

#ifndef VSTypes_H
#define VSTypes_H /* Base Type Module */

#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSConfig.h"
#include "VSPlatform.h"

typedef signed char ppInt8; /* standard signed one byte type,
                            range is 128 to 127 */
typedef ppInt8 *PppInt8; /* pointer to ppInt8 */

typedef unsigned char ppUns8; /* standard signed one byte type,
                              range is 0 to 255 */
typedef ppUns8 *PppUns8;    /* pointer to ppUns8 */

typedef short int ppInt16;  /* standard signed two byte type,
                            range is 32,768 to 32,767 */
typedef ppInt16 *PppInt16;  /* pointer to ppInt16 */

typedef unsigned short int ppUns16; /* standard unsigned two byte type,
                                    range is 0 to 65,535 */
typedef ppUns16 *PppUns16;  /* pointer to ppUns16 */

#if PDFLARGEINT

typedef int ppInt32;       /* standard signed four byte type,
                           range is 2,147,483,648 to 2,147,483,647 */
typedef ppInt32 *PppInt32; /* pointer to ppInt32 */

typedef unsigned int ppUns32; /* standard signed four byte type,
                              range is 0 to 4,294,967,295 */
typedef ppUns32 *PppUns32; /* pointer to ppUns32 */

#else

typedef long int ppInt32;  /* standard signed four byte type,
                           range is 2,147,483,648 to 2,147,483,647 */
typedef ppInt32 *PppInt32; /* pointer to ppInt32 */

typedef unsigned long int ppUns32; /* standard signed four byte type,
                                   range is 0 to 4,294,967,295 */
typedef ppUns32 *PppUns32; /* pointer to ppUns32 */

#endif

#ifdef WINDOWS_PLATFORM
typedef signed __int64 ppInt64; /* standard signed eight byte type,
                                range is 9,223,372,036,854,775,808
                                to 9,223,372,036,854,775,807 */
typedef unsigned __int64 ppUns64; /* standard signed eight byte type,
                                  range is 0 to 2^64-1 */
#else
typedef long long ppInt64;   /* standard signed eight byte type,
                             range is 9,223,372,036,854,775,808
                             to 9,223,372,036,854,775,807 */
typedef unsigned long long ppUns64; /* standard signed eight byte type,
                                    range is 0 to 2^64-1 */
#endif
typedef ppInt64 *PppInt64;   /* pointer to ppInt64 */
typedef ppUns64 *PppUns64;          /* pointer to ppUns64 */

typedef double ppReal;   /* standard signed eight byte type,
                         range is 1.7E +/- 308 (15 digits) */
typedef ppReal *PppReal; /* pointer to ppReal */

#define ULIntToReal(x)  ((ppReal)x)                 /* Type conversion from integer to real */
#define ULRealRoundToInt(x) ((ppInt32)(x+ 0.5f))    /* Type conversion from real to integer with rounding */
#define ULRealTruncToInt(x) ((ppInt32)x)            /* Type conversion from real to integer without rounding */
#define ULFloatToReal(x) ((ppReal)x)                /* Type conversion from float to real */
#define ULRealToFloat(x) ((double)x)                /* Type conversion from real to float */

#define ppMAXInt8           ((ppInt8)0x7F)          /* Maximum of ppInt8 range is 127 */
#define ppMINInt8           ((ppInt8)0x80)          /* Minimum of ppInt8 range is -128 */
#define ppMAXInt16          ((ppInt16)0x7FFF)       /* Maximum of ppInt8 range is 32,767 */
#define ppMINInt16          ((ppInt16)0x8000)       /* Minimum of ppInt8 range is 32,768 */
#define ppMAXInt32          ((ppInt32)0x7FFFFFFF)   /* Maximum of ppInt8 range is 2,147,483,647 */
#define ppMINInt32          ((ppInt32)0x80000000)   /* Minimum of ppInt8 range is 2,147,483,648 */
#define ppMAXUns8           ((ppUns8)0xFF)          /* Maximum of ppInt8 range is 255 */
#define ppMINUns8           ((ppUns8)0x00)          /* Minimum of ppInt8 range is 0 */
#define ppMAXUns16          ((ppUns16)0xFFFF)       /* Maximum of ppInt8 range is 65,535 */
#define ppMINUns16          ((ppUns16)0x0000)       /* Minimum of ppInt8 range is 0 */
#define ppMAXUns32          ((ppUns32)0xFFFFFFFF)   /* Maximum of ppInt8 range is 4,294,967,295 */
#define ppMINUns32          ((ppUns32)0x00000000)   /* Minimum of ppInt8 range is 0 */

typedef ppUns16 ppBool;     /* Boolean Type : true != 0, false == 0 */

#if !HAS_BOOL_SUPPORT
#ifndef true
#define true    1 /* default value of true is 1 */
#endif
#ifndef false
#define false   0 /* default value of false is 0 */
#endif
#endif

#ifndef NULL
#ifdef __cplusplus
#define NULL    0 /* default value of NULL is 0 ( zero ) */
#else
#define NULL   ((void *)0)  /* default value of NULL is pointer to 0 ( zero ) */
#endif
#endif

/* Primary Data Object Type */
typedef struct _t_PDFCosHandle{
#if 0
    struct _t_CosObj *a;    /* pointer to Data Object */
#else
    void *a;
#endif
    ppInt32 b;              /* Cos Object Identifier  */

} 
PDFCosHandle,               /* Cos Object Handle */
PDFActionHandle,            /* Action Handle */
PDFAnnotationHandle,        /* Annotation Handle */
PDFOutlineHandle,           /* Outline Handle */
PDFDestinationHandle,       /* Destination Handle */
PDFThreadHandle,            /* Thread Handle */
PDFBeadHandle,              /* Bead Handle */
PDFSoundHandle;             /* Sound Handle */

typedef void *PHandle;      /* Pointer Type */
#if 0
typedef struct _t_PDFStrm *PDFStreamHandle;     /* Stream Handle */
typedef struct _t_PDFDoc *PDFDocHandle;         /* PDF Document Handle */
typedef struct _t_PDFLib *PDFLibHandle;         /* PDF Library Handle */
typedef struct _t_PDFFile *PDFFileHandle;       /* PDF File Handle */
typedef struct _t_PDFCrypto *PDFCryptoHandle;   /* Encryption Handle */
typedef struct _t_PBX *PBXHandle;               /* Paint Box Handle */
typedef ppUns32 ppAtom;     /* Names Space Key */
#else
typedef void *PDFStreamHandle;     /* Stream Handle */
typedef void *PDFDocHandle;         /* PDF Document Handle */
typedef void *PDFLibHandle;         /* PDF Library Handle */
typedef void *PDFFileHandle;       /* PDF File Handle */
typedef void *PDFCryptoHandle;   /* Encryption Handle */
typedef void *PBXHandle;               /* Paint Box Handle */
typedef ppUns32 ppAtom;     /* Names Space Key */
#endif

#define ppAtomNull ppMAXUns32   /* Bad Atom Value - No name */

/* Rectangle Type */
typedef struct  {
    ppReal  xl;     /* Left border coordinate */
    ppReal  yl;     /* Top border coordinate */
    ppReal  xr;     /* Right border coordinate */
    ppReal  yr;     /* Bottom border coordinate */
} TPDFRect;         /* Rectangle Type */

/* Point Type */
typedef struct  {
    ppReal  x;      /* horizontal axis coordinate */
    ppReal  y;      /* vertical axis coordinate */
} TPDFRealPoint;    /* Point Type */

/* RGB Color Type */
typedef struct  {
    ppReal  R;      /* Red component of Color */
    ppReal  G;      /* Green component of Color */
    ppReal  B;      /* Blue component of Color */
} TPDFRGBColor;     /* RGB Color Type */

/* CMYK Color Type */
typedef struct  {
    ppReal  C;      /* Cyan component of Color */
    ppReal  M;      /* Magenta component of Color */
    ppReal  Y;      /* Yellow component of Color */
    ppReal  K;      /* Black component of Color */
}TPDFCMYKColor;     /* CMYK Color Type */

/* Color Device Type */
typedef enum  {
    pdfDeviceGray,  /* Gray scale Color Device */
    pdfDeviceRGB,   /* RGB Color Device */
    pdfDeviceCMYK   /* CMYK Color Device */
} TColorSpace;      /* Color Device Type */

/*  PDF String Type  */
typedef struct  {
    char    *String;    /* Pointer to first character of String */
    ppInt32 Length;     /* Length of String Data */
} PDFString;            /* PDF String Type */

/* PDF Color Type */
typedef struct  {
    TColorSpace Device;         /* Color Device */
    union {                     /* Color Value */
        ppReal          Gray;   /* Gray scale value */
        TPDFRGBColor    RGB;    /* RGB color value */
        TPDFCMYKColor   CMYK;   /* CMYK color value */
    } Color;                    /* Color Value */
} TPDFColor;                    /* PDF Color Type */
typedef TPDFColor *PPDFColor;   /* Pointer to PDF Color Type */

#endif /* #ifndef VSTypes_H */
