/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSThreadA.h
*********************************************************************/

#ifndef VSThreadA_H
#define VSThreadA_H /* PDF Document's Threads Module */

#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSTypes.h"

#ifdef __cplusplus
extern "C"{
#endif

    /* Description
       Gets Threads Count in PDF Document.
       Parameters
       Doc :  [in] PDF Document Handle.
       Returns
       Number of Threads Items.            */
    ppInt32 PDFDocGetThreadCount( PDFDocHandle Doc );
    /* Description
       Gets Thread of PDF Document according to Index.
       Parameters
       Doc :    [in] PDF Document Handle.
       Index :  [in] Index of Thread in PDF Document.
       Returns
       Thread Handle.
       See Also
       PDFThreadHandle                                 */
    PDFThreadHandle PDFDocGetThread( PDFDocHandle Doc, ppInt32 Index );
    /* Description
       Creates New Thread in PDF Document.
       Parameters
       Doc :    [in] PDF Document Handle.
       Index :  [in] Index of Thread in PDF Document.
       Returns
       New Thread Handle in PDF Document.
       See Also
       PDFThreadDelete                                */
    PDFThreadHandle PDFThreadNew( PDFDocHandle Doc );
    /* Description
       Deletes Thread from PDF Document.
       Parameters
       Doc :     [in] PDF Document Handle.
       Thread :  [in] Thread Handle in PDF Document for Deleting.
       Returns
       None.
       See Also
       PDFThreadNew                                               */
    void PDFThreadDelete( PDFDocHandle Doc, PDFThreadHandle Thread );
    /* Description
       Gets Bead Handle on First Bead in Thread.
       Parameters
       Doc :     [in] PDF Document Handle.
       Thread :  [in] Thread Handle in PDF Document for founding the
                 first bead.
       Returns
       Bead Handle on the First Bead in Thread.
       See Also
       PDFThreadSetFirstBead                                         */
    PDFBeadHandle PDFThreadGetFirstBead( PDFDocHandle Doc, PDFThreadHandle Thread );
    /* Description
       Inserts New Bead after current Bead.
       Parameters
       Doc :      [in] PDF Document Handle.
       Bead :     [in] Current Bead Handle of Thread in PDF Document.
       NewBead :  [in] New Bead Handle for inserting in Thread.
       Returns
       None.                                                          */
    void PDFBeadInsert( PDFDocHandle Doc, PDFBeadHandle Bead, PDFBeadHandle NewBead );
    /* Description
       Initializes Bead's Thread by creation the First Bead.
       Parameters
       Doc :     [in] PDF Document Handle.
       Thread :  [in] Thread Handle in PDF Document.
       Bead :    [in] Bead Handle of New Thread in PDF Document.
       Returns
       None.
       See Also
       PDFThreadGetFirstBead                                     */
    void PDFThreadSetFirstBead( PDFDocHandle Doc, PDFThreadHandle Thread, PDFBeadHandle Bead );
    /* Description
       Gets information from Thread according to Name.
       Parameters
       Doc :        [in] PDF Document Handle.
       Thread :     [in] Thread Handle in PDF Document.
       InfoKey :    [in] Name of requesting information.
       Value :      [out] Text value of requesting information.
       MaxLength :  [in] Maximum length of value in bytes.
       Returns
       Length of value in bytes ( not longer than MaxLength ).
       See Also
       PDFThreadSetInfo                                         */
    ppInt32 PDFThreadGetInfo( PDFDocHandle Doc, PDFThreadHandle Thread, char *InfoKey,
                              char *Value, ppInt32 MaxLength );
    /* Description
       Sets information to Thread according to property name.
       Parameters
       Doc :      [in] PDF Document Handle.
       Thread :   [in] Thread Handle in PDF Document.
       InfoKey :  [in] Name of setting information.
       Value :    [in] Text string information value.
       Length :   [in] Length of value in bytes.
       Returns
       None.
       See Also
       PDFThreadGetInfo                                       */
    void PDFThreadSetInfo( PDFDocHandle Doc, PDFThreadHandle Thread, char *InfoKey,
                           char *Value, ppInt32 Length );
    /* Description
       Creates new bead on the page.
       Parameters
       Doc :   [in] PDF Document Handle.
       Page :  [in] Index of Page on which this bead will be
               appeared.
       Rect :  [in] A rectangle specifying the location of this bead
               on the page.
       Returns
       Bead Handle.
       See Also
       PDFBeadDelete                                                 */
    PDFBeadHandle PDFBeadNew( PDFDocHandle Doc, ppInt32 Page, TPDFRect Rect );
    /* Description
       Deletes bead.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Handle of deleting bead.
       Returns
       None.
       See Also
       PDFBeadNew                            */
    void PDFBeadDelete( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Navigates to the next bead item.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead whence we go onward.
       Returns
       Handle of next bead.
       See Also
       PDFBeadGetPrev                         */
    PDFBeadHandle PDFBeadGetNext( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Navigates to previous bead item.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead whence we go back.
       Returns
       Handle of previous bead.
       See Also
       PDFBeadGetNext                       */
    PDFBeadHandle PDFBeadGetPrev( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Gets Index of Bead in Owner's Thread.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead for which index we are looking for.
       Returns
       Index of Bead in Owner's Thread.                      */
    ppInt32 PDFBeadGetIndex( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Gets a rectangle specifying the location of this bead on the
       page.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead Handle.
       Rect :  [out] Rectangle specifying the location of this bead
               on the page.
       Returns
       None.
       See Also
       PDFBeadSetRect                                               */
    void PDFBeadGetRect( PDFDocHandle Doc, PDFBeadHandle Bead, TPDFRect *Rect );
    /* Description
       Gets an Index of Page on which this bead appears.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead Handle.
       Returns
       Index of Page on which this bead appears.         */
    ppInt32 PDFBeadGetPage( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Gets a Handle of Bead's Thread.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead Handle.
       Returns
       Handle of Bead's Thread.          */
    PDFThreadHandle PDFBeadGetThread( PDFDocHandle Doc, PDFBeadHandle Bead );
    /* Description
       Sets a rectangle specifying the location of this bead on the
       page.
       Parameters
       Doc :   [in] PDF Document Handle.
       Bead :  [in] Bead Handle.
       Rect :  [out] Rectangle specifying the location of this bead
               on the page.
       Returns
       None.
       See Also
       PDFBeadGetRect                                               */
    void PDFBeadSetRect( PDFDocHandle Doc, PDFBeadHandle Bead, TPDFRect Rect );

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSThreadA_H */
