/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSPagesA.h
*********************************************************************/

#ifndef VSPAGESAH
#define VSPAGESAH /* Pages API and Document Connection Module */

#include "VSTypes.h"

/*  Document Connection Structure, Page Objects Container */
typedef struct _t_TPDFDocumentConnection {
    PDFDocHandle    OldDocument;    /* Source Document where pages are taken from */
    PDFDocHandle    NewDocument;    /* Destination Document where to put pages */
    ppUns32         Size;           /* Size of Queue of Page Numbers */
    PppUns32        Pages;          /* Queue Page Numbers, with repeated
                                       numbers possibility */
} TPDFDocumentConnection, *PPDFDocumentConnection;

#ifdef __cplusplus
extern "C" {
#endif

    /************************************************************************
        Description :
            Create source and destination documents connection and initialize
            page numbers array and its size.
        Parameters :
            OldDocument     - [in] Source Document where from take pages.
            NewDocument     - [in] Destination Document where to put pages.                                                  
            DocumentConnection - [out] pointer to PPDFDocumentConnection
                            structure.
        Returns :
            None.
        See also :
            TPDFDocumentConnection
    ************************************************************************/
    void PDFCreateDocumentConnection( PDFDocHandle OldDocument,
                                      PDFDocHandle NewDocument,
                                      PPDFDocumentConnection DocumentConnection );
    /************************************************************************
        Description :
            Add page index ( number as from 0 ) to page numbers array in
            DocumentConnection structure.
        Parameters:
            DocumentConnection  - [out] pointer to PPDFDocumentConnection
                                structure                       
            PageIndex           - [in]  integer index of page from Source
                                Document, as from 0                                    
        Returns:
            None.
        See Also:
            TPDFDocumentConnection
    ************************************************************************/
    void PDFSelectPageFromSourceDocument( PPDFDocumentConnection DocumentConnection,
                                          ppUns32 PageIndex );
    /************************************************************************
        Description :
            Copy Pages from source to destination document and reset page
            numbers array, but document connection remains linked with
            documents.
        Parameters :
            DocumentConnection  - [out] pointer to PPDFDocumentConnection
                                structure.
        Returns :
            None.
        See also :
            TPDFDocumentConnection
    ************************************************************************/
    void PDFCopyPagesToDestinationDocument( PPDFDocumentConnection DocumentConnection );
/************************************************************************
    Description :
        Free page numbers array and remove document connection from
        DocumentConnection structure.
    Parameters :
        DocumentConnection  - [out] pointer to PPDFDocumentConnection
                            structure.
    Returns :
        None.
    See also :
        TPDFDocumentConnection
************************************************************************/
    void PDFFreeDocumentConnection( PPDFDocumentConnection DocumentConnection );

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSPAGESAH */
