/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSFontA.h
*********************************************************************/

#ifndef VSFontA_H
#define VSFontA_H
#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSTypes.h"

#ifdef __cplusplus
extern "C"{
#endif

    /* Standard 14 fonts enum*/
    typedef enum _t_TPDFStdandardFont {
        stdfHelvetica,                /* Helvetica font */
        stdfHelveticaBold,            /* Helvetica Bold font */
        stdfHelveticaOblique,         /* Helvetica Oblique font */
        stdfHelveticaBoldOblique,     /* Helvetica Bold Obliquefont */
        stdfTimesRoman,               /* Times Roman font */
        stdfTimesBold,                /* Times Bold font */
        stdfTimesItalic,              /* Times Italic font */
        stdfTimesBoldItalic,          /* Times Bold Italicfont */
        stdfCourier,                  /* Courier font */
        stdfCourierBold,              /* Courier Bold font */
        stdfCourierOblique,           /* Courier Oblique font */
        stdfCourierBoldOblique,       /* Courier BoldOblique font */
        stdfSymbol,                   /* Symbol font */
        stdfZapfDingbats              /* Zapf Dingbats font */
    } TPDFStdandardFont;

    /* Font encoding*/
    typedef enum _t_TPDFEncodingType {
        etPDFDocEncoding,            /* PDF Document encoding */
        etWinAnsiEncoding,           /* ANSI windows encoding */
        etMacRomanEncoding,          /* Apple encoding */
        etStandardEncoding           /* Standard encoding */
    } TPDFEncodingType;

	/* Description
	   Append one of 14 standard fonts to document.
	   Parameters
	   Doc :     [ in ] Current PDF document.
	   font :    [ in ] One of standart font\: stdfHelvetica,
	             stdfHelveticaBold, stdfHelveticaOblique,
	             stdfHelveticaBoldOblique, stdfTimesRoman, stdfTimesBold,
	             stdfTimesItalic, stdfTimesBoldItalic, stdfCourier,
	             stdfCourierBold, stdfCourierOblique,
	             stdfCourierBoldOblique, stdfSymbol, stdfZapfDingbats<p/>
	   encode :  [ in ] Font encoding type.
	   Returns
	   Font index in PDF document.                                        */

    ppInt32 PDFFontAppend14Standard(PDFDocHandle Doc, TPDFStdandardFont font, TPDFEncodingType encode);
#ifdef WINDOWS_PLATFORM
	/* Description
	   Append true type font to document by name.
	   Parameters
	   Doc :       [ in ] Current PDF document.
	   fontname :  [ in ] Font name.
	   Bold :      [ in ] Is bold style.
	   Italic :    [ in ] Is italic style.
	   Returns
	   Font index in PDF document.                */
    ppInt32 PDFFontAppendTrueType(PDFDocHandle Doc, char *fontname, ppBool Bold, ppBool Italic);
#endif
	/* Description
	   Append true type font to document from file.
	   Parameters
	   Doc :       [ in ] Current PDF document.
	   fontname :  [ in ] Font filename.
	   Returns
	   Font index in PDF document.                  */
    ppInt32 PDFFontAppendTrueTypeFromFile(PDFDocHandle Doc, char *fontfilename);

	/* Description
	   Append true type font to document from stream.
	   Parameters
	   Doc :   [ in ] Current PDF document.
	   Strm :  [ in ] Font stream.
	   Returns
	   Font index in PDF document.                    */
    ppInt32 PDFFontAppendTrueTypeFromStream(PDFDocHandle Doc, PDFStreamHandle Strm);

	/* Description
	   Append Type1 font to document from file.
	   Parameters
	   Doc :       [ in ] Current PDF document.
	   fontname :  [ in ] Font filename.
	   Returns
	   Font index in PDF document.              */
    ppInt32 PDFFontAppendType1FromFile(PDFDocHandle Doc, char * fontfilename);

	/* Description
	   Append Type1 font to document from stream.
	   Parameters
	   Doc :   [ in ] Current PDF document.
	   Strm :  [ in ] Font stream.
	   Returns
	   Font index in PDF document.                */
    ppInt32 PDFFontAppendType1FromStream(PDFDocHandle Doc, PDFStreamHandle Strm);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSFontA_H */
