/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSExcept.h
*********************************************************************/

#ifndef VSExcept_H
#define VSExcept_H /*  */
#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#ifdef __cplusplus
extern "C"{
#endif
#include <setjmp.h>
#include "VSTypes.h"

#define PDFsetjmp setjmp      /* Sets jump */
#define PDFlongjmp longjmp    /* Sets long jump in VERSYPDF */ 
#define PDFjmp_buf jmp_buf    /* Sets jump buffer */ 


	/********************************************************************
    Description:
        Push exception the buffer.
    Parameters:
           Lib - [ in ] Current VERSYPDF library.
    Returns:
        PDF jump buffer.
    *********************************************************************/
    PDFjmp_buf *PPPushExceptionBuffer(PDFLibHandle Lib);


	/********************************************************************
    Description:
        Pop exception code from buffer.
    Parameters:
           Lib - [ in ] Current VERSYPDF library.
    Returns:
        None.
    *********************************************************************/
    void PPPopExceptionBuffer(PDFLibHandle Lib);

	/********************************************************************
    Description:
        Call the exception from error code.
    Parameters:
           Lib - [ in ] Current VERSYPDF library.
		   err - [ in ] Error code.
    Returns:
        None.
    *********************************************************************/
	void PPCallException(PDFLibHandle Lib, ppInt32 err);
    
	/********************************************************************
    Description:
        Returns code of last error.
    Parameters:
           Lib - [ in ] Current VERSYPDF library.
    Returns:
        Code of last error.
    *********************************************************************/
	ppInt32 PPGetLastError(PDFLibHandle Lib);

#define PDFTRY(lib) { if (!PDFsetjmp(*PPPushExceptionBuffer(lib))){ /* Begin of try expression */
#define PDFBUFRELEASE(lib) PPPopExceptionBuffer(lib)          /* Pop buffer exception into stack */
#define PDFEXCEPT(lib) PDFBUFRELEASE(lib);} else {            /* Release buffer exceptions */
#define PDFTRYEND(lib) }}                                     /* End of try expression */
#define PDFRETURN(lib,x) {PDFBUFRELEASE(lib);return x;}       /* Return value */
#define PDFRETURNVOID(lib) {PDFBUFRELEASE(lib);return;}       /* Return nothing */
#define PDFRAISE(lib,err) PPCallException(lib,(ppUns32)err);  /* Raise PDF exceptions */

#define PDFLASTERROR(lib) PPGetLastError(lib)                 /* Return last PDF error */
#define PDFRERAISE(lib) PDFRAISE(lib,PDFLASTERROR(lib))       /* Reraise PDF exceptions */
#define PDFFINALLY(lib) PDFRAISE(lib,0);}else {               /* Part of PDFTRY...PDFFINALLY...PDFFINALLYEND expression */     
#define PDFFINALLYEND(lib) if (PDFLASTERROR(lib)) PDFRERAISE(lib);}}  /* End of PDFTRY...PDFFINALLY...PDFFINALLYEND */     

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSExcept_H */
