/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <math.h>

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSTypes.h"        /* Use Versy Type Definitions */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSFontA.h"        /* Use Common Versy PDF Routines */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSCanvasA.h"  /* Use Acro Objects API */
#include "VSGStateA.h"  /* Use Acro Objects API */

#define PageWidth   595    /* Page width definition */
#define PageHeight  842    /* Page height definition */
/* Determination of graphics objects coordinates, normalized to 100 */
#define cx(x) (PageWidth*(x)/100)
#define cy(y) (PageHeight*(y)/100)

char *LineDashTypes[ 9 ] = { "[2 2] 0", "[4 4] 0", "[8 8] 0", "[8 8] 4", "[8 8] 8", "[12 4] 0",
                             "[16 3 4 3] 0", "[13 3 2 3 2 3] 0", "[ ] 0" };

int main()
{
    PDFLibHandle	PDFLibrary;     /* PDF Library Handle */
	PDFDocHandle	Doc = NULL;     /* PDF Document Handle */
    PBXHandle       PaintBox;       /* Handle of Paint Box for Content Drawing */

    ppInt32         ErrorCode;      /* Check Error Code */
    ppInt32         PageIndex;      /* Index of Page in Document */
    ppInt32         FontIndex;      /* Index of Font in Document */
    ppInt32         i;
    ppReal          Radius;

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */

        Doc = PDFDocCreate( PDFLibrary ); /* Create new destination PDF file */
        PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

        /************************************************************************/
        /* Text Fonts Example                                                   */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Font color is black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title of current page */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Fonts" ) / 2, cy(4), 0, "Fonts" );

        /* Set active font as Helvetica, size is 1% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(1), true, false );
        /* Draw text label 'Standard fonts' and underline it */
        PBXTextOut( PaintBox, cx(10), cy(8), 0, "Standard fonts" );
        /* Set active font as Helvetica, size is 3% of page height */
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Helvetica' */
        PBXTextOut( PaintBox, cx(10), cy(10), 0 , "Helvetica" );

        /* Set active font as Helvetica Bold, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelveticaBold, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Helvetica Bold' */
        PBXTextOut( PaintBox, cx(10), cy(15), 0 , "Helvetica Bold" );

        /* Set active font as Helvetica Oblique, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelveticaOblique, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Helvetica Oblique' */
        PBXTextOut( PaintBox, cx(10), cy(20), 0 , "Helvetica Oblique" );

        /* Set active font as Helvetica Bold Oblique, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelveticaBoldOblique, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Helvetica Bold Oblique' */
        PBXTextOut( PaintBox, cx(10), cy(25), 0 , "Helvetica Bold Oblique" );

        /* Set active font as Times New Roman, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfTimesRoman, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Times New Roman' */
        PBXTextOut( PaintBox, cx(10), cy(30), 0 , "Times New Roman" );

        /* Set active font as Times New Roman Bold, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfTimesBold, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Times New Roman Bold' */
        PBXTextOut( PaintBox, cx(10), cy(35), 0 , "Times New Roman Bold" );

        /* Set active font as Times New Roman Italic, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfTimesItalic, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Times New Roman Italic' */
        PBXTextOut( PaintBox, cx(10), cy(40), 0 , "Times New Roman Italic" );

        /* Set active font as Times New Roman Bold Italic, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfTimesBoldItalic, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Times New Roman Bold Italic' */
        PBXTextOut( PaintBox, cx(10), cy(45), 0 , "Times New Roman Bold Italic" );

        /* Set active font as Courier, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfCourier, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Courier' */
        PBXTextOut( PaintBox, cx(10), cy(50), 0 , "Courier" );

        /* Set active font as Courier Bold, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfCourierBold, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Courier Bold' */
        PBXTextOut( PaintBox, cx(10), cy(55), 0 , "Courier Bold" );

        /* Set active font as Courier Oblique, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfCourierOblique, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Courier Oblique' */
        PBXTextOut( PaintBox, cx(10), cy(60), 0 , "Courier Oblique" );

        /* Set active font as Courier Bold Oblique, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfCourierBoldOblique, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Courier Bold Oblique' */
        PBXTextOut( PaintBox, cx(10), cy(65), 0 , "Courier Bold Oblique" );

        /* Set active font as Symbol, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfSymbol, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label with Symbol's characters */
        PBXTextOut( PaintBox, cx(10), cy(70), 0 , "abcdefghijklmnopqrstuvwxyz" );
        /* Set active font as Helvetica, size is 1% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(1), false, false );
        /* Draw text label '(Symbol Font)' */
        PBXTextOut( PaintBox, cx(90) - PBXGetTextWidth( PaintBox, "(Symbol Font)" ),
            cy(70), 0, "(Symbol Font)" );

        /* Set active font as Zapf Dingbats, size is 3% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfZapfDingbats, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label with Zapf Dingbats characters */
        PBXTextOut( PaintBox, cx(10), cy(75), 0 , "1234567890-=[];'./,abcdef" );
        /* Set active font as Helvetica, size is 1% of page height */
        FontIndex = PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding );
        PBXSetActiveFont( PaintBox, FontIndex, cy(1), false, false );
        /* Draw text label '(Zapf Dingbats Font)' */
        PBXTextOut( PaintBox, cx(90) - PBXGetTextWidth( PaintBox, "(Zapf Dingbats Font)" ),
            cy(75), 0, "(Zapf Dingbats Font)" );

        /* Set active font as Helvetica, size is 1% of page height, and underline */
        PBXSetActiveFont( PaintBox, FontIndex, cy(1), true, false );
        /* Draw text label 'Non-standard fonts' */
        PBXTextOut( PaintBox, cx(10), cy(82), 0, "Non-standard fonts" );

        /* If set Windows platform then... */
#ifdef WINDOWS_PLATFORM
        /* ... append Windows TrueType Font which named as 'Arial' */
        FontIndex = PDFFontAppendTrueType( Doc, "Arial", false, false );
        /* ... else ... ( if set Unix platform ) */
#else
        /* ... load Arial TrueType Font from file 'arial.ttf' */
        FontIndex = PDFFontAppendTrueTypeFromFile( Doc, "../Data/in/arial.ttf" );  /* Load Arial font */
#endif
        /* Set active font as Arial, size is 3% of page height */
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );
        /* Draw text label 'Arial TrueType Font' */
        PBXTextOut( PaintBox, cx(10), cy(85), 0 , "Arial TrueType Font" );

        /* Load ArialMT Type1 Font from file 'arialMT.pfb' */
        FontIndex = PDFFontAppendType1FromFile( Doc, "../Data/in/a_font.pfb");    /* Load ArialMT Type1 font */
        /* Set active font as ArialMT, size is 3% of page height */
        PBXSetActiveFont( PaintBox, FontIndex, cy(3), false, false );  /* Set ArialMT as active font */      
        /* Draw text label 'ArialMT Type1 Font' */
        PBXTextOut( PaintBox, cx(10), cy(90), 0 , "ArialMT Type1 Font" );/* Draw text by current font */

        /* Save non-packed Page Content and Free PaintBox */
        PBXClose( PaintBox, false );

        /************************************************************************/
        /* Text Spacing                                                         */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Font color is black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Character Spacing' */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Character Spacing" ) / 2,
            cy(4), 0, "Character Spacing" );

        /* Draw blank table for text examples, size is 4 x 2 */
        /* Set line width as 0.5 point */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Set stroke color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Set background color as light green */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.95, 1.0, 0.95 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(10), cy(10), cx(50), cy(16) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(16), cx(90), cy(22) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(22), cx(50), cy(28) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(28), cx(90), cy(34) );
        PBXFillAndStroke( PaintBox );

        /* Set background color as light yellow */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 1.0, 0.95 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(50), cy(10), cx(90), cy(16) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(16), cx(50), cy(22) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(22), cx(90), cy(28) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(28), cx(50), cy(34) );
        PBXFillAndStroke( PaintBox );

        /* Set active font as Helvetica, size is 2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(2), false, false );
        /* Set fill color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw 1st column's text labels */
        PBXTextOut( PaintBox, cx(15), cy(12), 0, "= -0.1" );
        PBXTextOut( PaintBox, cx(15), cy(18), 0, "=  0.0 (Default)" ); 
        PBXTextOut( PaintBox, cx(15), cy(24), 0, "=  0.1" );
        PBXTextOut( PaintBox, cx(15), cy(30), 0, "=  0.5" );

        /* Set Character's Spacing value as -0.1 */
        PBXSetCharacterSpacing( PaintBox, -0.1 );
        /* Draw text label as spacing example */
        PBXTextOut( PaintBox, cx(55), cy(12), 0, "Test String" );
        /* Set Character's Spacing value as 0 ( default ) */
        PBXSetCharacterSpacing( PaintBox, 0 );
        /* Draw text label as spacing example */
        PBXTextOut( PaintBox, cx(55), cy(18), 0, "Test String" ); 
        /* Set Character's Spacing value as 0.1 */
        PBXSetCharacterSpacing( PaintBox, 0.1 );
        /* Draw text label as spacing example */
        PBXTextOut( PaintBox, cx(55), cy(24), 0, "Test String" );
        /* Set Character's Spacing value as 0.5 */
        PBXSetCharacterSpacing( PaintBox, 0.5 );
        /* Draw text label as spacing example */
        PBXTextOut( PaintBox, cx(55), cy(30), 0, "Test String" );
        /* Set Default Character's Spacing */
        PBXSetCharacterSpacing( PaintBox, 0 );

        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Draw title 'Word Spacing' in 36% of page height from top */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Word Spacing" ) / 2,
            cy(36), 0, "Word Spacing" );

        /* Draw blank table for text examples, size is 4 x 2 */
        /* Set line width as 0.5 point */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Set stroke color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Set background color as light blue */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.95, 0.95, 1.0 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(10), cy(40), cx(50), cy(46) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(46), cx(90), cy(52) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(52), cx(50), cy(58) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(58), cx(90), cy(64) );
        PBXFillAndStroke( PaintBox );

        /* Set background color as light red */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.95, 0.95 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(50), cy(40), cx(90), cy(46) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(46), cx(50), cy(52) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(52), cx(90), cy(58) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(58), cx(50), cy(64) );
        PBXFillAndStroke( PaintBox );

        /* Set active font as Helvetica, size is 2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(2), false, false );
        /* Set fill color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw 1st column's text labels */
        PBXTextOut( PaintBox, cx(15), cy(42), 0, "= -0.5" );
        PBXTextOut( PaintBox, cx(15), cy(48), 0, "=  0.0 (Default)" ); 
        PBXTextOut( PaintBox, cx(15), cy(54), 0, "=  0.5" );
        PBXTextOut( PaintBox, cx(15), cy(60), 0, "=  1.5" );

        /* Set Word's Spacing value as -0.5 */
        PBXSetWordSpacing( PaintBox, -0.5 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(55), cy(42), 0, "Test String" );
        /* Set Word's Spacing value as 0 ( default ) */
        PBXSetWordSpacing( PaintBox, 0 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(55), cy(48), 0, "Test String" ); 
        /* Set Word's Spacing value as 0.5 */
        PBXSetWordSpacing( PaintBox, 0.5 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(55), cy(54), 0, "Test String" );
        /* Set Word's Spacing value as 1.5 */
        PBXSetWordSpacing( PaintBox, 1.5 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(55), cy(60), 0, "Test String" );
        /* Set Default Word's Spacing */
        PBXSetWordSpacing( PaintBox, 0 );

        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Draw title 'Text Scaling' in 66% of page height from top */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Text Scaling" ) / 2,
            cy(66), 0, "Text Scaling" ); /* Draw text title on top-center of page */

        /* Draw blank table for text examples, size is 4 x 2 */
        /* Set line width as 0.5 point */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Set stroke color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Set background color as light violet */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.95, 0.9, 1.0 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(10), cy(70), cx(50), cy(76) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(76), cx(90), cy(82) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(82), cx(50), cy(88) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(88), cx(90), cy(94) );
        PBXFillAndStroke( PaintBox );

        /* Set background color as light orange */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.95, 0.9 ) );
        /* Draw 4 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(50), cy(70), cx(90), cy(76) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(76), cx(50), cy(82) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(82), cx(90), cy(88) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(88), cx(50), cy(94) );
        PBXFillAndStroke( PaintBox );

        /* Set active font as Helvetica, size is 2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(2), false, false );
        /* Set fill color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw 1st column's text labels */
        PBXTextOut( PaintBox, cx(15), cy(72), 0, "=   25" );
        PBXTextOut( PaintBox, cx(15), cy(78), 0, "=   50" ); 
        PBXTextOut( PaintBox, cx(15), cy(84), 0, "=  100 (Default)" );
        PBXTextOut( PaintBox, cx(15), cy(90), 0, "=  250" );

        /* Set Horizontal Scaling value as 25% */
        PBXSetHorizontalScaling( PaintBox, 25 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(55), cy(72), 0, "Test String" );
        /* Set Horizontal Scaling value as 50% */
        PBXSetHorizontalScaling( PaintBox, 50 );
        PBXTextOut( PaintBox, cx(55), cy(78), 0, "Test String" ); 
        /* Set Horizontal Scaling value as 100% ( default ) */
        PBXSetHorizontalScaling( PaintBox, 100 );
        PBXTextOut( PaintBox, cx(55), cy(84), 0, "Test String" );
        /* Set Horizontal Scaling value as 250% */
        PBXSetHorizontalScaling( PaintBox, 250 );
        PBXTextOut( PaintBox, cx(55), cy(90), 0, "Test String" );
        /* Set Default Horizontal Scaling */
        PBXSetHorizontalScaling( PaintBox, 100 );

        /* Save non-packed Page Content and Free PaintBox */
        PBXClose( PaintBox, false );

        /************************************************************************/
        /* Text Rendering Mode and Rotation Examples                            */
        /************************************************************************/
        /* Create new page in PDF document */
        PageIndex = PDFDocAppendPage( Doc, PageWidth, PageHeight );
        /* Create Page Content PaintBox with default resolution ( 72 dpi )*/
        PaintBox = PDFPageCreatePaintBox( Doc, PageIndex, 72 );

        /* Set active as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Font color is black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Text rendering modes' */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Text rendering modes" ) / 2,
            cy(4), 0, "Text rendering modes" );

        /* Draw blank table for text examples, size is 4 x 2 */
        /* Set line width as 0.5 point */
        PBXSetLineWidth( PaintBox, 0.5 );
        /* Set stroke color as black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Set background color as white */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 1.0, 1.0 ) );
        /* Draw 8 rectangles and colorize them */
        PBXRectangle( PaintBox, cx(10), cy(10), cx(50), cy(20) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(10), cx(90), cy(20) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(20), cx(50), cy(30) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(20), cx(90), cy(30) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(30), cx(50), cy(40) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(30), cx(90), cy(40) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(10), cy(40), cx(50), cy(50) );
        PBXFillAndStroke( PaintBox );
        PBXRectangle( PaintBox, cx(50), cy(40), cx(90), cy(50) );
        PBXFillAndStroke( PaintBox );

        /* Set active font as Helvetica, size is 2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(2), false, false );
        /* Set fill color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw 1st column's text labels */
        PBXTextOut( PaintBox, cx(15), cy(14), 0, "= 0 ( fill, default mode )" );
        PBXTextOut( PaintBox, cx(15), cy(24), 0, "= 1 ( stroke )" );
        PBXTextOut( PaintBox, cx(15), cy(34), 0, "= 2 ( fill and stroke )" );
        PBXTextOut( PaintBox, cx(15), cy(44), 0, "= 3 ( invisible )" );

        /* Set active font as Helvetica, size is 5% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelveticaBold, etStandardEncoding ),
            cy(5), false, false );
        /* Set stroke color as blue */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 1.0 ) );
        /* Set fill color as red */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.0, 0.0 ) );
        /* Set stroke line width as 2 points */
        PBXSetLineWidth( PaintBox, 2 );

        /* Set Text Rendering Mode as 0 ( default ) */
        PBXSetTextRenderingMode( PaintBox, 0 );
        /* Draw text label as spacing example in second column */
        PBXTextOut( PaintBox, cx(52), cy(13), 0, "Test String" );
        PBXSetTextRenderingMode( PaintBox, 1 );
        PBXTextOut( PaintBox, cx(52), cy(23), 0, "Test String" );
        PBXSetTextRenderingMode( PaintBox, 2 );
        PBXTextOut( PaintBox, cx(52), cy(33), 0, "Test String" );
        PBXSetTextRenderingMode( PaintBox, 3 );
        PBXTextOut( PaintBox, cx(52), cy(43), 0, "Test String" );
        PBXSetTextRenderingMode( PaintBox, 0 );

        /* Set active font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Set Fill color as black */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Draw title 'Text Rotation' in 53% of page height from top */
        PBXTextOut( PaintBox, cx(50) - PBXGetTextWidth( PaintBox, "Text Rotation" ) / 2,
            cy(53), 0, "Text Rotation" );

        /* Set active font as Helvetica, size is 2% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(2), false, false );
        /* Set Radius of example's circle as Label Width plus 1% of page width*/
        Radius = PBXGetTextWidth( PaintBox, "Test String" ) + cx(1);
        /* Draw Text Rotation on first third of circle in red color */
        for ( i = 0; i < 12; i++ ) {
            /* Set Fill color as red tone */
            PBXSetFillColor( PaintBox, ULRGBToColor( cos((ppReal)(i - 6)/3.83), 0.0, 0.0 ) );
            /* Draw text label 'Test String' with rotation on angle from 0 to 120 degrees */
            PBXTextOut( PaintBox, cx(50) + Radius * cos( (ppReal)i * 0.1745 ),
                cy(77) - Radius * sin ( (ppReal)i * 0.1745 ), (ppReal)i * 10, "Test String" );
        }
        /* Draw Text Rotation on second third of circle in green color */
        for ( i = 12; i < 24; i++ ) {
            /* Set Fill color as green tone */
            PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, cos((ppReal)(i - 18)/3.83), 0.0 ) );
            /* Draw text label 'Test String' with rotation on angle from 120 to 240 degrees */
            PBXTextOut( PaintBox, cx(50) + Radius * cos( (ppReal)i * 0.1745 ),
                cy(77) - Radius * sin ( (ppReal)i * 0.1745 ), (ppReal)i * 10, "Test String" );
        }
        /* Draw Text Rotation on last third of circle in blue color */
        for ( i = 24; i < 36; i++ ) {
            /* Set Fill color as blue tone */
            PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, cos((ppReal)(i - 30)/3.83) ) );
            /* Draw text label 'Test String' with rotation on angle from 240 to 360 degrees */
            PBXTextOut( PaintBox, cx(50) + Radius * cos( (ppReal)i * 0.1745 ),
                cy(77) - Radius * sin ( (ppReal)i * 0.1745 ), (ppReal)i * 10, "Test String" );
        }
        /* Save non-packed Page Content and Free PaintBox */
        PBXClose( PaintBox, false );
        /* Save destination PDF file as "text.pdf" in current path */
        PDFDocSaveToFile( Doc, "../Data/out/TextOut.pdf" );
    PDFFINALLY( PDFLibrary ) /* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc ); /* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary ); /* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary ); /* End of try...end block */
    return ErrorCode; /* Return Error Code as program result */
}

