/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TSCAnnotDict SCAnnotation;  /* SC annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			SCAnnotation.Contents = "Square annotation";  /* Annotation content filling */
			SCAnnotation.ContLength = 17;
			SCAnnotation.Open = true;                      /* Set open property to true */
			SCAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			SCAnnotation.DateTime = NULL;
			SCAnnotation.InteriorColor = NULL;
			SCAnnotation.Action = CosNewNull ( doc );      
			SCAnnotation.AdditAction = CosNewNull ( doc );
			SCAnnotation.Popup = CosNewNull ( doc );
            SCAnnotation.AnFlags = 0;
			SCAnnotation.Transparency = 1;
			SCAnnotation.Rectangle.pt1.X = 200;              /* Setting annotation sizes */
			SCAnnotation.Rectangle.pt1.Y = 800;
			SCAnnotation.Rectangle.pt2.X = 400;
			SCAnnotation.Rectangle.pt2.Y = 600;
			SCAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
			SCAnnotation.Color.red = 0.0;
			SCAnnotation.Color.green = 0.0;
			SCAnnotation.TitleText = "Square title";   /* Setting annotation title */
			SCAnnotation.TTLength = 12;
			PDFPageAddSCAnnotation( doc, 0, SCAnnotation, sctSquare ); /* Adding annotation to the document ( type Square ) */ 
			PDFDocSaveToFile( doc, "../Data/out/SquareAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}