/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>          /* Use standard Input/Output Console API */

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSAcroObjects.h"  /* Use Acro Objects API */

int main( int argc, char* argv[] ) /* Get PDF filename as first parameter */
{
    PDFLibHandle	PDFLibrary; /* PDF Library Handle */
	PDFDocHandle	Doc = NULL; /* PDF Document Handle */
    ppInt32         ErrorCode;  /* Check Error Code */
    ppInt32         AllPermission = ( prPrint | prModifyContent | prCopyInformation | prModifyAnnotation
        | prFillAcroForm | prExtractTextAndImage | prAssembleDocument | prPrintHiResolution );

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */
            Doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf" );/* Load existing PDF file */
            PDFDocSetLinearized( Doc, false ); /* Set non-linearize option for crypted PDF file */
            PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

            /* Set security on pdf-file with all permissions, 128-bits crypt key and passwords :
            user - "123", owner - "12345" */
            PDFDocSetSecurity( Doc, true, AllPermission, pt128BitProtection, "123", "12345" );

            PDFDocSaveToFile( Doc, "../Data/out/SetPassword.pdf" ); /* Save destination PDF file as "set-password.pdf" in current path */
    PDFFINALLY( PDFLibrary )/* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc );/* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary );/* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary );/* End of try...end block */
    return ErrorCode;/* Return Error Code as program result */
}

