/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TMovieAnnotDict MovieAnnotation;              /* Movie annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			MovieAnnotation.Contents = "Movie annotation";    /* Annotation content filling */
			MovieAnnotation.ContLength = 17;
			MovieAnnotation.DateTime = NULL;                  /* Zeroizing unused properties */
            MovieAnnotation.AnFlags = 0;
            MovieAnnotation.Transparency = 1;
			MovieAnnotation.Rectangle.pt1.X = 200;            /* Setting annotation sizes */
			MovieAnnotation.Rectangle.pt1.Y = 600;
			MovieAnnotation.Rectangle.pt2.X = 400;
			MovieAnnotation.Rectangle.pt2.Y = 800;
			MovieAnnotation.FileName = "clock.avi";  /* Set movie filename */            
			MovieAnnotation.FNLength = 9;
			MovieAnnotation.Color.blue = 0.0;                 /* Setting annotation color to red */ 
			MovieAnnotation.Color.red = 1.0;
			MovieAnnotation.Color.green = 1.0;
			PDFPageAddMovieAnnotation( doc, 0, MovieAnnotation );  /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/MovieAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}