/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TLineAnnotDict LineAnnotation;  /* Line annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			LineAnnotation.Contents = "Line annotation";     /* Annotation content filling */
			LineAnnotation.ContLength = 15;
			LineAnnotation.Open = true;                      /* Set open property to true */
			LineAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			LineAnnotation.DateTime = NULL;
			LineAnnotation.Action = CosNewNull ( doc );      
			LineAnnotation.AdditAction = CosNewNull ( doc );
			LineAnnotation.Popup = CosNewNull ( doc );
            LineAnnotation.AnFlags = 0;
            LineAnnotation.Transparency = 1;
			LineAnnotation.InteriorColor[0] = 1.0;
			LineAnnotation.InteriorColor[1] = 0.0;
			LineAnnotation.InteriorColor[2] = 0.0;
			LineAnnotation.Rectangle.pt1.X = 266;              /* Setting annotation sizes */
			LineAnnotation.Rectangle.pt1.Y = 116;
			LineAnnotation.Rectangle.pt2.X = 430;
			LineAnnotation.Rectangle.pt2.Y = 804;
			LineAnnotation.LineCoordinates[0] = 266;         /* Setting line coordinates */ 
			LineAnnotation.LineCoordinates[1] = 116;
			LineAnnotation.LineCoordinates[2] = 430;
			LineAnnotation.LineCoordinates[3] = 804;
			LineAnnotation.LineEnding[0] = lesSquare;
			LineAnnotation.LineEnding[1] = lesCircle;
			LineAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
			LineAnnotation.Color.red = 0.0;
			LineAnnotation.Color.green = 0.0;
			PDFPageAddLineAnnotation( doc, 0, LineAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/LineAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}
