/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TFreeAnnotDict FreeAnnotation;                /* Free annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			FreeAnnotation.Contents = "Free annotation";     /* Annotation content filling */
			FreeAnnotation.ContLength = 15;
			FreeAnnotation.Open = false;                     /* Set open property to true */
			FreeAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			FreeAnnotation.DateTime = NULL;
			FreeAnnotation.DA = NULL;
			FreeAnnotation.Action = CosNewNull ( doc );      
			FreeAnnotation.AdditAction = CosNewNull ( doc );
			FreeAnnotation.Popup = CosNewNull ( doc );
			FreeAnnotation.AnFlags = 0;
			FreeAnnotation.Transparency = 1;
			FreeAnnotation.Rectangle.pt1.X = 200;              /* Setting annotation sizes */
			FreeAnnotation.Rectangle.pt1.Y = 800;
			FreeAnnotation.Rectangle.pt2.X = 400;
			FreeAnnotation.Rectangle.pt2.Y = 700;
			FreeAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
			FreeAnnotation.Color.red = 0.0;
			FreeAnnotation.Color.green = 0.0;
			FreeAnnotation.TitleText = "Free title";   /* Setting annotation title */
			FreeAnnotation.TTLength = 10;
			PDFPageAddFreeAnnotation( doc, 0, FreeAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/FreeTextAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}