/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSTypes.h"        /* Use Versy Type Definitions */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSAcroObjects.h"  /* Use Acro Objects API */

#define PageWidth 1000      /* Page width definition */
#define PageHeight 500      /* Page height definition */

/* Determination of relative page coordinates, normalized to 100 */
#define PX(a) (PageWidth*a/100)
#define PY(a) (PageHeight*a/100)
/* Determination of relative control ( Acro Object Content ) coordinates, normalized to 100 */
#define OX(a) (PageWidth*a/100)
#define OY(a) (PageHeight*(100-a)/100)


TPDFRect GetPDFRect( ppReal xl, ppReal yl, ppReal xr, ppReal yr )
{
    TPDFRect Rect;
    Rect.xl = xl;
    Rect.yl = yl;
    Rect.xr = xr;
    Rect.yr = yr;
    return Rect;
}

/* Overload function for repaint pushbutton in pressed state, instead of default repaint */
void RepaintPushButtonContent( PBXHandle PaintBox, PPDFPushButton PushButton )
/*
    PaintBox -      Handle of Created Paint Box for Pushbutton Object
    PushButton -    Pointer to Pushbutton structure with all button properties
*/
{
    /* Set working rectangle as all button active area */
    TPDFRect  Rect = GetPDFRect( 0, 0, PushButton->Border.Rect.xr - PushButton->Border.Rect.xl,
                                    PushButton->Border.Rect.yr - PushButton->Border.Rect.yl );
    /* Save the current graphics state on the graphics state stack. */
    PBXStateStore( PaintBox );
    /* Set the line width in the graphics state. */
    PBXSetLineWidth( PaintBox, PushButton->Border.Width );
    /* Set the filling Color space to DeviceRGB and Color as Maroon to use for filling operations */
    PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.8, 0.8 ) );
    /* Begin a new subpath by moving the current point to new coordinates.
    Draw PushButton Border with Miter Width */
    PBXMoveTo( PaintBox, Rect.xl, Rect.yr );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl, Rect.yl );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr, Rect.yl );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr - PushButton->Miter, Rect.yl + PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl + PushButton->Miter, Rect.yl + PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl + PushButton->Miter, Rect.yr - PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl, Rect.yr );
    /* Fill the path, using the nonzero winding number rule to determine the region to fill.
    Any subpaths that are open are implicitly closed before being filled.*/
    PBXFill( PaintBox );

    /* Set the filling Color space to DeviceRGB and Color as Dark Green to use for filling operations */
    PBXSetFillColor( PaintBox, ULRGBToColor( 0.8, 1.0, 0.8 ) );
    /* Begin a new subpath by moving the current point to new coordinates.
    Draw PushButton Border with Miter Width */
    PBXMoveTo( PaintBox, Rect.xl, Rect.yr );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr, Rect.yr );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr, Rect.yl );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr - PushButton->Miter, Rect.yl + PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xr - PushButton->Miter, Rect.yr - PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl + PushButton->Miter, Rect.yr - PushButton->Miter );
    /* Append a straight line segment from the current point to next point */
    PBXLineTo( PaintBox, Rect.xl, Rect.yr );
    /* Fill the path, using the nonzero winding number rule to determine the region to fill.
    Any subpaths that are open are implicitly closed before being filled.*/
    PBXFill( PaintBox );
    /* Set the filling Color space to DeviceRGB and Color as Dark Blue to use for filling operations */
    PBXSetFillColor( PaintBox, ULRGBToColor( 0.8, 0.9, 1.0 ) );
    /* Append a rectangle to the current path as a complete subpath, with
    lower-left corner and top-right corner in user space. */
    PBXRectangle( PaintBox, Rect.xl + PushButton->Miter, Rect.yl + PushButton->Miter,
        Rect.xr - PushButton->Miter, Rect.yr - PushButton->Miter );
    /* Fill the path, using the nonzero winding number rule to determine the region to fill.
    Any subpaths that are open are implicitly closed before being filled.*/
    PBXFill( PaintBox );
    /* Set the text font as PushButtons Font */
    PBXSetActiveFont( PaintBox, PushButton->Font.ID.From.Index, PushButton->Font.Size, false, false );
    /* Set the filling Color as PushButton Font Color */
    PBXSetFillColor( PaintBox, PushButton->Font.Color );
    /* Set the text matrix and show a PushButton Caption */
    PBXTextOut( PaintBox, Rect.xl + 10, Rect.yl + 10, 0, PushButton->Caption );
    /* If Border Color is Visible then ... */
    if ( !IsNoPDFColor( PushButton->Border.BorderColor ) ) {
        /* Set the stroking Color as Black */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.0 ) );
        /* Append a rectangle to the current path as Pushbutton Border */
        PBXRectangle( PaintBox, Rect.xl, Rect.yl, Rect.xr, Rect.yr );
        /* Stroke the path. Draw Border line. */
        PBXStroke( PaintBox );
    }
    /* Restore the graphics state by removing the most recently saved state\n\
    from the stack and making it the current state.*/
    PBXStateRestore( PaintBox );
}

int main()
{
    PDFLibHandle	PDFLibrary;     /* PDF Library Handle */
	PDFDocHandle	Doc = NULL;     /* PDF Document Handle */
    PBXHandle       PaintBox;       /* Handle of Paint Box for Content Drawing */

    TPDFTextBox     TextBox;        /* Text Label Object */
    TPDFEditBox     EditBox;        /* EditBox Acro Object */
    TPDFPushButton  PushButton;     /* PushButton Acro Object */
    TPDFCheckBox    CheckBox;       /* CheckBox Acro Object */
    TPDFRadioButton RadioButton;    /* RadioButton Acro Object */
    TPDFComboBox    ComboBox;       /* ComboBox Acro Object */
    TPDFListBox     ListBox;        /* ListBox Acro Object */

    ppInt32         ErrorCode;      /* Check Error Code */
    ppInt32         i;              /* Variable counter */

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */

        Doc = PDFDocCreate( PDFLibrary ); /* Create new destination PDF file */
        PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

        i = PDFDocAppendPage( Doc, PageWidth, PageHeight ); /* Create new page in PDF document */
        PaintBox = PDFPageCreatePaintBox( Doc, i, 72 ); /* Create Page Content PaintBox with default resolution ( 72 dpi )*/

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the line 1 point width. */
        PBXSetLineWidth( PaintBox, 1 );
        /* Set the line cap style in the graphics state. */
        PBXSetLineCap( PaintBox, 1 );
        /* Set the line join style in the graphics state. */
        PBXSetLineJoin( PaintBox, 1 );
        /* Set the filling Color space to DeviceRGB and Color as White to use for filling operations */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.98, 0.95, 0.92 ) );
        /* Append a rectangle to the current path as all active area. */
        PBXRectangle( PaintBox, 0, 0, PX(100), PY(100) );
        /* Fill the path, using the nonzero winding number rule to determine the region to fill.
        Any subpaths that are open are implicitly closed before being filled.*/
        PBXFill( PaintBox );
        /* Set the stroking Color as Dark Maroon */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.3, 0.0, 0.0 ) );
        /* Set Rectangle Border around whole area */
        PBXRectangle( PaintBox, 0, 0, PX(100), PY(100) );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );
        /* Set the stroking Color as Light Maroon */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.6, 0.0, 0.0 ) );
        /* Set Rectangle Border in previous Rectangle */
        PBXRectangle( PaintBox, 1, 1, PX(100) - 1, PY(100) - 1 );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );
        /* Set the stroking Color as Red */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 1.0, 0.0, 0.0 ) );
        /* Set Rectangle Border in previous Rectangle */
        PBXRectangle( PaintBox, 2, 2, PX(100) - 2, PY(100) - 2 );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );

        /* Attach text to left top corner of field */
        TextBox.Align = PDFAcroQuaddingLeftTop;
        /* Text without rotation */
        TextBox.Orientation = 0;
        /* Memory allocation for TextBox Caption */
        TextBox.Caption = (char *)malloc(255);
        /* Set TextBox Caption as "Intention Form" */
        sprintf( TextBox.Caption, "Intention Form" );
        /* Border Color is invisible */
        TextBox.Border.BorderColor = SetNoPDFColor;
        /* Label no need fill color */
        TextBox.Border.FillColor = SetNoPDFColor;
        /* Text Label Area 58% of page width, and 8% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(02), PY(02), PX(60), PY(10) );
        /* Set Dark Maroon Font Color */
        TextBox.Font.Color = ULRGBToColor( 0.3, 0.0, 0.0 );
        /* Font Size is 8% of Page Height */
        TextBox.Font.Size = PY(8);
        /* Use standard font ... */
        TextBox.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        TextBox.Font.ID.From.StandardFont = stdfHelvetica;
        /* Draw Text Label on Page Content */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set filling color as Dark Maroon */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.3, 0.0, 0.0 ) );
        /* Set narrow rectangle under text caption */
        PBXRectangle( PaintBox, PX(02), PY(10) + 1, PX(98), PY(10) + 2 );
        /* Fill rectangle by Dark Maroon Color */
        PBXFill( PaintBox );

        /* Set TextBox Caption as "Thallium Software Group (c) 2005" */
        sprintf( TextBox.Caption, "Thallium Software Group %c 2005", 0251 );
        /* Text Label Area set in above underline-rectangle */
        TextBox.Border.Rect = GetPDFRect( PX(85), PY(1), PX(85), PY(10) - 2 );
        /* Set Dark Green Font Color */
        TextBox.Font.Color = ULRGBToColor( 0.0, 0.5, 0.0 );
        /* Font Size is 2% of Page Height */
        TextBox.Font.Size = PY(2); 
        /* Attach text to bottom central site of field */
        TextBox.Align = PDFAcroQuaddingBottom;
        /* Draw Text Label on Page Content */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set TextBox Caption as "Contact Person" */
        sprintf( TextBox.Caption, "Contact Person" );
        /* Text Label Area 8% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(02), PY(11), PX(10), PY(14) );
        /* Font Size is 2.5% of Page Height */
        TextBox.Font.Size = PY(2.5);
        /* Use standard font ... */
        TextBox.Font.ID.IsStdFont = true;
        /* ... which named CourierBold */
        TextBox.Font.ID.From.StandardFont = stdfCourierBold;
        /* Set Brown Font Color */
        TextBox.Font.Color = ULRGBToColor( 0.3, 0.2, 0.0 );
        /* Attach text to left bottom corner of field */
        TextBox.Align = PDFAcroQuaddingLeftBottom;
        /* Draw Text Label on Page Content */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Memory allocation for EditBox Name */
        EditBox.Name = (char *)malloc(255);
        /* Memory allocation for EditBox Caption */
        EditBox.Caption = (char *)malloc(255);
        /* Set EditBox Name as "cp" */
        sprintf( EditBox.Name, "cp" );
        /* Set EditBox Caption as void */
        sprintf( EditBox.Caption, "" );
        /* EditBox Area 58% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(02), OY(15), OX(60), OY(20) );
        /* Border Line Color is Dark Green */
        EditBox.Border.BorderColor = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* EditBox Filling Color is Turquoise */
        EditBox.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Set Border line width as 2 points */
        EditBox.Border.Width = 2;
        /* Set default AcroField flag */
        EditBox.Flag = PDFAcroFlags_Default;
        /* Text length is no limited */
        EditBox.MaxLen = 0;
        /* Attach variable text in edit box to left central site of field */
        EditBox.Align = PDFAcroQuaddingLeft;
        /* Font Size is 3% of Page Height */
        EditBox.Font.Size = PY(3);
        /* Set Dark Green Font Color of Variable Text */
        EditBox.Font.Color = ULRGBToColor( 0.0, 0.4, 0.0 );
        /* Use standard font ... */
        EditBox.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        EditBox.Font.ID.From.StandardFont = stdfHelvetica;
        /* No overload function for repaint edit box. Use default repaint appearance */
        EditBox.PaintContent = NULL;
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "Company Name" */
        sprintf( TextBox.Caption, "Company Name" );
        /* Text Label Area 8% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(02), PY(21), PX(10), PY(24) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "cn" */
        sprintf( EditBox.Name, "cn" );
        /* EditBox Area 58% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(02), OY(25), OX(60), OY(30) );
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "Department" */
        sprintf( TextBox.Caption, "Department" );
        /* Text Label Area 8% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(02), PY(31), PX(10), PY(34) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Memory allocation for ComboBox Name */
        ComboBox.Name = (char *)malloc(255);
        /* Memory allocation for ComboBox default caption */
        ComboBox.Caption = (char *)malloc(255);
        /* Set ComboBox Name as "dp" */
        sprintf( ComboBox.Name, "dp" );
        /* Set ComboBox default caption as "< select department, please >" */
        sprintf( ComboBox.Caption, "< select department, please >" );
        /* ComboBox Area 18% of page width, and 5% of Page Height */
        ComboBox.Border.Rect = GetPDFRect( OX(02), OY(35), OX(20), OY(40) );
        /* Border Line Color is Dark Green */
        ComboBox.Border.BorderColor = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* ComboBox Filling Color is Turquoise */
        ComboBox.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Set Border line width as 2 points */
        ComboBox.Border.Width = 2;
        /* Set default AcroField flag */
        ComboBox.Flag = PDFAcroFlags_Default;
        /* Font Size is 2.5% of Page Height */
        ComboBox.Font.Size = PY(2.5);
        /* Set Dark Green Font Color of Text */
        ComboBox.Font.Color = ULRGBToColor( 0.0, 0.4, 0.0 );
        /* Use standard font ... */
        ComboBox.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        ComboBox.Font.ID.From.StandardFont = stdfHelvetica;
        /* No overload function for repaint combo box. Use default repaint appearance */
        ComboBox.PaintContent = NULL;
        /* Add ComboBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroComboBoxInDocument( Doc, 0, ComboBox );
        /* Add text items to combo box items list */
        PDFAcroItemsBoxAdd( Doc, i, "100 Management", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "101 Administration", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "102 Accounting", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "103 Information Department", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "104 Technology Department", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "105 Personal Management", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "110 Customer Service", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "120 External Relations", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "121 Analog Proofs", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "150 System Analytic Department", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "200 Research Department", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "201 Development", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "202 Software Department", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "999 Other", ComboBox );

        /* Set TextBox Caption as "Phone" */
        sprintf( TextBox.Caption, "Phone" );
        /* Text Label Area 9% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(21), PY(31), PX(30), PY(34) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "ph" */
        sprintf( EditBox.Name, "ph" );
        /* EditBox Area 19% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(21), OY(35), OX(40), OY(40) );
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "E-mail" */
        sprintf( TextBox.Caption, "E-mail" );
        /* Text Label Area 19% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(41), PY(31), PX(60), PY(34) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "em" */
        sprintf( EditBox.Name, "em" );
        /* EditBox Area 19% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(41), OY(35), OX(60), OY(40) );
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "Street Address" */
        sprintf( TextBox.Caption, "Street Address" );
        /* Text Label Area 58% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(2), PY(41), PX(60), PY(44) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "ad" */
        sprintf( EditBox.Name, "ad" );
        /* EditBox Area 58% of page width, and 15% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(2), OY(45), OX(60), OY(60) );
        /* Set multi line possibility for entering address */
        EditBox.Flag = PDFAcroFlags_Multiline;
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "City" */
        sprintf( TextBox.Caption, "City" );
        /* Text Label Area 8% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(2), PY(61), PX(10), PY(64) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "ct" */
        sprintf( EditBox.Name, "ct" );
        /* EditBox Area 28% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(2), OY(65), OX(30), OY(70) );
        /* Return edit box flag in default state */
        EditBox.Flag = PDFAcroFlags_Default;
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "State" */
        sprintf( TextBox.Caption, "State" );
        /* Text Label Area 8% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(31), PY(61), PX(39), PY(64) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set ComboBox Name as "st" */
        sprintf( ComboBox.Name, "st" );
        /* Set ComboBox default caption as "<select>" */
        sprintf( ComboBox.Caption, "<select>" );
        /* ComboBox Area 8% of page width, and 5% of Page Height */
        ComboBox.Border.Rect = GetPDFRect( OX(31), OY(65), OX(39), OY(70) );
        /* Add ComboBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroComboBoxInDocument( Doc, 0, ComboBox );
        /* Add text items to combo box items list */
        PDFAcroItemsBoxAdd( Doc, i, "AL", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "AR", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "AZ", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "CA", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "CO", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "HA", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "KE", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "MA", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "NE", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "NY", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "OH", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "OL", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "OR", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "PE", ComboBox );
        PDFAcroItemsBoxAdd( Doc, i, "TX", ComboBox );

        /* Set TextBox Caption as "Zip" */
        sprintf( TextBox.Caption, "Zip" );
        /* Text Label Area 10% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(40), PY(61), PX(50), PY(64) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set EditBox Name as "zp" */
        sprintf( EditBox.Name, "zp" );
        /* EditBox Area 20% of page width, and 5% of Page Height */
        EditBox.Border.Rect = GetPDFRect( OX(40), OY(65), OX(60), OY(70) );
        /* Add EditBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current EditBox remains such either as in previous EditBox */
        PDFAcroEditBoxInDocument( Doc, 0, EditBox );

        /* Set TextBox Caption as "Which purposes are you pursuing?" */
        sprintf( TextBox.Caption, "Which purposes are you pursuing?" );
        /* Text Label Area 28% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(2), PY(71), PX(30), PY(74) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Memory allocation for ListBox Name */
        ListBox.Name = (char *)malloc(255);
        /* Set ListBox Name as "pu" */
        sprintf( ListBox.Name, "pu" );
        /* ListBox Area 58% of page width, and 15% of Page Height */
        ListBox.Border.Rect = GetPDFRect( OX(2), OY(90), OX(60), OY(75) );
        /* Border Line Color is Dark Green */
        ListBox.Border.BorderColor = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* ListBox Filling Color is Turquoise */
        ListBox.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Set Border line width as 2 points */
        ListBox.Border.Width = 2;
        /* Set AcroField flag as multiselect */
        ListBox.Flag = PDFAcroFlags_MultiSelect;
        /* Font Size is 2.5% of Page Height */
        ListBox.Font.Size = PY(2.5);
        /* Set Dark Green Font Color of Text */
        ListBox.Font.Color = ULRGBToColor( 0.0, 0.4, 0.0 );
        /* Use standard font ... */
        ListBox.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        ListBox.Font.ID.From.StandardFont = stdfHelvetica;
        /* No overload function for repaint combo box. Use default repaint appearance */
        ListBox.PaintContent = NULL;
        /* Add ListBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroListBoxInDocument( Doc, 0, ListBox );
        /* Add text items to list box items list */
        PDFAcroItemsBoxAdd( Doc, i, "I wanna buy one copy for me", ListBox );
        PDFAcroItemsBoxAdd( Doc, i, "I wanna buy library for my company", ListBox );
        PDFAcroItemsBoxAdd( Doc, i, "I wanna to be reseller in own region", ListBox );
        PDFAcroItemsBoxAdd( Doc, i, "I wanna testing yours library", ListBox );
        PDFAcroItemsBoxAdd( Doc, i, "I looking for similar product in internet", ListBox );
        PDFAcroItemsBoxAdd( Doc, i, "I have some questions about yours PDF products", ListBox );

        /* Set TextBox Caption as "I wanna to subscribe news about yours products" */
        sprintf( TextBox.Caption, "I wanna to subscribe news about yours products" );
        /* Text Label Area 55% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(2) + PY(5), PY(91), PX(60), PY(94) );
       /* Set Red Font Color of Text */
        TextBox.Font.Color = ULRGBToColor( 0.8, 0.1, 0.1 );
        /* Font Size is 3% of Page Height */
        TextBox.Font.Size = PY(3);
        /* Use standard font ... */
        TextBox.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        TextBox.Font.ID.From.StandardFont = stdfHelvetica;
        /* Attach text to left central site of field */
        TextBox.Align = PDFAcroQuaddingLeft;
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Memory allocation for CheckBox Name */
        CheckBox.Name = (char *)malloc(255);
        /* Set CheckBox Name as "sb" */
        sprintf( CheckBox.Name, "sb" );
        /* CheckBox Area 3% of Page Height, and 3% of Page Height */
        CheckBox.Border.Rect = GetPDFRect( OX(2), OY(94), OX(2) + PY(3), OY(91) );
        /* Border Line Color is Dark Green */
        CheckBox.Border.BorderColor = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* ListBox Filling Color is Turquoise */
        CheckBox.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Set Border line width as 2 points */
        CheckBox.Border.Width = 2;
        /* Set default AcroField flag */
        CheckBox.Flag = PDFAcroFlags_Default;
        /* Marker is sign 'V' */
        CheckBox.Sign = cbsVmark;
        /* Rectangle border */
        CheckBox.Style = cbfRectangle;
        /* Set checked box */
        CheckBox.Value = true;
        /* Set Dark Green Font Color of Text */
        CheckBox.Font.Color = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* No overload functions for repaint check boxes. Use default repaint appearance */
        CheckBox.PaintContentOn = NULL;
        CheckBox.PaintContentOff = NULL;
        /* Add CheckBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        PDFAcroCheckBoxInDocument( Doc, 0, CheckBox );

        /* Set TextBox Caption as "I wanna to contact with yours managers" */
        sprintf( TextBox.Caption, "I wanna to contact with yours managers" );
        /* Text Label Area 55% of page width, and 3% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(2) + PY(5), PY(95), PX(60), PY(98) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set CheckBox Name as "cm" */
        sprintf( CheckBox.Name, "cm" );
        /* CheckBox Area 3% of Page Height, and 3% of Page Height */
        CheckBox.Border.Rect = GetPDFRect( OX(2), OY(98), OX(2) + PY(3), OY(95) );
        /* Set unchecked box */
        CheckBox.Value = false;
        /* Set Dark Red Font Color of Text */
        CheckBox.Font.Color = ULRGBToColor( 0.3, 0.0, 0.0 );
        /* Add CheckBox Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current CheckBox remains such either as in previous CheckBox */
        PDFAcroCheckBoxInDocument( Doc, 0, CheckBox );

        /* Set TextBox Caption as "Which library pack" */
        sprintf( TextBox.Caption, "Which library pack" );
        /* Text Label Area 37% of Page width, and 4% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(62), PY(21), PX(99), PY(25) );
        /* Set Dark Red Font Color of Text */
        TextBox.Font.Color = ULRGBToColor( 0.3, 0.0, 0.0 );
        /* Font Size is 5% of Page Height */
        TextBox.Font.Size = PY(5);
        /* Attach text to left top corner of field */
        TextBox.Align = PDFAcroQuaddingLeftTop;
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set TextBox Caption as "are you interested?" */
        sprintf( TextBox.Caption, "are you interested?" );
        /* Text Label Area 37% of Page width, and 5% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(62), PY(25), PX(99), PY(30) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set TextBox Caption as "Demo" */
        sprintf( TextBox.Caption, "Demo" );
        /* Text Label Area 12% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(87) + PY(8), PY(21), PX(99), PY(30) );
        /* Set Dark Green Font Color of Text */
        TextBox.Font.Color = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* Font Size is 2% of Page Height */
        TextBox.Font.Size = PY(2);
        /* Attach text to left central site of field */
        TextBox.Align = PDFAcroQuaddingLeft;
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Memory allocation for RadioButton Name */
        RadioButton.Name = (char *)malloc(255);
        /* Set RadioButton Name as "Demo" */
        sprintf( RadioButton.Name, "Demo" );
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(87), OY(29), OX(87) + PY(07), OY(22) );
        /* Border Line Color is Dark Green */
        RadioButton.Border.BorderColor = ULRGBToColor( 0.0, 0.3, 0.0 );
        /* RadioButton Filling Color is Turquoise */
        RadioButton.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Set Border line width as 2 points */
        RadioButton.Border.Width = 2;
        /* Marker is sign 'Pen' */
        RadioButton.Sign = cbsPen;
        /* Circle border */
        RadioButton.Style = cbfCircle;
        /* Set checked box */
        RadioButton.Value = true;
        /* Set Dark Maroon Font Color of Text */
        RadioButton.Font.Color = ULRGBToColor( 0.3, 0.0, 0.0 );
        /* No overload functions for repaint check boxes. Use default repaint appearance */
        RadioButton.PaintContentOn = NULL;
        RadioButton.PaintContentOff = NULL;
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Set TextBox Caption as "Home Edition" */
        sprintf( TextBox.Caption, "Home Edition" );
        /* Text Label Area 15% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(80) + PY(8), PY(31), PX(99), PY(40) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set RadioButton Name as "Home" */
        sprintf( RadioButton.Name, "Home" );
        /* Set unchecked box */
        RadioButton.Value = false;
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(80), OY(39), OX(80) + PY(07), OY(32) );
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        /* ... other properties of current RadioButton remains such either as in previous RadioButton */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Set TextBox Caption as "Standard Edition" */
        sprintf( TextBox.Caption, "Standard Edition" );
        /* Text Label Area 21% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(74) + PY(8), PY(41), PX(99), PY(50) );
        /* Set Dark Blue Font Color of Text */
        TextBox.Font.Color = ULRGBToColor( 0.0, 0.0, 0.3 );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set RadioButton Name as "Standard" */
        sprintf( RadioButton.Name, "Standard" );
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(74), OY(49), OX(74) + PY(07), OY(42) );
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        /* ... other properties of current RadioButton remains such either as in previous RadioButton */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Set TextBox Caption as "Professional Edition" */
        sprintf( TextBox.Caption, "Professional Edition" );
        /* Text Label Area 21% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(69) + PY(8), PY(51), PX(99), PY(60) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set RadioButton Name as "Professional" */
        sprintf( RadioButton.Name, "Professional" );
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(69), OY(59), OX(69) + PY(07), OY(52) );
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        /* ... other properties of current RadioButton remains such either as in previous RadioButton */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Set TextBox Caption as "Enterprise Edition" */
        sprintf( TextBox.Caption, "Enterprise Edition" );
        /* Text Label Area 21% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(65) + PY(8), PY(61), PX(99), PY(70) );
        /* Set Dark Maroon Font Color of Text */
        TextBox.Font.Color = ULRGBToColor( 0.3, 0.0, 0.0 );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set RadioButton Name as "Enterprise" */
        sprintf( RadioButton.Name, "Enterprise" );
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(65), OY(69), OX(65) + PY(07), OY(62) );
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        /* ... other properties of current RadioButton remains such either as in previous RadioButton */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Set TextBox Caption as "Corporate Edition" */
        sprintf( TextBox.Caption, "Corporate Edition" );
        /* Text Label Area 21% of Page width, and 9% of Page Height */
        TextBox.Border.Rect = GetPDFRect( PX(62) + PY(8), PY(71), PX(99), PY(80) );
        /* Draw Text Label on Page Content */
        /* ... other properties of current TextBox remains such either as in previous TextBox */
        PBXDrawTextBox( PaintBox, TextBox );

        /* Set RadioButton Name as "Corporate" */
        sprintf( RadioButton.Name, "Corporate" );
        /* RadioButton Area 7% of Page Height, and 7% of Page Height */
        RadioButton.Border.Rect = GetPDFRect( OX(62), OY(79), OX(62) + PY(07), OY(72) );
        /* Add RadioButton Acro Object to PDF Document AcroForm in "pd" Group, and link repaint content to first page */
        /* ... other properties of current RadioButton remains such either as in previous RadioButton */
        PDFAcroRadioButtonInDocument( Doc, 0, "pd", RadioButton );

        /* Memory allocation for PushButton Name */
        PushButton.Name = (char *)malloc(255);
        /* Memory allocation for PushButton Caption */
        PushButton.Caption = (char *)malloc(255);
        /* Set PushButton Name as "SubmitButton" */
        sprintf( PushButton.Name, "SubmitButton" );
        /* Set PushButton Caption as "Submit Form" */
        sprintf( PushButton.Caption, "Submit Form" );
        /* PushButton Area 9% of Page width, and 5% of Page Height */
        PushButton.Border.Rect = GetPDFRect( 0.9 * PageWidth, 10, PageWidth - 10, 10 + 0.05 * PageHeight );
        /* Border Line Color is Invisible */
        PushButton.Border.BorderColor = SetNoPDFColor;
        /* PushButton Filling Color is Turquoise */
        PushButton.Border.FillColor = ULRGBToColor( 0.95, 1.0, 0.9 );
        /* Button Miter is 0.6% of Page Height */
        PushButton.Miter = 0.006 * PageHeight;
        /* Set AcroField flag as PushButton */
        PushButton.Flag = PDFAcroFlags_Pushbutton;
        /* Font Size is 2% of Page Height */
        PushButton.Font.Size = PY(2);
        /* Set Black Font Color of Text */
        PushButton.Font.Color = ULRGBToColor( 0.0, 0.0, 0.0 );
        /* Use standard font ... */
        PushButton.Font.ID.IsStdFont = true;
        /* ... which named Helvetica */
        PushButton.Font.ID.From.StandardFont = stdfHelvetica;
        /* No overload functions for repaint pushbutton. Use default repaint appearance */
        PushButton.PaintContentUp = NULL;
        PushButton.PaintContentDown = NULL;
        /* Add PushButton Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroPushButtonInDocument( Doc, 0, PushButton );
        /* Add Action item to PushButton on Activate Event */
        PDFAcroObjectAddAction( Doc, i, PDFActionNewSubmitForm( Doc, "//LocalHost/PDF/fdfserv.php",
            8, 0 ), PDFAcroEventTypeActivate );

        /* Set PushButton Name as "ExportButton" */
        sprintf( PushButton.Name, "ExportButton" );
        /* Set PushButton Caption as "Export Data" */
        sprintf( PushButton.Caption, "Export Data" );
        /* PushButton Area 9% of Page width, and 5% of Page Height */
        PushButton.Border.Rect = GetPDFRect( 0.8 * PageWidth, 10, 0.9 * PageWidth - 10, 10 + 0.05 * PageHeight );
        /* Add PushButton Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current PushButton remains such either as in previous PushButton */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroPushButtonInDocument( Doc, 0, PushButton );
        /* Add Action item to PushButton on KeyPress Event */
        PDFAcroObjectAddAction( Doc, i, PDFActionNewSubmitForm( Doc, "http://www.thallium.com/lib/pdf/fdfserv.php",
            15, PDF_SUBMIT_FORM_FLAG_EXPORT_FORMAT ), PDFAcroEventTypePress );

        /* Set PushButton Name as "ResetButton" */
        sprintf( PushButton.Name, "ResetButton" );
        /* Set PushButton Caption as "Reset Form" */
        sprintf( PushButton.Caption, "Reset Form" );
        /* PushButton Area 9% of Page width, and 5% of Page Height */
        PushButton.Border.Rect = GetPDFRect( 0.7 * PageWidth, 10, 0.8 * PageWidth - 10, 10 + 0.05 * PageHeight );
        /* Overload function for repaint pushbutton in pressed state ( see above function "RepaintPushButtonContent" ),
        instead of default repaint appearance */
        PushButton.PaintContentDown = RepaintPushButtonContent;
        /* Add PushButton Acro Object to PDF Document AcroForm, and link repaint content to first page */
        /* ... other properties of current PushButton remains such either as in previous PushButton */
        /* ... and store Acro Object Index (i) */
        i = PDFAcroPushButtonInDocument( Doc, 0, PushButton );
        /* Add Action item to PushButton on Activate Event */
        PDFAcroObjectAddAction( Doc, i, PDFActionNewResetForm( Doc, false ), PDFAcroEventTypeActivate );

        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        free( TextBox.Caption ); /* Free memory of TextBox structure */
        free( EditBox.Caption ); /* Free memory of EditBox Caption */
        free( EditBox.Name ); /* Free memory of EditBox Name */
        free( ComboBox.Caption ); /* Free memory of ComboBox Caption */
        free( ComboBox.Name ); /* Free memory of ComboBox Name */
        free( ListBox.Name ); /* Free memory of ListBox Name */
        free( CheckBox.Name ); /* Free memory of CheckBox Name */
        free( PushButton.Caption ); /* Free memory of PushButton Caption */
        free( PushButton.Name ); /* Free memory of PushButton Name */
        free( RadioButton.Name ); /* Free memory of RadioButton Name */
        
        PBXClose( PaintBox, false ); /* Free PaintBox of Page Content */

        /* Save destination PDF file as "acroform-api-test.pdf" in current path */
        PDFDocSaveToFile( Doc, "../Data/out/AcroFormAPITest.pdf" );
    PDFFINALLY( PDFLibrary ) /* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc ); /* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary ); /* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary ); /* End of try...end block */
    return ErrorCode; /* Return Error Code as program result */
}

