/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class RegistryExplorer_ModifyValueDialog extends JDialog implements ActionListener
{
	JLabel label1 = new JLabel();
	JButton buttonCancel = new JButton();
	JTextField jTextFieldData = new JTextField();
	JPanel jPanel1 = new JPanel();
	JPanel jPanel3 = new JPanel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel label2 = new JLabel();
	JTextField jTextFieldName = new JTextField();
	JButton buttonOk = new JButton();

	RegistryExplorer registry_explorer;

	String path;

	String old_name;

	boolean completed;
	boolean modify;

	JPanel jPanel2 = new JPanel();
	JPanel jPanel4 = new JPanel();
	JPanel jPanel5 = new JPanel();
	JPanel jPanel6 = new JPanel();
	GridLayout gridLayout1 = new GridLayout();
	JPanel jPanel7 = new JPanel();
	JPanel jPanel8 = new JPanel();
	GridLayout gridLayout2 = new GridLayout();
	GridLayout gridLayout3 = new GridLayout();
	GridLayout gridLayout4 = new GridLayout();
	GridLayout gridLayout5 = new GridLayout();
	GridLayout gridLayout6 = new GridLayout();
	GridLayout gridLayout7 = new GridLayout();
	GridLayout gridLayout8 = new GridLayout();

	public RegistryExplorer_ModifyValueDialog(Frame parent)
	{
		super(parent);

		registry_explorer = (RegistryExplorer)parent;

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try
		{
			jbInit();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		pack();
	}
	void jbInit() throws Exception
	{
		label1.setText("Data:");
		this.setResizable(false);
		this.setModal(true);
		this.setTitle("Modify Value");
		this.addComponentListener(new java.awt.event.ComponentAdapter()
		{
			public void componentShown(ComponentEvent e)
			{
				this_componentShown(e);
			}
		});
		this.getContentPane().setLayout(gridBagLayout1);
		buttonCancel.setText("Cancel");
		buttonCancel.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonCancel_keyTyped(e);
			}
		});
		buttonCancel.addActionListener(this);
		jTextFieldData.setText("Data");
		jTextFieldData.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jTextFieldData_keyTyped(e);
			}
		});
		jPanel1.setLayout(gridLayout4);
		jPanel3.setLayout(gridLayout1);
		label2.setText("Name:");
		jTextFieldName.setText("Name");
		jTextFieldName.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jTextFieldName_keyTyped(e);
			}
		});
		buttonOk.addActionListener(this);
		buttonOk.setEnabled(false);
		buttonOk.setToolTipText("");
		buttonOk.setText("Ok");
		buttonOk.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonOk_keyTyped(e);
			}
		});
		gridLayout1.setRows(4);
		gridLayout1.setColumns(1);
		gridLayout1.setHgap(5);
		gridLayout1.setVgap(5);
		jPanel8.setLayout(gridLayout2);
		jPanel7.setLayout(gridLayout3);
		gridLayout4.setRows(2);
		gridLayout4.setColumns(1);
		gridLayout4.setHgap(5);
		gridLayout4.setVgap(5);
		jPanel2.setLayout(gridLayout5);
		jPanel5.setLayout(gridLayout6);
		jPanel6.setLayout(gridLayout7);
		jPanel4.setLayout(gridLayout8);
		this.getContentPane().add(jPanel1, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0
			,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(10, 2, 44, 9), 7, 0));
		jPanel1.add(jPanel7, null);
		jPanel7.add(buttonOk, null);
		jPanel1.add(jPanel8, null);
		jPanel8.add(buttonCancel, null);
		this.getContentPane().add(jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
			,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(10, 11, 10, 9), 226, 3));
		jPanel3.add(jPanel2, null);
		jPanel2.add(label2, null);
		jPanel3.add(jPanel4, null);
		jPanel4.add(jTextFieldName, null);
		jPanel3.add(jPanel5, null);
		jPanel5.add(label1, null);
		jPanel3.add(jPanel6, null);
		jPanel6.add(jTextFieldData, null);
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}
	/**Close the dialog*/
	void cancel()
	{
		completed = false;
		hide();
	}
	/**Close the dialog on a button event*/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == buttonCancel)
		{
			cancel();
		}
		else if (e.getSource() == buttonOk)
		{
			done();
		}
	}

	void done()
	{
		if(!modify)
		{
			String value_name = jTextFieldName.getText().trim();

			if(old_name != null)
			{
				if(old_name.equals(value_name))
				{
					cancel();
					return;
				}
			}

			if(value_name.length() == 0)
			{
				registry_explorer.doMessage("Name is required.");
				return;
			}

			if(value_name.indexOf(Registry.DELIMITER) != -1)
			{
				registry_explorer.doMessage("Name cannot contain " + Registry.DELIMITER + ".");
				jTextFieldName.setText("");
				buttonOk.setEnabled(false);
				return;
			}

			String tpath;

			if(path.endsWith(Registry.DELIMITER))
			{
				tpath = path + value_name;
			}
			else
			{
				tpath = path + Registry.DELIMITER + value_name;
			}

			try
			{
				if(registry_explorer.registry.containsValue(tpath))
				{
					registry_explorer.doMessage("Name already exists.");
					return;
				}
			}
			catch(IOException ex)
			{
				registry_explorer.doError(ex);
			}
		}

		completed = true;

		hide();
	}

	void buttonOk_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			done();
		}
		else if(chr == 27)
		{
			cancel();
		}
	}

	void buttonCancel_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			cancel();
		}
		else if(chr == 27)
		{
			cancel();
		}
	}

	void jTextFieldName_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == 27)
		{
			cancel();
			return;
		}

		String value_name = jTextFieldName.getText().trim();

		int length = value_name.trim().length();

		if(chr == 0x08)
		{
			length--;
		}
		else if(!Character.isSpace(chr))
		{
			length++;
		}

		if(jTextFieldName.getSelectionEnd() > 0)
		{
			length -= (jTextFieldName.getSelectionEnd() - jTextFieldName.getSelectionStart());
		}

		if(length > 0)
		{
			buttonOk.setEnabled(true);

			if(chr == '\n')
			{
				done();
			}
		}
		else
		{
			buttonOk.setEnabled(false);
		}
	}

	void this_componentShown(ComponentEvent e)
	{
		completed = false;

		if(modify)
		{
			jTextFieldData.grabFocus();
		}
		else
		{
			jTextFieldName.grabFocus();
		}
	}

	void jTextFieldData_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();

		if(chr == 27)
		{
			cancel();
			return;
		}

		String value_name = jTextFieldName.getText().trim();

		int length = value_name.trim().length();

		if(length > 0)
		{
			if(chr == '\n')
			{
				done();
			}
		}
		else
		{
			buttonOk.setEnabled(false);
		}
	}
}