/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.beans.*;

public class RegistryExplorer_ModifyKeyDialog extends JDialog implements ActionListener
{
	JButton buttonCancel = new JButton();
	JPanel jPanel1 = new JPanel();
	JPanel jPanel3 = new JPanel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel label2 = new JLabel();
	JTextField jTextFieldKey = new JTextField();
	JButton buttonOk = new JButton();

	RegistryExplorer registry_explorer;

	String path;

	String old_key;

	boolean completed;

	JPanel jPanel2 = new JPanel();
	JPanel jPanel4 = new JPanel();
	GridLayout gridLayout1 = new GridLayout();
	GridLayout gridLayout2 = new GridLayout();
	GridLayout gridLayout3 = new GridLayout();
	JPanel jPanel5 = new JPanel();
	JPanel jPanel6 = new JPanel();
	GridLayout gridLayout4 = new GridLayout();
	GridLayout gridLayout5 = new GridLayout();
	GridLayout gridLayout6 = new GridLayout();

	public RegistryExplorer_ModifyKeyDialog(Frame parent)
	{
		super(parent);

		registry_explorer = (RegistryExplorer)parent;

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try
		{
			jbInit();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		pack();
	}
	void jbInit() throws Exception
	{
		this.setResizable(false);
		this.setModal(true);
		this.setTitle("Modify Key");
		this.addComponentListener(new java.awt.event.ComponentAdapter()
		{
			public void componentShown(ComponentEvent e)
			{
				this_componentShown(e);
			}
		});
		this.getContentPane().setLayout(gridBagLayout1);
		buttonCancel.setText("Cancel");
		buttonCancel.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonCancel_keyTyped(e);
			}
		});
		buttonCancel.addActionListener(this);
		jPanel3.setLayout(gridLayout4);
		label2.setText("Key:");
		jTextFieldKey.setText("Name");
		jTextFieldKey.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				jTextFieldKey_keyTyped(e);
			}
		});
		buttonOk.addActionListener(this);
		buttonOk.setEnabled(false);
		buttonOk.setText("Ok");
		buttonOk.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonOk_keyTyped(e);
			}
		});
		jPanel1.setLayout(gridLayout1);
		gridLayout1.setRows(2);
		gridLayout1.setColumns(1);
		gridLayout1.setHgap(5);
		gridLayout1.setVgap(5);
		jPanel2.setLayout(gridLayout2);
		jPanel4.setLayout(gridLayout3);
		gridLayout4.setRows(2);
		gridLayout4.setColumns(1);
		gridLayout4.setHgap(5);
		gridLayout4.setVgap(5);
		jPanel6.setLayout(gridLayout5);
		jPanel5.setLayout(gridLayout6);
		this.getContentPane().add(jPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 2, 10, 9), 7, 0));
		jPanel1.add(jPanel2, null);
		jPanel2.add(buttonOk, null);
		jPanel1.add(jPanel4, null);
		jPanel4.add(buttonCancel, null);
		this.getContentPane().add(jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
			,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(10, 11, 10, 9), 226, 3));
		jPanel3.add(jPanel5, null);
		jPanel5.add(label2, null);
		jPanel3.add(jPanel6, null);
		jPanel6.add(jTextFieldKey, null);
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}
	/**Close the dialog*/
	void cancel()
	{
		completed = false;
		hide();
	}
	/**Close the dialog on a button event*/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == buttonCancel)
		{
			cancel();
		}
		else if (e.getSource() == buttonOk)
		{
			done();
		}
	}

	void done()
	{
		String key = jTextFieldKey.getText().trim();

		if(old_key != null)
		{
			if(old_key.equals(key))
			{
				cancel();
				return;
			}
		}

		if(key.length() == 0)
		{
			registry_explorer.doMessage("Key is required.");
			return;
		}

		if(key.indexOf(Registry.DELIMITER) != -1)
		{
			registry_explorer.doMessage("Key cannot contain " + Registry.DELIMITER + ".");
			jTextFieldKey.setText("");
			buttonOk.setEnabled(false);
			return;
		}

		String tpath;

		if(path.endsWith(Registry.DELIMITER))
		{
			tpath = path + key + Registry.DELIMITER;
		}
		else
		{
			tpath = path + Registry.DELIMITER + key + Registry.DELIMITER;
		}

		try
		{
			if(registry_explorer.registry.containsKey(tpath))
			{
				registry_explorer.doMessage("Key already exists.");
				return;
			}
		}
		catch(IOException ex)
		{
			registry_explorer.doError(ex);
		}

		completed = true;

		hide();
	}

	void buttonOk_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			done();
		}
		else if(chr == 27)
		{
			cancel();
		}
	}

	void buttonCancel_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n')
		{
			cancel();
		}
		else if(chr == 27)
		{
			cancel();
		}
	}

	void jTextFieldKey_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == 27)
		{
			cancel();
			return;
		}

		String key = jTextFieldKey.getText().trim();

		int length = key.trim().length();

		if(chr == 0x08)
		{
			length--;
		}
		else if(!Character.isSpace(chr))
		{
			length++;
		}

		if(jTextFieldKey.getSelectionEnd() > 0)
		{
			length -= (jTextFieldKey.getSelectionEnd() - jTextFieldKey.getSelectionStart());
		}

		if(length > 0)
		{
			buttonOk.setEnabled(true);

			if(chr == '\n')
			{
				done();
			}
		}
		else
		{
			buttonOk.setEnabled(false);
		}
	}

	void this_componentShown(ComponentEvent e)
	{
		completed = false;
		jTextFieldKey.grabFocus();
	}
}