/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.Serializable;

public class AddressBookEntry implements Serializable
{
	public Long id;

	public String category;
	public String title;
	public String first_name;
	public String middle_initial;
	public String last_name;
	public String nick_name;

	public String company_name;
	public String business_address_line1;
	public String business_address_line2;
	public String business_city;
	public String business_state;
	public String business_zipcode;
	public String business_country;
	public String job_title;
	public String department;
	public String office;
	public String business_phone_number;
	public String business_fax_number;
	public String business_pager_number;
	public String business_mobile_number;
	public String business_website;
	public String business_email_address;
	public String business_imessenger_address;

	public String home_address_line1;
	public String home_address_line2;
	public String home_city;
	public String home_state;
	public String home_zipcode;
	public String home_country;
	public String home_phone_number;
	public String home_fax_number;
	public String home_pager_number;
	public String home_mobile_number;
	public String home_website;
	public String home_email_address;
	public String home_imessenger_address;

	public String spouse;
	public String children;
	public String birthday;
	public String anniversary;
	public String notes;

	public String toString()
	{
		if(last_name.length() == 0)
		{
			return company_name;
		}

		StringBuffer sb = new StringBuffer();

		sb.append(last_name);
		sb.append(", ");
		sb.append(first_name);

		if(middle_initial.length() > 0)
		{
			sb.append(' ');
			sb.append(middle_initial);
			sb.append('.');
		}

		if(nick_name.length() > 0)
		{
			sb.append(" (");
			sb.append(nick_name);
			sb.append(')');
		}

		return sb.toString();
	}
}