/*
 * Decompiled with CFR 0.152.
 */
package stec.xpos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Stack;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.xpos.Index;
import stec.xpos.IndexReference;
import stec.xpos.IndexStoreInstance;
import stec.xpos.KeysIndexInstance;
import stec.xpos.ValuesIndexInstance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckIndex {
    private boolean case;
    private boolean new;
    private boolean b;
    private boolean try = true;
    private IndexReference for;
    private boolean goto;
    private boolean null;
    private boolean if;
    private long else;
    private long int;
    private long c;
    private long d;
    private long e;
    private long byte;
    private long a;
    private long long;
    private long do;
    private long void;
    private boolean char;

    public static final void main(String[] stringArray) throws Throwable {
        Common.logo("Persistent Index Checker");
        if (stringArray.length < 1) {
            System.out.println("Usage: <java> stec.xpos.CheckIndex <options> <index>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-d            do not display progress");
            System.out.println("-l            check links");
            System.out.println("-u            display utilization");
            System.out.println("-v            verbose messages");
            return;
        }
        CheckIndex.check(stringArray);
    }

    public static final boolean check(String[] stringArray) throws Throwable {
        String string;
        int n;
        CheckIndex checkIndex = new CheckIndex();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).charAt(0) == '-'; ++n) {
            if (string.equalsIgnoreCase("-d")) {
                checkIndex.try = false;
                continue;
            }
            if (string.equalsIgnoreCase("-l")) {
                checkIndex.new = true;
                continue;
            }
            if (string.equalsIgnoreCase("-u")) {
                checkIndex.b = true;
                continue;
            }
            if (string.equalsIgnoreCase("-v")) {
                checkIndex.case = true;
                continue;
            }
            System.out.println("Invalid parameter: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (n >= n2) {
            System.out.println("Index was not specified.");
            return false;
        }
        try {
            if (!checkIndex.a(stringArray[n])) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            throw Common.getRootCause(exception);
        }
        return true;
    }

    public static final boolean check(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        int n = stringArray2.length;
        String[] stringArray3 = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            System.out.print(String.valueOf(String.valueOf(string)).concat(": "));
            stringArray3[n] = string;
            try {
                boolean bl2 = CheckIndex.check(stringArray3);
                if (bl2) {
                    System.out.println("PASSED");
                    continue;
                }
                bl = false;
                System.out.println("FAILED");
                continue;
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("FAILED");
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    private final boolean a(RandomAccessFile randomAccessFile, String string) throws IOException {
        int n = randomAccessFile.readInt();
        if (this.case) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor count: ").append(n))));
        }
        if (n < 1) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor count must be at least one (1): ").append(n))));
            return false;
        }
        for (int i = 0; i < n; ++i) {
            File file;
            String string2 = randomAccessFile.readUTF();
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor file name: ").append(string2))));
            }
            if (!(file = new File(string2)).exists()) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor filename must not be a directory: ").append(string2))));
                return false;
            }
            if (file.isDirectory()) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor filename must not be a directory: ").append(string2))));
                return false;
            }
            long l = randomAccessFile.readLong();
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count: ").append(l))));
            }
            if (i == n - 1) {
                if (l >= (long)1 || l == (long)-1) continue;
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count must be at least one (1): ").append(l))));
                return false;
            }
            if (l >= (long)1) continue;
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count must be at least one (1): ").append(l))));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean a(String string) throws Exception {
        block67: {
            boolean bl;
            block66: {
                boolean bl2;
                block65: {
                    boolean bl3;
                    block64: {
                        boolean bl4;
                        block63: {
                            boolean bl5;
                            block62: {
                                boolean bl6;
                                block61: {
                                    boolean bl7;
                                    block60: {
                                        boolean bl8;
                                        block59: {
                                            boolean bl9;
                                            block58: {
                                                boolean bl10;
                                                block57: {
                                                    boolean bl11;
                                                    block56: {
                                                        boolean bl12;
                                                        block55: {
                                                            boolean bl13;
                                                            block54: {
                                                                boolean bl14;
                                                                block53: {
                                                                    boolean bl15;
                                                                    block52: {
                                                                        boolean bl16;
                                                                        block51: {
                                                                            RandomAccessFile randomAccessFile;
                                                                            block49: {
                                                                                boolean bl17;
                                                                                block50: {
                                                                                    boolean bl18;
                                                                                    block48: {
                                                                                        boolean bl19;
                                                                                        block47: {
                                                                                            boolean bl20;
                                                                                            block46: {
                                                                                                boolean bl21;
                                                                                                block45: {
                                                                                                    boolean bl22;
                                                                                                    block44: {
                                                                                                        File file;
                                                                                                        if (this.case) {
                                                                                                            System.out.println("Checking index");
                                                                                                        }
                                                                                                        if (this.case) {
                                                                                                            System.out.println("Index: ".concat(String.valueOf(String.valueOf(string))));
                                                                                                        }
                                                                                                        if (!(file = new File(string)).exists()) {
                                                                                                            System.out.println("Index does not exist: ".concat(String.valueOf(String.valueOf(string))));
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (file.isDirectory()) {
                                                                                                            System.out.println("Index can not be a directory: ".concat(String.valueOf(String.valueOf(string))));
                                                                                                            return false;
                                                                                                        }
                                                                                                        long l = file.length();
                                                                                                        if (this.case) {
                                                                                                            System.out.println("Index file length: ".concat(String.valueOf(String.valueOf(l))));
                                                                                                        }
                                                                                                        if (l < (long)4) {
                                                                                                            System.out.println("Index file length is too small.");
                                                                                                            System.out.println("Mimimum index file length: 4");
                                                                                                            System.out.println("Current index file length: ".concat(String.valueOf(String.valueOf(l))));
                                                                                                            return false;
                                                                                                        }
                                                                                                        randomAccessFile = new RandomAccessFile(string, "r");
                                                                                                        try {
                                                                                                            randomAccessFile.seek(0L);
                                                                                                            byte by = randomAccessFile.readByte();
                                                                                                            if (by != 11) {
                                                                                                                System.out.println("Index type mismatch.");
                                                                                                                System.out.println("Required index type: 11");
                                                                                                                System.out.println("Current index type: ".concat(String.valueOf(String.valueOf(by))));
                                                                                                                bl22 = false;
                                                                                                                Object var11_8 = null;
                                                                                                                break block44;
                                                                                                            }
                                                                                                            short s = randomAccessFile.readShort();
                                                                                                            if (s != 256) {
                                                                                                                System.out.println("Index version mismatch.");
                                                                                                                System.out.println("Required index version: 256");
                                                                                                                System.out.println("Current index version: ".concat(String.valueOf(String.valueOf(s))));
                                                                                                                bl21 = false;
                                                                                                                break block45;
                                                                                                            }
                                                                                                            byte by2 = randomAccessFile.readByte();
                                                                                                            this.goto = (by2 & 1) == 1;
                                                                                                            this.null = (by2 & 2) == 2;
                                                                                                            boolean bl23 = this.if = (by2 & 4) == 4;
                                                                                                            if (!this.a(randomAccessFile, "Index")) {
                                                                                                                bl20 = false;
                                                                                                                break block46;
                                                                                                            }
                                                                                                            if (this.goto && !this.a(randomAccessFile, "Keys store")) {
                                                                                                                bl19 = false;
                                                                                                                break block47;
                                                                                                            }
                                                                                                            if (this.if && !this.a(randomAccessFile, "Values index")) {
                                                                                                                bl18 = false;
                                                                                                                break block48;
                                                                                                            }
                                                                                                            if (!this.null || this.a(randomAccessFile, "Values store")) break block49;
                                                                                                            bl17 = false;
                                                                                                            break block50;
                                                                                                        }
                                                                                                        catch (Throwable throwable) {
                                                                                                            Object var11_15 = null;
                                                                                                            randomAccessFile.close();
                                                                                                            throw throwable;
                                                                                                        }
                                                                                                    }
                                                                                                    randomAccessFile.close();
                                                                                                    return bl22;
                                                                                                }
                                                                                                Object var11_9 = null;
                                                                                                randomAccessFile.close();
                                                                                                return bl21;
                                                                                            }
                                                                                            Object var11_10 = null;
                                                                                            randomAccessFile.close();
                                                                                            return bl20;
                                                                                        }
                                                                                        Object var11_11 = null;
                                                                                        randomAccessFile.close();
                                                                                        return bl19;
                                                                                    }
                                                                                    Object var11_12 = null;
                                                                                    randomAccessFile.close();
                                                                                    return bl18;
                                                                                }
                                                                                Object var11_13 = null;
                                                                                randomAccessFile.close();
                                                                                return bl17;
                                                                            }
                                                                            Object var11_14 = null;
                                                                            randomAccessFile.close();
                                                                            if (this.case) {
                                                                                System.out.println();
                                                                            }
                                                                            this.for = Index.if(string);
                                                                            if (this.for == null) {
                                                                                System.out.println("Index is in use: ".concat(String.valueOf(String.valueOf(string))));
                                                                                return false;
                                                                            }
                                                                            try {
                                                                                if (!this.null()) {
                                                                                    bl16 = false;
                                                                                    Object var14_39 = null;
                                                                                    break block51;
                                                                                }
                                                                                if (this.goto && !this.if(this.for.H.do.s, "key")) {
                                                                                    bl15 = false;
                                                                                    break block52;
                                                                                }
                                                                                if (this.if && !this.char()) {
                                                                                    bl14 = false;
                                                                                    break block53;
                                                                                }
                                                                                if (this.null) {
                                                                                    if (this.if) {
                                                                                        if (!this.if(this.for.H.do.H.new, "value")) {
                                                                                            bl13 = false;
                                                                                            break block54;
                                                                                        }
                                                                                    } else if (!this.if(this.for.H.do.char, "value")) {
                                                                                        bl12 = false;
                                                                                        break block55;
                                                                                    }
                                                                                }
                                                                                if (!this.void()) {
                                                                                    bl11 = false;
                                                                                    break block56;
                                                                                }
                                                                                if (this.goto && !this.a(this.for.H.do.s, "key")) {
                                                                                    bl10 = false;
                                                                                    break block57;
                                                                                }
                                                                                if (this.if && !this.else()) {
                                                                                    bl9 = false;
                                                                                    break block58;
                                                                                }
                                                                                if (this.null) {
                                                                                    if (this.if) {
                                                                                        if (!this.a(this.for.H.do.H.new, "value")) {
                                                                                            bl8 = false;
                                                                                            break block59;
                                                                                        }
                                                                                    } else if (!this.a(this.for.H.do.char, "value")) {
                                                                                        bl7 = false;
                                                                                        break block60;
                                                                                    }
                                                                                }
                                                                                if (this.new) {
                                                                                    if (!this.do()) {
                                                                                        bl6 = false;
                                                                                        break block61;
                                                                                    }
                                                                                    if (this.goto && !this.for()) {
                                                                                        bl5 = false;
                                                                                        break block62;
                                                                                    }
                                                                                    if (this.if && !this.int()) {
                                                                                        bl4 = false;
                                                                                        break block63;
                                                                                    }
                                                                                    if (this.null) {
                                                                                        if (this.if) {
                                                                                            if (!this.case()) {
                                                                                                bl3 = false;
                                                                                                break block64;
                                                                                            }
                                                                                        } else if (!this.new()) {
                                                                                            bl2 = false;
                                                                                            break block65;
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (!this.long()) {
                                                                                    bl = false;
                                                                                    break block66;
                                                                                }
                                                                                this.goto();
                                                                                if (this.b) {
                                                                                    this.a();
                                                                                }
                                                                                break block67;
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var14_56 = null;
                                                                                this.for.close();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        this.for.close();
                                                                        return bl16;
                                                                    }
                                                                    Object var14_40 = null;
                                                                    this.for.close();
                                                                    return bl15;
                                                                }
                                                                Object var14_41 = null;
                                                                this.for.close();
                                                                return bl14;
                                                            }
                                                            Object var14_42 = null;
                                                            this.for.close();
                                                            return bl13;
                                                        }
                                                        Object var14_43 = null;
                                                        this.for.close();
                                                        return bl12;
                                                    }
                                                    Object var14_44 = null;
                                                    this.for.close();
                                                    return bl11;
                                                }
                                                Object var14_45 = null;
                                                this.for.close();
                                                return bl10;
                                            }
                                            Object var14_46 = null;
                                            this.for.close();
                                            return bl9;
                                        }
                                        Object var14_47 = null;
                                        this.for.close();
                                        return bl8;
                                    }
                                    Object var14_48 = null;
                                    this.for.close();
                                    return bl7;
                                }
                                Object var14_49 = null;
                                this.for.close();
                                return bl6;
                            }
                            Object var14_50 = null;
                            this.for.close();
                            return bl5;
                        }
                        Object var14_51 = null;
                        this.for.close();
                        return bl4;
                    }
                    Object var14_52 = null;
                    this.for.close();
                    return bl3;
                }
                Object var14_53 = null;
                this.for.close();
                return bl2;
            }
            Object var14_54 = null;
            this.for.close();
            return bl;
        }
        Object var14_55 = null;
        this.for.close();
        return true;
    }

    private final boolean null() throws Exception {
        block100: {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.case) {
                System.out.println("Checking index header");
            }
            KeysIndexInstance keysIndexInstance = this.for.H.do;
            if (this.case) {
                System.out.println("Index type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.W))));
            }
            if (keysIndexInstance.W != 12) {
                System.out.println("Index type mismatch.");
                System.out.println("Required index type: 12");
                System.out.println("Current index type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.W))));
                return false;
            }
            if (this.case) {
                System.out.println("Index version: ".concat(String.valueOf(String.valueOf(keysIndexInstance.M))));
            }
            if (keysIndexInstance.M != 256) {
                System.out.println("Index version mismatch.");
                System.out.println("Required index version: 256");
                System.out.println("Current index version: ".concat(String.valueOf(String.valueOf(keysIndexInstance.M))));
                return false;
            }
            if (this.case) {
                System.out.println("Index flags: ".concat(String.valueOf(String.valueOf(keysIndexInstance.L))));
            }
            if (this.case) {
                System.out.println("Index key class name: ".concat(String.valueOf(String.valueOf(keysIndexInstance.p))));
            }
            if (keysIndexInstance.p == null) {
                System.out.println("Index key class name cannot be null.");
                return false;
            }
            if (keysIndexInstance.p.length() == 0) {
                System.out.println("Index key class name cannot be empty.");
                return false;
            }
            if (keysIndexInstance.p.equals("java.lang.Byte")) {
                n4 = 1;
                n3 = 1;
            } else if (keysIndexInstance.p.equals("java.lang.Character")) {
                n4 = 2;
                n3 = 2;
            } else if (keysIndexInstance.p.equals("java.lang.Short")) {
                n4 = 3;
                n3 = 2;
            } else if (keysIndexInstance.p.equals("java.lang.Integer")) {
                n4 = 4;
                n3 = 4;
            } else if (keysIndexInstance.p.equals("java.lang.Long")) {
                n4 = 5;
                n3 = 8;
            } else if (keysIndexInstance.p.equals("java.lang.Float")) {
                n4 = 6;
                n3 = 4;
            } else if (keysIndexInstance.p.equals("java.lang.Double")) {
                n4 = 7;
                n3 = 8;
            } else if (keysIndexInstance.p.equals("java.util.Date")) {
                n4 = 12;
                n3 = 8;
            } else if (keysIndexInstance.p.equals("java.math.BigInteger")) {
                n4 = 13;
                n3 = 12;
            } else if (keysIndexInstance.p.equals("java.math.BigDecimal")) {
                n4 = 14;
                n3 = 12;
            } else if (keysIndexInstance.p.equals("java.lang.String")) {
                n4 = 8;
                n3 = 12;
            } else if (keysIndexInstance.p.equals("stec.pos.Blob")) {
                n4 = 11;
                n3 = 12;
            } else if (keysIndexInstance.p.equals("[B")) {
                n4 = 15;
                n3 = 12;
            } else {
                if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(keysIndexInstance.p))) {
                    System.out.println("Index key class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(keysIndexInstance.p))));
                    return false;
                }
                n4 = 9;
                n3 = 12;
            }
            if (this.case) {
                System.out.println("Index key entry type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.do))));
            }
            if (this.case) {
                System.out.println("Index key entry length: ".concat(String.valueOf(String.valueOf(keysIndexInstance.q))));
            }
            if (keysIndexInstance.do != n4) {
                System.out.println("Index key entry type does not match key class.");
                System.out.println("Estimated key entry type: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Current key entry type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.do))));
                return false;
            }
            if (keysIndexInstance.q != n3) {
                System.out.println("Index key entry length does not match key class.");
                System.out.println("Estimated key entry length: ".concat(String.valueOf(String.valueOf(n3))));
                System.out.println("Current key entry length: ".concat(String.valueOf(String.valueOf(keysIndexInstance.q))));
                return false;
            }
            if (this.case) {
                System.out.println("Index value class name: ".concat(String.valueOf(String.valueOf(keysIndexInstance.k))));
            }
            if (keysIndexInstance.k == null) {
                System.out.println("Index value class name cannot be null.");
                return false;
            }
            if (keysIndexInstance.k.length() == 0) {
                System.out.println("Index value class name cannot be empty.");
                return false;
            }
            if (keysIndexInstance.P) {
                n2 = -1;
                n = 12;
            } else if (keysIndexInstance.k.equals("java.lang.Byte")) {
                n2 = 1;
                n = 1;
            } else if (keysIndexInstance.k.equals("java.lang.Boolean")) {
                n2 = 10;
                n = 1;
            } else if (keysIndexInstance.k.equals("java.lang.Character")) {
                n2 = 2;
                n = 2;
            } else if (keysIndexInstance.k.equals("java.lang.Short")) {
                n2 = 3;
                n = 2;
            } else if (keysIndexInstance.k.equals("java.lang.Integer")) {
                n2 = 4;
                n = 4;
            } else if (keysIndexInstance.k.equals("java.lang.Long")) {
                n2 = 5;
                n = 8;
            } else if (keysIndexInstance.k.equals("java.lang.Float")) {
                n2 = 6;
                n = 4;
            } else if (keysIndexInstance.k.equals("java.lang.Double")) {
                n2 = 7;
                n = 8;
            } else if (keysIndexInstance.k.equals("java.util.Date")) {
                n2 = 12;
                n = 8;
            } else if (keysIndexInstance.k.equals("java.math.BigInteger")) {
                n2 = 13;
                n = 12;
            } else if (keysIndexInstance.k.equals("java.math.BigDecimal")) {
                n2 = 14;
                n = 12;
            } else if (keysIndexInstance.k.equals("java.lang.String")) {
                n2 = 8;
                n = 12;
            } else if (keysIndexInstance.k.equals("stec.pos.Blob")) {
                n2 = 11;
                n = 12;
            } else if (keysIndexInstance.k.equals("[B")) {
                n2 = 15;
                n = 12;
            } else {
                if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(keysIndexInstance.k))) {
                    System.out.println("Index value class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(keysIndexInstance.k))));
                    return false;
                }
                n2 = 9;
                n = 12;
            }
            if (this.case) {
                System.out.println("Index value entry type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.v))));
            }
            if (keysIndexInstance.v != n2) {
                System.out.println("Index value entry type does not match value class.");
                System.out.println("Estimated value entry type: ".concat(String.valueOf(String.valueOf(n2))));
                System.out.println("Current value entry type: ".concat(String.valueOf(String.valueOf(keysIndexInstance.v))));
                return false;
            }
            if (this.case) {
                System.out.println("Index value entry length: ".concat(String.valueOf(String.valueOf(keysIndexInstance.O))));
            }
            if (keysIndexInstance.O != n) {
                System.out.println("Index value entry length does not match value class.");
                System.out.println("Estimated value entry length: ".concat(String.valueOf(String.valueOf(n))));
                System.out.println("Current value entry length: ".concat(String.valueOf(String.valueOf(keysIndexInstance.O))));
                return false;
            }
            if (this.case) {
                System.out.println("Index order: ".concat(String.valueOf(String.valueOf(keysIndexInstance.u))));
            }
            if (keysIndexInstance.u < 2) {
                System.out.println("Index order must be at least two (2): ".concat(String.valueOf(String.valueOf(keysIndexInstance.u))));
                return false;
            }
            if (this.case) {
                System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.else))));
            }
            if (this.case) {
                System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.y))));
            }
            if (keysIndexInstance.y < (long)0) {
                System.out.println("Index page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(keysIndexInstance.y))));
                return false;
            }
            if (keysIndexInstance.else != (long)-1 && keysIndexInstance.y > keysIndexInstance.else) {
                System.out.println("Index page count exceeds maximum page count.");
                System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.else))));
                System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.y))));
                return false;
            }
            if (this.case) {
                System.out.println("Index root page number: ".concat(String.valueOf(String.valueOf(keysIndexInstance.Q))));
            }
            if (keysIndexInstance.Q < (long)0 && keysIndexInstance.Q != (long)-1) {
                System.out.println("Index root page number is not valid: ".concat(String.valueOf(String.valueOf(keysIndexInstance.Q))));
                return false;
            }
            if (keysIndexInstance.Q != (long)-1 && keysIndexInstance.else != (long)-1 && keysIndexInstance.Q > keysIndexInstance.else) {
                System.out.println("Index root page number exceeds maximum page count.");
                System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.else))));
                System.out.println("Index root page number: ".concat(String.valueOf(String.valueOf(keysIndexInstance.Q))));
                return false;
            }
            long l = keysIndexInstance.byte;
            if (this.case) {
                System.out.println("Index free list page number: ".concat(String.valueOf(String.valueOf(l))));
            }
            if (l < (long)-1) {
                System.out.println("Index free list page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= keysIndexInstance.y) {
                System.out.println("Index free list page number exceeds page count.");
                System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.y))));
                System.out.println("Index free list page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (this.case) {
                System.out.println("Index free count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.z))));
            }
            if (this.case) {
                System.out.println("Index total entry count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.int))));
            }
            if (keysIndexInstance.int < (long)0) {
                System.out.println("Index total entry count must be at least zero (0): ".concat(String.valueOf(String.valueOf(keysIndexInstance.int))));
                return false;
            }
            long l2 = 0L;
            int n5 = keysIndexInstance.n.length;
            for (int i = 0; i < n5; ++i) {
                File file;
                long l3;
                long l4;
                String string = keysIndexInstance.n[i].if;
                long l5 = keysIndexInstance.n[i].a;
                if (i == n5 - 1) {
                    if (l5 < (long)1 && l5 != (long)-1) {
                        System.out.println("Index maximum page count must be greater or equal to 1.");
                        System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                        System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                        return false;
                    }
                } else if (l5 < (long)1) {
                    System.out.println("Index maximum page count must be greater or equal to 1.");
                    System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                    return false;
                }
                l2 = l5 == (long)-1 ? -1L : (l2 += l5);
                if (l5 == (long)-1 || (l4 = i == 0 ? 11L + (long)keysIndexInstance.V + l5 * (long)keysIndexInstance.h : 11L + l5 * (long)keysIndexInstance.h) == (l3 = (file = new File(string)).length())) continue;
                System.out.println("Index file length is not correct.");
                System.out.println("Current index file length: ".concat(String.valueOf(String.valueOf(l3))));
                System.out.println("Estimated index file length: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            if (this.case) {
                System.out.println("Index total page count: ".concat(String.valueOf(String.valueOf(l2))));
            }
            if (l2 != keysIndexInstance.else) {
                System.out.println("Index maximum page count is not correct.");
                System.out.println("Current index maximum page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.else))));
                System.out.println("Estimated index maximum page count: ".concat(String.valueOf(String.valueOf(l2))));
                return false;
            }
            if (!this.case) break block100;
            System.out.println();
        }
        return true;
    }

    private final boolean if(IndexStoreInstance indexStoreInstance, String string) throws Exception {
        block25: {
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Checking ").append(string).append(" store header"))));
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store type: ").append(indexStoreInstance.if))));
            }
            if (indexStoreInstance.if != 13) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" store type mismatch."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Required ").append(string).append(" store type: ").append(13))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store type: ").append(indexStoreInstance.if))));
                return false;
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store version: ").append(indexStoreInstance.do))));
            }
            if (indexStoreInstance.do != 256) {
                System.out.println(String.valueOf(String.valueOf(string)).concat("store version mismatch."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Required ").append(string).append(" store version: ").append(256))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store version: ").append(indexStoreInstance.do))));
                return false;
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page length: ").append(indexStoreInstance.a))));
            }
            if (indexStoreInstance.a < 1) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page length must be at least one (1): ").append(indexStoreInstance.a))));
                return false;
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store maximum page count: ").append(indexStoreInstance.i))));
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count: ").append(indexStoreInstance.e))));
            }
            if (indexStoreInstance.e < (long)0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count must be at least zero (0): ").append(indexStoreInstance.e))));
                return false;
            }
            if (indexStoreInstance.i != (long)-1 && indexStoreInstance.e > indexStoreInstance.i) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" store page count exceeds maximum page count."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store maximum page count: ").append(indexStoreInstance.i))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count: ").append(indexStoreInstance.e))));
                return false;
            }
            long l = indexStoreInstance.case;
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free list page number: ").append(l))));
            }
            if (l < (long)-1) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free list is not valid: ").append(l))));
                return false;
            }
            if (l >= indexStoreInstance.e) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" free list page number exceeds page count."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" file list page count: ").append(indexStoreInstance.e))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("file list page number: ").append(l))));
                return false;
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free count: ").append(indexStoreInstance.h))));
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count: ").append(indexStoreInstance.c))));
            }
            if (indexStoreInstance.c < (long)0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count must be at least zero (0): ").append(indexStoreInstance.c))));
                return false;
            }
            if (indexStoreInstance.c > indexStoreInstance.e) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" record count exceeds page count."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page count: ").append(indexStoreInstance.e))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count: ").append(indexStoreInstance.c))));
                return false;
            }
            long l2 = 0L;
            int n = indexStoreInstance.k.length;
            for (int i = 0; i < n; ++i) {
                File file;
                long l3;
                long l4;
                String string2 = indexStoreInstance.k[i].if;
                long l5 = indexStoreInstance.k[i].a;
                if (i == n - 1) {
                    if (l5 < (long)1 && l5 != (long)-1) {
                        System.out.println(String.valueOf(String.valueOf(string)).concat(" maximum page count must be greater or equal to 1."));
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" maximum page count: ").append(l5))));
                        System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string2))));
                        return false;
                    }
                } else if (l5 < (long)1) {
                    System.out.println(String.valueOf(String.valueOf(string)).concat(" maximum page count must be greater or equal to 1."));
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" maximum page count: ").append(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string2))));
                    return false;
                }
                l2 = l5 == (long)-1 ? -1L : (l2 += l5);
                if (l5 == (long)-1 || (l4 = i == 0 ? 58L + l5 * (long)(9 + indexStoreInstance.a) : 11L + l5 * (long)(9 + indexStoreInstance.a)) == (l3 = (file = new File(string2)).length())) continue;
                System.out.println(String.valueOf(String.valueOf(string)).concat(" file length is not correct."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" file length: ").append(l3))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimated ").append(string).append(" file length: ").append(l4))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string2))));
                return false;
            }
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" total page count: ").append(l2))));
            }
            if (l2 != indexStoreInstance.i) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" maximum page count is not correct."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" maximum page count: ").append(indexStoreInstance.i))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimated ").append(string).append(" maximum page count: ").append(l2))));
                return false;
            }
            if (!this.case) break block25;
            System.out.println();
        }
        return true;
    }

    private final boolean char() throws Exception {
        block56: {
            int n;
            int n2;
            if (this.case) {
                System.out.println("Checking values index header");
            }
            ValuesIndexInstance valuesIndexInstance = this.for.H.do.H;
            if (this.case) {
                System.out.println("Values index type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.J))));
            }
            if (valuesIndexInstance.J != 14) {
                System.out.println("Values index type mismatch.");
                System.out.println("Required values index type: 14");
                System.out.println("Current values index type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.J))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index version: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.A))));
            }
            if (valuesIndexInstance.A != 256) {
                System.out.println("Values index version mismatch.");
                System.out.println("Required values index version: 256");
                System.out.println("Current values index version: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.A))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index flags: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.z))));
            }
            if (valuesIndexInstance.f.equals("java.lang.Byte")) {
                n2 = 1;
                n = 1;
            } else if (valuesIndexInstance.f.equals("java.lang.Boolean")) {
                n2 = 10;
                n = 1;
            } else if (valuesIndexInstance.f.equals("java.lang.Character")) {
                n2 = 2;
                n = 2;
            } else if (valuesIndexInstance.f.equals("java.lang.Short")) {
                n2 = 3;
                n = 2;
            } else if (valuesIndexInstance.f.equals("java.lang.Integer")) {
                n2 = 4;
                n = 4;
            } else if (valuesIndexInstance.f.equals("java.lang.Long")) {
                n2 = 5;
                n = 8;
            } else if (valuesIndexInstance.f.equals("java.lang.Float")) {
                n2 = 6;
                n = 4;
            } else if (valuesIndexInstance.f.equals("java.lang.Double")) {
                n2 = 7;
                n = 8;
            } else if (valuesIndexInstance.f.equals("java.util.Date")) {
                n2 = 12;
                n = 8;
            } else if (valuesIndexInstance.f.equals("java.math.BigInteger")) {
                n2 = 13;
                n = 12;
            } else if (valuesIndexInstance.f.equals("java.math.BigDecimal")) {
                n2 = 14;
                n = 12;
            } else if (valuesIndexInstance.f.equals("java.lang.String")) {
                n2 = 8;
                n = 12;
            } else if (valuesIndexInstance.f.equals("stec.pos.Blob")) {
                n2 = 11;
                n = 12;
            } else if (valuesIndexInstance.f.equals("[B")) {
                n2 = 15;
                n = 12;
            } else {
                if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(valuesIndexInstance.f))) {
                    System.out.println("Values index value class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.f))));
                    return false;
                }
                n2 = 9;
                n = 12;
            }
            if (this.case) {
                System.out.println("Values index value entry type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.m))));
            }
            if (valuesIndexInstance.m != n2) {
                System.out.println("Values index value entry type does not match value class.");
                System.out.println("Estimated values index entry type: ".concat(String.valueOf(String.valueOf(n2))));
                System.out.println("Current values index entry type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.m))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index value entry length: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.C))));
            }
            if (valuesIndexInstance.C != n) {
                System.out.println("Values index value entry length does not match value class.");
                System.out.println("Estimated values index entry length: ".concat(String.valueOf(String.valueOf(n))));
                System.out.println("Current values index entry length: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.C))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index order: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l))));
            }
            if (valuesIndexInstance.l < 2) {
                System.out.println("Values index order must be at least two (2): ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.byte))));
            }
            if (this.case) {
                System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
            }
            if (valuesIndexInstance.o < (long)0) {
                System.out.println("Values index page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
                return false;
            }
            if (valuesIndexInstance.byte != (long)-1 && valuesIndexInstance.o > valuesIndexInstance.byte) {
                System.out.println("Values index page count exceeds maximum page count.");
                System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.byte))));
                System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
                return false;
            }
            long l = valuesIndexInstance.try;
            if (this.case) {
                System.out.println("Values index free list page number: ".concat(String.valueOf(String.valueOf(l))));
            }
            if (l < (long)-1) {
                System.out.println("Values index free list page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= valuesIndexInstance.o) {
                System.out.println("Values index free list page number exceeds page count.");
                System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
                System.out.println("Values index free list page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index free count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.p))));
            }
            long l2 = 0L;
            int n3 = valuesIndexInstance.h.length;
            for (int i = 0; i < n3; ++i) {
                File file;
                long l3;
                long l4;
                String string = valuesIndexInstance.h[i].if;
                long l5 = valuesIndexInstance.h[i].a;
                if (i == n3 - 1) {
                    if (l5 < (long)1 && l5 != (long)-1) {
                        System.out.println("Values index maximum page count must be greater or equal to 1.");
                        System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                        System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                        return false;
                    }
                } else if (l5 < (long)1) {
                    System.out.println("Values index maximum page count must be greater or equal to 1.");
                    System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                    return false;
                }
                l2 = l5 == (long)-1 ? -1L : (l2 += l5);
                if (l5 == (long)-1 || (l4 = i == 0 ? 11L + (long)valuesIndexInstance.I + l5 * (long)valuesIndexInstance.c : 11L + l5 * (long)valuesIndexInstance.c) == (l3 = (file = new File(string)).length())) continue;
                System.out.println("Values index file length is not correct.");
                System.out.println("Current values index file length: ".concat(String.valueOf(String.valueOf(l3))));
                System.out.println("Estimated values index file length: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            if (this.case) {
                System.out.println("Values index total page count: ".concat(String.valueOf(String.valueOf(l2))));
            }
            if (l2 != valuesIndexInstance.byte) {
                System.out.println("Values index maximum page count is not correct.");
                System.out.println("Current values index maximum page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.byte))));
                System.out.println("Estimated values index maximum page count: ".concat(String.valueOf(String.valueOf(l2))));
                return false;
            }
            if (!this.case) break block56;
            System.out.println();
        }
        return true;
    }

    private final boolean void() throws IOException {
        if (this.case) {
            System.out.println("Checking index free list");
        }
        KeysIndexInstance keysIndexInstance = this.for.H.do;
        long l = keysIndexInstance.byte;
        long l2 = 0L;
        long l3 = keysIndexInstance.z;
        long l4 = keysIndexInstance.y;
        keysIndexInstance.E = keysIndexInstance.D;
        while (l != (long)-1) {
            ++l2;
            if (this.case && this.try) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                this.char = true;
            }
            if (l < (long)0) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Index page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= l4) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Index page exceeds page count.");
                System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            keysIndexInstance.a(l);
            byte by = ByteArray.getByte(keysIndexInstance.E, 0);
            if (by != 0) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Index page is not available.");
                System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            l = ByteArray.getLong(keysIndexInstance.E, 1);
        }
        if (this.char) {
            System.out.println();
            this.char = false;
        }
        if (l2 != keysIndexInstance.z) {
            System.out.println("Index free list page count is not correct.");
            System.out.println("Current index free list page count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.z))));
            System.out.println("Estimated index free list page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean a(IndexStoreInstance indexStoreInstance, String string) throws Exception {
        block11: {
            if (this.case) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Checking ").append(string).append(" free list"))));
            }
            long l = indexStoreInstance.case;
            long l2 = 0L;
            long l3 = indexStoreInstance.h;
            long l4 = indexStoreInstance.e;
            while (l != (long)-1) {
                ++l2;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                    this.char = true;
                }
                if (l < (long)0) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number is not valid: ").append(l))));
                    return false;
                }
                if (l >= l4) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println(String.valueOf(String.valueOf(string)).concat(" page exceeds page count."));
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page count: ").append(l4))));
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number: ").append(l))));
                    return false;
                }
                indexStoreInstance.int(l);
                byte by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by != 0) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println(String.valueOf(String.valueOf(string)).concat(" page is not available."));
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page flags: ").append(by))));
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number: ").append(l))));
                    return false;
                }
                l = ByteArray.getLong(indexStoreInstance.new, 1);
            }
            if (l2 != indexStoreInstance.h) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println(String.valueOf(String.valueOf(string)).concat(" free list page count is not correct."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" free list page count: ").append(indexStoreInstance.h))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimates ").append(string).append(" free list page count: ").append(l2))));
                return false;
            }
            if (!this.char) break block11;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final boolean else() throws Exception {
        if (this.case) {
            System.out.println("Checking values index free list");
        }
        ValuesIndexInstance valuesIndexInstance = this.for.H.do.H;
        long l = valuesIndexInstance.try;
        long l2 = 0L;
        long l3 = valuesIndexInstance.p;
        long l4 = valuesIndexInstance.o;
        valuesIndexInstance.u = valuesIndexInstance.t;
        while (l != (long)-1) {
            ++l2;
            if (this.case && this.try) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                this.char = true;
            }
            if (l < (long)0) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Values index page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= l4) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Values index page exceeds page count.");
                System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            valuesIndexInstance.a(l);
            byte by = ByteArray.getByte(valuesIndexInstance.u, 0);
            if (by != 0) {
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Values index page is not available.");
                System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            l = ByteArray.getLong(valuesIndexInstance.u, 1);
        }
        if (this.char) {
            System.out.println();
            this.char = false;
        }
        if (l2 != valuesIndexInstance.p) {
            System.out.println("Values index free list page count is not correct.");
            System.out.println("Current values index free list page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.p))));
            System.out.println("Estimated values index free list page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean long() throws IOException {
        if (this.case) {
            System.out.println("Checking index entries");
        }
        Object object = null;
        Object object2 = null;
        int n = 0;
        long l = this.for.size();
        boolean bl = true;
        this.for.first();
        while (this.for.next()) {
            Object object3 = this.for.getCurrentKey();
            ++n;
            if (this.case && this.try) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" - ").append(l).append(": ").append((int)((double)n / (double)l * 100.0)).append("%"))));
                this.char = true;
            }
            Object object4 = this.for.getCurrentValue();
            if (bl) {
                bl = false;
            } else {
                int n2 = this.for.H.do.do(object3, object);
                if (n2 == 0) {
                    if (!this.for.duplicates()) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Duplicates are not supported.");
                        System.out.println("Current key: ".concat(String.valueOf(String.valueOf(object3))));
                        System.out.println("Last key: ".concat(String.valueOf(String.valueOf(object))));
                        return false;
                    }
                } else if (n2 < 0) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    if (this.for.ascending()) {
                        System.out.println("Current key must be greater than last key.");
                    } else {
                        System.out.println("Current key must be less than last key.");
                    }
                    System.out.println("Current key: ".concat(String.valueOf(String.valueOf(object3))));
                    System.out.println("Last key: ".concat(String.valueOf(String.valueOf(object))));
                    return false;
                }
            }
            object = object3;
            object2 = object4;
        }
        if (this.char) {
            System.out.println();
            this.char = false;
        }
        if ((long)n != this.for.H.do.int) {
            System.out.println("Index entry count does not equal total entry count.");
            System.out.println("Current index total entry count: ".concat(String.valueOf(String.valueOf(this.for.H.do.int))));
            System.out.println("Estimates total entry count: ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        return true;
    }

    private final boolean do() throws IOException {
        block71: {
            byte by;
            if (this.case) {
                System.out.println("Checking index links");
            }
            KeysIndexInstance keysIndexInstance = this.for.H.do;
            keysIndexInstance.E = keysIndexInstance.D;
            if (keysIndexInstance.Q != (long)-1) {
                keysIndexInstance.a(keysIndexInstance.Q);
                by = ByteArray.getByte(keysIndexInstance.E, 0);
                if (by != 1) {
                    System.out.println("Index root page is not correct: ".concat(String.valueOf(String.valueOf(keysIndexInstance.Q))));
                    return false;
                }
            }
            long l = keysIndexInstance.y;
            for (long i = 0L; i < l; ++i) {
                byte by2;
                long l2;
                long l3;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l).append(": ").append((int)(((double)i + 1.0) / (double)l * 100.0)).append("%"))));
                    this.char = true;
                }
                keysIndexInstance.a(i);
                by = ByteArray.getByte(keysIndexInstance.E, 0);
                long l4 = ByteArray.getLong(keysIndexInstance.E, 1);
                if (l4 < (long)-1) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Index next page number is not correct.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 >= l) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Index next page number exceeds index page count.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == i) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Index next page number cannot be the same as the current page number.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by == 0) {
                    l3 = 0L;
                    l2 = keysIndexInstance.byte;
                    keysIndexInstance.E = keysIndexInstance.B;
                    while (l2 != (long)-1) {
                        if (l2 == i) {
                            ++l3;
                        }
                        keysIndexInstance.a(l2);
                        l2 = ByteArray.getLong(keysIndexInstance.E, 1);
                    }
                    keysIndexInstance.E = keysIndexInstance.D;
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Index page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Index page marked as available was found multiple times on free list.");
                        System.out.println("Index page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by == 1) {
                    long l5;
                    int n = ByteArray.getInt(keysIndexInstance.E, 9);
                    if (n > keysIndexInstance.u * 2) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Index entry count cannot exceed index order * 2 is not correct.");
                        System.out.println("Estimated index entry count: ".concat(String.valueOf(String.valueOf(keysIndexInstance.u * 2))));
                        System.out.println("Current index entry count: ".concat(String.valueOf(String.valueOf(n))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 != (long)-1) {
                        keysIndexInstance.E = keysIndexInstance.B;
                        keysIndexInstance.a(l4);
                        by2 = ByteArray.getByte(keysIndexInstance.E, 0);
                        if (by2 != by) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry next link is to a page whose flags are not the same.");
                            System.out.println("Index next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        keysIndexInstance.E = keysIndexInstance.D;
                    }
                    if (!this.a(i)) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Index page number could not be found.");
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    for (int j = 0; j < n; ++j) {
                        long l6;
                        int n2;
                        l5 = ByteArray.getLong(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 0);
                        if (l5 < (long)-1) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry previous page number is not correct.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(l5))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 >= l) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry previous page number exceeds page count.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(l5))));
                            System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(l))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 == i) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry previous page number cannot be the same as the current page number.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(l5))));
                            System.out.println("Index current page number: ".concat(String.valueOf(String.valueOf(i))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 != (long)-1) {
                            keysIndexInstance.E = keysIndexInstance.B;
                            keysIndexInstance.a(l5);
                            by2 = ByteArray.getByte(keysIndexInstance.E, 0);
                            if (by2 != by) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry previous link is to a page whose flags are not the same.");
                                System.out.println("Previous page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                                System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(l5))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            keysIndexInstance.E = keysIndexInstance.D;
                        }
                        if (this.goto) {
                            n2 = ByteArray.getInt(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + 8);
                            if (n2 < 0) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry key record length must be at least zero (0).");
                                System.out.println("Index entry key record length: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            l6 = ByteArray.getLong(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + 0);
                            if (l6 == (long)-1) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry key base page number is not correct.");
                                System.out.println("Index entry key base page number: ".concat(String.valueOf(String.valueOf(l6))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            keysIndexInstance.s.int(l6);
                            by2 = ByteArray.getByte(keysIndexInstance.s.new, 0);
                            if (by2 != 1) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry keys store base page number cannot reference a free page.");
                                System.out.println("Index entry keys store base page number: ".concat(String.valueOf(String.valueOf(l6))));
                                System.out.println("Index entry keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                        }
                        if (this.if) {
                            long l7 = ByteArray.getInt(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + keysIndexInstance.q + 8);
                            if (l7 < (long)1) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry values index record count must be at least one (1).");
                                System.out.println("Index entry values index record count: ".concat(String.valueOf(String.valueOf(l7))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            l6 = ByteArray.getLong(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + keysIndexInstance.q + 0);
                            if (l6 == (long)-1) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry values index base page number is not correct.");
                                System.out.println("Index entry values index base page number: ".concat(String.valueOf(String.valueOf(l6))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            keysIndexInstance.H.u = keysIndexInstance.H.t;
                            keysIndexInstance.H.a(l6);
                            by2 = ByteArray.getByte(keysIndexInstance.H.u, 0);
                            if (by2 != 1) {
                                if (this.char) {
                                    System.out.println();
                                    this.char = false;
                                }
                                System.out.println("Index entry values index base page number is not correct.");
                                System.out.println("Index entry values index base page number: ".concat(String.valueOf(String.valueOf(l6))));
                                System.out.println("Index entry values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            if (!this.null || (l3 = (long)this.if(l6)) == l7) continue;
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry values index record count is not correct.");
                            System.out.println("Estimated value count: ".concat(String.valueOf(String.valueOf(l3))));
                            System.out.println("Current value count: ".concat(String.valueOf(String.valueOf(l7))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (!this.null) continue;
                        n2 = ByteArray.getInt(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + keysIndexInstance.q + 8);
                        if (n2 < 0) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry value record length must be at least zero (0).");
                            System.out.println("Index entry value record length: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        l6 = ByteArray.getLong(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 8 + keysIndexInstance.q + 0);
                        if (l6 == (long)-1) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Index entry value base page number is not correct.");
                            System.out.println("Index entry value base page number: ".concat(String.valueOf(String.valueOf(l6))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        keysIndexInstance.char.int(l6);
                        by2 = ByteArray.getByte(keysIndexInstance.s.new, 0);
                        if (by2 == 1) continue;
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Index entry values store base page number is not correct.");
                        System.out.println("Index entry values store base page number: ".concat(String.valueOf(String.valueOf(l6))));
                        System.out.println("Index entry values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                        System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(j))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    l3 = 0L;
                    if (i == keysIndexInstance.byte) {
                        ++l3;
                    }
                    if (i == keysIndexInstance.Q) {
                        ++l3;
                    }
                    for (l2 = 0L; l2 < l; ++l2) {
                        if (i == l2) continue;
                        keysIndexInstance.E = keysIndexInstance.B;
                        keysIndexInstance.a(l2);
                        by2 = ByteArray.getByte(keysIndexInstance.E, 0);
                        if (by2 == 1) {
                            long l8 = ByteArray.getLong(keysIndexInstance.E, 1);
                            if (i == l8) {
                                ++l3;
                            }
                            n = ByteArray.getInt(keysIndexInstance.E, 9);
                            for (int j = 0; j < n; ++j) {
                                l5 = ByteArray.getLong(keysIndexInstance.E, 13 + keysIndexInstance.goto * j + 0);
                                if (i != l5) continue;
                                ++l3;
                            }
                        }
                        keysIndexInstance.E = keysIndexInstance.D;
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used page was found mapped to multiple index pages.");
                        System.out.println("Index page referecne count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Index page flags are not correct.");
                    System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == (long)-1) continue;
                keysIndexInstance.E = keysIndexInstance.B;
                keysIndexInstance.a(l4);
                by2 = ByteArray.getByte(keysIndexInstance.E, 0);
                if (by2 != by) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Index page next link is to a page whose flags are not the same.");
                    System.out.println("Index next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                keysIndexInstance.E = keysIndexInstance.D;
            }
            if (!this.char) break block71;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final boolean for() throws Exception {
        block29: {
            if (this.case) {
                System.out.println("Checking keys store links");
            }
            IndexStoreInstance indexStoreInstance = this.for.H.do.s;
            long l = indexStoreInstance.e;
            for (long i = 0L; i < l; ++i) {
                byte by;
                long l2;
                long l3;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l).append(": ").append((int)(((double)i + 1.0) / (double)l * 100.0)).append("%"))));
                    this.char = true;
                }
                indexStoreInstance.int(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                long l4 = ByteArray.getLong(indexStoreInstance.new, 1);
                if (l4 < (long)-1) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Keys store next page number is not correct.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 >= l) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Keys store next page number exceeds keys store page count.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == i) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Keys store next page number cannot be the same as the current page number.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    l3 = 0L;
                    l2 = indexStoreInstance.case;
                    while (l2 != (long)-1) {
                        if (l2 == i) {
                            ++l3;
                        }
                        indexStoreInstance.int(l2);
                        l2 = ByteArray.getLong(indexStoreInstance.new, 1);
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Keys store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Keys store page marked as available was found multiple times on free list.");
                        System.out.println("Keys store reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    l3 = 0L;
                    if (i == indexStoreInstance.case) {
                        ++l3;
                    }
                    for (l2 = 0L; l2 < l; ++l2) {
                        indexStoreInstance.int(l2);
                        long l5 = ByteArray.getLong(indexStoreInstance.new, 1);
                        if (i != l5) continue;
                        ++l3;
                    }
                    this.for.H.do.E = this.for.H.do.D;
                    long l6 = this.for.H.do.y;
                    for (l2 = 0L; l2 < l6; ++l2) {
                        this.for.H.do.a(l2);
                        by = ByteArray.getByte(this.for.H.do.E, 0);
                        if (by != 1) continue;
                        int n = ByteArray.getInt(this.for.H.do.E, 9);
                        for (int j = 0; j < n; ++j) {
                            long l7 = ByteArray.getLong(this.for.H.do.E, 13 + this.for.H.do.goto * j + 8 + 0);
                            int n2 = ByteArray.getInt(this.for.H.do.E, 13 + this.for.H.do.goto * j + 8 + 8);
                            if (i != l7) continue;
                            ++l3;
                        }
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used keys store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used keys store page was found mapped to multiple index entries.");
                        System.out.println("Keys store page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Keys store page flags are not correct.");
                    System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == (long)-1) continue;
                indexStoreInstance.int(l4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Keys store page next link is to a page whose flags are not the same.");
                System.out.println("Next keys store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next keys store page number: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.char) break block29;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final boolean new() throws Exception {
        block29: {
            if (this.case) {
                System.out.println("Checking values store links");
            }
            IndexStoreInstance indexStoreInstance = this.for.H.do.char;
            long l = indexStoreInstance.e;
            for (long i = 0L; i < l; ++i) {
                byte by;
                long l2;
                long l3;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l).append(": ").append((int)(((double)i + 1.0) / (double)l * 100.0)).append("%"))));
                    this.char = true;
                }
                indexStoreInstance.int(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                long l4 = ByteArray.getLong(indexStoreInstance.new, 1);
                if (l4 < (long)-1) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number is not correct.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 >= l) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number exceeds values store page count.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == i) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number cannot be the same as the current page number.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    l3 = 0L;
                    l2 = indexStoreInstance.case;
                    while (l2 != (long)-1) {
                        if (l2 == i) {
                            ++l3;
                        }
                        indexStoreInstance.int(l2);
                        l2 = ByteArray.getLong(indexStoreInstance.new, 1);
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values store page marked as available was found multiple times on free list.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    l3 = 0L;
                    if (i == indexStoreInstance.case) {
                        ++l3;
                    }
                    for (l2 = 0L; l2 < l; ++l2) {
                        indexStoreInstance.int(l2);
                        long l5 = ByteArray.getLong(indexStoreInstance.new, 1);
                        if (i != l5) continue;
                        ++l3;
                    }
                    this.for.H.do.E = this.for.H.do.D;
                    long l6 = this.for.H.do.y;
                    for (l2 = 0L; l2 < l6; ++l2) {
                        this.for.H.do.a(l2);
                        by = ByteArray.getByte(this.for.H.do.E, 0);
                        if (by != 1) continue;
                        int n = ByteArray.getInt(this.for.H.do.E, 9);
                        for (int j = 0; j < n; ++j) {
                            long l7 = ByteArray.getLong(this.for.H.do.E, 13 + this.for.H.do.goto * j + 8 + this.for.H.do.q + 0);
                            int n2 = ByteArray.getInt(this.for.H.do.E, 13 + this.for.H.do.goto * j + 8 + this.for.H.do.q + 8);
                            if (i != l7) continue;
                            ++l3;
                        }
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values store page was found mapped to multiple index entries.");
                        System.out.println("Values store reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == (long)-1) continue;
                indexStoreInstance.int(l4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Values store page next link is to a page whose flags are not the same.");
                System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.char) break block29;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final boolean case() throws Exception {
        block29: {
            if (this.case) {
                System.out.println("Checking values store links");
            }
            IndexStoreInstance indexStoreInstance = this.for.H.do.H.new;
            long l = indexStoreInstance.e;
            for (long i = 0L; i < l; ++i) {
                byte by;
                long l2;
                long l3;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l).append(": ").append((int)(((double)i + 1.0) / (double)l * 100.0)).append("%"))));
                    this.char = true;
                }
                indexStoreInstance.int(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                long l4 = ByteArray.getLong(indexStoreInstance.new, 1);
                if (l4 < (long)-1) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number is not correct.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 >= l) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number exceeds values store page count.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == i) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store next page number cannot be the same as the current page number.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    l3 = 0L;
                    l2 = indexStoreInstance.case;
                    while (l2 != (long)-1) {
                        if (l2 == i) {
                            ++l3;
                        }
                        indexStoreInstance.int(l2);
                        l2 = ByteArray.getLong(indexStoreInstance.new, 1);
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values store page marked as available was found multiple times on free list.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    l3 = 0L;
                    if (i == indexStoreInstance.case) {
                        ++l3;
                    }
                    for (l2 = 0L; l2 < l; ++l2) {
                        indexStoreInstance.int(l2);
                        long l5 = ByteArray.getLong(indexStoreInstance.new, 1);
                        if (i != l5) continue;
                        ++l3;
                    }
                    this.for.H.do.H.u = this.for.H.do.H.t;
                    long l6 = this.for.H.do.H.o;
                    for (l2 = 0L; l2 < l6; ++l2) {
                        this.for.H.do.H.a(l2);
                        by = ByteArray.getByte(this.for.H.do.H.u, 0);
                        if (by != 1) continue;
                        int n = ByteArray.getInt(this.for.H.do.H.u, 9);
                        for (int j = 0; j < n; ++j) {
                            long l7 = ByteArray.getLong(this.for.H.do.H.u, 13 + this.for.H.do.H.case * j + 8 + 0);
                            int n2 = ByteArray.getInt(this.for.H.do.H.u, 13 + this.for.H.do.H.case * j + 8 + 8);
                            if (i != l7) continue;
                            ++l3;
                        }
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values store page was found mapped to multiple index entries.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values store page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == (long)-1) continue;
                indexStoreInstance.int(l4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.char) {
                    System.out.println();
                    this.char = false;
                }
                System.out.println("Values store page next link is to a page whose flags are not the same.");
                System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values stores page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.char) break block29;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final boolean int() throws Exception {
        block47: {
            if (this.case) {
                System.out.println("Checking values index links");
            }
            ValuesIndexInstance valuesIndexInstance = this.for.H.do.H;
            valuesIndexInstance.u = valuesIndexInstance.t;
            long l = valuesIndexInstance.o;
            for (long i = 0L; i < l; ++i) {
                byte by;
                long l2;
                long l3;
                if (this.case && this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l).append(": ").append((int)(((double)i + 1.0) / (double)l * 100.0)).append("%"))));
                    this.char = true;
                }
                valuesIndexInstance.a(i);
                byte by2 = ByteArray.getByte(valuesIndexInstance.u, 0);
                long l4 = ByteArray.getLong(valuesIndexInstance.u, 1);
                if (l4 < (long)-1) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values index next page number is not correct.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 >= l) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values index next page number exceeds values index page count.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == i) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values index next page number cannot be the same as the current page number.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    l3 = 0L;
                    l2 = valuesIndexInstance.try;
                    valuesIndexInstance.u = valuesIndexInstance.r;
                    while (l2 != (long)-1) {
                        if (l2 == i) {
                            ++l3;
                        }
                        valuesIndexInstance.a(l2);
                        l2 = ByteArray.getLong(valuesIndexInstance.u, 1);
                    }
                    valuesIndexInstance.u = valuesIndexInstance.t;
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values index page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values index page marked as available was found multiple times on free list.");
                        System.out.println("Values index page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    int n;
                    long l5;
                    int n2 = ByteArray.getInt(valuesIndexInstance.u, 9);
                    if (n2 > valuesIndexInstance.l * 2) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Values index entry count cannot exceed values index order * 2 is not correct.");
                        System.out.println("Current values index entry count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l * 2))));
                        System.out.println("Estimates values index entry count: ".concat(String.valueOf(String.valueOf(n2))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 != (long)-1) {
                        valuesIndexInstance.u = valuesIndexInstance.r;
                        valuesIndexInstance.a(l4);
                        by = ByteArray.getByte(valuesIndexInstance.u, 0);
                        if (by != by2) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Values index entry next link is to a page whose flags are not the same.");
                            System.out.println("Values index next page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(l4))));
                            System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        valuesIndexInstance.u = valuesIndexInstance.t;
                    }
                    for (int j = 0; j < n2; ++j) {
                        l5 = ByteArray.getLong(valuesIndexInstance.u, 13 + valuesIndexInstance.case * j + 0);
                        if (l5 < (long)-1) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Values index entry previous page number is not correct.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(l4))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 >= l) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Values index entry previous page number exceeds values index entry page count.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(l4))));
                            System.out.println("Values index entry page count: ".concat(String.valueOf(String.valueOf(l))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 == i) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Values index entry previous page number cannot be the same as the current page number.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(l4))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (l5 == (long)-1) continue;
                        valuesIndexInstance.u = valuesIndexInstance.r;
                        valuesIndexInstance.a(l5);
                        by = ByteArray.getByte(valuesIndexInstance.u, 0);
                        if (by != by2) {
                            if (this.char) {
                                System.out.println();
                                this.char = false;
                            }
                            System.out.println("Values index entry previous link is to a page whose flags are not the same.");
                            System.out.println("Values index previous page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Values index previous page number: ".concat(String.valueOf(String.valueOf(l5))));
                            System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        valuesIndexInstance.u = valuesIndexInstance.t;
                    }
                    l3 = 0L;
                    if (i == valuesIndexInstance.try) {
                        ++l3;
                    }
                    this.for.H.do.E = this.for.H.do.D;
                    long l6 = this.for.H.do.y;
                    for (l2 = 0L; l2 < l6; ++l2) {
                        this.for.H.do.a(l2);
                        by = ByteArray.getByte(this.for.H.do.E, 0);
                        if (by != 1) continue;
                        n2 = ByteArray.getInt(this.for.H.do.E, 9);
                        for (n = 0; n < n2; ++n) {
                            long l7 = ByteArray.getLong(this.for.H.do.E, 13 + this.for.H.do.goto * n + 8 + this.for.H.do.q + 0);
                            int n3 = ByteArray.getInt(this.for.H.do.E, 13 + this.for.H.do.goto * n + 8 + this.for.H.do.q + 8);
                            if (i != l7) continue;
                            ++l3;
                        }
                    }
                    for (l2 = 0L; l2 < l; ++l2) {
                        if (i == l2) continue;
                        valuesIndexInstance.u = valuesIndexInstance.r;
                        valuesIndexInstance.a(l2);
                        by = ByteArray.getByte(valuesIndexInstance.u, 0);
                        if (by == 1) {
                            long l8 = ByteArray.getLong(valuesIndexInstance.u, 1);
                            if (i == l8) {
                                ++l3;
                            }
                            n2 = ByteArray.getInt(valuesIndexInstance.u, 9);
                            for (n = 0; n < n2; ++n) {
                                l5 = ByteArray.getLong(valuesIndexInstance.u, 13 + valuesIndexInstance.case * n + 0);
                                if (i != l5) continue;
                                ++l3;
                            }
                        }
                        valuesIndexInstance.u = valuesIndexInstance.t;
                    }
                    if (l3 == (long)0) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values index page page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l3 > (long)1) {
                        if (this.char) {
                            System.out.println();
                            this.char = false;
                        }
                        System.out.println("Used values index page page was found mapped to multiple index pages.");
                        System.out.println("Values index page reference count: ".concat(String.valueOf(String.valueOf(l3))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values index page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l4 == (long)-1) continue;
                valuesIndexInstance.u = valuesIndexInstance.r;
                valuesIndexInstance.a(l4);
                by = ByteArray.getByte(valuesIndexInstance.u, 0);
                if (by != by2) {
                    if (this.char) {
                        System.out.println();
                        this.char = false;
                    }
                    System.out.println("Values index page next link is to a page whose flags are not the same.");
                    System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Values stores page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(l4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                valuesIndexInstance.u = valuesIndexInstance.t;
            }
            if (!this.char) break block47;
            System.out.println();
            this.char = false;
        }
        return true;
    }

    private final void byte() throws Exception {
        block8: {
            if (this.case) {
                System.out.println("Generating keys statistics");
            }
            boolean bl = false;
            byte by = this.for.H.do.do;
            this.e = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.for.H.do.s.a : (long)this.for.H.do.q;
            long l = this.for.H.do.y;
            int n = 0;
            while ((long)n < l) {
                if (this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n + 1))).append(" - ").append(l).append(": ").append((int)((double)(n + 1) / (double)l * 100.0)).append("%"))));
                    bl = true;
                }
                this.for.H.do.a((long)n);
                if (ByteArray.getByte(this.for.H.do.E, 0) == 1) {
                    int n2 = ByteArray.getInt(this.for.H.do.E, 9);
                    if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                        for (int i = 0; i < n2; ++i) {
                            int n3 = this.for.H.do.for(i) + 8;
                            int n4 = ByteArray.getInt(this.for.H.do.E, n3 + 8);
                            this.else += (long)n4;
                            long l2 = n4 / this.for.H.do.s.a;
                            if (l2 * (long)this.for.H.do.s.a < (long)n4) {
                                ++l2;
                            }
                            this.c += l2;
                        }
                    } else {
                        this.else += (long)n2 * this.e;
                        this.c += (long)n2;
                    }
                    this.a += (long)n2;
                    this.do += (long)(this.for.H.do.u * 2);
                }
                ++n;
            }
            if (!bl) break block8;
            System.out.println();
            bl = false;
        }
    }

    private final void try() throws Exception {
        block8: {
            if (this.case) {
                System.out.println("Generating values statistics");
            }
            boolean bl = false;
            byte by = this.for.H.do.v;
            this.byte = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.for.H.do.char.a : (long)this.for.H.do.O;
            long l = this.for.H.do.y;
            int n = 0;
            while ((long)n < l) {
                if (this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n + 1))).append(" - ").append(l).append(": ").append((int)((double)(n + 1) / (double)l * 100.0)).append("%"))));
                    bl = true;
                }
                this.for.H.do.a((long)n);
                if (ByteArray.getByte(this.for.H.do.E, 0) == 1) {
                    int n2 = ByteArray.getInt(this.for.H.do.E, 9);
                    if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                        for (int i = 0; i < n2; ++i) {
                            int n3 = this.for.H.do.for(i) + 8 + this.for.H.do.q;
                            int n4 = ByteArray.getInt(this.for.H.do.E, n3 + 8);
                            this.int += (long)n4;
                            long l2 = n4 / this.for.H.do.char.a;
                            if (l2 * (long)this.for.H.do.char.a < (long)n4) {
                                ++l2;
                            }
                            this.d += l2;
                        }
                    } else {
                        this.int += (long)n2 * this.byte;
                        this.d += (long)n2;
                    }
                    this.long += (long)n2;
                    this.void += (long)(this.for.H.do.u * 2);
                }
                ++n;
            }
            if (!bl) break block8;
            System.out.println();
            bl = false;
        }
    }

    private final void if() throws Exception {
        block8: {
            if (this.case) {
                System.out.println("Generating duplicate values statistics");
            }
            boolean bl = false;
            byte by = this.for.H.do.H.m;
            this.byte = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.for.H.do.H.new.a : (long)this.for.H.do.H.C;
            long l = this.for.H.do.H.o;
            int n = 0;
            while ((long)n < l) {
                if (this.try) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n + 1))).append(" - ").append(l).append(": ").append((int)((double)(n + 1) / (double)l * 100.0)).append("%"))));
                    bl = true;
                }
                this.for.H.do.H.a((long)n);
                if (ByteArray.getByte(this.for.H.do.H.u, 0) == 1) {
                    int n2 = ByteArray.getInt(this.for.H.do.H.u, 9);
                    if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                        for (int i = 0; i < n2; ++i) {
                            int n3 = this.for.H.do.H.for(i) + 8;
                            int n4 = ByteArray.getInt(this.for.H.do.H.u, n3 + 8);
                            this.int += (long)n4;
                            long l2 = n4 / this.for.H.do.H.new.a;
                            if (l2 * (long)this.for.H.do.H.new.a < (long)n4) {
                                ++l2;
                            }
                            this.d += l2;
                        }
                    } else {
                        this.int += (long)n2 * this.byte;
                        this.d += (long)n2;
                    }
                    this.long += (long)n2;
                    this.void += (long)(this.for.H.do.u * 2);
                }
                ++n;
            }
            if (!bl) break block8;
            System.out.println();
            bl = false;
        }
    }

    private final void goto() throws Exception {
        KeysIndexInstance keysIndexInstance = this.for.H.do;
        this.byte();
        if (keysIndexInstance.v == -1) {
            this.if();
        } else {
            this.try();
        }
        if (this.case) {
            System.out.println();
            long l = this.for.H.char();
            System.out.println("Average key page count: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.c / (double)l))));
            System.out.println("Average value page count: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.d / (double)l))));
            System.out.println("Average key length: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.else / (double)l))));
            System.out.println("Average value length: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.int / (double)l))));
        }
    }

    private final void a() throws Exception {
        byte by;
        System.out.println();
        System.out.println("Keys index page utilization: ".concat(String.valueOf(String.valueOf(this.for.H.do.y == (long)0 ? 0.0 : (double)(this.for.H.do.y - this.for.H.do.z) / (double)this.for.H.do.y * (double)100))));
        byte by2 = this.for.H.do.v;
        if (by2 == -1) {
            System.out.println("Values index page utilization: ".concat(String.valueOf(String.valueOf(this.for.H.do.H.o == (long)0 ? 0.0 : (double)(this.for.H.do.H.o - this.for.H.do.H.p) / (double)this.for.H.do.H.o * (double)100))));
        }
        if ((by = this.for.H.do.do) == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
            System.out.println("Keys store page utilization: ".concat(String.valueOf(String.valueOf(this.for.H.do.s.e == (long)0 ? 0.0 : (double)(this.for.H.do.s.e - this.for.H.do.s.h) / (double)this.for.H.do.s.e * (double)100))));
        }
        if (by2 == -1) {
            by2 = this.for.H.do.H.m;
            if (by2 == 8 || by2 == 13 || by2 == 14 || by2 == 11 || by2 == 15 || by2 == 9) {
                System.out.println("Values store page utilization: ".concat(String.valueOf(String.valueOf(this.for.H.do.H.new.e == (long)0 ? 0.0 : (double)(this.for.H.do.H.new.e - this.for.H.do.H.new.h) / (double)this.for.H.do.H.new.e * (double)100))));
            }
        } else if (by2 == 8 || by2 == 13 || by2 == 14 || by2 == 11 || by2 == 15 || by2 == 9) {
            System.out.println("Values store page utilization: ".concat(String.valueOf(String.valueOf(this.for.H.do.char.e == (long)0 ? 0.0 : (double)(this.for.H.do.char.e - this.for.H.do.char.h) / (double)this.for.H.do.char.e * (double)100))));
        }
        System.out.println("Keys index entry utilization: ".concat(String.valueOf(String.valueOf(this.do == (long)0 ? 0.0 : (double)this.a / (double)this.do * 100.0))));
        System.out.println("Values index entry utilization: ".concat(String.valueOf(String.valueOf(this.void == (long)0 ? 0.0 : (double)this.long / (double)this.void * 100.0))));
        System.out.println("Keys index space utilization: ".concat(String.valueOf(String.valueOf(this.c * this.e == (long)0 ? 0.0 : (double)this.else / (double)(this.c * this.e) * (double)100))));
        System.out.println("Values index space utilization: ".concat(String.valueOf(String.valueOf(this.d * this.byte == (long)0 ? 0.0 : (double)this.int / (double)(this.d * this.byte) * (double)100))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean a(long l) throws IOException {
        int n;
        KeysIndexInstance keysIndexInstance;
        block16: {
            block15: {
                block14: {
                    keysIndexInstance = this.for.H.do;
                    keysIndexInstance.E = keysIndexInstance.B;
                    try {
                        byte[] byArray = keysIndexInstance.E;
                        long l2 = keysIndexInstance.Q;
                        Stack<long[]> stack = new Stack<long[]>();
                        while (true) {
                            long l3;
                            int n2;
                            long[] lArray;
                            if (l2 != (long)-1) {
                                if (l == l2) {
                                    n = 1;
                                    Object var18_12 = null;
                                    keysIndexInstance.E = keysIndexInstance.D;
                                    return n != 0;
                                }
                                lArray = new long[]{l2, 0L};
                                stack.push(lArray);
                                keysIndexInstance.a(l2);
                                n2 = keysIndexInstance.for(0);
                                l2 = ByteArray.getLong(byArray, n2 + 0);
                                continue;
                            }
                            if (stack.empty()) {
                                n = 0;
                                break block14;
                            }
                            lArray = (long[])stack.pop();
                            boolean bl = false;
                            keysIndexInstance.a(lArray[0]);
                            int n3 = ByteArray.getInt(byArray, 9);
                            for (n = (int)lArray[1]; n < n3; ++n) {
                                n2 = keysIndexInstance.for(n);
                                l3 = ByteArray.getLong(byArray, n2 + 0);
                                if (l3 == (long)-1) continue;
                                lArray = new long[]{l3, n};
                                stack.push(lArray);
                                bl = true;
                                l2 = l3;
                                break;
                            }
                            if (!bl) {
                                l3 = ByteArray.getLong(byArray, 1);
                                if (l3 != (long)-1) {
                                    lArray = new long[]{l3, -1L};
                                    stack.push(lArray);
                                    bl = true;
                                    l2 = l3;
                                }
                                if (!bl) {
                                    if (stack.empty()) {
                                        n = 0;
                                        break block15;
                                    }
                                    lArray = (long[])stack.pop();
                                    keysIndexInstance.a(lArray[0]);
                                    n3 = ByteArray.getInt(byArray, 9);
                                    lArray[1] = lArray[1] + (long)1;
                                    if (lArray[1] < (long)n3) {
                                        n2 = keysIndexInstance.for((int)lArray[1]);
                                        l3 = ByteArray.getLong(byArray, n2 + 0);
                                        stack.push(lArray);
                                    } else {
                                        l3 = ByteArray.getLong(byArray, 1);
                                    }
                                    if (l3 != (long)-1) {
                                        l2 = l3;
                                        bl = true;
                                    }
                                }
                            }
                            if (!bl) break;
                        }
                        n = 0;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var18_16 = null;
                        keysIndexInstance.E = keysIndexInstance.D;
                        throw throwable;
                    }
                }
                Object var18_13 = null;
                keysIndexInstance.E = keysIndexInstance.D;
                return n != 0;
            }
            Object var18_14 = null;
            keysIndexInstance.E = keysIndexInstance.D;
            return n != 0;
        }
        Object var18_15 = null;
        keysIndexInstance.E = keysIndexInstance.D;
        return n != 0;
    }

    private final int if(long l) throws IOException {
        ValuesIndexInstance valuesIndexInstance = this.for.H.do.H;
        valuesIndexInstance.u = valuesIndexInstance.r;
        try {
            int n;
            int n2 = 0;
            byte[] byArray = valuesIndexInstance.u;
            long l2 = l;
            Stack<long[]> stack = new Stack<long[]>();
            while (true) {
                long l3;
                int n3;
                int n4;
                long[] lArray;
                if (l2 != (long)-1) {
                    lArray = new long[]{l2, 0L};
                    stack.push(lArray);
                    valuesIndexInstance.a(l2);
                    n4 = ByteArray.getInt(byArray, 9);
                    n2 += n4;
                    n3 = valuesIndexInstance.for(0);
                    l2 = ByteArray.getLong(byArray, n3 + 0);
                    continue;
                }
                if (stack.empty()) break;
                lArray = (long[])stack.pop();
                boolean bl = false;
                valuesIndexInstance.a(lArray[0]);
                n4 = ByteArray.getInt(byArray, 9);
                for (n = (int)lArray[1]; n < n4; ++n) {
                    n3 = valuesIndexInstance.for(n);
                    l3 = ByteArray.getLong(byArray, n3 + 0);
                    if (l3 == (long)-1) continue;
                    lArray = new long[]{l3, n};
                    stack.push(lArray);
                    bl = true;
                    l2 = l3;
                    break;
                }
                if (!bl) {
                    l3 = ByteArray.getLong(byArray, 1);
                    if (l3 != (long)-1) {
                        lArray = new long[]{l3, -1L};
                        stack.push(lArray);
                        bl = true;
                        l2 = l3;
                    }
                    if (!bl) {
                        if (stack.empty()) break;
                        lArray = (long[])stack.pop();
                        valuesIndexInstance.a(lArray[0]);
                        n4 = ByteArray.getInt(byArray, 9);
                        lArray[1] = lArray[1] + (long)1;
                        if (lArray[1] < (long)n4) {
                            n3 = valuesIndexInstance.for((int)lArray[1]);
                            l3 = ByteArray.getLong(byArray, n3 + 0);
                            stack.push(lArray);
                        } else {
                            l3 = ByteArray.getLong(byArray, 1);
                        }
                        if (l3 != (long)-1) {
                            l2 = l3;
                            bl = true;
                        }
                    }
                }
                if (!bl) break;
            }
            n = n2;
            Object var19_13 = null;
            valuesIndexInstance.u = valuesIndexInstance.t;
            return n;
        }
        catch (Throwable throwable) {
            Object var19_14 = null;
            valuesIndexInstance.u = valuesIndexInstance.t;
            throw throwable;
        }
    }
}

