// This is part of the Professional User Interface Suite library.
// Copyright (C) 2001-2002 FOSS Software, Inc.
// All rights reserved.
//
// http://www.fossware.com
// mailto:foss@fossware.com
//
// This source code can be used, modified and redistributed
// under the terms of the license agreement that is included
// in the Professional User Interface Suite package.
//
// Warranties and Disclaimers:
// THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND
// INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
// IN NO EVENT WILL FOSS SOFTWARE INC. BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES,
// INCLUDING DAMAGES FOR LOSS OF PROFITS, LOSS OR INACCURACY OF DATA,
// INCURRED BY ANY PERSON FROM SUCH PERSON'S USAGE OF THIS SOFTWARE
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

#include "stdafx.h"

#if (!defined __EXTDOCKBAR_H)
	#include "ExtDockBar.h"
#endif

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	#if (!defined __EXT_CONTROLBAR_TABBED_FEATURES_H)
		#include "ExtControlBarTabbedFeatures.h"
	#endif // __EXT_CONTROLBAR_TABBED_FEATURES_H
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

#if _MFC_VER < 0x700
	#include <../src/AfxImpl.h>
#else
	#include <../src/mfc/AfxImpl.h>
#endif

#if (!defined __EXT_MEMORY_DC_H)
	#include <../Src/ExtMemoryDC.h>
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////
// CExtDockBar window

IMPLEMENT_DYNAMIC(CExtDockBar, CDockBar);

BEGIN_MESSAGE_MAP(CExtDockBar, CDockBar)
	//{{AFX_MSG_MAP(CExtDockBar)
	//}}AFX_MSG_MAP
	ON_WM_CONTEXTMENU()
	ON_WM_CANCELMODE()
	ON_WM_ERASEBKGND()
	ON_MESSAGE(WM_SIZEPARENT, OnSizeParent)
	ON_WM_NCCALCSIZE()
	ON_WM_NCPAINT()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

bool CExtDockBar::g_bControlBarFixSizePixel = true;
bool CExtDockBar::g_bExtendedRepositioning = false;
bool CExtDockBar::g_bDockBarClassRegistered = false;

CExtDockBar::CExtDockBar(
	UINT nCircleNo
	)
	: m_nCircleNo( nCircleNo )
	, m_bLockedOptimize( false )
	, m_pDockBarOuter( NULL )
	, m_pDockBarInner( NULL )
	, m_rcLastInvisiblePreCalc( 0, 0, 0, 0 )
	, m_bInDynamicLayoutUpdate( false )
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	, m_pWndAutoHideArea( NULL )
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
{
	VERIFY( RegisterDockBarClass() );
}

bool CExtDockBar::RegisterDockBarClass()
{
	if( g_bDockBarClassRegistered )
		return true;

WNDCLASS wndclass;
HINSTANCE hInst = AfxGetInstanceHandle();
	if( ! ::GetClassInfo(
			hInst,
			__EXT_DOCKBAR_CLASS_NAME,
			&wndclass
			)
		)
	{
		// otherwise we need to register a new class
		wndclass.style = 0;
		wndclass.lpfnWndProc = ::DefWindowProc;
		wndclass.cbClsExtra = wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInst;
		wndclass.hIcon = NULL;
		wndclass.hCursor =
				::LoadCursor(
					NULL, //hInst,
					IDC_ARROW
					)
				;
		ASSERT( wndclass.hCursor != NULL );
		wndclass.hbrBackground = NULL;
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = __EXT_DOCKBAR_CLASS_NAME;
		if( !::AfxRegisterClass( &wndclass ) )
		{
			ASSERT( FALSE );
			//AfxThrowResourceException();
			return false;
		}
	}

	g_bDockBarClassRegistered = true;
	return true;
}

void CExtDockBar::PreSubclassWindow()
{
	CDockBar::PreSubclassWindow();
}

BOOL CExtDockBar::PreCreateWindow(CREATESTRUCT& cs)
{
	if( ( !RegisterDockBarClass() )
		|| ( !CWnd::PreCreateWindow(cs) )
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	
	cs.lpszClass = __EXT_DOCKBAR_CLASS_NAME;

	return TRUE;
}

void CExtDockBar::OnCancelMode()
{
	ASSERT_VALID( this );
	CDockBar::OnCancelMode();

	CExtPopupMenuWnd::CancelMenuTracking();
	ASSERT( !CExtPopupMenuWnd::IsMenuTracking() );
}

CFrameWnd * CExtDockBar::_GetDockingFrameImpl()
{
	ASSERT_VALID( this );
	return
		CExtControlBar::_GetDockingFrameImpl( (CControlBar *)this );
}

void CExtDockBar::_ContextMenuBuild(
	CFrameWnd * pFrame,
	CExtPopupMenuWnd * pPopup
	)
{
	ASSERT_VALID( pFrame );
	ASSERT( pPopup != NULL );
ExtControlBarVector_t vBars;
	CExtControlBar::_GetFrameControlBars(
		pFrame,
		vBars
		);
bool bOleInplaceItemActivated =
	CExtControlBar::IsOleIpObjActive( pFrame );

int nBarsCount = vBars.GetSize();
CExtControlBar * pPrevBar = NULL;
	for( int i=0; i<nBarsCount; i++ )
	{
		CExtControlBar * pBar = vBars[i];
		ASSERT_VALID( pBar );
		if( pBar->GetSafeHwnd() == NULL
			|| ( ! ::IsWindow(pBar->GetSafeHwnd()) )
			)
			continue;
		// do not include dynamic bars
		if( pBar->IsKindOf( RUNTIME_CLASS(CExtDynamicControlBar) ) )
			continue;

		// do not include temporary hidden bars
		if( pBar->m_nStateFlags &
				//(CControlBar::delayHide | CControlBar::tempHide)
				CControlBar::tempHide
			)
			continue;
		// do not include some bars when OLE inplace object active
		if( bOleInplaceItemActivated &&
				(pBar->m_dwStyle & CBRS_HIDE_INPLACE)
			)
			continue;

		// do not include bars without caption
		CString sBarText;
		pBar->GetWindowText( sBarText );
		if( sBarText.IsEmpty() )
		{
			// do not include bars without window text to menu
			// ASSERT( FALSE );
			continue;
		}

		if( pPrevBar != NULL
			&&
			pPrevBar->IsFixedMode() != pBar->IsFixedMode()
			)
		{
			VERIFY(
				pPopup->ItemInsert(
					CExtPopupMenuWnd::TYPE_SEPARATOR
					)
				);
		}
		pPrevBar = pBar;


		int nBarID = pBar->GetDlgCtrlID();
		ASSERT( CExtCmdManager::IsCommand(nBarID) );
		
		CExtCmdManager::cmd_t cmd;
		cmd.m_nCmdID = nBarID;
		cmd.m_sMenuText = sBarText;
		cmd.TipsLoad();
		g_CmdManager->CmdSetup(
			g_CmdManager->ProfileNameFromWnd( pFrame->GetSafeHwnd() ),
			cmd
			);

		VERIFY(
			pPopup->ItemInsert(
				nBarID
				)
			);
	} // for( int i=0; i<nBarsCount; i++ )
}

void CExtDockBar::_ContextMenuTrack()
{
	ASSERT_VALID( this );
	// find any control bar
CControlBar * pBar = NULL;
	for( int nPos = 0; nPos < m_arrBars.GetSize(); nPos++ )
	{
		pBar = GetDockedControlBar(nPos);
		if( pBar != NULL )
		{
			ASSERT_VALID( pBar );
			break;
		}
	}
	if( pBar == NULL )
		return;

CFrameWnd * pFrame = _GetDockingFrameImpl();
CPoint point;
	VERIFY( ::GetCursorPos(&point) );
HWND hWndTrack = pBar->GetOwner()->GetSafeHwnd();
	ASSERT(
		hWndTrack != NULL
		&& ::IsWindow(hWndTrack)
		);
CExtPopupMenuWnd * pPopup = new CExtPopupMenuWnd;
	VERIFY( pPopup->CreatePopupMenu(hWndTrack) );
	_ContextMenuBuild(
		pFrame,
		pPopup
		);
	::SetFocus( hWndTrack );
	pPopup->TrackPopupMenu( TPMX_OWNERDRAW_FIXED, point.x, point.y );
}

void CExtDockBar::OnContextMenu(CWnd* pWnd, CPoint point)
{
	ASSERT_VALID( this );
	pWnd;
	point;
	_ContextMenuTrack();
}

void CExtDockBar::DoPaint(CDC* pDC)
{
	ASSERT_VALID( this );
	ASSERT_VALID( pDC );
	CExtPaintManager::stat_ExcludeChildAreas(
		pDC->GetSafeHdc(),
		GetSafeHwnd()
		);
//	CDockBar::DoPaint( pDC );

CRect rcClient;
	GetClientRect( &rcClient );
	g_PaintManager->PaintDockBarClientArea(
		*pDC,
		rcClient
		);
}

BOOL CExtDockBar::OnEraseBkgnd( CDC* pDC )
{
	ASSERT_VALID( this );
	ASSERT_VALID( pDC );
	pDC;
//	CExtPaintManager::stat_ExcludeChildAreas(
//		*pDC,
//		*this
//		);
//	return CDockBar::OnEraseBkgnd(pDC);
	return TRUE;
}

void CExtDockBar::OnDynamicLayoutUpdate()
{
	ASSERT_VALID( this );
	ASSERT_KINDOF( CExtDockBar, this );

	if( m_bLockedOptimize )
		return;

	if( m_bInDynamicLayoutUpdate )
		return;
	m_bInDynamicLayoutUpdate = true;

	ASSERT( m_arrBars.GetSize() >= 1 );
	for( INT nBar = 1; nBar < m_arrBars.GetSize(); nBar++ )
	{
		CExtControlBar * pBar = (CExtControlBar *)
			m_arrBars[ nBar ];
		if( pBar == NULL )
			continue;
		if( __PLACEHODLER_BAR_PTR(pBar) )
			continue;
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CExtControlBar, pBar );
		if( pBar->IsFixedMode() )
			continue;
		if( !pBar->IsVisible() )
			continue;
		if( !pBar->IsKindOf(RUNTIME_CLASS(CExtDynamicControlBar)) )
			continue;
		ASSERT_VALID( ((CExtDynamicControlBar *)pBar)->m_pWndDynDocker );
		((CExtDynamicControlBar *)pBar)->m_pWndDynDocker->OnDynamicLayoutUpdate();
	}
	
	RedrawWindow(
		NULL, NULL,
		RDW_ERASE|RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASENOW
			|RDW_ALLCHILDREN|RDW_FRAME
		);

	m_bInDynamicLayoutUpdate = false;
}

void CExtDockBar::OnDynamicLayoutOptimize()
{
	if( m_bLockedOptimize )
		return;

	ASSERT( m_arrBars.GetSize() >= 1 );
	for( INT nBar = 1; nBar < m_arrBars.GetSize(); nBar++ )
	{
		CExtControlBar * pBar = (CExtControlBar *)
			m_arrBars[ nBar ];
		if( pBar == NULL )
			continue;
		if( __PLACEHODLER_BAR_PTR(pBar) )
			continue;
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CExtControlBar, pBar );
		if( pBar->IsFixedMode() )
			continue;
		if( !pBar->IsVisible() )
			continue;
		if( !pBar->IsKindOf(RUNTIME_CLASS(CExtDynamicControlBar)) )
			continue;
		ASSERT_VALID( ((CExtDynamicControlBar *)pBar)->m_pWndDynDocker );
		((CExtDynamicControlBar *)pBar)->m_pWndDynDocker->OnDynamicLayoutOptimize();
	}
}

CSize CExtDockBar::CalcFixedLayout(
	BOOL bStretch,
	BOOL bHorz
	)
{
	// based on MFC's source of
	// CDockBar::CalcFixedLayout()
	ASSERT_VALID(this);
CSize sizeFixed =
		CControlBar::CalcFixedLayout( bStretch, bHorz );
	// get max size
CSize sizeMax;
	if( !m_rectLayout.IsRectEmpty() )
		sizeMax = m_rectLayout.Size();
	else
	{
		CFrameWnd * pFrame = GetParentFrame();
		CRect rcFrameWindow;
		pFrame->GetClientRect( &rcFrameWindow );
		sizeMax = rcFrameWindow.Size();
	}
	// prepare for layout
AFX_SIZEPARENTPARAMS layout;
	layout.hDWP = m_bLayoutQuery ?
		NULL : ::BeginDeferWindowPos( m_arrBars.GetSize() );

CPoint pt( 0, 0 );
int nWidth = 0;

BOOL bWrapped = FALSE;

	for( int nPos = 0; nPos < m_arrBars.GetSize(); nPos++ )
	{ // layout all the control bars
		CControlBar * pBar = GetDockedControlBar(nPos);
		void * pVoid = m_arrBars[nPos];

		if( pBar != NULL )
		{
			CRect rcBarWin, rcBarClient;
			pBar->GetWindowRect( &rcBarWin );
			pBar->ScreenToClient( & rcBarWin );
			pBar->GetClientRect( &rcBarClient );
			CSize sizeBarMin =
				rcBarWin.Size() - rcBarClient.Size();

			if(	pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
			{
				if( ! ((CExtControlBar*)pBar)->IsFixedMode() )
				{
					sizeBarMin =
						CSize(
							((CExtControlBar *)pBar)->_CalcDesiredMinHW(),
							((CExtControlBar *)pBar)->_CalcDesiredMinVH()
							);
				} // if( ! ((CExtControlBar*)pBar)->IsFixedMode() )
			} // if(	pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
			if( pBar->IsVisible() )
			{
				// get ideal rect for bar
				DWORD dwMode = 0;
				if(	(pBar->m_dwStyle & CBRS_SIZE_DYNAMIC)
					&&
					(pBar->m_dwStyle & CBRS_FLOATING)
					)
					dwMode |= LM_HORZ | LM_MRUWIDTH;
				else if(pBar->m_dwStyle & CBRS_ORIENT_HORZ)
					dwMode |= LM_HORZ | LM_HORZDOCK;
				else
					dwMode |=  LM_VERTDOCK;

				CSize sizeBar =
					pBar->CalcDynamicLayout(-1, dwMode);
				bool bIsMenuBar = false;

				if( pBar->IsKindOf(RUNTIME_CLASS(CExtMenuControlBar)) )
				{
					bIsMenuBar = true;
					if(dwMode & LM_HORZDOCK)
						sizeBar.cx = sizeMax.cx;
					else if(dwMode & LM_VERTDOCK)
						sizeBar.cy = sizeMax.cy;
				}

				CRect rc(pt, sizeBar);

				// get current rect for bar
				CRect rcBar;
				pBar->GetWindowRect( &rcBar );
				ScreenToClient( &rcBar );

				bool bMenuIsCutted = false;

				if( bHorz )
				{
					// Offset Calculated Rect out to Actual
					if(	rcBar.left > rc.left
						&& !m_bFloating
						)
						rc.OffsetRect(
							rcBar.left - rc.left,
							0
							);

					// If ControlBar goes off the right, then right justify
					if(	rc.right > sizeMax.cx
						&& !m_bFloating
						)
					{
						int x = rc.Width();
						x = max(sizeMax.cx - x, pt.x);
						rc.OffsetRect(
							x - rc.left,
							0
							);
						if( bIsMenuBar )
							bMenuIsCutted = true;
						if(	rc.right  > sizeMax.cx )
							rc.right -= rc.right - sizeMax.cx;
					}

					// If ControlBar has been wrapped, then left justify
					if( bWrapped )
					{
						bWrapped = FALSE;
						rc.OffsetRect( - rc.left, 0 );

					}
					// If ControlBar is completely invisible, then wrap it
					else if(
						rc.Width() < sizeBarMin.cx
						||
						(rc.left >= sizeMax.cx
							|| bMenuIsCutted )
						&&
						(nPos > 0) && (m_arrBars[nPos - 1] != NULL)
						)
					{
						if(	!pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
							||	(
								pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
								&&
								((CExtControlBar*)pBar)->IsFixedMode()
								)
							)
						{
							m_arrBars.InsertAt(
								nPos,
								(CObject*)NULL
								);
							pBar = NULL;
							pVoid = NULL;
							bWrapped = TRUE;
						}
					}
					if( !bWrapped )
					{
						if(rc != rcBar)
						{
							if(	!m_bLayoutQuery &&
								!(pBar->m_dwStyle & CBRS_FLOATING)
								)
								pBar->m_pDockContext->
									m_rectMRUDockPos = rc;
							AfxRepositionWindow(
								&layout,
								pBar->m_hWnd,
								&rc
								);
						}
						pt.x = rc.left + sizeBar.cx;
						nWidth = max(nWidth, sizeBar.cy);
					} // if( !bWrapped )
				} // if( bHorz )
				else
				{
					// Offset Calculated Rect out to Actual
					if(	rcBar.top > rc.top
						&& !m_bFloating
						)
						rc.OffsetRect(
							0,
							rcBar.top - rc.top
							);

					// If ControlBar goes off the bottom, then bottom justify
					if(	rc.bottom > sizeMax.cy
						&& !m_bFloating
						)
					{
						int y = rc.Height();
						y = max(sizeMax.cy - y, pt.y);
						rc.OffsetRect(
							0,
							y - rc.top
							);
						if( bIsMenuBar )
							bMenuIsCutted = true;
						if(	rc.bottom  > sizeMax.cy )
							rc.bottom -= rc.bottom - sizeMax.cy;
					}

					// If ControlBar has been wrapped, then top justify
					if( bWrapped )
					{
						bWrapped = FALSE;
						rc.OffsetRect( 0, - rc.top );
					}
					// If ControlBar is completely invisible, then wrap it
					else if(
						rc.Height() < sizeBarMin.cy
						||
						(rc.top >= sizeMax.cy
							|| bMenuIsCutted )
						&& (nPos > 0)
						&& (m_arrBars[nPos - 1] != NULL)
						)
					{
						if(	!pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar)) 
							||	(
								pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
								&&
								((CExtControlBar*)pBar)->IsFixedMode()
								)
							)
						{
							m_arrBars.InsertAt(
								nPos,
								(CObject*)NULL
								);
							pBar = NULL;
							pVoid = NULL;
							bWrapped = TRUE;
						}
					}

					if( !bWrapped )
					{
						if(rc != rcBar)
						{
							if(	!m_bLayoutQuery
								&& !(pBar->m_dwStyle & CBRS_FLOATING)
								&& pBar->m_pDockContext != NULL
								)
								pBar->m_pDockContext->
									m_rectMRUDockPos = rc;
							AfxRepositionWindow(
								&layout,
								pBar->m_hWnd,
								&rc
								);
						}
						pt.y = rc.top + sizeBar.cy;
						nWidth = max(nWidth, sizeBar.cx);
					} // if( !bWrapped )
				} // else from if( bHorz )
			
//				if( !m_bLayoutQuery && pBar != NULL )
//				{
//					if( pBar->IsKindOf(RUNTIME_CLASS(CExtDynamicControlBar)) )
//					{
//						ASSERT_VALID( ((CExtDynamicControlBar *)pBar)->m_pWndDynDocker );
//						((CExtDynamicControlBar *)pBar)->m_pWndDynDocker->OnDynamicLayoutUpdate();
//					}
//				}

			} // if( pBar->IsVisible() )

			if( !bWrapped )
				// handle any delay/show hide for the bar
				pBar->RecalcDelayShow( &layout );

		} // if( pBar != NULL )
		else
		{
			if( g_bExtendedRepositioning )
			{
				// try to remove wrapping:
				// are we have free space in the end of previouse row?
				if( nPos > 0 && nPos != m_arrBars.GetSize()-1 )
				{
					int nPosPrev = nPos-1;
					CControlBar * pPrevBar = NULL;
					do
					{
						pPrevBar = GetDockedControlBar(nPosPrev--);
						if( pPrevBar != NULL
							&& pPrevBar->IsVisible()
							&& (!pPrevBar->IsFloating())
							)
						{
//							if( pPrevBar->IsKindOf(RUNTIME_CLASS(CExtMenuControlBar)) )
//							{
//								pPrevBar = NULL;
//								break;
//							}

							// get ideal rect for prev bar
							DWORD dwMode = 0;
							if(	(pPrevBar->m_dwStyle & CBRS_SIZE_DYNAMIC)
								&&
								(pPrevBar->m_dwStyle & CBRS_FLOATING)
								)
								dwMode |= LM_HORZ | LM_MRUWIDTH;
							else if(pPrevBar->m_dwStyle & CBRS_ORIENT_HORZ)
								dwMode |= LM_HORZ | LM_HORZDOCK;
							else
								dwMode |=  LM_VERTDOCK;

							CSize sizePrevBar =
								pPrevBar->CalcDynamicLayout(-1, dwMode);

							CRect rcPrev(pt, sizePrevBar);

							if( bHorz )
							{
								if(	rcPrev.right > sizeMax.cx
									&& !m_bFloating
									)
									pPrevBar = NULL;
							}
							else
							{
								if(	rcPrev.bottom > sizeMax.cy
									&& !m_bFloating
									)
									pPrevBar = NULL;
							}
							if( pPrevBar != NULL )
								break;
						}
						pPrevBar = NULL;
					} while( nPosPrev >= 0 );
					if( pPrevBar != NULL )
					{
						m_arrBars.RemoveAt(nPos);
						nPos--;
						continue;
					}
				} // if( nPos > 0 && nPos != m_arrBars.GetSize()-1 )
			} // if( g_bExtendedRepositioning )
		} // else from if( pBar != NULL )

		if( pBar == NULL && pVoid == NULL && nWidth != 0 )
		{
			// end of row because pBar == NULL
			if( bHorz )
			{
				pt.y += nWidth;
				sizeFixed.cx = max(sizeFixed.cx, pt.x);
				sizeFixed.cy = max(sizeFixed.cy, pt.y);
				pt.x = 0;
				sizeFixed.cy--;
			}
			else
			{
				pt.x += nWidth;
				sizeFixed.cx = max(sizeFixed.cx, pt.x);
				sizeFixed.cy = max(sizeFixed.cy, pt.y);
				pt.y = 0;
				sizeFixed.cx--;
			}
			nWidth = 0;
		}
	} // layout all the control bars
	if( !m_bLayoutQuery )
	{
		ASSERT( layout.hDWP != NULL );
		if( layout.hDWP != NULL )
		{
			VERIFY( ::EndDeferWindowPos(layout.hDWP) );
		}
	} // if( !m_bLayoutQuery )

	// adjust size for borders on the dock bar itself
CRect rc( 0, 0, 0, 0 );
	CalcInsideRect(rc, bHorz);
	if( (!bStretch || !bHorz) && sizeFixed.cx != 0 )
		sizeFixed.cx +=
			-rc.right + rc.left
			+ g_bControlBarFixSizePixel ? 1 : 0;
	if(	(!bStretch || bHorz) && sizeFixed.cy != 0 )
		sizeFixed.cy +=
			-rc.bottom + rc.top
			+ g_bControlBarFixSizePixel ? 1 : 0;

	if( !m_bLayoutQuery )
		OnDynamicLayoutUpdate();

	return sizeFixed;
}

void CExtDockBar::RemoveAllPlaceHolders(
	bool bSearchPlaceHolder // = true
	)
{
	ASSERT_VALID( this );
INT nCount = m_arrBars.GetSize();
	ASSERT( nCount > 0 );
	ASSERT( m_arrBars[0] == NULL );
MfcControlBarVector_t vPlaceHolders;
	for( INT nBar = 1; nBar < nCount; nBar++ )
	{
		CControlBar * pBar = (CControlBar *) m_arrBars[ nBar ];
		if( pBar == NULL )
			continue;
		if( __PLACEHODLER_BAR_PTR(pBar) )
		{
			vPlaceHolders.Add( pBar );
			continue;
		}
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CControlBar, pBar );
	}

	nCount = vPlaceHolders.GetSize();
	for( nBar = 0; nBar < nCount; nBar++ )
	{
		CControlBar * pBar = vPlaceHolders[nBar];
		RemovePlaceHolder( pBar, bSearchPlaceHolder );
	}
}

void CExtDockBar::RemovePlaceHolder(
	CControlBar * pBar,
	bool bSearchPlaceHolder, // = true
	bool * p_bRemoved // = NULL
	)
{
	if( p_bRemoved != NULL )
		*p_bRemoved = false;
	// remove remembered docking position
	if( HIWORD(pBar) != 0 )
		pBar = (CControlBar*)_AfxGetDlgCtrlID(pBar->m_hWnd);
int nOldPos = FindBar(pBar);
	if( nOldPos > 0)
	{
		m_arrBars.RemoveAt(nOldPos);

		// remove section indicator (NULL) if nothing else in section
		if(		m_arrBars[nOldPos-1] == NULL
			&&	m_arrBars[nOldPos] == NULL
			)
			m_arrBars.RemoveAt(nOldPos);

		if( p_bRemoved != NULL )
			*p_bRemoved = true;

		return;
	}
	if( !bSearchPlaceHolder )
		return;


	_RemovePlaceHolder(
		m_pDockSite,
		pBar,
		p_bRemoved
		);
}

void CExtDockBar::_RemovePlaceHolder(
	CFrameWnd * pFrame,
	CControlBar * pBar,
	bool * p_bRemoved // = NULL
	)
{
	ASSERT_VALID( pFrame );
	ASSERT( pBar != NULL ); // may be placeholder ID
POSITION pos = pFrame->m_listControlBars.GetHeadPosition();
	for( ; pos != NULL; )
	{
		CControlBar * pTestBar = (CControlBar *)
			pFrame->m_listControlBars.GetNext( pos );
		ASSERT_VALID( pTestBar );
		ASSERT_KINDOF( CControlBar, pTestBar );
		if( !pTestBar->IsDockBar() )
		{
			if( pTestBar->IsKindOf(RUNTIME_CLASS(CExtDynamicControlBar)) )
			{
				CExtDynamicDockBar * pDynDocker =
					((CExtDynamicControlBar*)pTestBar)->
						m_pWndDynDocker;
				ASSERT_VALID( pDynDocker );
				bool bRemoved = false;
				pDynDocker->RemovePlaceHolder(
					pBar,
					false,
					&bRemoved
					);
				if( bRemoved )
				{
					if( p_bRemoved != NULL )
						*p_bRemoved = true;
					return;
				}
			}
			continue;
		}
		ASSERT_KINDOF( CDockBar, pTestBar );
		// dirty, but safe
		bool bRemoved = false;
		((CExtDockBar *)pTestBar)->RemovePlaceHolder(
			pBar,
			false,
			&bRemoved
			);
		if( bRemoved )
		{
			if( p_bRemoved != NULL )
				*p_bRemoved = true;
			return;
		}
	}
}

void CExtDockBar::_SlideDockControlBar(
	CControlBar* pBar,
	LPCRECT lpRect,
	BOOL bMovingEnabled,
	const POINT * ptDesiredMid // = NULL
	)
{
	ASSERT_VALID( this);
	ASSERT_VALID( pBar );
	ASSERT_KINDOF( CControlBar, pBar );

CRect rcBar;
	pBar->GetWindowRect( &rcBar );
	if(	pBar->m_pDockBar == this
		&& (lpRect == NULL || rcBar == *lpRect)
		)
	{
		// already docked and no change in position
		return;
	}

	// set CBRS_FLOAT_MULTI style if docking bar has it
	if(	m_bFloating
		&& (pBar->m_dwDockStyle & CBRS_FLOAT_MULTI)
		)
		m_dwStyle |= CBRS_FLOAT_MULTI;

	m_dwStyle &= ~(CBRS_SIZE_FIXED | CBRS_SIZE_DYNAMIC);
	m_dwStyle |=
		pBar->m_dwStyle & (CBRS_SIZE_FIXED | CBRS_SIZE_DYNAMIC);

	if( !(m_dwStyle & CBRS_FLOAT_MULTI) )
	{
		TCHAR szTitle[_MAX_PATH];
		pBar->GetWindowText(szTitle, _countof(szTitle));
		AfxSetWindowText(m_hWnd, szTitle);
	}

	// align correctly and turn on all borders
DWORD dwStyle = pBar->GetBarStyle();
	dwStyle &= ~(CBRS_ALIGN_ANY);
	dwStyle |=  (m_dwStyle & CBRS_ALIGN_ANY) | CBRS_BORDER_ANY;

	if( m_bFloating )
		dwStyle |= CBRS_FLOATING;
	else
		dwStyle &= ~CBRS_FLOATING;

	pBar->SetBarStyle( dwStyle );

	// hide first if changing to a new docking site to avoid flashing
bool bShow = false;
	if( bMovingEnabled &&
		pBar->m_pDockBar != this && pBar->IsWindowVisible() )
	{
		pBar->SetWindowPos(NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_HIDEWINDOW);
		bShow = true;
	}

int nPos = -1;
	if( lpRect != NULL )
	{
		// insert into appropriate row
		CRect rc( lpRect );
		ScreenToClient( &rc );
		CPoint ptMid(
			(ptDesiredMid == NULL) ?
				rc.left + rc.Width()/2 : ptDesiredMid->x,
			(ptDesiredMid == NULL) ?
				rc.top + rc.Height()/2 : ptDesiredMid->y
			);
		nPos = _InsertByPointImpl( pBar, rc, ptMid );
		ASSERT_VALID( this );
		ASSERT_BAR_LOCATION_IN_ROW( this, pBar );

		// position at requested position
		if( bMovingEnabled )
			pBar->SetWindowPos(
				NULL,
				rc.left, rc.top, rc.Width(), rc.Height(),
				SWP_NOREDRAW|SWP_NOSENDCHANGING
					|SWP_NOZORDER|SWP_NOOWNERZORDER
					|SWP_NOACTIVATE|SWP_NOCOPYBITS
				);
	}
	else
	{
		// always add on current row, then create new one
		m_arrBars.Add(pBar);
		m_arrBars.Add(NULL);
		ASSERT_VALID( this );
		ASSERT_BAR_LOCATION_IN_ROW( this, pBar );

		// align off the edge initially
		if( bMovingEnabled )
			pBar->SetWindowPos(
				NULL,
				-afxData.cxBorder2, -afxData.cyBorder2,
				0, 0,
				SWP_NOREDRAW|SWP_NOSENDCHANGING
					|SWP_NOZORDER|SWP_NOOWNERZORDER
					|SWP_NOACTIVATE|SWP_NOCOPYBITS
					|SWP_NOSIZE
				);
	}

	// attach it to the docking site
	if( pBar->GetParent() != this )
		pBar->SetParent(this);
	if( pBar->m_pDockBar == this )
	{
		//pBar->m_pDockBar->
			RemoveControlBar(
				pBar,
				nPos,
				0,
				false // (!bMovingEnabled) ? true : false
				);
		ASSERT_VALID( this );
	} // if( pBar->m_pDockBar == this )
	else if( pBar->m_pDockBar != NULL )
	{
		ASSERT_KINDOF( CDockBar, pBar->m_pDockBar );
		if( pBar->m_pDockBar->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
		{
			bool bOptimizeDockBarLayout = false;
			if( !((CExtDockBar *)(pBar->m_pDockBar))->m_bFloating )
				bOptimizeDockBarLayout = true;
			((CExtDockBar *)(pBar->m_pDockBar))->
				RemoveControlBar(
					pBar,
					-1,
					m_bFloating && !pBar->m_pDockBar->m_bFloating,
					false // (!bMovingEnabled) ? true : false
					);
			ASSERT_VALID( this );
			if( bOptimizeDockBarLayout )
				((CExtDockBar *)(pBar->m_pDockBar))->OnDynamicLayoutOptimize();
		}
		else
		{
			pBar->m_pDockBar->
				RemoveControlBar(
					pBar,
//ph//
					0, //-1,
					m_bFloating && !pBar->m_pDockBar->m_bFloating
					);
			ASSERT_VALID( this );
		}
	} // else if( pBar->m_pDockBar != NULL )

	pBar->m_pDockBar = this;
	ASSERT( pBar->m_pDockContext != NULL );
	pBar->m_pDockContext->m_uMRUDockID = GetDlgCtrlID();
	if( lpRect != NULL )
		pBar->m_pDockContext->m_rectMRUDockPos = *lpRect;

	if( bShow )
	{
		ASSERT(!pBar->IsWindowVisible());
		//pBar->SetWindowPos(NULL, 0, 0, 0, 0,
		//	SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_SHOWWINDOW);
		pBar->SetWindowPos(NULL,
			lpRect->left,
			lpRect->top,
			lpRect->right-lpRect->left,
			lpRect->bottom-lpRect->top,
			SWP_NOSIZE/*|SWP_NOMOVE*/|SWP_NOZORDER|SWP_NOACTIVATE|SWP_SHOWWINDOW);
	}

	// remove any place holder for pBar in this dockbar
	RemovePlaceHolder( pBar, true );
	ASSERT_VALID( this );

//	// get parent frame for recalc layout
//CFrameWnd* pFrameWnd = GetDockingFrame();
//	pFrameWnd->DelayRecalcLayout();

	_OptimizeCircles();
}

void CExtDockBar::_NewRowDockControlBar(
	CControlBar * pExtBarDocked,
	CControlBar * pExtBarNew,
	bool bLessIndex
	)
{
	ASSERT_VALID( this);
	ASSERT_VALID( pExtBarDocked );
	ASSERT_KINDOF( CControlBar, pExtBarDocked );
	ASSERT_VALID( pExtBarNew );
	ASSERT_KINDOF( CControlBar, pExtBarNew );

CFrameWnd * pNewDockingFrameWnd = pExtBarNew->GetDockingFrame();
INT nNewDockBarGetDockedVisibleCount = -1;
BOOL bNewFloating = pExtBarNew->IsFloating();

BOOL bNewExt = pExtBarNew->IsKindOf( RUNTIME_CLASS(CExtControlBar) );

	if( pExtBarNew->GetParent() != this )
	{
		if( bNewExt )
			((CExtControlBar *)pExtBarNew)->m_bUpdatingChain = true;
		pExtBarNew->SetWindowPos(
			NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
			|SWP_HIDEWINDOW
			);
		pExtBarNew->SetParent( this );
		if( bNewExt )
			((CExtControlBar *)pExtBarNew)->m_bUpdatingChain = false;
	}

	// align correctly and turn on all borders
DWORD dwStyle = pExtBarNew->GetBarStyle();
	dwStyle &= ~(CBRS_ALIGN_ANY);
	dwStyle |=  (m_dwStyle & CBRS_ALIGN_ANY) | CBRS_BORDER_ANY;

	if( m_bFloating )
		dwStyle |= CBRS_FLOATING;
	else
		dwStyle &= ~CBRS_FLOATING;

	pExtBarNew->SetBarStyle( dwStyle );

INT nCountOfSideBars = m_arrBars.GetSize();
CControlBar * pRemoveBar = NULL;
HWND hWndDockBarOld = NULL;
	if( pExtBarNew->m_pDockBar != this )
	{
		if( pExtBarNew->m_pDockBar != NULL )
		{
			nNewDockBarGetDockedVisibleCount =
				GetDockedVisibleCount();
			ASSERT_VALID( pExtBarNew->m_pDockBar );
			ASSERT_KINDOF( CDockBar, pExtBarNew->m_pDockBar );
			if( pExtBarNew->IsWindowVisible() )
				pExtBarNew->SetWindowPos(
					NULL, 0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
					|SWP_HIDEWINDOW
					);
			ASSERT_VALID( pExtBarNew->m_pDockBar );

			if( !pExtBarNew->m_pDockBar->m_bFloating
				&& pExtBarNew->m_pDockBar->IsKindOf(RUNTIME_CLASS(CExtDockBar))
				)
			{
hWndDockBarOld = pExtBarNew->m_pDockBar->GetSafeHwnd();
				((CExtDockBar *)pExtBarNew->m_pDockBar)->RemoveControlBar( pExtBarNew );
// optimized at final state with all circles
//				((CExtDockBar *)pExtBarNew->m_pDockBar)->OnDynamicLayoutOptimize();
			}
			else		
				pExtBarNew->m_pDockBar->RemoveControlBar( pExtBarNew );

			//ASSERT_VALID( pExtBarNew->m_pDockBar ); this may be alredy destroyed floating dockbar
		} // if( pExtBarNew->m_pDockBar != NULL )
	} // if( pExtBarNew->m_pDockBar != this )
	else
	{
		if( pExtBarDocked != pExtBarNew )
		{
			INT nPos = FindBar( pExtBarNew );
			ASSERT( nPos >= 0 && nPos < nCountOfSideBars );
			m_arrBars.RemoveAt( nPos );
			nCountOfSideBars --;
			ASSERT( nCountOfSideBars > 1 );
			if(   (	nCountOfSideBars == nPos
					&& m_arrBars[nPos-1] == NULL )
				||
				  (	nCountOfSideBars > nPos
					&& m_arrBars[nPos-1] == NULL
					&& m_arrBars[nPos] == NULL
					)
				)
			{
				// remove empty row
				m_arrBars.RemoveAt( nPos-1 );
				nCountOfSideBars --;
			}
			ASSERT_VALID( this );
		} // if( pExtBarDocked != pExtBarNew )
		else
			pRemoveBar = pExtBarNew;
	} // else from if( pExtBarNew->m_pDockBar != this )

INT nIdxDockedBar = FindBar( pExtBarDocked );
	ASSERT( nIdxDockedBar >= 0 && nIdxDockedBar < nCountOfSideBars );

INT nIncrement = bLessIndex ? -1 : 1;

	for( INT nIdx = nIdxDockedBar; true; nIdx += nIncrement )
	{
		CControlBar * pBar = (CControlBar *) m_arrBars[ nIdx ];
		if( nIdx == 0
			|| nIdx == (nCountOfSideBars-1)
			|| pBar == NULL
			)
		{
			ASSERT( m_arrBars[0] == NULL );
			m_arrBars.InsertAt( nIdx, pExtBarNew );
			m_arrBars.InsertAt( nIdx, (CControlBar *)NULL );
			ASSERT_VALID( this );
			break;
		}

#ifdef _DEBUG
		if( __PLACEHODLER_BAR_PTR(pBar) )
			continue;
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CControlBar, pBar );
#endif // _DEBUG

	} // for( INT nIdx = nIdxDockedBar; true; nIdx += nIncrement )

CDockBar * pOldDockBar = pExtBarNew->m_pDockBar;

	pExtBarNew->m_pDockBar = this;
	ASSERT_BAR_LOCATION_IN_ROW( this, pExtBarNew );
	
	ASSERT( pExtBarNew->m_pDockContext != NULL );
	pExtBarNew->m_pDockContext->m_uMRUDockID = GetDlgCtrlID();

	if( pRemoveBar != NULL )
	{
		INT nPos = FindBar( pRemoveBar, nIdx+1 );
		nCountOfSideBars = m_arrBars.GetSize();
		ASSERT( nPos >= 0 && nPos < nCountOfSideBars );
		m_arrBars.RemoveAt( nPos );
		nCountOfSideBars --;
		ASSERT( nCountOfSideBars > 1 );
		if(   (	nCountOfSideBars == nPos
				&& m_arrBars[nPos-1] == NULL )
			||
			  (	nCountOfSideBars > nPos
				&& m_arrBars[nPos-1] == NULL
				&& m_arrBars[nPos] == NULL
				)
			)
		{
			// remove empty row
			m_arrBars.RemoveAt( nPos-1 );
//			nCountOfSideBars --;
		}
		ASSERT_VALID( this );
	}

	if( bNewFloating && nNewDockBarGetDockedVisibleCount == 0 )
	{
		if( pOldDockBar->GetDockedCount() == 0 )
			pNewDockingFrameWnd->DestroyWindow();
		else
			pNewDockingFrameWnd->ShowWindow( SW_HIDE );
	}
//	else
//		pNewDockingFrameWnd->DelayRecalcLayout();

//	ASSERT( !pExtBarNew->IsWindowVisible() );
	pExtBarNew->SetWindowPos(NULL, 0, 0, 0, 0,
		SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
			|SWP_SHOWWINDOW|SWP_FRAMECHANGED
		);

	OnDynamicLayoutUpdate();
	if( hWndDockBarOld != NULL
		&& hWndDockBarOld != GetSafeHwnd()
		&& ::IsWindow(hWndDockBarOld)
		)
	{
		CWnd * pWndDockBar = FromHandlePermanent( hWndDockBarOld );
		if( pWndDockBar != NULL
			&& pWndDockBar->GetSafeHwnd() == hWndDockBarOld
			)
		{
			ASSERT( pWndDockBar != this );
			ASSERT_KINDOF( CExtDockBar, pWndDockBar );
			((CExtDockBar *)pWndDockBar)->OnDynamicLayoutUpdate();
		}
	}

CFrameWnd * pFrame = GetParentFrame();
	ASSERT_VALID( pFrame );
	if( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) )
		_OptimizeCircles();
}

void CExtDockBar::_InnerOuterDockControlBar(
	CControlBar * pBar,
	bool bInner
	)
{
	ASSERT_VALID( this );
	ASSERT_VALID( pBar );
	ASSERT_KINDOF( CControlBar, pBar );

UINT nOwnID = GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );

bool bDockAtStartIdx = false;
	if( nOwnID == AFX_IDW_DOCKBAR_RIGHT
		|| nOwnID == AFX_IDW_DOCKBAR_BOTTOM
		)
		bDockAtStartIdx = true;
	if( !bInner )
		bDockAtStartIdx = false;

	if( pBar->m_pDockBar == this )
	{
		INT nCountOfBars = m_arrBars.GetSize();
		ASSERT( nCountOfBars > 2 );
		if( m_arrBars[1] == pBar )
			return;
		INT nBarPos = FindBar( pBar );
		ASSERT( nBarPos > 0 && nBarPos < nCountOfBars );
		m_arrBars.RemoveAt( nBarPos );
		nCountOfBars --;
		if( m_arrBars[nBarPos - 1] == NULL
			&& m_arrBars[ nBarPos ] == NULL
			)
		{
			m_arrBars.RemoveAt( nBarPos );
			nCountOfBars --;
		}

		//ASSERT_VALID( this );
		if( bDockAtStartIdx )
		{
			m_arrBars.InsertAt( 1, pBar );
			nCountOfBars++;
			ASSERT( nCountOfBars == m_arrBars.GetSize() );
			if( nCountOfBars < 3 || m_arrBars[2] != NULL )
				m_arrBars.InsertAt( 2, (CControlBar *)NULL );
			ASSERT_VALID( this );
		} // if( bDockAtStartIdx )
		else
		{
			m_arrBars.InsertAt( nCountOfBars, (CControlBar *)NULL );
			m_arrBars.InsertAt( nCountOfBars, pBar );
			ASSERT_VALID( this );
		} // else from if( bDockAtStartIdx )
	} // if( pBar->m_pDockBar == this )
	else
	{
		CFrameWnd * pDockingFrameWnd = pBar->GetDockingFrame();
		INT nDockBarGetDockedVisibleCount = -1;
		BOOL bFloating = pBar->IsFloating();

		ASSERT( pBar->GetParent() != this );
		pBar->SetWindowPos(
			NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
			|SWP_HIDEWINDOW
			);
		pBar->SetParent( this );

		// align correctly and turn on all borders
		DWORD dwStyle = pBar->GetBarStyle();
		dwStyle &= ~(CBRS_ALIGN_ANY);
		dwStyle |=  (m_dwStyle & CBRS_ALIGN_ANY) | CBRS_BORDER_ANY;

		if( m_bFloating )
			dwStyle |= CBRS_FLOATING;
		else
			dwStyle &= ~CBRS_FLOATING;

		pBar->SetBarStyle( dwStyle );

		ASSERT( pBar->m_pDockBar != this );
		if( pBar->IsWindowVisible() )
			pBar->SetWindowPos(
				NULL, 0, 0, 0, 0,
				SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
				|SWP_HIDEWINDOW
				);

		if( pBar->m_pDockBar != NULL )
		{
			ASSERT_VALID( pBar->m_pDockBar );
			ASSERT_KINDOF( CDockBar, pBar->m_pDockBar );
			if( !pBar->m_pDockBar->m_bFloating
				&& pBar->m_pDockBar->IsKindOf(RUNTIME_CLASS(CExtDockBar))
				)
			{
				((CExtDockBar *)pBar->m_pDockBar)->RemoveControlBar( pBar );
				((CExtDockBar *)pBar->m_pDockBar)->OnDynamicLayoutOptimize();
			}
			else
				pBar->m_pDockBar->RemoveControlBar( pBar );
			//ASSERT_VALID( pBar->m_pDockBar ); this may be alredy destroyed floating dockbar
		}

		
		//ASSERT_VALID( this );
		INT nCountOfBars = m_arrBars.GetSize();
		ASSERT( nCountOfBars > 0 );
		if( bDockAtStartIdx )
		{
			m_arrBars.InsertAt( 1, pBar );
			nCountOfBars++;
			if( nCountOfBars < 3 || m_arrBars[2] != NULL )
				m_arrBars.InsertAt( 2, (CControlBar *)NULL );
			ASSERT_VALID( this );
		} // if( bDockAtStartIdx )
		else
		{
			m_arrBars.InsertAt( nCountOfBars, (CControlBar *)NULL );
			m_arrBars.InsertAt( nCountOfBars, pBar );
			ASSERT_VALID( this );
		} // else from if( bDockAtStartIdx )

		CDockBar * pOldDockBar = pBar->m_pDockBar;
		pBar->m_pDockBar = this;
		ASSERT_BAR_LOCATION_IN_ROW( this, pBar );
		
		ASSERT( pBar->m_pDockContext != NULL );
		pBar->m_pDockContext->m_uMRUDockID = GetDlgCtrlID();

		if( bFloating && nDockBarGetDockedVisibleCount == 0 )
		{
			if( pOldDockBar->GetDockedCount() == 0 )
				pDockingFrameWnd->DestroyWindow();
			else
				pDockingFrameWnd->ShowWindow( SW_HIDE );
		}
//		else
//			pDockingFrameWnd->DelayRecalcLayout();

//		ASSERT( !pBar->IsWindowVisible() );
		pBar->SetWindowPos(NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
				|SWP_SHOWWINDOW|SWP_FRAMECHANGED
			);

		ASSERT_VALID( this );
	} // else from if( pBar->m_pDockBar == this )

	_OptimizeCircles();
}

void CExtDockBar::_LockSequenceOptimization( bool bLock )
{
	ASSERT_VALID( this );
	ASSERT_KINDOF( CExtDockBar, this );
	m_bLockedOptimize = bLock;
}

void CExtDynamicDockBar::_LockSequenceOptimization( bool bLock )
{
	ASSERT_VALID( this );
	ASSERT_KINDOF( CExtDynamicDockBar, this );
	m_bLockedOptimize = bLock;
CExtDynamicControlBar * pDynBar =
		STATIC_DOWNCAST(
			CExtDynamicControlBar,
			GetParent()
			);
	ASSERT( pDynBar->m_pWndDynDocker == this );
	ASSERT_VALID( pDynBar->m_pDockBar );
	if(  pDynBar->m_pDockBar->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
		((CExtDockBar *)pDynBar->m_pDockBar)->_LockSequenceOptimization( bLock );
}

void CExtDockBar::DockControlBar(
	CControlBar * pBar,
	LPCRECT lpRect // = NULL
	)
{
	ASSERT_VALID(this);
	ASSERT_VALID(pBar);
	ASSERT_KINDOF(CControlBar, pBar);

	CRect rectBar;
	pBar->GetWindowRect(&rectBar);
	if (pBar->m_pDockBar == this && (lpRect == NULL || rectBar == *lpRect))
	{
		// already docked and no change in position
		return;
	}

	// set CBRS_FLOAT_MULTI style if docking bar has it
	if (m_bFloating && (pBar->m_dwDockStyle & CBRS_FLOAT_MULTI))
		m_dwStyle |= CBRS_FLOAT_MULTI;

	m_dwStyle &= ~(CBRS_SIZE_FIXED | CBRS_SIZE_DYNAMIC);
	m_dwStyle |= pBar->m_dwStyle & (CBRS_SIZE_FIXED | CBRS_SIZE_DYNAMIC);

	if (!(m_dwStyle & CBRS_FLOAT_MULTI))
	{
		TCHAR szTitle[_MAX_PATH];
		pBar->GetWindowText(szTitle, _countof(szTitle));
		AfxSetWindowText(m_hWnd, szTitle);
	}

	// align correctly and turn on all borders
	DWORD dwStyle = pBar->GetBarStyle();
	dwStyle &= ~(CBRS_ALIGN_ANY);
	dwStyle |=  (m_dwStyle & CBRS_ALIGN_ANY) | CBRS_BORDER_ANY;

	if (m_bFloating)
		dwStyle |= CBRS_FLOATING;
	else
		dwStyle &= ~CBRS_FLOATING;

	pBar->SetBarStyle(dwStyle);

	// hide first if changing to a new docking site to avoid flashing
	BOOL bShow = FALSE;
	if (pBar->m_pDockBar != this && pBar->IsWindowVisible())
	{
		pBar->SetWindowPos(NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_HIDEWINDOW);
		bShow = TRUE;
	}

	int nPos = -1;
	if (lpRect != NULL)
	{
		// insert into appropriate row
		CRect rect(lpRect);
		ScreenToClient(&rect);
		CPoint ptMid(rect.left + rect.Width()/2, rect.top + rect.Height()/2);
		//nPos = Insert(pBar, rect, ptMid);
		nPos = CDockBar::Insert(pBar, rect, ptMid);

		// position at requested position
		pBar->SetWindowPos(NULL, rect.left, rect.top, rect.Width(),
			rect.Height(), SWP_NOZORDER|SWP_NOACTIVATE|SWP_NOCOPYBITS);
	}
	else
	{
		// always add on current row, then create new one
		m_arrBars.Add(pBar);
		m_arrBars.Add(NULL);

		// align off the edge initially
		pBar->SetWindowPos(NULL, -afxData.cxBorder2, -afxData.cyBorder2, 0, 0,
			SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_NOCOPYBITS);
	}

	// attach it to the docking site
	if (pBar->GetParent() != this)
		pBar->SetParent(this);
	if( pBar->m_pDockBar == this )
		//pBar->m_pDockBar->
			RemoveControlBar(pBar, nPos);
	else if (pBar->m_pDockBar != NULL)
	{

		ASSERT_KINDOF( CDockBar, pBar->m_pDockBar );
		if( pBar->m_pDockBar->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
		{
			bool bOptimizeDockBarLayout = false;
			if( !((CExtDockBar *)(pBar->m_pDockBar))->m_bFloating )
				bOptimizeDockBarLayout = true;
			((CExtDockBar *)(pBar->m_pDockBar))->
				RemoveControlBar(
					pBar,
					-1,
					m_bFloating && !pBar->m_pDockBar->m_bFloating,
					false // (!bMovingEnabled) ? true : false
					);
			ASSERT_VALID( this );
			if( bOptimizeDockBarLayout
				&& !m_bLockedOptimize
				)
				((CExtDockBar *)(pBar->m_pDockBar))->OnDynamicLayoutOptimize();
		}
		else
		{
			pBar->m_pDockBar->
				RemoveControlBar(
					pBar,
//ph//
					0, //-1,
					m_bFloating && !pBar->m_pDockBar->m_bFloating
					);
			ASSERT_VALID( this );
		}
	}
	pBar->m_pDockBar = this;

	if (bShow)
	{
		ASSERT(!pBar->IsWindowVisible());
		pBar->SetWindowPos(NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_SHOWWINDOW);
	}

	// remove any place holder for pBar in this dockbar
	RemovePlaceHolder( pBar, true );

	// get parent frame for recalc layout
CFrameWnd* pFrameWnd = GetDockingFrame();
	pFrameWnd->DelayRecalcLayout();

// OPTFIX:
//	if( !pFrameWnd->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) )
//		_OptimizeCircles();
}

void CExtDockBar::DrawBorders(CDC* pDC, CRect& rect)
{
	ASSERT_VALID( this );
	ASSERT_VALID( pDC );

	g_PaintManager->PaintControlBarBorders(
		CExtPaintManager::__CB_OUTER_DOCKBAR,
		m_dwStyle, // |CBRS_BORDER_ANY|CBRS_BORDER_3D
		*pDC, 
		rect
		);
}

void CExtDockBar::DrawGripper(CDC* pDC, const CRect& rect)
{
	ASSERT_VALID( this );
	pDC,
	rect;
}

LRESULT CExtDockBar::OnSizeParent(WPARAM wParam, LPARAM lParam)
{
	ASSERT_VALID( this );
//	if( CExtControlBar::g_bUpdatingDragState )
//		return 0;

	if( m_bLockedOptimize )
		return 0;

LRESULT lResult =
		CDockBar::OnSizeParent(wParam,lParam);

//	if( _GetCircleNo() == 0 )
//		return lResult;

	if( (m_dwStyle & CBRS_ALIGN_ANY) == 0 )
		return lResult;

UINT nOwnID = GetDlgCtrlID();
	if( nOwnID == AFX_IDW_DOCKBAR_FLOAT )
		return lResult;
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );

//DWORD dwWndStyle = GetStyle();
//bool bWndVisible = (dwWndStyle & WS_VISIBLE) ? true : false;
//	if( bWndVisible )
//	{
//		if( GetDockedVisibleCount() != 0 )
//			return lResult;
//	}

AFX_SIZEPARENTPARAMS * lpLayout = (AFX_SIZEPARENTPARAMS*)lParam;
	ASSERT( lpLayout != NULL );
//	if( lpLayout->hDWP == NULL )
//		return lResult;

	m_rcLastInvisiblePreCalc = lpLayout->rect;

	switch( nOwnID )
	{
	case AFX_IDW_DOCKBAR_TOP:
		ASSERT( m_rcLastInvisiblePreCalc.left <= m_rcLastInvisiblePreCalc.right );
		m_rcLastInvisiblePreCalc.bottom = m_rcLastInvisiblePreCalc.top; // + 1;
		break;
	case AFX_IDW_DOCKBAR_BOTTOM:
		ASSERT( m_rcLastInvisiblePreCalc.left <= m_rcLastInvisiblePreCalc.right );
		m_rcLastInvisiblePreCalc.top = m_rcLastInvisiblePreCalc.bottom; //  - 1;
		break;
	case AFX_IDW_DOCKBAR_LEFT:
		ASSERT( m_rcLastInvisiblePreCalc.top <= m_rcLastInvisiblePreCalc.bottom );
		m_rcLastInvisiblePreCalc.right = m_rcLastInvisiblePreCalc.left; //  + 1;
		break;
	case AFX_IDW_DOCKBAR_RIGHT:
		ASSERT( m_rcLastInvisiblePreCalc.top <= m_rcLastInvisiblePreCalc.bottom );
		m_rcLastInvisiblePreCalc.left = m_rcLastInvisiblePreCalc.right; //  - 1;
		break;
#ifdef _DEBUG
	default:
		ASSERT( FALSE );
		break;
#endif // _DEBUG
	} // switch( nOwnID )

//	MoveWindow( &m_rcLastInvisiblePreCalc, FALSE );

CFrameWnd * pFrame = _GetDockingFrameImpl();
	ASSERT_VALID( pFrame );
	ASSERT_KINDOF( CFrameWnd, pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );
	pFrame->ClientToScreen( &m_rcLastInvisiblePreCalc );

	return lResult;
}

BOOL CExtDockBar::RemoveControlBar(
	CControlBar * pBar,
	int nPosExclude, // -1
	int nAddPlaceHolder, // = 0
	bool bEnableFrameDelayRecalcLayout // = true
	)
{
//ph//
// temp
	if(	pBar->IsKindOf( RUNTIME_CLASS(CExtControlBar) )
		&& (! ((CExtControlBar*)pBar)->IsFixedMode() )
		)
		nAddPlaceHolder = 0;

	ASSERT_VALID( this );
	ASSERT(
		nAddPlaceHolder == 1
		|| nAddPlaceHolder == 0
		|| nAddPlaceHolder == -1
		);
	ASSERT_VALID( this );
	ASSERT( pBar != NULL );
int nPos = FindBar( pBar, nPosExclude );
	ASSERT( nPos > 0 );

	if( nAddPlaceHolder == 1 )
	{
		m_arrBars[ nPos ] = (void*)
			_AfxGetDlgCtrlID( pBar->m_hWnd );
		// check for already existing place holder
		int nPosOld =
			FindBar(
				(CControlBar *) m_arrBars[ nPos ],
				nPos
				);
		if( nPosOld > 0 )
		{
			m_arrBars.RemoveAt( nPos );
			// remove section indicator (NULL) if nothing
			// else in section
			if( m_arrBars[ nPos - 1 ] == NULL
				&& m_arrBars[ nPos ] == NULL
				)
				m_arrBars.RemoveAt( nPos );
		} // if( nPosOld > 0 )
	} // if( nAddPlaceHolder == 1 )
	else
	{
		m_arrBars.RemoveAt( nPos );
		if( m_arrBars[nPos-1] == NULL
			&& m_arrBars[nPos] == NULL
			)
			m_arrBars.RemoveAt( nPos );

		// Remove any pre-existing place holders.
		if( nAddPlaceHolder != -1 )
			RemovePlaceHolder( pBar, true );
	} // else from if( nAddPlaceHolder == 1 )

	// don't do anything more in the shutdown case!
	if( pBar->m_pDockContext == NULL )
		return FALSE;

	// get parent frame for recalc layout/frame destroy
CFrameWnd * pFrameWnd = GetDockingFrame();
	if( m_bFloating && GetDockedVisibleCount() == 0 )
	{
		if( GetDockedCount() == 0 )
		{
			pFrameWnd->DestroyWindow();
			return TRUE; // Self-Destruct
		}
		else
			pFrameWnd->ShowWindow( SW_HIDE );
	} // if( m_bFloating && GetDockedVisibleCount() == 0 )
	else
	{
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		if( IsKindOf(RUNTIME_CLASS(CExtDynamicTabbedDockBar)) )
		{
			// TO FIX:

			//CExtDynamicTabbedDockBar * pTabbedDocker =
			//	STATIC_DOWNCAST(
			//		CExtDynamicTabbedDockBar,
			//		this
			//		);
			//pTabbedDocker->_SyncTabbedChilds(false,true);
			//OnDynamicLayoutUpdate();
			//pFrameWnd->RecalcLayout();

//			HWND hWndOwn = GetSafeHwnd();
//			ASSERT( hWndOwn != NULL );
//			ASSERT( ::IsWindow(hWndOwn) );
//			OnDynamicLayoutOptimize();
//			if( !::IsWindow(hWndOwn) )
//				return TRUE;


			CExtDynamicTabbedControlBar * pTabbedBar =
				STATIC_DOWNCAST(
					CExtDynamicTabbedControlBar,
					GetParent()
					);
			//pTabbedBar->SyncSwitcher();
			pTabbedBar->OnRepositionSingleChild();
		}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

		if( bEnableFrameDelayRecalcLayout )
			pFrameWnd->DelayRecalcLayout();
	} // else from if( m_bFloating && GetDockedVisibleCount() == 0 )

	return TRUE;
}

int CExtDockBar::Insert(
	CControlBar * pBarIns,
	CRect rect,
	CPoint ptMid
	)
{
	return _InsertByPointImpl( pBarIns, rect, ptMid );
}

int CExtDockBar::_InsertByPointImpl(
	CControlBar * pBarIns,
	CRect rect,
	CPoint ptMid
	)
{
	ASSERT_VALID( this );
	ASSERT( pBarIns != NULL );
	
//	ASSERT( pBarIns->m_pDockBar == this );

BOOL bExtBar = pBarIns->IsKindOf(RUNTIME_CLASS(CExtControlBar));
BOOL bExtFixedBar = FALSE;
	if( bExtBar )
		bExtFixedBar =  ((CExtControlBar *)pBarIns)->IsFixedMode();
BOOL bFixedBar = !bExtBar || bExtFixedBar;

INT nPos = 0, nPosInsAfter = -1, nWidth = 0, nTotalWidth = 0;
INT nCountOfSideBars = m_arrBars.GetSize();
BOOL bHorz = m_dwStyle & CBRS_ORIENT_HORZ;

CRect rcDockBarWnd;
	GetWindowRect( &rcDockBarWnd );
	if( rcDockBarWnd.PtInRect(ptMid) )
	{
		for( ; nPos < nCountOfSideBars; nPos++ )
		{
			CControlBar * pBar = GetDockedControlBar( nPos );
			if( pBar != NULL && pBar->IsVisible() )
			{
				CRect rcBar;
				pBar->GetWindowRect( &rcBar );
				//ScreenToClient( &rcBar );
				nWidth =
					max(
						nWidth,
						bHorz ? rcBar.Size().cy : rcBar.Size().cx - 1
						);
				if( bHorz
						? ( rect.left > rcBar.left )
						: ( rect.top  > rcBar.top  )
					)
				{
					//nPosInsAfter = nPos; // orig
					if( bFixedBar )
					{
						if( !pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
							nPosInsAfter = nPos;
						else if(
							((CExtControlBar *)pBar)->IsFixedMode()
							)
							nPosInsAfter = nPos;
					}
					else
						nPosInsAfter = nPos;
				}
				if( bFixedBar
					&& rcBar.PtInRect( ptMid )
//					&& pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
//					&& (	!(((CExtControlBar *)pBar)->IsFixedMode())
//						//|| pBar->IsKindOf(RUNTIME_CLASS(CExtMenuControlBar))
//						)
					)
				{
					INT nDistUp = 0, nDistDown = 0;
					if( bHorz )
					{
						nDistUp = ptMid.y - rcBar.top;
						nDistDown = rcBar.bottom - ptMid.y;
					} // if( bHorz )
					else
					{
						nDistUp = ptMid.x - rcBar.left;
						nDistDown = rcBar.right - ptMid.x;
					} // else from if( bHorz )
					bool bNextRow = ( nDistUp < nDistDown ) ? false : true;
					CControlBar * pFirstBar =
						CExtControlBar::_GetFirstControlBarInRow(
							pBar,
							bNextRow
							);
					ASSERT_VALID( pFirstBar );
					nPosInsAfter = FindBar( pFirstBar );
					ASSERT( nPosInsAfter > 0 && nPosInsAfter < nCountOfSideBars );

					if( bNextRow )
					{
						m_arrBars.InsertAt( nPosInsAfter+1, pBarIns );
						m_arrBars.InsertAt( nPosInsAfter+1, (CObject*)NULL );
						ASSERT_VALID( this );
						ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
						return nPosInsAfter+2;
					}
					else
					{
						m_arrBars.InsertAt( nPosInsAfter, (CObject*)NULL );
						m_arrBars.InsertAt( nPosInsAfter, pBarIns );
						ASSERT_VALID( this );
						ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
						return nPosInsAfter+1;
					}


//					if( !bNextRow )
///						nPosInsAfter --;
//					break;
				}
			} // if( pBar != NULL && pBar->IsVisible() )
			else
			{
				if( pBar != NULL )
					continue;
				// end of row because pBar == NULL
				nTotalWidth += nWidth - afxData.cyBorder2;
				nWidth = 0;
				if( (bHorz ? ptMid.y : ptMid.x) < nTotalWidth )
				{
					if( nPos == 0 ) // first section
					{
						m_arrBars.InsertAt( 1, (CObject*)NULL );
						m_arrBars.InsertAt( 1, pBarIns );
						ASSERT_VALID( this );
						ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
						return 1;
					} // if( nPos == 0 )
					else
					{
						if( !bFixedBar )
						{
							m_arrBars.InsertAt( nPos, pBarIns );
							ASSERT_VALID( this );
							ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
						}
						//if( nPosInsAfter < 0 || !bFixedBar )
						if( nPosInsAfter < 0 )
							break;

						ASSERT( nPosInsAfter >= 0 && nPosInsAfter <= nCountOfSideBars );
						CControlBar * pBar2 = (CControlBar *)m_arrBars[ nPosInsAfter ];
						if( pBar2 == NULL )
							break;
						if(  __PLACEHODLER_BAR_PTR(pBar2) )
							break;
						CRect rcBar2;
						pBar2->GetWindowRect( &rcBar2 );

						INT nDistUp = 0, nDistDown = 0;
						if( bHorz )
						{
							nDistUp = ptMid.y - rcBar2.top;
							nDistDown = rcBar2.bottom - ptMid.y;
						} // if( bHorz )
						else
						{
							nDistUp = ptMid.x - rcBar2.left;
							nDistDown = rcBar2.right - ptMid.x;
						} // else from if( bHorz )
						bool bNextRow = ( nDistUp < nDistDown ) ? false : true;
						CControlBar * pFirstBar =
							CExtControlBar::_GetFirstControlBarInRow(
								pBar2,
								bNextRow
								);
						ASSERT_VALID( pFirstBar );
						nPosInsAfter = FindBar( pFirstBar );
						ASSERT( nPosInsAfter > 0 && nPosInsAfter < nCountOfSideBars );

						if( bNextRow )
						{
							m_arrBars.InsertAt( nPosInsAfter+1, pBarIns );
							m_arrBars.InsertAt( nPosInsAfter+1, (CObject*)NULL );
							ASSERT_VALID( this );
							ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
							return nPosInsAfter+2;
						}
						else
						{
							m_arrBars.InsertAt( nPosInsAfter, (CObject*)NULL );
							m_arrBars.InsertAt( nPosInsAfter, pBarIns );
							ASSERT_VALID( this );
							ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );
							return nPosInsAfter+1;
						}

					} // else from if( nPos == 0 )
				}
//				nPosInsAfter = nPos;
			} // else from if( pBar != NULL && pBar->IsVisible() )

		} // for( ; nPos < nCountOfSideBars; nPos++ )
	} // if( rcDockBarWnd.PtInRect(ptMid) )

	if( nPosInsAfter < 0 )
	{
		INT nDistUp = 0, nDistDown = 0;
		if( bHorz )
		{
			nDistUp = ptMid.y - rcDockBarWnd.top;
			nDistDown = rcDockBarWnd.bottom - ptMid.y;
		} // if( bHorz )
		else
		{
			nDistUp = ptMid.x - rcDockBarWnd.left;
			nDistDown = rcDockBarWnd.right - ptMid.x;
		} // else from if( bHorz )
		bool bNextRow =
			( abs(nDistUp) < abs(nDistDown) )
			? false : true;
		nPosInsAfter = bNextRow ? (nCountOfSideBars-1) : 1;
	}

	ASSERT( nPosInsAfter < nCountOfSideBars );
	if( nPosInsAfter == nCountOfSideBars-1 )
		m_arrBars.InsertAt( nCountOfSideBars, (CObject*)NULL ); // upper bound NULL

	if( m_arrBars[ nPosInsAfter ] != NULL )
	{
		if( nPosInsAfter+1 < nCountOfSideBars
			&& m_arrBars[nPosInsAfter+1] != NULL
			)
			m_arrBars.InsertAt( nPosInsAfter+1, (CObject*)NULL );
	}

	m_arrBars.InsertAt( nPosInsAfter+1, pBarIns );

	for( nPos = nPosInsAfter; nPos > 0; nPos-- )
	{
		CControlBar * pBar = (CControlBar *)m_arrBars[nPos];
		if( pBar == NULL )
			break;
		if( __PLACEHODLER_BAR_PTR(pBar) )
		{
			pBar = _GetDockingFrameImpl()->GetControlBar( LOWORD( DWORD(pBar) ) );
			if( pBar == NULL )
				continue;
		}
	
		BOOL bPrevFixedCheck = TRUE;
		if( pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
			&& !((CExtControlBar *)pBar)->IsFixedMode()
			)
			bPrevFixedCheck = FALSE;
		if( bFixedBar != bPrevFixedCheck )
		{
			m_arrBars.InsertAt( nPosInsAfter+1, (CObject*)NULL );
			nPosInsAfter++;
		}

		break;
	} // for( INT nPos = nPosInsAfter; nPos > 0; nPos-- )
	
//	ASSERT( FindBar(pBarIns) == (nPosInsAfter+1) );
	ASSERT_VALID( this );
	ASSERT_BAR_LOCATION_IN_ROW( this, pBarIns );

	return nPosInsAfter+1;
}

#ifdef _DEBUG

void CExtDockBar::_AssertValid_CheckBarRows() const
{

	ASSERT( this != NULL );
	if( m_hWnd == NULL )
		return;
	if( ! ::IsWindow(m_hWnd) )
		return;

CRect rcMyWnd;
	GetWindowRect( &rcMyWnd );
CSize sizeMyWnd = rcMyWnd.Size();
	if( sizeMyWnd.cx < 40 || sizeMyWnd.cy < 40 )
		return;

INT nCountOfSideBars = m_arrBars.GetSize();
	ASSERT( nCountOfSideBars > 0 );

// first should be NULL
CControlBar * pFirstPosBar = (CControlBar *) m_arrBars[ 0 ];
	ASSERT( pFirstPosBar == NULL );

	if( m_nCircleNo == 0 )
		return;

// walk all rows and verify no empty rows
INT nRowEntryCount = 0; // including placeholders
INT nBar = 1;
	
	if( nCountOfSideBars > 2  )
	{
		for( ; nBar < nCountOfSideBars; nBar++ )
		{
			CControlBar * pBar = (CControlBar *) m_arrBars[ nBar ];
			if( pBar == NULL )
			{
				ASSERT( nRowEntryCount > 0 );
				nRowEntryCount = 0;
				continue;
			}
			nRowEntryCount++;
		} // for( ; nBar < nCountOfSideBars; nBar++ )
	}
}

void CExtDockBar::_AssertValid_FixedBarNotInNonfixedRow(
	CDockBar * pDockBar,
	CControlBar * pBar
	)
{
	// verify bar and its dockbar
	ASSERT_VALID( pBar );
	ASSERT_KINDOF( CControlBar, pBar->m_pDockBar );
	ASSERT( !pBar->IsDockBar() );
	ASSERT( !pBar->IsKindOf(RUNTIME_CLASS(CDockBar)) );
//	ASSERT( !pBar->IsFloating() );
	
//	ASSERT( pBar->m_pDockBar != NULL );
//	ASSERT_VALID( pBar->m_pDockBar );
//	ASSERT_KINDOF( CExtDockBar, pBar->m_pDockBar );
//CExtDockBar * pDockBar = (CExtDockBar *)pBar->m_pDockBar;

	ASSERT_VALID( pDockBar );
	ASSERT_KINDOF( CDockBar, pDockBar );

bool bCheckingFixedBar = true;
	// verify bar is not a kind of resizable bar
	if( pBar->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
	{
		CExtControlBar * pExtBar = (CExtControlBar *)pBar;
		if( !pExtBar->IsFixedMode() )
			bCheckingFixedBar = false;
	}

INT nCountOfSideBars = pDockBar->m_arrBars.GetSize();
	ASSERT( nCountOfSideBars > 0 );
INT nBarPosInDockBar = pDockBar->FindBar( pBar );
	ASSERT( nBarPosInDockBar > 0 && nBarPosInDockBar < nCountOfSideBars );

	// walk to begin of row
	for( INT nBar = nBarPosInDockBar-1; nBar > 0; nBar-- )
	{
		CControlBar * pBarExamine = (CControlBar *)
			pDockBar->m_arrBars[ nBar ];
		if( pBarExamine == NULL )
			break; // ok
		if( __PLACEHODLER_BAR_PTR(pBarExamine) )
			continue;
		ASSERT_VALID( pBarExamine );
		ASSERT_KINDOF( CControlBar, pBarExamine );
		ASSERT( pBarExamine->m_pDockBar == pDockBar );
		
		bool bFixedBar = true;
		if( pBarExamine->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
		{
			CExtControlBar * pExtBar = (CExtControlBar *)pBarExamine;
			//ASSERT( pExtBar->IsFixedMode() );
			if( !pExtBar->IsFixedMode() )
				bFixedBar = false;
		}
		ASSERT( bCheckingFixedBar == bFixedBar );
	}
	
	// walk to end of row
	for( nBar = nBarPosInDockBar+1; nBar < nCountOfSideBars; nBar++ )
	{
		CControlBar * pBarExamine = (CControlBar *)
			pDockBar->m_arrBars[ nBar ];
		if( pBarExamine == NULL )
			break; // ok
		if( __PLACEHODLER_BAR_PTR(pBarExamine) )
			continue;
		ASSERT_VALID( pBarExamine );
		ASSERT_KINDOF( CControlBar, pBarExamine );
		ASSERT( pBarExamine->m_pDockBar == pDockBar );

		bool bFixedBar = true;
		if( pBarExamine->IsKindOf(RUNTIME_CLASS(CExtControlBar)) )
		{
			CExtControlBar * pExtBar = (CExtControlBar *)pBarExamine;
			//ASSERT( pExtBar->IsFixedMode() );
			if( !pExtBar->IsFixedMode() )
				bFixedBar = false;
		}
		ASSERT( bCheckingFixedBar == bFixedBar );
	}
	
}

#endif // _DEBUG

void CExtDockBar::OnNcCalcSize(
	BOOL bCalcValidRects,
	NCCALCSIZE_PARAMS * lpncsp
	)
{
	ASSERT_VALID( this );
	bCalcValidRects;
	lpncsp;

#if (defined __DEBUG_PAINTING_AREAS_DOCKBAR__ )

CRect & rcClientLoc =
		reinterpret_cast < CRect & > ( lpncsp->rgrc[0] );
	rcClientLoc.DeflateRect( 0, 0, 1, 1 );

#endif // __DEBUG_PAINTING_AREAS_DOCKBAR__
}

void CExtDockBar::OnNcPaint()
{
	ASSERT_VALID( this );

#if (defined __DEBUG_PAINTING_AREAS_DOCKBAR__ )

CRect rcBarWnd, rcBarClient;
	GetWindowRect( &rcBarWnd );
	GetClientRect( &rcBarClient );
	ClientToScreen( &rcBarClient );
	if( rcBarWnd == rcBarClient )
		return;
CPoint ptDevOffset = -rcBarWnd.TopLeft();
	rcBarWnd.OffsetRect( ptDevOffset );
	rcBarClient.OffsetRect( ptDevOffset );

CWindowDC dcBarWnd( this );
	ASSERT( dcBarWnd.GetSafeHdc() != NULL );
	dcBarWnd.ExcludeClipRect( &rcBarClient );

BOOL bDynamicDockBar = IsKindOf( RUNTIME_CLASS(CExtDynamicDockBar) );

COLORREF clrDebugMargine = bDynamicDockBar
		? RGB( 255, 255, 0 )
		: RGB( 255, 0, 255 );

	dcBarWnd.FillSolidRect( &rcBarWnd, clrDebugMargine );

#endif // __DEBUG_PAINTING_AREAS_DOCKBAR__
}

CExtDockBar * CExtDockBar::_GetInCircle(
	UINT nDockBarID,
	bool bEnableCreateNew // = true
	)
{
	ASSERT_VALID( this );
UINT nOwnID = GetDlgCtrlID();
	if( nDockBarID == nOwnID )
		return this;
CFrameWnd * pFrame = GetParentFrame();
	ASSERT_VALID( pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );
	return
		_GetInCircle(
			pFrame,
			m_nCircleNo,
			nDockBarID,
			bEnableCreateNew
			);
}

CExtDockBar * CExtDockBar::_GetInCircle(
	CFrameWnd * pFrame,
	UINT nCircleNo,
	UINT nDockBarID,
	bool bEnableCreateNew // = true
	)
{
	ASSERT_VALID( pFrame );
POSITION pos = pFrame->m_listControlBars.GetHeadPosition();
	ASSERT( pos != NULL );
	while( pos != NULL )
	{
		CControlBar * pBar = (CControlBar *)
			pFrame->m_listControlBars.GetNext( pos );
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CControlBar, pBar );
		if( !pBar->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
			continue;
		UINT nID = pBar->GetDlgCtrlID();
		if( nID != nDockBarID )
			continue;
		UINT nCircleNo2 = ((CExtDockBar *)pBar)->_GetCircleNo();
		if( nCircleNo == nCircleNo2 )
			return ((CExtDockBar *)pBar);
	} // while( pos != NULL )
	if( !bEnableCreateNew )
		return NULL;
	_CreateInnerCircle( pFrame );
CExtDockBar * pDockBar =
		_GetInCircle(
			pFrame,
			nCircleNo,
			nDockBarID,
			bEnableCreateNew
			);
	ASSERT_VALID( pDockBar );
	return pDockBar;
}

UINT CExtDockBar::_CreateInnerCircle()
{
	ASSERT_VALID( this );
	if( _GetDockBarInner() != NULL )
	{
		ASSERT_VALID( _GetDockBarInner() );
		return ( _GetCircleNo() + 1 );
	}
CFrameWnd * pFrame = GetParentFrame();
	ASSERT_VALID( pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );
	return _CreateInnerCircle( pFrame );
}

UINT CExtDockBar::_CreateInnerCircle( CFrameWnd * pFrame )
{
	ASSERT_VALID( pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );

UINT nCircleNo = 0;
CExtDockBar * vInnerCircle[4] = { NULL, NULL, NULL, NULL };
CExtDockBar * vCreatingCircle[4] = { NULL, NULL, NULL, NULL };

POSITION pos = pFrame->m_listControlBars.GetHeadPosition();
	ASSERT( pos != NULL );
	while( pos != NULL )
	{
		CControlBar * pBar = (CControlBar *)
			pFrame->m_listControlBars.GetNext( pos );
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CControlBar, pBar );
		if( !pBar->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
			continue;
		if( pBar->IsKindOf(RUNTIME_CLASS(CExtDynamicDockBar)) )
			continue;
		UINT nCircleNo2 = ((CExtDockBar *)pBar)->_GetCircleNo();
		if( nCircleNo2 < nCircleNo )
			continue;
		nCircleNo = nCircleNo2;
		UINT nID = pBar->GetDlgCtrlID();
		//if( nID == AFX_IDW_DOCKBAR_FLOAT )
		//	continue;
		ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nID );
		switch( nID )
		{
		case AFX_IDW_DOCKBAR_TOP:
			vInnerCircle[0] = ((CExtDockBar *)pBar);
			break;
		case AFX_IDW_DOCKBAR_BOTTOM:
			vInnerCircle[1] = ((CExtDockBar *)pBar);
			break;
		case AFX_IDW_DOCKBAR_LEFT:
			vInnerCircle[2] = ((CExtDockBar *)pBar);
			break;
		case AFX_IDW_DOCKBAR_RIGHT:
			vInnerCircle[3] = ((CExtDockBar *)pBar);
			break;
#ifdef _DEBUG
		default:
			ASSERT( FALSE );
			break;
#endif // _DEBUG
		} // switch( nID )
	} // while( pos != NULL )

	ASSERT( vInnerCircle[0] != NULL );
	ASSERT( vInnerCircle[1] != NULL );
	ASSERT( vInnerCircle[2] != NULL );
	ASSERT( vInnerCircle[3] != NULL );

#ifdef _DEBUG
	if( vInnerCircle[0]->m_pDockBarInner == NULL )
	{
		ASSERT( vInnerCircle[1]->m_pDockBarInner == NULL );
		ASSERT( vInnerCircle[2]->m_pDockBarInner == NULL );
		ASSERT( vInnerCircle[3]->m_pDockBarInner == NULL );
	}
	else
	{
		ASSERT( vInnerCircle[1]->m_pDockBarInner != NULL );
		ASSERT( vInnerCircle[2]->m_pDockBarInner != NULL );
		ASSERT( vInnerCircle[3]->m_pDockBarInner != NULL );
	}
	if( vInnerCircle[0]->m_pDockBarOuter == NULL )
	{
		ASSERT( vInnerCircle[1]->m_pDockBarOuter == NULL );
		ASSERT( vInnerCircle[2]->m_pDockBarOuter == NULL );
		ASSERT( vInnerCircle[3]->m_pDockBarOuter == NULL );
	}
	else
	{
		ASSERT( vInnerCircle[1]->m_pDockBarOuter != NULL );
		ASSERT( vInnerCircle[2]->m_pDockBarOuter != NULL );
		ASSERT( vInnerCircle[3]->m_pDockBarOuter != NULL );
	}
#endif // _DEBUG

	nCircleNo ++;


	for( INT i = 0; i<4; i++ )
	{
		CExtDockBar * pBar = vInnerCircle[i];
		UINT nID = pBar->GetDlgCtrlID();
		ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nID );
		ASSERT( vCreatingCircle[i] == NULL );
		vCreatingCircle[i] =
			new CExtDockBar( nCircleNo );
static const DWORD dwAlignFlags[4] =
{
	CBRS_ALIGN_TOP,
	CBRS_ALIGN_BOTTOM,
	CBRS_ALIGN_LEFT,
	CBRS_ALIGN_RIGHT
};
		DWORD dwStyle =
			WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN
			|dwAlignFlags[i] // |CBRS_ALIGN_ANY
			;
		VERIFY(
			vCreatingCircle[i]->Create( pFrame, dwStyle, nID )
			);
		ASSERT( pBar->m_pDockBarInner == NULL );
		ASSERT( vCreatingCircle[i]->m_pDockBarInner == NULL );
		ASSERT( vCreatingCircle[i]->m_pDockBarOuter == NULL );
		pBar->m_pDockBarInner = vCreatingCircle[i];
		vCreatingCircle[i]->m_pDockBarOuter = pBar;
		vCreatingCircle[i]->SetBarStyle( pBar->GetBarStyle() );

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		vCreatingCircle[i]->m_pWndAutoHideArea =
			pBar->m_pWndAutoHideArea;
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		
		
		if( (pBar->GetStyle() & WS_VISIBLE) != NULL
			&& pBar->GetDockedVisibleCount() != 0
			)
		{
			pBar->GetWindowRect( &vCreatingCircle[i]->m_rcLastInvisiblePreCalc );
			switch( nID )
			{
			case AFX_IDW_DOCKBAR_TOP:
				ASSERT( vCreatingCircle[i]->m_rcLastInvisiblePreCalc.left <= vCreatingCircle[i]->m_rcLastInvisiblePreCalc.right );
				vCreatingCircle[i]->m_rcLastInvisiblePreCalc.bottom = vCreatingCircle[i]->m_rcLastInvisiblePreCalc.top; // + 1;
				break;
			case AFX_IDW_DOCKBAR_BOTTOM:
				ASSERT( vCreatingCircle[i]->m_rcLastInvisiblePreCalc.left <= vCreatingCircle[i]->m_rcLastInvisiblePreCalc.right );
				vCreatingCircle[i]->m_rcLastInvisiblePreCalc.top = vCreatingCircle[i]->m_rcLastInvisiblePreCalc.bottom; //  - 1;
				break;
			case AFX_IDW_DOCKBAR_LEFT:
				ASSERT( vCreatingCircle[i]->m_rcLastInvisiblePreCalc.top <= vCreatingCircle[i]->m_rcLastInvisiblePreCalc.bottom );
				vCreatingCircle[i]->m_rcLastInvisiblePreCalc.right = vCreatingCircle[i]->m_rcLastInvisiblePreCalc.left; //  + 1;
				break;
			case AFX_IDW_DOCKBAR_RIGHT:
				ASSERT( vCreatingCircle[i]->m_rcLastInvisiblePreCalc.top <= vCreatingCircle[i]->m_rcLastInvisiblePreCalc.bottom );
				vCreatingCircle[i]->m_rcLastInvisiblePreCalc.left = vCreatingCircle[i]->m_rcLastInvisiblePreCalc.right; //  - 1;
				break;
#ifdef _DEBUG
			default:
				ASSERT( FALSE );
				break;
#endif // _DEBUG
			} // switch( nID )
		} // if( (pBar->GetStyle()&WS_VISIBLE) != NULL  .....
		else
			vCreatingCircle[i]->m_rcLastInvisiblePreCalc = pBar->m_rcLastInvisiblePreCalc;

		// reposition created circle in parent HWND list
		switch( nID )
		{
		case AFX_IDW_DOCKBAR_TOP:
			ASSERT( i == 0 );
			ASSERT( vCreatingCircle[i] != NULL );
			ASSERT( vCreatingCircle[i]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCreatingCircle[i]->GetSafeHwnd() ) );
			ASSERT( vInnerCircle[3] != NULL );
			ASSERT( vInnerCircle[3]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vInnerCircle[3]->GetSafeHwnd() ) );
			VERIFY(
				::SetWindowPos(
					vCreatingCircle[i]->GetSafeHwnd(),
					vInnerCircle[3]->GetSafeHwnd(),
					0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOMOVE
						|SWP_NOREDRAW|SWP_NOACTIVATE|SWP_NOCOPYBITS
						|SWP_NOSENDCHANGING
					)
				);
			break;
		case AFX_IDW_DOCKBAR_BOTTOM:
		case AFX_IDW_DOCKBAR_LEFT:
		case AFX_IDW_DOCKBAR_RIGHT:
			ASSERT( i >= 1 && i <= 3 );
			ASSERT( vCreatingCircle[i] != NULL );
			ASSERT( vCreatingCircle[i]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCreatingCircle[i]->GetSafeHwnd() ) );
			ASSERT( vCreatingCircle[i-1] != NULL );
			ASSERT( vCreatingCircle[i-1]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCreatingCircle[i-1]->GetSafeHwnd() ) );
			VERIFY(
				::SetWindowPos(
					vCreatingCircle[i]->GetSafeHwnd(),
					vCreatingCircle[i-1]->GetSafeHwnd(),
					0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOMOVE
						|SWP_NOREDRAW|SWP_NOACTIVATE|SWP_NOCOPYBITS
						|SWP_NOSENDCHANGING
					)
				);
			break;
#ifdef _DEBUG
		default:
			ASSERT( FALSE );
			break;
#endif // _DEBUG
		} // switch( nID )
	
	}

	ASSERT( vInnerCircle[0]->m_pDockBarInner != NULL );
	ASSERT( vInnerCircle[1]->m_pDockBarInner != NULL );
	ASSERT( vInnerCircle[2]->m_pDockBarInner != NULL );
	ASSERT( vInnerCircle[3]->m_pDockBarInner != NULL );
	
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	if( vInnerCircle[0]->m_pWndAutoHideArea != NULL )
	{
		vInnerCircle[0]->m_pWndAutoHideArea->AdjustOrder();
		vInnerCircle[1]->m_pWndAutoHideArea->AdjustOrder();
		vInnerCircle[2]->m_pWndAutoHideArea->AdjustOrder();
		vInnerCircle[3]->m_pWndAutoHideArea->AdjustOrder();
	}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

	ASSERT( nCircleNo > 0 );
	return nCircleNo;
}

void CExtDockBar::_InjectInnerCircle()
{
	ASSERT_VALID( this );
	_InjectCircle( m_nCircleNo + 1 );
}

void CExtDockBar::_InjectCircle( UINT nCircleNo )
{
	ASSERT_VALID( this );
	ASSERT( nCircleNo > 0 );

CFrameWnd * pFrame = GetParentFrame();
	ASSERT_VALID( pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );
	_InjectCircle( pFrame, nCircleNo );
}

void CExtDockBar::_InjectCircle( CFrameWnd * pFrame, UINT nCircleNo )
{
	ASSERT_VALID( pFrame );
	ASSERT( nCircleNo > 0 );

CExtDockBar * vCircleOld[4];
	vCircleOld[0] = (CExtDockBar *)pFrame->GetControlBar( AFX_IDW_DOCKBAR_TOP );
	vCircleOld[1] = (CExtDockBar *)pFrame->GetControlBar( AFX_IDW_DOCKBAR_BOTTOM );
	vCircleOld[2] = (CExtDockBar *)pFrame->GetControlBar( AFX_IDW_DOCKBAR_LEFT );
	vCircleOld[3] = (CExtDockBar *)pFrame->GetControlBar( AFX_IDW_DOCKBAR_RIGHT );
bool bEmptyCircleExist = true;
	for( INT nDockSide = 0; nDockSide < 4; nDockSide++ )
	{
		ASSERT_VALID( vCircleOld[nDockSide] );
		ASSERT_KINDOF( CExtDockBar, vCircleOld[nDockSide] );
		ASSERT( vCircleOld[nDockSide]->_GetCircleNo() == 0 );
		vCircleOld[nDockSide] = vCircleOld[nDockSide]->_GetBarByCircleNo( nCircleNo );
		ASSERT_VALID( vCircleOld[nDockSide] );
		ASSERT( vCircleOld[nDockSide]->_GetCircleNo() == nCircleNo );
		if( ! vCircleOld[nDockSide]->_CanBeSafeOptimized() )
			bEmptyCircleExist = false;
	} // for( INT nDockSide = 0; nDockSide < 4; nDockSide++ )
	if( bEmptyCircleExist )
	{
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		if( vCircleOld[0]->m_pWndAutoHideArea != NULL )
		{
			vCircleOld[0]->m_pWndAutoHideArea->AdjustOrder();
			vCircleOld[1]->m_pWndAutoHideArea->AdjustOrder();
			vCircleOld[2]->m_pWndAutoHideArea->AdjustOrder();
			vCircleOld[3]->m_pWndAutoHideArea->AdjustOrder();
		}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		return;
	}

CExtDockBar * vCircleNew[4] = { NULL, NULL, NULL, NULL };
	for( nDockSide = 0; nDockSide < 4; nDockSide++ )
	{
		ASSERT_VALID( vCircleOld[nDockSide] );
		ASSERT( vCircleOld[nDockSide]->_GetCircleNo() == nCircleNo );

		UINT nID = vCircleOld[nDockSide]->GetDlgCtrlID();
		ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nID );
		vCircleNew[nDockSide] =
			new CExtDockBar( nCircleNo );
		
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		vCircleNew[nDockSide]->m_pWndAutoHideArea =
			vCircleOld[nDockSide]->m_pWndAutoHideArea;
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		
static const DWORD dwAlignFlags[4] =
{
	CBRS_ALIGN_TOP,
	CBRS_ALIGN_BOTTOM,
	CBRS_ALIGN_LEFT,
	CBRS_ALIGN_RIGHT
};
		DWORD dwStyle =
			WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN
			|dwAlignFlags[nDockSide] // |CBRS_ALIGN_ANY
			;
		VERIFY(
			vCircleNew[nDockSide]->Create( pFrame, dwStyle, nID )
			);
		ASSERT( vCircleNew[nDockSide]->m_pDockBarInner == NULL );
		ASSERT( vCircleNew[nDockSide]->m_pDockBarOuter == NULL );
		ASSERT( vCircleOld[nDockSide]->m_pDockBarOuter != NULL );
		ASSERT( vCircleOld[nDockSide]->m_pDockBarOuter->m_pDockBarInner == vCircleOld[nDockSide] );
		
		vCircleOld[nDockSide]->m_pDockBarOuter->m_pDockBarInner = vCircleNew[nDockSide];
		vCircleNew[nDockSide]->m_pDockBarOuter = vCircleOld[nDockSide]->m_pDockBarOuter;
		vCircleOld[nDockSide]->m_pDockBarOuter = vCircleNew[nDockSide];
		vCircleNew[nDockSide]->m_pDockBarInner = vCircleOld[nDockSide];

		vCircleNew[nDockSide]->SetBarStyle(
			vCircleOld[nDockSide]->GetBarStyle()
			);
		if( (vCircleOld[nDockSide]->GetStyle() & WS_VISIBLE) != NULL
			&& vCircleOld[nDockSide]->GetDockedVisibleCount() != 0
			)
		{
			vCircleOld[nDockSide]->GetWindowRect(
				&(vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc)
				);
			switch( nID )
			{
			case AFX_IDW_DOCKBAR_TOP:
				ASSERT( vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.left <= vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.right );
				vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.bottom = vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.top; // + 1;
				break;
			case AFX_IDW_DOCKBAR_BOTTOM:
				ASSERT( vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.left <= vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.right );
				vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.top = vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.bottom; //  - 1;
				break;
			case AFX_IDW_DOCKBAR_LEFT:
				ASSERT( vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.top <= vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.bottom );
				vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.right = vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.left; //  + 1;
				break;
			case AFX_IDW_DOCKBAR_RIGHT:
				ASSERT( vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.top <= vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.bottom );
				vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.left = vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc.right; //  - 1;
				break;
#ifdef _DEBUG
			default:
				ASSERT( FALSE );
				break;
#endif // _DEBUG
			} // switch( nID )
		} // if( (vCircleOld[nDockSide]->GetStyle()&WS_VISIBLE) != NULL  .....
		else
			vCircleNew[nDockSide]->m_rcLastInvisiblePreCalc =
				vCircleOld[nDockSide]->m_rcLastInvisiblePreCalc;
		
		for(	CExtDockBar * pResetNoBar = vCircleOld[nDockSide];
				pResetNoBar != NULL;
				pResetNoBar = pResetNoBar->m_pDockBarInner
				)
			pResetNoBar->m_nCircleNo++;

		switch( nID )
		{
		case AFX_IDW_DOCKBAR_TOP:
			ASSERT( nDockSide == 0 );
			ASSERT( vCircleOld[3]->m_pDockBarOuter != NULL );
			ASSERT( vCircleOld[3]->m_pDockBarOuter->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCircleOld[3]->m_pDockBarOuter->GetSafeHwnd() ) );

			ASSERT( vCircleNew[nDockSide] != NULL );
			ASSERT( vCircleNew[nDockSide]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCircleNew[nDockSide]->GetSafeHwnd() ) );

			VERIFY(
				::SetWindowPos(
					vCircleNew[nDockSide]->GetSafeHwnd(),
					vCircleOld[3]->m_pDockBarOuter->GetSafeHwnd(),
					0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOMOVE
						|SWP_NOREDRAW|SWP_NOACTIVATE|SWP_NOCOPYBITS
						|SWP_NOSENDCHANGING
					)
				);
			break;
		case AFX_IDW_DOCKBAR_BOTTOM:
		case AFX_IDW_DOCKBAR_LEFT:
		case AFX_IDW_DOCKBAR_RIGHT:
			ASSERT( nDockSide > 0 );
			ASSERT( vCircleNew[nDockSide-1] != NULL );
			ASSERT( vCircleNew[nDockSide-1]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCircleNew[nDockSide-1]->GetSafeHwnd() ) );

			ASSERT( vCircleNew[nDockSide] != NULL );
			ASSERT( vCircleNew[nDockSide]->GetSafeHwnd() != NULL );
			ASSERT( ::IsWindow( vCircleNew[nDockSide]->GetSafeHwnd() ) );

			VERIFY(
				::SetWindowPos(
					vCircleNew[nDockSide]->GetSafeHwnd(),
					vCircleNew[nDockSide-1]->GetSafeHwnd(),
					0, 0, 0, 0,
					SWP_NOSIZE|SWP_NOMOVE
						|SWP_NOREDRAW|SWP_NOACTIVATE|SWP_NOCOPYBITS
						|SWP_NOSENDCHANGING
					)
				);
			break;
#ifdef _DEBUG
		default:
			ASSERT( FALSE );
			break;
#endif // _DEBUG
		} // switch( nID )

//		VERIFY(
//			::SetWindowPos(
//				vCircleNew[nDockSide]->GetSafeHwnd(),
//				vCircleOld[nDockSide]->m_pDockBarOuter->_GetHwndForInjectingAfter(),
//				0, 0, 0, 0,
//				SWP_NOSIZE|SWP_NOMOVE
//					|SWP_NOREDRAW|SWP_NOACTIVATE|SWP_NOCOPYBITS
//					|SWP_NOSENDCHANGING
//				)
//			);

	} // for( nDockSide = 0; nDockSide < 4; nDockSide++ )
	ASSERT_VALID( vCircleNew[0] );
	ASSERT_VALID( vCircleNew[1] );
	ASSERT_VALID( vCircleNew[2] );
	ASSERT_VALID( vCircleNew[3] );

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	if( vCircleNew[0]->m_pWndAutoHideArea != NULL )
	{
		vCircleNew[0]->m_pWndAutoHideArea->AdjustOrder();
		vCircleNew[1]->m_pWndAutoHideArea->AdjustOrder();
		vCircleNew[2]->m_pWndAutoHideArea->AdjustOrder();
		vCircleNew[3]->m_pWndAutoHideArea->AdjustOrder();
	}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
}

#ifdef _DEBUG

void CExtDockBar::_Assert_HwndIsDockbar(
	HWND hWndDockBar,
	UINT nDockBarID,
	UINT nCircleNo
	)
{
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nDockBarID );
	ASSERT( hWndDockBar != NULL );
	ASSERT( ::IsWindow( hWndDockBar ) );
CWnd * pWndDockBar = CWnd::FromHandlePermanent( hWndDockBar );
	ASSERT_VALID( pWndDockBar );
CExtDockBar * pDockBar =
		STATIC_DOWNCAST( CExtDockBar, pWndDockBar );
UINT nRealDockBarID = pDockBar->GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nRealDockBarID );
	ASSERT( nDockBarID == nRealDockBarID );
UINT nRealCircleNo = pDockBar->_GetCircleNo();
	ASSERT( nRealCircleNo == nCircleNo );
}

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
void CExtDockBar::_Assert_HwndIsAutoHider(
	HWND hWndAutoHider,
	UINT nAutoHiderID
	)
{
	ASSERT( hWndAutoHider != NULL );
	ASSERT( ::IsWindow( hWndAutoHider ) );
CWnd * pWndAutoHider = CWnd::FromHandlePermanent( hWndAutoHider );
	ASSERT_VALID( pWndAutoHider );
CExtDynamicAutoHideArea * pAutoHider =
		STATIC_DOWNCAST( CExtDynamicAutoHideArea, pWndAutoHider );
UINT nRealAutoHiderID = pAutoHider->GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nRealAutoHiderID );
	ASSERT( nAutoHiderID == nRealAutoHiderID );
}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

#endif // _DEBUG

//HWND CExtDockBar::_GetHwndForInjectingAfter()
//{
//	ASSERT_VALID( this );
//HWND hWndOwn = GetSafeHwnd();
//	ASSERT( hWndOwn != NULL );
//	ASSERT( ::IsWindow( hWndOwn ) );
//
//UINT nOwnID = GetDlgCtrlID();
//	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );
//
//HWND hWndAutoHideArea = m_pWndAutoHideArea->GetSafeHwnd();
//UINT nOwnCircleNo =  _GetCircleNo();
//
//HWND hWndInsertAfter =
//		(hWndAutoHideArea != NULL && nOwnCircleNo == 0)
//			? hWndAutoHideArea
//			: hWndOwn
//			;
//	switch( nOwnID )
//	{
//	case AFX_IDW_DOCKBAR_TOP:
//	{
//		// get dockbar in same circle (nOwnCircleNo) - bottom
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM, nOwnCircleNo );
//		// get dockbar in same circle (nOwnCircleNo) - left
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT, nOwnCircleNo );
//		// get dockbar in same circle (nOwnCircleNo) - right
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT, nOwnCircleNo );
//		if( nOwnCircleNo == 0 && hWndAutoHideArea != NULL )
//		{
//			// get autohider - top
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP );
//			// get autohider - bottom
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM );
//			// get autohider - left
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT );
//			// get autohider - right
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT );
//		}
//	}
//	break; // case AFX_IDW_DOCKBAR_TOP
//	case AFX_IDW_DOCKBAR_BOTTOM:
//	{
//		// get dockbar in same circle (nOwnCircleNo) - left
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT, nOwnCircleNo );
//		// get dockbar in same circle (nOwnCircleNo) - right
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT, nOwnCircleNo );
//		if( nOwnCircleNo == 0 && hWndAutoHideArea != NULL )
//		{
//			// get autohider - top
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP );
//			// get autohider - bottom
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM );
//			// get autohider - left
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT );
//			// get autohider - right
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT );
//		}
//		// get dockbar in next circle (nOwnCircleNo+1) - top
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP, (nOwnCircleNo+1) );
//	}
//	break; // case AFX_IDW_DOCKBAR_BOTTOM
//	case AFX_IDW_DOCKBAR_LEFT:
//	{
//		// get dockbar in same circle (nOwnCircleNo) - right
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT, nOwnCircleNo );
//		if( nOwnCircleNo == 0 && hWndAutoHideArea != NULL )
//		{
//			// get autohider - top
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP );
//			// get autohider - bottom
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM );
//			// get autohider - left
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT );
//			// get autohider - right
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT );
//		}
//		// get dockbar in next circle (nOwnCircleNo+1) - top
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP, (nOwnCircleNo+1) );
//		// get dockbar in next circle (nOwnCircleNo+1) - bottom
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM, (nOwnCircleNo+1) );
//	}
//	break; // case AFX_IDW_DOCKBAR_LEFT
//	case AFX_IDW_DOCKBAR_RIGHT:
//	{
//		if( nOwnCircleNo == 0 && hWndAutoHideArea != NULL )
//		{
//			// get autohider - top
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP );
//			// get autohider - bottom
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM );
//			// get autohider - left
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT );
//			// get autohider - right
//			hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//			ASSERT_HWND_IS_AUTOHIDER( hWndInsertAfter, AFX_IDW_DOCKBAR_RIGHT );
//		}
//		// get dockbar in next circle (nOwnCircleNo+1) - top
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_TOP, (nOwnCircleNo+1) );
//		// get dockbar in next circle (nOwnCircleNo+1) - bottom
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_BOTTOM, (nOwnCircleNo+1) );
//		// get dockbar in next circle (nOwnCircleNo+1) - left
//		hWndInsertAfter = ::GetWindow( hWndInsertAfter, GW_HWNDNEXT );
//		ASSERT_HWND_IS_DOCKBAR( hWndInsertAfter, AFX_IDW_DOCKBAR_LEFT, (nOwnCircleNo+1) );
//	}
//	break; // case AFX_IDW_DOCKBAR_RIGHT
//#ifdef _DEBUG
//	default:
//		ASSERT( FALSE );
//		break;
//#endif // _DEBUG
//	} // switch( nOwnID )
//
//
//	ASSERT( hWndInsertAfter != NULL );
//	return hWndInsertAfter;
//}

CExtDockBar * CExtDockBar::_GetBarByCircleNo( UINT nCircleNo )
{
	ASSERT_VALID( this );
	if( nCircleNo == m_nCircleNo )
		return this;
	if( nCircleNo < m_nCircleNo )
	{
		ASSERT( m_nCircleNo > 0 );
		ASSERT( m_pDockBarOuter != NULL );
		return m_pDockBarOuter->_GetBarByCircleNo( nCircleNo );
	}

	if( m_pDockBarInner == NULL )
	{
#ifdef _DEBUG
		UINT nNewCircle =
#endif // _DEBUG
			_CreateInnerCircle();
		ASSERT( nNewCircle == (m_nCircleNo + 1) );
	}
	ASSERT( m_pDockBarInner != NULL );
	ASSERT( m_pDockBarInner->m_nCircleNo == (m_nCircleNo + 1) );
	return m_pDockBarInner->_GetBarByCircleNo( nCircleNo );
}

LRESULT CExtDockBar::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch( message )
	{
	case WM_CREATE:
		EnableToolTips();
	break;
	case WM_DESTROY:
	case WM_NCDESTROY:
		if( m_pDockBarInner != NULL )
		{
			ASSERT( m_pDockBarInner->m_pDockBarOuter == this );
			m_pDockBarInner->m_pDockBarOuter = NULL;
			m_pDockBarInner = NULL;
		}
		if( m_pDockBarOuter != NULL )
		{
			ASSERT( m_pDockBarOuter->m_pDockBarInner == this );
			m_pDockBarOuter->m_pDockBarInner = NULL;
			m_pDockBarOuter = NULL;
		}
		break;
	} // switch( message )

	return CControlBar::WindowProc(message, wParam, lParam);
}

void CExtDockBar::_OptimizeCircles()
{
	ASSERT_VALID( this );

CFrameWnd * pFrame = GetParentFrame();
	ASSERT_VALID( pFrame );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );

	if( !m_bLockedOptimize )
		_OptimizeCircles( pFrame );
}

void CExtDockBar::_OptimizeCircles( CFrameWnd * pFrame )
{
	ASSERT_VALID( pFrame );

CExtDockBar * vCircle[4];

	vCircle[0] = (CExtDockBar*)pFrame->GetControlBar( AFX_IDW_DOCKBAR_TOP );
	ASSERT_VALID( vCircle[0] );
	ASSERT_KINDOF( CExtDockBar, vCircle[0] );
	ASSERT( vCircle[0]->_GetCircleNo() == 0 );
	vCircle[1] = (CExtDockBar*)pFrame->GetControlBar( AFX_IDW_DOCKBAR_BOTTOM );
	ASSERT_VALID( vCircle[1] );
	ASSERT_KINDOF( CExtDockBar, vCircle[1] );
	ASSERT( vCircle[1]->_GetCircleNo() == 0 );
	vCircle[2] = (CExtDockBar*)pFrame->GetControlBar( AFX_IDW_DOCKBAR_LEFT );
	ASSERT_VALID( vCircle[2] );
	ASSERT_KINDOF( CExtDockBar, vCircle[2] );
	ASSERT( vCircle[2]->_GetCircleNo() == 0 );
	vCircle[3] = (CExtDockBar*)pFrame->GetControlBar( AFX_IDW_DOCKBAR_RIGHT );
	ASSERT_VALID( vCircle[3] );
	ASSERT_KINDOF( CExtDockBar, vCircle[3] );
	ASSERT( vCircle[3]->_GetCircleNo() == 0 );

	if( vCircle[0]->_GetDockBarInner() == NULL )
		return;
	vCircle[0] = vCircle[0]->_GetDockBarInner();
	ASSERT( vCircle[0] != NULL );
	ASSERT_KINDOF( CExtDockBar, vCircle[0] );
	ASSERT( vCircle[0]->_GetCircleNo() == 1 );
	
	vCircle[1] = vCircle[1]->_GetDockBarInner();
	ASSERT( vCircle[1] != NULL );
	ASSERT_KINDOF( CExtDockBar, vCircle[1] );
	ASSERT( vCircle[1]->_GetCircleNo() == 1 );
	
	vCircle[2] = vCircle[2]->_GetDockBarInner();
	ASSERT( vCircle[2] != NULL );
	ASSERT_KINDOF( CExtDockBar, vCircle[2] );
	ASSERT( vCircle[2]->_GetCircleNo() == 1 );
	
	vCircle[3] = vCircle[3]->_GetDockBarInner();
	ASSERT( vCircle[3] != NULL );
	ASSERT_KINDOF( CExtDockBar, vCircle[3] );
	ASSERT( vCircle[3]->_GetCircleNo() == 1 );

//bool bCreateInnerCircle = true;

UINT nCircleShift = 0;
#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
bool bAutoHidersPassed = false;
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	while( vCircle[0] != NULL )
	{
		ASSERT( vCircle[0] != NULL );
		ASSERT_KINDOF( CExtDockBar, vCircle[0] );
		ASSERT( vCircle[1] != NULL );
		ASSERT_KINDOF( CExtDockBar, vCircle[1] );
		ASSERT( vCircle[2] != NULL );
		ASSERT_KINDOF( CExtDockBar, vCircle[2] );
		ASSERT( vCircle[3] != NULL );
		ASSERT_KINDOF( CExtDockBar, vCircle[3] );

		ASSERT( vCircle[0]->m_nCircleNo == vCircle[1]->m_nCircleNo );
		ASSERT( vCircle[0]->m_nCircleNo == vCircle[2]->m_nCircleNo );
		ASSERT( vCircle[0]->m_nCircleNo == vCircle[3]->m_nCircleNo );

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
		if( !bAutoHidersPassed )
		{
			bAutoHidersPassed = true;
			if( vCircle[0]->m_pWndAutoHideArea != NULL )
			{
				vCircle[0]->m_pWndAutoHideArea->AdjustOrder();
				vCircle[1]->m_pWndAutoHideArea->AdjustOrder();
				vCircle[2]->m_pWndAutoHideArea->AdjustOrder();
				vCircle[3]->m_pWndAutoHideArea->AdjustOrder();
			}
		}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

		if( nCircleShift != 0 )
		{
			ASSERT( vCircle[0]->m_nCircleNo > nCircleShift );
			vCircle[0]->m_nCircleNo -= nCircleShift;
			vCircle[1]->m_nCircleNo -= nCircleShift;
			vCircle[2]->m_nCircleNo -= nCircleShift;
			vCircle[3]->m_nCircleNo -= nCircleShift;
		}

		CExtDockBar * vCircleOptimize[4];
		
		vCircleOptimize[0] = vCircle[0];
		vCircleOptimize[1] = vCircle[1];
		vCircleOptimize[2] = vCircle[2];
		vCircleOptimize[3] = vCircle[3];

//		bool bLastCircle =
//			( vCircle[0]->_GetDockBarInner() != NULL ) ? true : false;

		vCircle[0] = vCircle[0]->_GetDockBarInner();
		vCircle[1] = vCircle[1]->_GetDockBarInner();
		vCircle[2] = vCircle[2]->_GetDockBarInner();
		vCircle[3] = vCircle[3]->_GetDockBarInner();

		if(		vCircleOptimize[0]->_CanBeSafeOptimized()
			&&	vCircleOptimize[1]->_CanBeSafeOptimized()
			&&	vCircleOptimize[2]->_CanBeSafeOptimized()
			&&	vCircleOptimize[3]->_CanBeSafeOptimized()
			)
		{
//			if( bLastCircle )
//			{
//				bCreateInnerCircle = false;
//				break;
//			}

#ifdef __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
			ASSERT( !vCircleOptimize[0]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[1]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[2]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[3]->m_bLockedOptimize );
#endif // __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
			
			vCircleOptimize[0]->_SafeOptimizeInnerOuterChain();
			vCircleOptimize[1]->_SafeOptimizeInnerOuterChain();
			vCircleOptimize[2]->_SafeOptimizeInnerOuterChain();
			vCircleOptimize[3]->_SafeOptimizeInnerOuterChain();
			
			nCircleShift++;
		}
		else
		{
#ifdef __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
			ASSERT( !vCircleOptimize[0]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[1]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[2]->m_bLockedOptimize );
			ASSERT( !vCircleOptimize[3]->m_bLockedOptimize );
#endif // __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
			
			vCircleOptimize[0]->OnDynamicLayoutOptimize();
			vCircleOptimize[1]->OnDynamicLayoutOptimize();
			vCircleOptimize[2]->OnDynamicLayoutOptimize();
			vCircleOptimize[3]->OnDynamicLayoutOptimize();
		}

	} // while( vCircle[0] != NULL )

//	if( bCreateInnerCircle )
//		_CreateInnerCircle( pFrame );

CArray < HWND, HWND > arrHwndsToDynOptimize;
bool bDeepOptimize = false;

POSITION pos = pFrame->m_listControlBars.GetHeadPosition();
	for( ; pos != NULL; )
	{
		CExtDynamicControlBar * pBar =
			DYNAMIC_DOWNCAST(
				CExtDynamicControlBar,
				((CObject *)(pFrame->m_listControlBars.GetNext(pos)))
				);
		if( pBar == NULL )
			continue;
		ASSERT( !pBar->IsFixedMode() );
		HWND hWnd = pBar->m_pWndDynDocker->GetSafeHwnd();
		if( hWnd == NULL
			|| ! ::IsWindow( hWnd )
			)
			continue;
		//if( !pBar->IsFloating() )
		{
			INT nDockedCount =
				pBar->m_pWndDynDocker->GetDockedCount();
			if( nDockedCount > 0 )
				continue;
			bDeepOptimize = true;
		} // if( !pBar->IsFloating() )

		arrHwndsToDynOptimize.Add( hWnd );
	}

	for( INT nHwndIdx = 0; nHwndIdx < arrHwndsToDynOptimize.GetSize(); nHwndIdx++ )
	{
		HWND hWnd = arrHwndsToDynOptimize[ nHwndIdx ];
		ASSERT( hWnd != NULL );
		if( !::IsWindow( hWnd ) )
			continue;
		CWnd * pWndChild = CWnd::FromHandlePermanent( hWnd );
		if( pWndChild == NULL )
			continue;
		CExtDynamicDockBar * pDockBar =
			DYNAMIC_DOWNCAST(
				CExtDynamicDockBar,
				pWndChild
				);
		if( pDockBar == NULL )
			continue;
#ifdef __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
		ASSERT( !pDockBar->m_bLockedOptimize );
#endif // __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
		pDockBar->OnDynamicLayoutOptimize();
	}

	if( bDeepOptimize )
		_OptimizeCircles( pFrame );
}

void CExtDockBar::_SafeOptimizeInnerOuterChain()
{
	ASSERT( this != NULL );
	ASSERT_KINDOF( CExtDockBar, this );
	ASSERT( GetSafeHwnd() != NULL );
	ASSERT( ::IsWindow(GetSafeHwnd()) );

	if( m_pDockBarInner != NULL )
	{
		ASSERT( m_pDockBarInner->m_pDockBarOuter == this );
		m_pDockBarInner->m_pDockBarOuter = m_pDockBarOuter;
	}
	if( m_pDockBarOuter != NULL )
	{
		ASSERT( m_pDockBarOuter->m_pDockBarInner == this );
		m_pDockBarOuter->m_pDockBarInner = m_pDockBarInner;
	}
	m_pDockBarInner = NULL;
	m_pDockBarOuter = NULL;

CFrameWnd * pFrame = GetParentFrame();
	ASSERT( pFrame != NULL );
	ASSERT( !pFrame->IsKindOf(RUNTIME_CLASS(CMiniFrameWnd)) );

POSITION pos = pFrame->m_listControlBars.Find( this );
	ASSERT( pos != NULL );
	pFrame->m_listControlBars.RemoveAt( pos );

BOOL bAutoDelete = m_bAutoDelete;
	DestroyWindow();
	if( !bAutoDelete )
		delete this;
}

bool CExtDockBar::_CanBeSafeOptimized()
{
	ASSERT( this != NULL );
	ASSERT_KINDOF( CExtDockBar, this );
	for( INT nPos = 0; nPos < m_arrBars.GetSize(); nPos++ )
	{
		void * pBar = m_arrBars[ nPos ];
		if( pBar != NULL ) // placeholer or child control bar
			return false;
	}
	return true;
}

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
CExtDynamicAutoHideArea * CExtDockBar::_GetAutoHideArea()
{
	return m_pWndAutoHideArea;
}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

void CExtDockBar::_HandleDestruction()
{
	m_bLockedOptimize = true;
bool bFirstDestroyed = true;
	for( int nBar = m_arrBars.GetSize() - 1; nBar > 0 ; nBar-- )
	{
		ASSERT( m_arrBars[0] == NULL );
		CExtControlBar * pBar = (CExtControlBar *)
			m_arrBars[ nBar ];
		if( bFirstDestroyed )
		{
			ASSERT( pBar == NULL );
			bFirstDestroyed = false;
			continue;
		}
		if( pBar == NULL )
		{
			m_arrBars.RemoveAt( nBar );
			continue;
		}
		if( __PLACEHODLER_BAR_PTR(pBar) )
		{
			m_arrBars.RemoveAt( nBar );
			continue;
		}
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CExtControlBar, pBar );
		ASSERT_VALID( pBar->m_pDockSite );
		ASSERT( pBar->m_pDockContext != NULL );
		ASSERT( pBar->m_pDockBar == this );
		pBar->m_bUpdatingChain = true;
		pBar->m_pDockBar = NULL;
		if( pBar->IsKindOf(RUNTIME_CLASS(CExtDynamicControlBar)) )
		{
			CExtDynamicDockBar * pDynDocker =
				((CExtDynamicControlBar*)pBar)->m_pWndDynDocker;
			ASSERT_VALID( pDynDocker );
			pDynDocker->_HandleDestruction();
		}
		ASSERT( pBar->m_bUpdatingChain );
		if( pBar->GetParent() != pBar->m_pDockSite )
			pBar->SetParent( pBar->m_pDockSite );
		pBar->m_bUpdatingChain = false;
		m_arrBars.RemoveAt( nBar );
	}
	m_bLockedOptimize = false;
}

void CExtDockBar::OnDestroy()
{
	_HandleDestruction();
	CDockBar::OnDestroy();
}

BOOL CExtDockBar::DestroyWindow()
{
	_HandleDestruction();
	return  CDockBar::DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////
// CExtDynamicDockBar window

IMPLEMENT_DYNAMIC(CExtDynamicDockBar, CExtDockBar);

BEGIN_MESSAGE_MAP(CExtDynamicDockBar, CExtDockBar)
	//{{AFX_MSG_MAP(CExtDynamicDockBar)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CExtDynamicDockBar::CExtDynamicDockBar(
	UINT nCircleNo
	)
	: CExtDockBar( nCircleNo )
	, m_bHelperDockSiteModified( false )
{
	m_bAutoDelete = TRUE;
}

/////////////////////////////////////////////////////////////////////////
// CExtDynamicControlBar window

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
CExtDynamicAutoHideArea * CExtDynamicDockBar::_GetAutoHideArea()
{
CExtControlBar * pExtBar = 
		STATIC_DOWNCAST(
			CExtControlBar,
			GetParent()
			);
	ASSERT( pExtBar->m_pDockBar != NULL );
CExtDockBar * pDockBar =
		DYNAMIC_DOWNCAST(
			CExtDockBar,
			pExtBar->m_pDockBar
			);
	if( pDockBar == NULL )
		return NULL;
	return pDockBar->_GetAutoHideArea();
}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

void CExtDynamicDockBar::VisibleLayoutItem_t::_AssignFromOther(
	const CExtDynamicDockBar::VisibleLayoutItem_t & other
	)
{
	m_vRow.RemoveAll();
INT nSize = other.m_vRow.GetSize();
	if( nSize == 0 )
	{
		m_vRow.FreeExtra();
		return;
	}
	m_vRow.SetSize( nSize );
	for( INT nBar = 0; nBar < nSize; nBar++ )
	{
		CExtControlBar * pExtBar = other.m_vRow[ nBar ];
		ASSERT( pExtBar != NULL );
		ASSERT( !pExtBar->IsFixedMode() );
#ifdef _DEBUG
		if( __PLACEHODLER_BAR_PTR(pExtBar) )
		{
			ASSERT( FALSE );
		}
#endif // _DEBUG
		m_vRow.SetAt( nBar, pExtBar );
	} // for( INT nBar = 0; nBar < nSize; nBar++ )
}

CExtDynamicDockBar::VisibleLayoutItem_t::VisibleLayoutItem_t()
	: m_nRowMetric( 0 )
	, m_nRowMinMetric( 0 )
	, m_nRowExtent( 0 )
	, m_nRowMinExtent( 0 )
{
}

CExtDynamicDockBar::VisibleLayoutItem_t::VisibleLayoutItem_t(
	const CExtDynamicDockBar::VisibleLayoutItem_t & other
	)
{
	_AssignFromOther( other );
}

CExtDynamicDockBar::VisibleLayoutItem_t::~VisibleLayoutItem_t()
{
}

CExtDynamicDockBar::VisibleLayoutItem_t &
	CExtDynamicDockBar::VisibleLayoutItem_t::operator=(
		const CExtDynamicDockBar::VisibleLayoutItem_t & other
		)
{
	_AssignFromOther( other );
	return * this;
}

bool CExtDynamicDockBar::VisibleLayoutItem_t::IsEmpty() const
{
	if( m_vRow.GetSize() == 0 )
		return true;
	return false;
}

bool CExtDynamicDockBar::VisibleLayoutItem_t::IsRowMinSized() const
{
	ASSERT( m_nRowMetric >= m_nRowMinMetric );
	return (m_nRowMetric == m_nRowMinMetric ) ? true : false;
}


void CExtDynamicDockBar::VisibleLayout_t::_Clean()
{
INT nSize = m_vRows.GetSize();
	for( INT nRow = 0; nRow < nSize; nRow++ )
	{
		VisibleLayoutItem_t * pVLI = m_vRows.GetAt( nRow );
		ASSERT( pVLI != NULL );
		delete pVLI;
	}
	m_vRows.RemoveAll();
	m_vRows.FreeExtra();
}

CExtDynamicDockBar::VisibleLayout_t::VisibleLayout_t()
	: m_nTotalMetric( 0 )
	, m_nTotalMinMetric( 0 )
	, m_nTotalMinExtent( 0 )
	, m_nTotalBarsCount( 0 )
{
}

CExtDynamicDockBar::VisibleLayout_t::~VisibleLayout_t()
{
	_Clean();
}

void CExtDynamicDockBar::VisibleLayout_t::AddBarPointer(
	CExtControlBar * pExtBar
	)
{
	ASSERT_VALID( pExtBar );
	ASSERT( !pExtBar->IsFixedMode() );
	if( !pExtBar->IsVisible() )
		return;
#ifdef _DEBUG
		if( __PLACEHODLER_BAR_PTR(pExtBar) )
		{
			ASSERT( FALSE );
		}
#endif // _DEBUG

VisibleLayoutItem_t * pVLI = NULL;
INT nRowCount = m_vRows.GetSize();
	if( nRowCount == 0 )
	{
		pVLI = new VisibleLayoutItem_t;
		m_vRows.Add( pVLI );
	}
	else
		pVLI = m_vRows[ nRowCount - 1 ];
	ASSERT( pVLI != NULL );
	pVLI->m_vRow.Add( pExtBar );

	m_nTotalBarsCount++;
}

void CExtDynamicDockBar::VisibleLayout_t::MakeNewRow()
{
INT nRowCount = m_vRows.GetSize();
	if( nRowCount == 0 )
	{
		VisibleLayoutItem_t * pVLI = new VisibleLayoutItem_t;
		m_vRows.Add( pVLI );
		return;
	}
VisibleLayoutItem_t * pVLI = m_vRows.GetAt( nRowCount - 1 );
	ASSERT( pVLI != NULL );
	if( pVLI->IsEmpty() )
		return;
	pVLI = new VisibleLayoutItem_t;
	m_vRows.Add( pVLI );
}

bool CExtDynamicDockBar::VisibleLayout_t::IsEmpty() const
{
INT nRowCount = m_vRows.GetSize();
	if( nRowCount == 0 )
		return true;
	if( nRowCount == 1 )
	{
		VisibleLayoutItem_t * pVLI = m_vRows.GetAt( 0 );
		if( pVLI->IsEmpty() )
			return true;
	}
#ifdef _DEBUG
	else
	{
		VisibleLayoutItem_t * pVLI = m_vRows.GetAt( 0 );
		ASSERT( !pVLI->IsEmpty() );
		
	}
#endif // _DEBUG
	return false;
}

void CExtDynamicDockBar::_VisibleLayoutBuild(
	VisibleLayout_t & _vl
	)
{
	ASSERT_VALID( this );

	ASSERT( _vl.IsEmpty() );

INT nCount = m_arrBars.GetSize();
	ASSERT( nCount > 0 );
	ASSERT( m_arrBars[0] == NULL );

UINT nOwnID = GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );
BOOL bHorz = ( nOwnID == AFX_IDW_DOCKBAR_TOP || nOwnID == AFX_IDW_DOCKBAR_BOTTOM );

	ASSERT( m_arrBars[0] == NULL );

	for( INT nBar = 1; nBar < nCount; nBar++ )
	{
		CExtControlBar * pExtBar = (CExtControlBar *) m_arrBars[nBar];
		if( pExtBar == NULL )
		{
			if( nBar == (nCount-1) )
				break;
			_vl.MakeNewRow();
			continue;
		}
		if( __PLACEHODLER_BAR_PTR(pExtBar) )
			continue;
		ASSERT_VALID( pExtBar );
		ASSERT_KINDOF( CExtControlBar, pExtBar );
		ASSERT( !pExtBar->IsFixedMode() );
		if( !pExtBar->IsVisible() )
			continue;
		_vl.AddBarPointer( pExtBar );
	} // for( INT nBar = 1; nBar < nCount; nBar++ )

INT nRowsCount = _vl.m_vRows.GetSize();
	if( nRowsCount == 0 )
		return;
	for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
	{
		VisibleLayoutItem_t * pVLI = _vl.m_vRows[ nRow ];
		ASSERT( pVLI != NULL );
		INT nRowSize = pVLI->m_vRow.GetSize();
		// TO FIX:
		if( nRowSize == 0 )
			continue;
		ASSERT( nRowSize > 0 );
		CExtControlBar * pExtBar = pVLI->m_vRow[ 0 ];
		ASSERT( pExtBar != NULL );
		
		LONG nMinHW = pExtBar->_CalcDesiredMinHW();
		LONG nMinVH = pExtBar->_CalcDesiredMinVH();
		pVLI->m_nRowMinMetric = bHorz
			? nMinVH
			: nMinHW;
		pVLI->m_nRowMetric = bHorz
			? pExtBar->m_sizeDockedH.cy
			: pExtBar->m_sizeDockedV.cx;
		_vl.m_nTotalMetric += pVLI->m_nRowMetric;

		INT nRowMinMetric = bHorz
			? nMinVH
			: nMinHW;

		INT nRowMinExtent = bHorz
			? nMinHW
			: nMinVH;
		INT nRowExtent = bHorz
			? pExtBar->m_sizeDockedH.cx
			: pExtBar->m_sizeDockedV.cy;
		
		for( nBar = 1; nBar < nRowSize; nBar++ )
		{
			pExtBar = pVLI->m_vRow[ nBar ];
			ASSERT( pExtBar != NULL );
			LONG nMinHW = pExtBar->_CalcDesiredMinHW();
			LONG nMinVH = pExtBar->_CalcDesiredMinVH();
			INT nBarMinMetric = bHorz
				? nMinVH
				: nMinHW;
			nRowMinMetric =
				min( nRowMinMetric, nBarMinMetric );
			nRowMinExtent += bHorz
				? nMinHW
				: nMinVH;
			nRowExtent += bHorz
				? pExtBar->m_sizeDockedH.cx
				: pExtBar->m_sizeDockedV.cy;
		}

		_vl.m_nTotalMinMetric += nRowMinMetric;
		_vl.m_nTotalMinExtent = max( nRowMinExtent, _vl.m_nTotalMinExtent );
		pVLI->m_nRowExtent = nRowExtent;
	} // for( INT nRow = 0; nRow < nRowsCount; nRow ++ )

}

void CExtDynamicDockBar::_VisibleLayoutAlign(
	VisibleLayout_t & _vl,
	CSize _size
	)
{
	ASSERT_VALID( this );

	ASSERT( !_vl.IsEmpty() );
	ASSERT( _size.cx > 0 && _size.cy > 0 );

CRect rcDockBarReal;
	GetClientRect( &rcDockBarReal );
	_size = rcDockBarReal.Size();
	if( _size.cx <= 0 || _size.cy <= 0 )
		return;

UINT nOwnID = GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );
BOOL bHorz = ( nOwnID == AFX_IDW_DOCKBAR_TOP || nOwnID == AFX_IDW_DOCKBAR_BOTTOM );

INT nRowsCount = _vl.m_vRows.GetSize();
	ASSERT( nRowsCount > 0 );

INT nDesiredMetric = bHorz ? _size.cy : _size.cx;
INT nIncrement = (_vl.m_nTotalMetric < nDesiredMetric) ? 1 : -1;
INT nDiff = abs(_vl.m_nTotalMetric - nDesiredMetric);

	// align direction 1 (row metrics)
bool bResetRowMetrics = true;
	while( nDiff != 0 )
	{
		bResetRowMetrics = false;
		ASSERT( nDiff >= 0 );
		INT nRowsMinSized = 0;
		for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
		{
			VisibleLayoutItem_t * pVLI = _vl.m_vRows[ nRow ];
			ASSERT( pVLI != NULL );
			//ASSERT( !pVLI->IsEmpty() );
			INT nRowSize = pVLI->m_vRow.GetSize();
			// TO FIX:
			if( nRowSize == 0 )
				continue;
			ASSERT( nRowSize > 0 );

			if( nIncrement < 0 && pVLI->IsRowMinSized() )
			{
				nRowsMinSized ++;
				if( nRowsCount == nRowsMinSized )
					break;
				continue;
			}
			pVLI->m_nRowMetric += nIncrement;
			nDiff--;

			for( INT nBar = 0; nBar < nRowSize; nBar++ )
			{
				CExtControlBar * pExtBar = pVLI->m_vRow[ nBar ];
				ASSERT( pExtBar != NULL );
				LONG & nRowMetricRef = bHorz
					? pExtBar->m_sizeDockedH.cy
					: pExtBar->m_sizeDockedV.cx;
				nRowMetricRef += nIncrement;
			} // for( INT nBar = 0; nBar < nRowSize; nBar++ )

			if( nDiff == 0 )
				break;
		} // for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
		if( nRowsCount == nRowsMinSized )
			break;
	} // while( nDiff != 0 )
	if( bResetRowMetrics )
	{
		for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
		{
			VisibleLayoutItem_t * pVLI = _vl.m_vRows[ nRow ];
			ASSERT( pVLI != NULL );
			//ASSERT( !pVLI->IsEmpty() );
			INT nRowSize = pVLI->m_vRow.GetSize();
			// TO FIX:
			if( nRowSize == 0 )
				continue;
			ASSERT( nRowSize > 0 );
			for( INT nBar = 0; nBar < nRowSize; nBar++ )
			{
				CExtControlBar * pExtBar = pVLI->m_vRow[ nBar ];
				ASSERT( pExtBar != NULL );
				LONG & nRowMetricRef = bHorz
					? pExtBar->m_sizeDockedH.cy
					: pExtBar->m_sizeDockedV.cx;
				nRowMetricRef = pVLI->m_nRowMetric;
			} // for( INT nBar = 0; nBar < nRowSize; nBar++ )
		} // for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
	} // if( bResetRowMetrics )

	// align direction 2 (row extents)
	nDesiredMetric = bHorz ? _size.cx : _size.cy;
	for( INT nRow = 0; nRow < nRowsCount; nRow ++ )
	{
		VisibleLayoutItem_t * pVLI = _vl.m_vRows[ nRow ];
		ASSERT( pVLI != NULL );
		//ASSERT( !pVLI->IsEmpty() );
		// TO FIX:
		if( pVLI->IsEmpty() )
			continue;

		INT nIncrement =
			(pVLI->m_nRowExtent < nDesiredMetric) ? 1 : -1;
		INT nDiff = abs( pVLI->m_nRowExtent - nDesiredMetric );

		while( nDiff != 0 )
		{
			ASSERT( nDiff >= 0 );
			INT nRowSize = pVLI->m_vRow.GetSize();
			// TO FIX:
			if( nRowSize == 0 )
				continue;
			ASSERT( nRowSize > 0 );
			INT nBarsMinSized = 0;
			for( INT nBar = 0; nBar < nRowSize; nBar++ )
			{
				CExtControlBar * pExtBar = pVLI->m_vRow[ nBar ];
				ASSERT( pExtBar != NULL );
				LONG & nBarMetricRef = bHorz
					? pExtBar->m_sizeDockedH.cx
					: pExtBar->m_sizeDockedV.cy;

				if( nIncrement < 0 )
				{
					LONG nBarMinMetric = bHorz
						? pExtBar->_CalcDesiredMinHW()
						: pExtBar->_CalcDesiredMinVH();
					ASSERT( nBarMetricRef >= nBarMinMetric );
					if( nBarMetricRef <= nBarMinMetric )
					{
						nBarsMinSized ++;
						if( nBarsMinSized == nRowSize )
							break;
						continue;
					}
				} // if( nIncrement < 0 )

				nBarMetricRef += nIncrement;
				nDiff --;
				if( nDiff == 0 )
					break;
			} // for( INT nBar = 0; nBar < nRowSize; nBar++ )
			if( nBarsMinSized == nRowSize )
				break;
		} // while( nDiff != 0 )
	} // for( INT nRow = 0; nRow < nRowsCount; nRow ++ )

	ASSERT( _vl.m_nTotalBarsCount > 0 );
HANDLE hDWP = ::BeginDeferWindowPos( _vl.m_nTotalBarsCount );
	ASSERT( hDWP != NULL );
	
	// apply new layout
CPoint ptOffs( 0, 0 );	
	for( nRow = 0; nRow < nRowsCount; nRow ++ )
	{
		VisibleLayoutItem_t * pVLI = _vl.m_vRows[ nRow ];
		ASSERT( pVLI != NULL );
		//ASSERT( !pVLI->IsEmpty() );
		INT nRowSize = pVLI->m_vRow.GetSize();
		// TO FIX:
		if( nRowSize == 0 )
			continue;
		ASSERT( nRowSize > 0 );

		INT nRowOffset = 0;
		for( INT nBar = 0; nBar < nRowSize; nBar++ )
		{
			CExtControlBar * pExtBar = pVLI->m_vRow[ nBar ];
			ASSERT( pExtBar != NULL );

			if( nBar == 0 )
				nRowOffset = bHorz
					? pExtBar->m_sizeDockedH.cy
					: pExtBar->m_sizeDockedV.cx;

			CRect rcBar(
				ptOffs,
				bHorz
					? pExtBar->m_sizeDockedH
					: pExtBar->m_sizeDockedV
				);
		
			if( hDWP != NULL )
			{
				hDWP =
					::DeferWindowPos(
						hDWP,
						pExtBar->GetSafeHwnd(),
						NULL,
						rcBar.left, rcBar.top,
						rcBar.Width(), rcBar.Height(),
						SWP_NOZORDER|SWP_NOACTIVATE
						);
				ASSERT( hDWP != NULL );
			}
			if( hDWP == NULL )
				pExtBar->MoveWindow( &rcBar );

			if( bHorz )
				ptOffs.x += pExtBar->m_sizeDockedH.cx;
			else
				ptOffs.y += pExtBar->m_sizeDockedV.cy;

		} // for( INT nBar = 0; nBar < nRowSize; nBar++ )

		if( bHorz )
		{
			ptOffs.x = 0;
			ptOffs.y += nRowOffset;
		}
		else
		{
			ptOffs.x += nRowOffset;
			ptOffs.y = 0;
		}
	} // for( nRow = 0; nRow < nRowsCount; nRow ++ )

	ASSERT( hDWP != NULL );
	if( hDWP != NULL )
		::EndDeferWindowPos( hDWP );
}

IMPLEMENT_DYNAMIC(CExtDynamicControlBar, CExtControlBar);

BEGIN_MESSAGE_MAP(CExtDynamicControlBar, CExtControlBar)
	//{{AFX_MSG_MAP(CExtDynamicControlBar)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CExtDynamicControlBar::CExtDynamicControlBar()
	: m_pWndDynDocker( NULL )
{
	m_bAutoDelete = TRUE;
}

CExtDynamicDockBar * CExtDynamicControlBar::OnCreateDynamicDockBarObject()
{
	return ( new CExtDynamicDockBar( 0 ) );
}

int CExtDynamicControlBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if( CExtControlBar::OnCreate(lpCreateStruct) == -1 )
	{
		ASSERT( FALSE );
		return -1;
	}

UINT nOwnID = GetDlgCtrlID();

#if (!defined __EXT_MFC_NO_TAB_CONTROLBARS)
	if( IsKindOf( RUNTIME_CLASS(CExtDynamicTabbedControlBar) )
		&& nOwnID == AFX_IDW_DOCKBAR_FLOAT
		)
	{
		nOwnID = AFX_IDW_DOCKBAR_TOP;
		SetDlgCtrlID( nOwnID );
	}
#endif // (!defined __EXT_MFC_NO_TAB_CONTROLBARS)

	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nOwnID );

	ASSERT( m_pWndDynDocker == NULL );
	m_pWndDynDocker = OnCreateDynamicDockBarObject();
	ASSERT( m_pWndDynDocker != NULL );
	
CFrameWnd * pParentFrame =
		STATIC_DOWNCAST( CFrameWnd, GetParent() );
	ASSERT_VALID( pParentFrame );
	if( !m_pWndDynDocker->Create(
			pParentFrame,
			WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN
				|CBRS_ALIGN_TOP //|CBRS_ALIGN_ANY
				|CBRS_BORDER_ANY
				,
			nOwnID
			)
		)
	{
		ASSERT( FALSE );
		return -1;
	}
	m_pWndDynDocker->SetParent( this );
	EnableToolTips();
	return 0;
}

bool CExtDynamicControlBar::IsBarWithGripper(
	bool * pbGripperAtTop, // = NULL
	bool * pbTextOnGripper // = NULL
	) const
{
	ASSERT_VALID( this );
	if( pbGripperAtTop != NULL )
		*pbGripperAtTop = false;
	if( pbTextOnGripper != NULL )
		*pbTextOnGripper = false;
	return false;
}

CSize CExtDynamicControlBar::_CalcLayoutMinSize() const
{
	ASSERT_VALID( this );
CExtDynamicDockBar * pDockBar = 
		STATIC_DOWNCAST( CExtDynamicDockBar, GetWindow(GW_CHILD) );
	ASSERT_VALID( pDockBar );
	ASSERT_KINDOF( CExtDynamicDockBar, pDockBar );
CExtDynamicDockBar::VisibleLayout_t _vl;
	pDockBar->_VisibleLayoutBuild( _vl );
UINT nDockBarID = pDockBar->GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nDockBarID );
BOOL bHorz = ( nDockBarID == AFX_IDW_DOCKBAR_TOP || nDockBarID == AFX_IDW_DOCKBAR_BOTTOM );
CSize _size(
		bHorz ? _vl.m_nTotalMinMetric : _vl.m_nTotalMinExtent,
		bHorz ? _vl.m_nTotalMinExtent : _vl.m_nTotalMinExtent
		);
	return _size;
}

INT CExtDynamicControlBar::_CalcDesiredMinHW() const
{
	return _CalcLayoutMinSize().cx;
}

INT CExtDynamicControlBar::_CalcDesiredMinVH() const
{
	return _CalcLayoutMinSize().cy;
}

CSize CExtDynamicControlBar::_CalcDesiredMinFloatedSize() const
{
	return _CalcLayoutMinSize();
}

CSize CExtDynamicControlBar::CalcDynamicLayout(
	int nLength,
	DWORD nMode
	)
{
CSize _size = CExtControlBar::CalcDynamicLayout( nLength, nMode );

	ASSERT_VALID( m_pDockBar );
	if( ((CExtDockBar *)m_pDockBar)->m_bLayoutQuery )
		return _size;

	if( m_pWndDynDocker->GetSafeHwnd() == NULL )
		return _size;

INT nDockedVisibleCount = m_pWndDynDocker->GetDockedVisibleCount();
	if( nDockedVisibleCount == 0 )
	{
		m_pDockSite->ShowControlBar( this, FALSE, FALSE );
		_size.cx = _size.cy = 0;
	}

CFrameWnd * pParentFrame = GetParentFrame();
	if(	pParentFrame->IsKindOf( RUNTIME_CLASS( CMiniFrameWnd ) ) )
	{
		ASSERT_VALID( m_pWndDynDocker );
		ASSERT( ::IsWindow( m_pWndDynDocker->GetSafeHwnd() ) );
//!!//
//		m_pWndDynDocker->OnDynamicLayoutUpdate();
//		pParentFrame->SetWindowPos(
//			NULL, 0, 0, 0, 0,
//			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE
//				|SWP_FRAMECHANGED
//			);
//		pParentFrame->SendMessage( WM_NCPAINT );

		ASSERT_VALID( m_pDockBar );
		if(	( ! m_pWndDynDocker->m_bLockedOptimize )
			&& pParentFrame == m_pDockBar->GetParent()
			)
			m_pWndDynDocker->OnDynamicLayoutUpdate();

	} // if( ....
	
	return _size;
}

void CExtDynamicDockBar::OnDynamicLayoutUpdate()
{
	ASSERT_VALID( this );
	ASSERT_KINDOF( CExtDynamicDockBar, this );

	if( m_bLockedOptimize )
		return;

	if( m_bInDynamicLayoutUpdate )
		return;
	m_bInDynamicLayoutUpdate = true;

UINT nDockBarID = GetDlgCtrlID();
	ASSERT_DOCKBAR_DLGCTRLID_DOCKED( nDockBarID );
BOOL bHorz = ( nDockBarID == AFX_IDW_DOCKBAR_TOP || nDockBarID == AFX_IDW_DOCKBAR_BOTTOM );
	
	CalcFixedLayout( TRUE, bHorz );

	m_bInDynamicLayoutUpdate = false;

	CExtDockBar::OnDynamicLayoutUpdate();
}

void CExtDynamicDockBar::OnDynamicLayoutOptimize()
{
	ASSERT_VALID( this );
	ASSERT_VALID( m_pDockSite );

	if( m_bLockedOptimize )
	{
#ifdef _DEBUG
	#ifdef __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
		INT nDockedCount = GetDockedCount();
		ASSERT( nDockedCount != 0 );
	#endif // __DEBUG_LOCKING_OPTIMIZATION_ASSERTS__
#endif // _DEBUG
		return;
	}

bool bOptimizeChilds = false;
INT nSinglePos = -1;
bool bPlaceHolder = false;
	ASSERT( m_arrBars.GetSize() >= 1 );

INT nDockedCount = GetDockedCount();
	if( nDockedCount != 0 )
	{
		ASSERT( nDockedCount >= 1 );
		for( INT nBar = 1; nBar < m_arrBars.GetSize(); nBar++ )
		{
			CControlBar * pBar = (CControlBar *)m_arrBars[ nBar ];
			if( pBar == NULL )
				continue;
			if( __PLACEHODLER_BAR_PTR(pBar) )
			{
				if( nSinglePos >= 0 && !bPlaceHolder )
				{
					bOptimizeChilds = true;
					break;
				}
				nSinglePos = nBar;
				bPlaceHolder = true;
				continue;
			}
			else
			{
				ASSERT_VALID( pBar );
				ASSERT_KINDOF( CControlBar, pBar );
				if( nSinglePos >= 0 )
				{
					bOptimizeChilds = true;
					break;
				}
				nSinglePos = nBar;
			}
		} // for( INT nBar = 1; nBar < m_arrBars.GetSize(); nBar++ )
	} // if( nDockedCount != 0 )
	
	if( bOptimizeChilds )
	{
		CExtDockBar::OnDynamicLayoutOptimize();
		return;
	}

CFrameWnd * pDockSite = m_pDockSite;
CMiniFrameWnd * pMiniFrame =
		DYNAMIC_DOWNCAST(
			CMiniFrameWnd,
			GetParentFrame()
			);
	if( pMiniFrame != NULL )
		pMiniFrame->DelayRecalcLayout();

CExtDynamicControlBar * pDynBar =
		STATIC_DOWNCAST( CExtDynamicControlBar, GetParent() );
	ASSERT_VALID( pDynBar );
	ASSERT( pDockSite == pDynBar->m_pDockSite );

CDockBar * pDockBarParent = 
		STATIC_DOWNCAST( CDockBar, pDynBar->GetParent() );
	ASSERT_VALID( pDockBarParent );
	ASSERT( pDockSite == pDockBarParent->m_pDockSite );

HWND hWndOwn = GetSafeHwnd();

	if( nSinglePos == -1 )
	{ // optimizing empty dynamic docker
//		AfxMessageBox( "Optimizing empty dynamic docker!" );

		pDynBar->m_pDockBar = NULL;
//		pDockSite->RemoveControlBar( pDynBar );
		pDockSite->RemoveControlBar( this );

		ASSERT( pDynBar->m_bAutoDelete );
		HWND hWndDynBar = pDynBar->GetSafeHwnd();
		pDockBarParent->RemoveControlBar( pDynBar );
		if( ::IsWindow(hWndDynBar) )
			pDynBar->DestroyWindow();
		
		if( pMiniFrame == NULL )
			pDockSite->DelayRecalcLayout();
		ASSERT( pDockSite->m_listControlBars.Find(pDynBar) == NULL );

		if( ! (	::IsWindow(hWndOwn) ) )
			return;

		if( pDockBarParent->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
			((CExtDockBar *)pDockBarParent)->OnDynamicLayoutUpdate();
		return;
	} // optimizing empty dynamic docker

	if( bPlaceHolder )
	{ // optimizing placeholder dynamic docker
////		AfxMessageBox( "Optimizing placeholder dynamic docker!" );
		return;
	} // optimizing placeholder dynamic docker

	// optimizing singlebar dynamic docker
//	AfxMessageBox( "Optimizing singlebar dynamic docker!" );

CExtControlBar * pSingleBar = (CExtControlBar *)m_arrBars[ nSinglePos ];
	ASSERT_VALID( pSingleBar );
	ASSERT_KINDOF( CExtControlBar, pSingleBar );
	ASSERT( !pSingleBar->IsFixedMode() );
CRect wrSingleBar;
	pDynBar->GetWindowRect( &wrSingleBar );
CSize sizeSingleBar = wrSingleBar.Size();

INT nDynPos = pDockBarParent->FindBar( pDynBar );
	ASSERT( nDynPos > 0 );
	pDockBarParent->m_arrBars[ nDynPos ] = pSingleBar;
	pSingleBar->m_pDockBar = pDockBarParent;

	if( pSingleBar->IsKindOf(RUNTIME_CLASS(CExtControlBar))
		&& !((CExtControlBar*)pSingleBar)->IsFixedMode()
		)
	{
		if( pDockBarParent->GetBarStyle() & CBRS_ORIENT_HORZ )
			((CExtControlBar*)pSingleBar)->
				SetInitDesiredSizeHorizontal( sizeSingleBar );
		else
			((CExtControlBar*)pSingleBar)->
				SetInitDesiredSizeVertical( sizeSingleBar );
		DWORD dwStyle = pSingleBar->GetBarStyle();
		dwStyle &= ~(CBRS_ALIGN_ANY);
		dwStyle |=  (pDynBar->m_dwStyle & CBRS_ALIGN_ANY) | CBRS_BORDER_ANY;
		pSingleBar->SetBarStyle( dwStyle );
	}

	m_arrBars.RemoveAll();
	m_arrBars.Add( (CControlBar *)NULL );

	pSingleBar->SetParent( pDockBarParent );
	pSingleBar->m_pDockBar = pDockBarParent;

	pDynBar->m_pDockBar = NULL;
//	pDockSite->RemoveControlBar( pDynBar );
	pDockSite->RemoveControlBar( this );
	ASSERT( pDynBar->m_bAutoDelete );
	pDynBar->DestroyWindow();

/*
//	pSingleBar->m_bUpdatingChain = true;
	pDockBarParent->ScreenToClient( &wrSingleBar );
	pSingleBar->SetWindowPos(
		NULL,
		wrSingleBar.left, wrSingleBar.top,
		sizeSingleBar.cx, sizeSingleBar.cy,
		SWP_NOZORDER|SWP_NOOWNERZORDER
			|SWP_NOACTIVATE
			|SWP_FRAMECHANGED
			//|SWP_NOREDRAW
		);
//	pSingleBar->m_bUpdatingChain = false;
*/

	if( pMiniFrame == NULL )
		pDockSite->DelayRecalcLayout();
	ASSERT( pDockSite->m_listControlBars.Find(pDynBar) == NULL );

	if( pDockBarParent->IsKindOf(RUNTIME_CLASS(CExtDockBar)) )
		((CExtDockBar *)pDockBarParent)->OnDynamicLayoutUpdate();
}

CSize CExtDynamicDockBar::CalcFixedLayout(
	BOOL bStretch,
	BOOL bHorz
	)
{
	bHorz;

	ASSERT_VALID( this );
	ASSERT( !m_bFloating );

VisibleLayout_t _vl;
	_VisibleLayoutBuild( _vl );

CRect rect;
	GetWindowRect( &rect );
CSize _size = rect.Size();

	if( !_vl.IsEmpty()
		&& bStretch
		&& _size.cx > 0 && _size.cy > 0
		)
	{
		_VisibleLayoutAlign( _vl, _size );
	}

	return _size;
}

void CExtDynamicDockBar::CalcOrderedVector(
	ExtControlBarVector_t & vBars
	)
{
	ASSERT_VALID( this );

INT nCount = m_arrBars.GetSize();
	ASSERT( nCount > 0 );
	ASSERT( m_arrBars[0] == NULL );
	for( INT nBar = 1; nBar < nCount; nBar++ )
	{
		CExtControlBar * pBar = (CExtControlBar *) m_arrBars[nBar];
		if( pBar == NULL )
			continue;
		if( __PLACEHODLER_BAR_PTR( pBar ) )
			continue;
		ASSERT_VALID( pBar );
		ASSERT_KINDOF( CExtControlBar, pBar );
		ASSERT( !pBar->IsFixedMode() );
		vBars.Add( pBar );
	} // for( INT nBar = 1; nBar < nCount; nBar++ )
}

void CExtDynamicDockBar::OnSize(UINT nType, int cx, int cy) 
{
	CExtDockBar::OnSize(nType, cx, cy);
	
	if(		!m_bHelperDockSiteModified
		&&	m_pDockSite != NULL
		)
	{
		POSITION pos = m_pDockSite->m_listControlBars.Find( this );
		if( pos != NULL )
		{
			m_pDockSite->m_listControlBars.RemoveAt( pos );
			m_bHelperDockSiteModified = true;
		}
	}

/*
	if( nType == SIZE_MINIMIZED )
		return;
	if( cx <= 0 || cy <= 0 )
		return;

	OnDynamicLayoutUpdate();
*/

}



