unit AtoPas;

interface
 Uses Windows, Classes, Clipbrd, SWFObjects, SWFStrings, Contnrs;

 Procedure GetDoAction(DoAction: TSWFDoAction);
 Procedure GetPlaceObjectAction(PO: TSWFPlaceObject2);
 Procedure GetButtonAction(B: TSWFDefineButton);
 Procedure GetButton2Action(B: TSWFDefineButton2);

implementation
  uses SWFConst, SysUtils;

const
  fs: array [0..6] of pchar = ('(%d)',
                               '(%s)',
                               '(%d, %d)',
                               '(%s, %s)',
                               '(%s, %d)',
                               '(%s, %s, %d)',
                               '[%s]');
  ABool: array [boolean] of pchar = ('false', 'true');
  PushTypes : array [0..9] of pChar = ('vtString', 'vtFloat', 'vtNull', 'vtUndefined', 'vtRegister', 'vtBoolean', 'vtDouble',
                'vtInteger', 'vtConstant8', 'vtConstant16');

Procedure CopyActions(AL: TSWFActionList);
 var il, il2: word;
     AStt: ansistring;
     aname, stt, stt2: string;

Procedure CreateJampName;
begin

end;

begin
  AStt :='';
  if AL.Count > 0 then
   for il := 0 to AL.Count - 1 do
    begin
     aname := GetActionName(TSWFAction(AL[il]).ActionCode);
     Delete(aname, 1, Length('Action'));
     if TSWFAction(AL[il]).ActionCode in [ActionAnd, ActionIf, ActionNot, ActionOr, ActionTry, ActionWith] then
       aname := '_'+aname;
     case TSWFAction(AL[il]).ActionCode of

      ActionGotoFrame:
        with TSWFActionGotoFrame(AL[il]) do
          stt := Format(fs[0], [Frame]);

      ActionGetUrl:
        with TSWFActionGetUrl(AL[il]) do
          stt := Format(fs[3], [Target, URL]);

      ActionWaitForFrame:
       with TSWFActionWaitForFrame(AL[il]) do
         stt := Format(fs[2], [Frame, SkipCount]);

      ActionSetTarget:
       with TSWFActionSetTarget(AL[il]) do
         stt := Format(fs[1], [TargetName]);

      ActionGoToLabel:
       with TSWFActionSetTarget(AL[il]) do
         stt := Format(fs[1], [TargetName]);

      ActionPush:
       with TSWFActionPush (AL[il]) do
        begin
          stt := '';
          stt2 := '';
          for il2:=0 to ValueCount - 1 do
           begin
            stt := stt+', ';
            stt2 := stt2+', ' + PushTypes[byte(ValueInfo[il2].ValueType)];
            case ValueInfo[il2].ValueType of
             vtString: stt := stt + '''' + Value[il2] + '''';
             vtFloat, vtDouble: stt := stt + FloatToStr(Value[il2]);
             vtNull: stt := stt + fvNull;
             vtUndefined: stt := stt + fvUndefined;
             vtBoolean: stt := stt + ABool[boolean(Value[il2])];
             vtInteger, vtConstant8, vtConstant16, vtRegister:
                        stt := stt + IntToStr(Value[il2]);
            end;
           end;
          Delete(stt, 1, 2);
          Delete(stt2, 1, 2);
          stt := Format(fs[6], [stt]);
          stt2 := Format(fs[6], [stt2]);
          stt := Format(fs[3], [stt, stt2]);
        end;

      ActionGetURL2:
        with TSWFActionGetURL2(AL[il]) do
          stt := Format(fs[5], [Abool[LoadTargetFlag], ABool[LoadVariablesFlag], SendVarsMethod]);

      ActionGotoFrame2:
        with TSWFActionGotoFrame2(AL[il]) do
          stt := Format(fs[4], [ABool[PlayFlag], SceneBias]);

      ActionConstantPool:
        With TSWFActionConstantPool(AL[il]) do
         begin
           stt := '';
           For il2:=0 to ConstantPool.Count - 1 do
             stt := stt + ', ''' + ConstantPool[il2]+ '''';
           Delete(Stt, 1, 2);
           stt := '['+stt+']';
           stt := Format(fs[1], [stt]);
         end;

      actionJump, actionIf:
        With TSWFactionJump(AL[il]) do
         begin
           stt := BranchOffsetMarker.MarkerName;
           Delete(stt, 6, 1);
           if BranchOffsetMarker.JumpToBack
             then aname := aname+'.BranchOffsetMarker := ' +stt
             else aname := stt +' := '+aname+ '.BranchOffsetMarker';
           stt := '';
         end;

      ActionDefineFunction:
        With TSWFActionDefineFunction(AL[il]) do
         begin
           aname := CodeSizeMarker.MarkerName + ' := ' + aname + '.CodeSizeMarker';
           delete(aname, 6, 1);
           stt := '';
           For il2:=0 to Params.Count - 1 do
             stt := stt + ', ''' + Params[il2] + '''';
           Delete(Stt, 1, 2);
           stt := Format(fs[6], [stt]);
           stt := Format(fs[3], [FunctionName, stt]);

         end;

      ActionStoreRegister:
        With TSWFActionStoreRegister(AL[il]) do
         stt := Format(fs[0], [RegisterNumber]);

      ActionDefineFunction2:
        With TSWFActionDefineFunction2(AL[il]) do
         begin
           stt := '';
           For il2:=0 to Parameters.Count - 1 do
             stt := stt + ', ''' + Parameters[il2] + '''';
           Delete(Stt, 1, 2);
           stt := '[' + stt + ']';
           stt := Format(fs[5], [FunctionName, stt, RegisterCount]);


           if PreloadArgumentsFlag or PreloadGlobalFlag or PreloadParentFlag or
              PreloadRootFlag or PreloadSuperFlag or PreloadThisFlag or
              SuppressArgumentsFlag or SuppressSuperFlag or SuppressThisFlag then
             begin
              aname := 'with '+ aname + ' do'#13'begin';
              if PreloadArgumentsFlag then stt := stt +#13'PreloadArgumentsFlag := true;';
              if PreloadGlobalFlag then stt := stt +#13'PreloadGlobalFlag := true;';
              if PreloadParentFlag then stt := stt +#13'PreloadParentFlag := true;';
              if PreloadRootFlag then stt := stt +#13'PreloadRootFlag := true;';
              if PreloadSuperFlag then stt := stt +#13'PreloadSuperFlag := true;';
              if PreloadThisFlag then stt := stt +#13'PreloadThisFlag := true;';

              if SuppressArgumentsFlag then stt := stt +#13'SuppressArgumentsFlag := true;';
              if SuppressSuperFlag then stt := stt +#13'SuppressSuperFlag := true;';
              if SuppressThisFlag then stt := stt +#13'SuppressThisFlag := true;';
              stt := stt + #13'end';
             end;

         end;
         actionByteCode:
           With TSWFActionByteCode(AL[il]) do
            if DataSize > 0 then
             begin
              stt := '';
              for il2 := 0 to DataSize do
               begin
                 Stt := stt + '$'+IntToHex(ByteCode[il2], 2) + ',';
              //   if Length(Stt) in [80..83, 160..163, 240..243] then stt := stt + #13'  ';
               end;
              Delete(Stt, length(stt), 1);
              stt := Format(fs[1], [Format(fs[6], [stt])]);
             end;

         actionOffsetWork:
           With TSWFOffsetMarker(AL[il]) do
             begin
              aname := MarkerName;
              Delete(aname, 6, 1);
              if JumpToBack then stt := ' := SetMarker'
                else
                begin
                 aname := 'SetMarker('+aname+', false)';
                 stt :='';
                end;
             end;
       else stt := '';
     end;
     if AStt<>'' then Astt := Astt+#13;
     AStt := Astt + aname + stt + ';';
    end;
  Clipboard.AsText := AStt;
end;

Procedure GetDoAction(DoAction: TSWFDoAction);
begin
 CopyActions(DoAction.Actions);
end;

Procedure GetPlaceObjectAction(PO: TSWFPlaceObject2);
 var astt:ansistring;
     il: integer;
     stt: string;
begin
  if PO.PlaceFlagHasClipActions and
     (PO.ClipActions.ActionRecords.Count>0) then
  begin
    astt := 'with Movie.PlaceObject(_Object_, depth) do'#13'  begin'#13;
    for il := 0 to PO.ClipActions.ActionRecords.Count - 1 do
      with PO.ClipActions.ActionRecord[il] do
        begin
          CopyActions(Actions);
          astt := astt + '  with '+GetClipEventFlagsName(EventFlags)+ ' do'#13'    begin'#13+
                  Clipboard.AsText +#13'    end;'#13;
        end;
    Clipboard.AsText := AStt +'  end;';
  end;
end;

Procedure GetButtonAction(B: TSWFDefineButton);
begin
 CopyActions(B.Actions);
end;

Procedure GetButton2Action(B: TSWFDefineButton2);
begin

end;

end.
