//*******************************************************//
//                                                       //
//                      DelphiFlash.com                  //
//              Copyright (c) 2004 FeatherySoft, Inc.    //
//                    info@delphiflash.com               //
//                                                       //
//*******************************************************//

//  Description: live drawing on FlashCanvas
//  Last update: 29 oct 2004

unit ULiveDraw;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, FlashPlayerControl, FlashCanvasControl, StdCtrls;

type
  TForm4 = class(TForm)
    Panel1: TPanel;
    Flash: TFlashCanvasControl;
    RGType: TRadioGroup;
    procedure FlashMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FlashMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FlashMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    PStart: TPoint;
    isDown: boolean;
  end;

var
  Form4: TForm4;

implementation

{$R *.dfm}

procedure TForm4.FlashMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PStart.X := X;
  PStart.Y := Y;
  isDown := true;
end;

procedure TForm4.FormCreate(Sender: TObject);
begin
  isDown := false;
end;

procedure TForm4.FlashMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  isDown := false;
end;

procedure TForm4.FlashMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if isDown then
    begin
      With Flash.FlashCanvas do
        begin
          Clear;
          Case RGType.ItemIndex of
           0:begin
              Pen.Color := clBlue;
              MoveTo(PStart.X, PStart.Y);
              LineTo(X, Y);
             end;
           1:begin
              Pen.Color := clGreen;
              Rectangle(PStart.X, PStart.Y, X, Y);
             end;
           2:begin
              Pen.Color := clRed;
              Ellipse(PStart.X, PStart.Y, X, Y);
             end;
          end;
        end;
      Flash.UpdateCanvas;
    end;
end;

end.
